/*
 * Decompiled with CFR 0.152.
 */
package my.osama.timberreplant.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import my.osama.timberreplant.config.ConfigManager;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;

public class TreeDetection {
    private final ConfigManager configManager;
    private static final BlockFace[] SEARCH_DIRECTIONS = new BlockFace[]{BlockFace.NORTH, BlockFace.SOUTH, BlockFace.EAST, BlockFace.WEST, BlockFace.UP, BlockFace.DOWN, BlockFace.NORTH_EAST, BlockFace.NORTH_WEST, BlockFace.SOUTH_EAST, BlockFace.SOUTH_WEST};

    public TreeDetection(ConfigManager configManager) {
        this.configManager = configManager;
    }

    public List<Block> getTreeBlocks(Block startBlock) {
        if (!this.configManager.isWoodType(startBlock.getType())) {
            return new ArrayList<Block>();
        }
        if (this.configManager.isStrictNaturalDetection() && !this.isLikelyNaturalTree(startBlock)) {
            return new ArrayList<Block>();
        }
        HashSet<Location> visited = new HashSet<Location>();
        ArrayList<Block> treeBlocks = new ArrayList<Block>();
        this.findConnectedWoodBlocks(startBlock, visited, treeBlocks, startBlock.getType());
        if (!this.isValidNaturalTreeStructure(treeBlocks, startBlock.getType())) {
            return new ArrayList<Block>();
        }
        return treeBlocks;
    }

    public List<Block> getConnectedLeaves(List<Block> treeBlocks, Material woodType) {
        if (treeBlocks.isEmpty()) {
            return new ArrayList<Block>();
        }
        Material leafType = this.getLeafTypeForWood(woodType);
        if (leafType == null) {
            return new ArrayList<Block>();
        }
        HashSet<Location> visited = new HashSet<Location>();
        ArrayList<Block> leafBlocks = new ArrayList<Block>();
        int maxRadius = this.configManager.getLeafSearchRadius();
        for (Block woodBlock : treeBlocks) {
            this.findLeavesAroundBlock(woodBlock, leafType, visited, leafBlocks, maxRadius);
        }
        return leafBlocks;
    }

    private void findConnectedWoodBlocks(Block block, Set<Location> visited, List<Block> treeBlocks, Material originalWoodType) {
        Location location = block.getLocation();
        if (visited.contains(location) || treeBlocks.size() >= this.configManager.getMaxTreeSize()) {
            return;
        }
        if (!this.isValidWoodForTree(block.getType(), originalWoodType)) {
            return;
        }
        visited.add(location);
        treeBlocks.add(block);
        for (BlockFace direction : SEARCH_DIRECTIONS) {
            Block adjacentBlock = block.getRelative(direction);
            if (direction == BlockFace.UP) {
                for (int i = 1; i <= 3; ++i) {
                    Block upperBlock = block.getRelative(BlockFace.UP, i);
                    if (!this.isValidWoodForTree(upperBlock.getType(), originalWoodType)) continue;
                    this.findConnectedWoodBlocks(upperBlock, visited, treeBlocks, originalWoodType);
                }
                continue;
            }
            this.findConnectedWoodBlocks(adjacentBlock, visited, treeBlocks, originalWoodType);
        }
    }

    private void findLeavesAroundBlock(Block center, Material leafType, Set<Location> visited, List<Block> leafBlocks, int maxRadius) {
        LinkedList<BlockWithDistance> queue = new LinkedList<BlockWithDistance>();
        queue.offer(new BlockWithDistance(center, 0));
        while (!queue.isEmpty()) {
            Block adjacent;
            Location location;
            BlockWithDistance current = (BlockWithDistance)queue.poll();
            Block block = current.block;
            int distance = current.distance;
            if (distance > maxRadius || visited.contains(location = block.getLocation())) continue;
            visited.add(location);
            if (block.getType() == leafType) {
                leafBlocks.add(block);
                for (BlockFace direction : SEARCH_DIRECTIONS) {
                    adjacent = block.getRelative(direction);
                    if (visited.contains(adjacent.getLocation()) || distance + 1 > maxRadius) continue;
                    queue.offer(new BlockWithDistance(adjacent, distance + 1));
                }
                continue;
            }
            if (!this.configManager.isWoodType(block.getType())) continue;
            for (BlockFace direction : SEARCH_DIRECTIONS) {
                adjacent = block.getRelative(direction);
                if (visited.contains(adjacent.getLocation()) || distance + 1 > maxRadius) continue;
                queue.offer(new BlockWithDistance(adjacent, distance + 1));
            }
        }
    }

    private boolean isValidWoodForTree(Material blockType, Material originalWoodType) {
        if (!this.configManager.isWoodType(blockType)) {
            return false;
        }
        String originalBase = this.getBaseWoodType(originalWoodType);
        String currentBase = this.getBaseWoodType(blockType);
        return originalBase.equals(currentBase);
    }

    private String getBaseWoodType(Material material) {
        String materialName = material.name();
        materialName = materialName.replace("STRIPPED_", "");
        materialName = materialName.replace("_LOG", "");
        materialName = materialName.replace("_WOOD", "");
        return materialName;
    }

    private Material getLeafTypeForWood(Material woodType) {
        String baseType;
        switch (baseType = this.getBaseWoodType(woodType)) {
            case "OAK": {
                return Material.OAK_LEAVES;
            }
            case "SPRUCE": {
                return Material.SPRUCE_LEAVES;
            }
            case "BIRCH": {
                return Material.BIRCH_LEAVES;
            }
            case "JUNGLE": {
                return Material.JUNGLE_LEAVES;
            }
            case "ACACIA": {
                return Material.ACACIA_LEAVES;
            }
            case "DARK_OAK": {
                return Material.DARK_OAK_LEAVES;
            }
            case "MANGROVE": {
                return Material.MANGROVE_LEAVES;
            }
            case "CHERRY": {
                return Material.CHERRY_LEAVES;
            }
        }
        return null;
    }

    public Block findTreeBase(List<Block> treeBlocks) {
        if (treeBlocks.isEmpty()) {
            return null;
        }
        Block lowest = treeBlocks.get(0);
        for (Block block : treeBlocks) {
            if (block.getY() >= lowest.getY()) continue;
            lowest = block;
        }
        return lowest.getRelative(BlockFace.DOWN);
    }

    private boolean isLikelyNaturalTree(Block woodBlock) {
        Material leafType = this.getLeafTypeForWood(woodBlock.getType());
        if (leafType == null) {
            return false;
        }
        boolean hasNearbyLeaves = false;
        for (int x = -3; x <= 3; ++x) {
            for (int y = -3; y <= 3; ++y) {
                for (int z = -3; z <= 3; ++z) {
                    Block checkBlock = woodBlock.getRelative(x, y, z);
                    if (checkBlock.getType() != leafType) continue;
                    hasNearbyLeaves = true;
                    break;
                }
                if (hasNearbyLeaves) break;
            }
            if (hasNearbyLeaves) break;
        }
        if (!hasNearbyLeaves) {
            return false;
        }
        Block groundBlock = this.findGroundConnection(woodBlock);
        if (groundBlock == null) {
            return false;
        }
        return !this.hasPlayerStructurePattern(woodBlock);
    }

    private boolean isValidNaturalTreeStructure(List<Block> treeBlocks, Material woodType) {
        if (treeBlocks.isEmpty()) {
            return false;
        }
        List<Block> associatedLeaves = this.getConnectedLeaves(treeBlocks, woodType);
        if (associatedLeaves.isEmpty()) {
            return false;
        }
        double leavesToWoodRatio = (double)associatedLeaves.size() / (double)treeBlocks.size();
        if (leavesToWoodRatio < this.configManager.getMinLeavesToWoodRatio()) {
            return false;
        }
        if (!this.hasNaturalTrunkStructure(treeBlocks)) {
            return false;
        }
        Block treeBase = this.findTreeBase(treeBlocks);
        return treeBase != null && this.isValidGroundBlock(treeBase.getType());
    }

    private Block findGroundConnection(Block woodBlock) {
        Block current = woodBlock;
        for (int i = 0; i < 20; ++i) {
            Block below = current.getRelative(BlockFace.DOWN);
            if (this.isValidGroundBlock(below.getType())) {
                return below;
            }
            if (this.configManager.isWoodType(below.getType())) {
                current = below;
                continue;
            }
            if (below.getType() != Material.AIR) break;
            current = below;
        }
        return null;
    }

    private boolean hasPlayerStructurePattern(Block woodBlock) {
        int z;
        int x;
        int horizontalWoodCount = 1;
        for (x = 1; x <= 8 && this.configManager.isWoodType(woodBlock.getRelative(x, 0, 0).getType()); ++x) {
            ++horizontalWoodCount;
        }
        for (x = -1; x >= -8 && this.configManager.isWoodType(woodBlock.getRelative(x, 0, 0).getType()); --x) {
            ++horizontalWoodCount;
        }
        if (horizontalWoodCount > this.configManager.getMaxHorizontalWoodBlocks()) {
            return true;
        }
        horizontalWoodCount = 1;
        for (z = 1; z <= 8 && this.configManager.isWoodType(woodBlock.getRelative(0, 0, z).getType()); ++z) {
            ++horizontalWoodCount;
        }
        for (z = -1; z >= -8 && this.configManager.isWoodType(woodBlock.getRelative(0, 0, z).getType()); --z) {
            ++horizontalWoodCount;
        }
        return horizontalWoodCount > this.configManager.getMaxHorizontalWoodBlocks();
    }

    private boolean hasNaturalTrunkStructure(List<Block> treeBlocks) {
        if (treeBlocks.size() < 2) {
            return false;
        }
        Block lowest = treeBlocks.get(0);
        for (Block block : treeBlocks) {
            if (block.getY() >= lowest.getY()) continue;
            lowest = block;
        }
        int verticalBlocks = 0;
        for (Block block : treeBlocks) {
            if (block.getX() != lowest.getX() || block.getZ() != lowest.getZ() || block.getY() < lowest.getY()) continue;
            ++verticalBlocks;
        }
        return verticalBlocks >= 2;
    }

    private boolean isValidGroundBlock(Material material) {
        return material == Material.GRASS_BLOCK || material == Material.DIRT || material == Material.COARSE_DIRT || material == Material.PODZOL || material == Material.MYCELIUM || material == Material.ROOTED_DIRT;
    }

    public boolean isNaturalTree(List<Block> treeBlocks) {
        return !treeBlocks.isEmpty();
    }

    private static class BlockWithDistance {
        final Block block;
        final int distance;

        BlockWithDistance(Block block, int distance) {
            this.block = block;
            this.distance = distance;
        }
    }
}

