/*
 * Decompiled with CFR 0.152.
 */
package com.example.timberreplant.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;

public class TimberReplantConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("timberreplant.json");
    private static TimberReplantConfig instance;
    public boolean enabled = true;
    public boolean replantSaplings = true;
    public int maxTreeSize = 500;
    public int maxTreeHeight = 50;
    public boolean requireAxe = true;
    public boolean consumeDurability = true;
    public boolean breakLeaves = true;
    public boolean dropSaplings = true;
    public boolean instantBreak = false;
    public int breakDelay = 1;
    public boolean requireSneaking = false;
    public boolean logFelling = true;

    public static TimberReplantConfig getInstance() {
        if (instance == null) {
            instance = TimberReplantConfig.load();
        }
        return instance;
    }

    public static TimberReplantConfig load() {
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try {
                String json = Files.readString(CONFIG_PATH);
                return (TimberReplantConfig)GSON.fromJson(json, TimberReplantConfig.class);
            }
            catch (IOException e) {
                System.err.println("Failed to load TimberReplant config: " + e.getMessage());
            }
        }
        TimberReplantConfig config = new TimberReplantConfig();
        config.save();
        return config;
    }

    public void save() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            Files.writeString(CONFIG_PATH, (CharSequence)GSON.toJson((Object)this), new OpenOption[0]);
        }
        catch (IOException e) {
            System.err.println("Failed to save TimberReplant config: " + e.getMessage());
        }
    }
}

