/*
 * Decompiled with CFR 0.152.
 */
package com.timberreplant.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.timberreplant.TimberReplantMod;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.fabricmc.loader.api.FabricLoader;

public class TimberReplantConfig {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_PATH = FabricLoader.getInstance().getConfigDir().resolve("timberreplant.json");
    private static ConfigData config = new ConfigData();

    public static void init() {
        TimberReplantConfig.loadConfig();
    }

    private static void loadConfig() {
        if (Files.exists(CONFIG_PATH, new LinkOption[0])) {
            try {
                String json = Files.readString(CONFIG_PATH);
                config = (ConfigData)GSON.fromJson(json, ConfigData.class);
                TimberReplantMod.LOGGER.info("Loaded configuration from {}", (Object)CONFIG_PATH);
            }
            catch (Exception e) {
                TimberReplantMod.LOGGER.error("Failed to load config, using defaults", (Throwable)e);
                config = new ConfigData();
                TimberReplantConfig.saveConfig();
            }
        } else {
            TimberReplantMod.LOGGER.info("No config file found, creating default configuration");
            TimberReplantConfig.saveConfig();
        }
    }

    private static void saveConfig() {
        try {
            Files.createDirectories(CONFIG_PATH.getParent(), new FileAttribute[0]);
            String json = GSON.toJson((Object)config);
            Files.writeString(CONFIG_PATH, (CharSequence)json, new OpenOption[0]);
            TimberReplantMod.LOGGER.info("Saved configuration to {}", (Object)CONFIG_PATH);
        }
        catch (IOException e) {
            TimberReplantMod.LOGGER.error("Failed to save config", (Throwable)e);
        }
    }

    public static boolean getEnableTreeFelling() {
        return TimberReplantConfig.config.enableTreeFelling;
    }

    public static boolean getEnableSaplingReplanting() {
        return TimberReplantConfig.config.enableSaplingReplanting;
    }

    public static int getMaxTreeSize() {
        return TimberReplantConfig.config.maxTreeSize;
    }

    public static int getMaxSearchRadius() {
        return TimberReplantConfig.config.maxSearchRadius;
    }

    public static boolean getRequireTool() {
        return TimberReplantConfig.config.requireTool;
    }

    public static boolean getDamageTools() {
        return TimberReplantConfig.config.damageTools;
    }

    public static boolean getFellLeaves() {
        return TimberReplantConfig.config.fellLeaves;
    }

    public static boolean getPlaySounds() {
        return TimberReplantConfig.config.playSounds;
    }

    public static class ConfigData {
        public boolean enableTreeFelling = true;
        public boolean enableSaplingReplanting = true;
        public int maxTreeSize = 500;
        public int maxSearchRadius = 32;
        public boolean requireTool = false;
        public boolean damageTools = true;
        public boolean fellLeaves = true;
        public boolean playSounds = true;
    }
}

