/*
 * Decompiled with CFR 0.152.
 */
package com.timberreplant.event;

import com.timberreplant.TimberReplantMod;
import com.timberreplant.config.TimberReplantConfig;
import com.timberreplant.util.SaplingUtil;
import com.timberreplant.util.TreeDetector;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_173;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_52;
import net.minecraft.class_8567;

public class TreeFellingEventHandler {
    public boolean onBlockBreak(class_1937 level, class_1657 player, class_2338 pos, class_2680 state, class_2586 blockEntity) {
        class_1799 mainHand;
        if (level.method_8608()) {
            return true;
        }
        if (player == null) {
            return true;
        }
        if (!TreeDetector.isLog(state)) {
            return true;
        }
        if (!TimberReplantConfig.getEnableTreeFelling()) {
            return true;
        }
        if (TimberReplantConfig.getRequireTool() && ((mainHand = player.method_6047()).method_7960() || !mainHand.method_7951(state))) {
            return true;
        }
        TreeDetector.TreeData treeData = TreeDetector.detectTree(level, pos);
        if (treeData.logs.size() > 1 && TreeDetector.isNaturalTree(treeData)) {
            this.fellEntireTree(level, treeData, player, pos, state.method_26204());
            return false;
        }
        if (treeData.logs.size() > 1) {
            TimberReplantMod.LOGGER.info("Found {} connected logs but not treating as natural tree - allowing normal single-block break", (Object)treeData.logs.size());
        }
        return true;
    }

    private void fellEntireTree(class_1937 level, TreeDetector.TreeData treeData, class_1657 player, class_2338 originalPos, class_2248 logType) {
        class_1799 tool = player.method_6047();
        boolean canDamageTool = !tool.method_7960() && tool.method_7963();
        int logsBroken = 0;
        class_3218 serverLevel = (class_3218)level;
        TimberReplantMod.LOGGER.info("Felling tree with {} logs and {} leaves", (Object)treeData.logs.size(), (Object)treeData.leaves.size());
        for (class_2338 logPos : treeData.logs) {
            class_2680 logState = level.method_8320(logPos);
            if (!TreeDetector.isLog(logState)) continue;
            this.dropBlockLoot(serverLevel, logPos, logState, player);
            level.method_8650(logPos, false);
            ++logsBroken;
            if (!TimberReplantConfig.getPlaySounds()) continue;
            level.method_8396(null, logPos, class_3417.field_15215, class_3419.field_15245, 1.0f, 1.0f);
        }
        if (TimberReplantConfig.getFellLeaves()) {
            for (class_2338 leafPos : treeData.leaves) {
                class_2680 leafState = level.method_8320(leafPos);
                if (!TreeDetector.isLeaf(leafState)) continue;
                this.dropBlockLoot(serverLevel, leafPos, leafState, player);
                level.method_8650(leafPos, false);
                if (!TimberReplantConfig.getPlaySounds() || !(level.method_8409().method_43057() < 0.1f)) continue;
                level.method_8396(null, leafPos, class_3417.field_15037, class_3419.field_15245, 0.5f, 1.2f);
            }
        }
        if (TimberReplantConfig.getEnableSaplingReplanting() && TreeDetector.isNaturalTree(treeData)) {
            class_2248 saplingBlock = SaplingUtil.getSaplingForLog(logType);
            boolean planted = SaplingUtil.plantSapling(level, treeData.basePos, saplingBlock);
            if (planted) {
                if (TimberReplantConfig.getPlaySounds()) {
                    level.method_8396(null, treeData.basePos, class_3417.field_14653, class_3419.field_15245, 1.0f, 1.0f);
                }
                TimberReplantMod.LOGGER.info("Replanted {} at {}", (Object)saplingBlock.method_9539(), (Object)treeData.basePos);
            } else {
                SaplingUtil.dropSaplingAsItem(level, treeData.basePos, saplingBlock);
                TimberReplantMod.LOGGER.info("Dropped sapling item at {} (couldn't plant)", (Object)treeData.basePos);
            }
        } else if (TimberReplantConfig.getEnableSaplingReplanting()) {
            TimberReplantMod.LOGGER.info("Skipped sapling planting - detected structure is not a natural tree (likely placed blocks)");
        }
        if (TimberReplantConfig.getDamageTools() && canDamageTool && logsBroken > 0) {
            tool.method_7970(logsBroken, (class_1309)player, class_1304.field_6173);
            TimberReplantMod.LOGGER.debug("Applied {} durability damage to tool for {} logs", (Object)logsBroken, (Object)logsBroken);
        }
    }

    private void dropBlockLoot(class_3218 level, class_2338 pos, class_2680 state, class_1657 player) {
        class_52 lootTable = level.method_8503().method_58576().method_58295(state.method_26204().method_26162());
        class_8567.class_8568 lootParamsBuilder = new class_8567.class_8568(level).method_51874(class_181.field_24424, (Object)class_243.method_24953((class_2382)pos)).method_51874(class_181.field_1229, (Object)player.method_6047()).method_51877(class_181.field_1226, (Object)player).method_51877(class_181.field_1224, (Object)state);
        class_8567 lootParams = lootParamsBuilder.method_51875(class_173.field_1172);
        ObjectArrayList drops = lootTable.method_51878(lootParams);
        for (class_1799 drop : drops) {
            if (drop.method_7960()) continue;
            class_1542 itemEntity = new class_1542((class_1937)level, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, drop);
            itemEntity.method_6988();
            level.method_8649((class_1297)itemEntity);
        }
    }
}

