/*
 * Decompiled with CFR 0.152.
 */
package com.timberreplant.util;

import com.timberreplant.config.TimberReplantConfig;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3481;

public class TreeDetector {
    public static TreeData detectTree(class_1937 level, class_2338 startPos) {
        HashSet<class_2338> logs = new HashSet<class_2338>();
        HashSet<class_2338> leaves = new HashSet<class_2338>();
        HashSet<class_2338> visited = new HashSet<class_2338>();
        class_2338 basePos = TreeDetector.findTreeBase(level, startPos);
        TreeDetector.findConnectedLogs(level, basePos, logs, visited, basePos);
        TreeDetector.findConnectedLeaves(level, logs, leaves);
        return new TreeData(logs, leaves, basePos);
    }

    private static void findConnectedLogs(class_1937 level, class_2338 currentPos, Set<class_2338> logs, Set<class_2338> visited, class_2338 basePos) {
        LinkedList<class_2338> toCheck = new LinkedList<class_2338>();
        toCheck.add(currentPos);
        visited.add(currentPos);
        int maxTreeSize = TimberReplantConfig.getMaxTreeSize();
        int maxSearchRadius = TimberReplantConfig.getMaxSearchRadius();
        while (!toCheck.isEmpty() && logs.size() < maxTreeSize) {
            boolean isHighInTree;
            class_2680 state;
            class_2338 pos = (class_2338)toCheck.poll();
            int horizontalDistance = Math.max(Math.abs(pos.method_10263() - basePos.method_10263()), Math.abs(pos.method_10260() - basePos.method_10260()));
            if (horizontalDistance > maxSearchRadius || pos.method_10264() - basePos.method_10264() > maxSearchRadius * 2 || pos.method_10264() < basePos.method_10264() || !TreeDetector.isLog(state = level.method_8320(pos))) continue;
            logs.add(pos);
            TreeDetector.checkAndAddLog(level, pos.method_10084(), toCheck, visited, basePos, pos);
            TreeDetector.checkAndAddLog(level, pos.method_10074(), toCheck, visited, basePos, pos);
            boolean hasLogAbove = TreeDetector.isLog(level.method_8320(pos.method_10084()));
            boolean bl = isHighInTree = pos.method_10264() - basePos.method_10264() > 3;
            if (!hasLogAbove && !isHighInTree) continue;
            TreeDetector.checkAndAddLog(level, pos.method_10095(), toCheck, visited, basePos, pos);
            TreeDetector.checkAndAddLog(level, pos.method_10072(), toCheck, visited, basePos, pos);
            TreeDetector.checkAndAddLog(level, pos.method_10078(), toCheck, visited, basePos, pos);
            TreeDetector.checkAndAddLog(level, pos.method_10067(), toCheck, visited, basePos, pos);
        }
    }

    private static void checkAndAddLog(class_1937 level, class_2338 pos, Queue<class_2338> toCheck, Set<class_2338> visited, class_2338 basePos, class_2338 fromPos) {
        int horizontalDistance;
        if (visited.contains(pos)) {
            return;
        }
        if (!TreeDetector.isLog(level.method_8320(pos))) {
            return;
        }
        if (pos.method_10264() == fromPos.method_10264() && (horizontalDistance = Math.max(Math.abs(pos.method_10263() - basePos.method_10263()), Math.abs(pos.method_10260() - basePos.method_10260()))) > 5) {
            return;
        }
        visited.add(pos);
        toCheck.add(pos);
    }

    private static void findConnectedLeaves(class_1937 level, Set<class_2338> logs, Set<class_2338> leaves) {
        HashSet<class_2338> visited = new HashSet<class_2338>();
        LinkedList<class_2338> toCheck = new LinkedList<class_2338>();
        toCheck.addAll(logs);
        visited.addAll(logs);
        int maxTreeSize = TimberReplantConfig.getMaxTreeSize();
        while (!toCheck.isEmpty() && leaves.size() < maxTreeSize) {
            class_2338 pos = (class_2338)toCheck.poll();
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dy = -1; dy <= 1; ++dy) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        class_2338 adjacent;
                        if (dx == 0 && dy == 0 && dz == 0 || visited.contains(adjacent = pos.method_10069(dx, dy, dz))) continue;
                        visited.add(adjacent);
                        class_2680 state = level.method_8320(adjacent);
                        if (!TreeDetector.isLeaf(state) || !TreeDetector.isLeafBelongsToOurTree(level, adjacent, logs)) continue;
                        leaves.add(adjacent);
                        toCheck.add(adjacent);
                    }
                }
            }
        }
    }

    private static boolean isLeafBelongsToOurTree(class_1937 level, class_2338 leafPos, Set<class_2338> ourLogs) {
        int minDistanceToOurLogs = Integer.MAX_VALUE;
        for (class_2338 log : ourLogs) {
            int distance = Math.abs(leafPos.method_10263() - log.method_10263()) + Math.abs(leafPos.method_10264() - log.method_10264()) + Math.abs(leafPos.method_10260() - log.method_10260());
            minDistanceToOurLogs = Math.min(minDistanceToOurLogs, distance);
        }
        for (int dx = -4; dx <= 4; ++dx) {
            for (int dy = -4; dy <= 4; ++dy) {
                for (int dz = -4; dz <= 4; ++dz) {
                    int distanceToOtherLog;
                    class_2338 checkPos = leafPos.method_10069(dx, dy, dz);
                    if (ourLogs.contains(checkPos) || !TreeDetector.isLog(level.method_8320(checkPos)) || (distanceToOtherLog = Math.abs(dx) + Math.abs(dy) + Math.abs(dz)) > minDistanceToOurLogs) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static class_2338 findTreeBase(class_1937 level, class_2338 startPos) {
        class_2338 below;
        class_2680 belowState;
        class_2338 currentPos = startPos;
        while (currentPos.method_10264() > level.method_31607() && TreeDetector.isLog(belowState = level.method_8320(below = currentPos.method_10074()))) {
            currentPos = below;
        }
        return currentPos;
    }

    public static boolean isLog(class_2680 state) {
        return state.method_26164(class_3481.field_15475);
    }

    public static boolean isLeaf(class_2680 state) {
        return state.method_26164(class_3481.field_15503);
    }

    public static boolean isNaturalTree(TreeData treeData) {
        if (treeData.leaves.isEmpty()) {
            return false;
        }
        int logCount = treeData.logs.size();
        int leafCount = treeData.leaves.size();
        if (leafCount == 0 && logCount > 1) {
            return false;
        }
        return logCount <= 4 || leafCount <= 0 || leafCount * 10 >= logCount || logCount >= 20;
    }

    public static class TreeData {
        public final Set<class_2338> logs;
        public final Set<class_2338> leaves;
        public final class_2338 basePos;

        public TreeData(Set<class_2338> logs, Set<class_2338> leaves, class_2338 basePos) {
            this.logs = logs;
            this.leaves = leaves;
            this.basePos = basePos;
        }
    }
}

