/*
 * Decompiled with CFR 0.152.
 */
package com.timberreplant.event;

import com.timberreplant.TimberReplantMod;
import com.timberreplant.config.TimberReplantConfig;
import com.timberreplant.util.SaplingUtil;
import com.timberreplant.util.TreeDetector;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class TreeFellingEventHandler {
    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        ItemStack mainHand;
        Level level = (Level)event.getWorld();
        BlockPos pos = event.getPos();
        BlockState state = event.getState();
        Player player = event.getPlayer();
        if (level.m_5776_()) {
            return;
        }
        if (player == null) {
            return;
        }
        if (!TreeDetector.isLog(state)) {
            return;
        }
        if (!((Boolean)TimberReplantConfig.ENABLE_TREE_FELLING.get()).booleanValue()) {
            return;
        }
        if (((Boolean)TimberReplantConfig.REQUIRE_TOOL.get()).booleanValue() && ((mainHand = player.m_21205_()).m_41619_() || !mainHand.m_41735_(state))) {
            return;
        }
        TreeDetector.TreeData treeData = TreeDetector.detectTree(level, pos);
        if (treeData.logs.size() > 1 && TreeDetector.isNaturalTree(treeData)) {
            this.fellEntireTree(level, treeData, player, pos, state.m_60734_());
            event.setCanceled(true);
        } else if (treeData.logs.size() > 1) {
            TimberReplantMod.LOGGER.info("Found {} connected logs but not treating as natural tree - allowing normal single-block break", (Object)treeData.logs.size());
        }
    }

    private void fellEntireTree(Level level, TreeDetector.TreeData treeData, Player player, BlockPos originalPos, Block logType) {
        ItemStack tool = player.m_21205_();
        boolean canDamageTool = !tool.m_41619_() && tool.m_41763_();
        int logsBroken = 0;
        ServerLevel serverLevel = (ServerLevel)level;
        TimberReplantMod.LOGGER.info("Felling tree with {} logs and {} leaves", (Object)treeData.logs.size(), (Object)treeData.leaves.size());
        for (BlockPos logPos : treeData.logs) {
            BlockState logState = level.m_8055_(logPos);
            if (!TreeDetector.isLog(logState)) continue;
            this.dropBlockLoot(serverLevel, logPos, logState, player);
            level.m_7471_(logPos, false);
            ++logsBroken;
            if (!((Boolean)TimberReplantConfig.PLAY_SOUNDS.get()).booleanValue()) continue;
            level.m_5594_(null, logPos, SoundEvents.f_12630_, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        if (((Boolean)TimberReplantConfig.FELL_LEAVES.get()).booleanValue()) {
            for (BlockPos leafPos : treeData.leaves) {
                BlockState leafState = level.m_8055_(leafPos);
                if (!TreeDetector.isLeaf(leafState)) continue;
                this.dropBlockLoot(serverLevel, leafPos, leafState, player);
                level.m_7471_(leafPos, false);
                if (!((Boolean)TimberReplantConfig.PLAY_SOUNDS.get()).booleanValue() || !(level.m_5822_().nextFloat() < 0.1f)) continue;
                level.m_5594_(null, leafPos, SoundEvents.f_11988_, SoundSource.BLOCKS, 0.5f, 1.2f);
            }
        }
        if (((Boolean)TimberReplantConfig.ENABLE_SAPLING_REPLANTING.get()).booleanValue() && TreeDetector.isNaturalTree(treeData)) {
            Block saplingBlock = SaplingUtil.getSaplingForLog(logType);
            boolean planted = SaplingUtil.plantSapling(level, treeData.basePos, saplingBlock);
            if (planted) {
                if (((Boolean)TimberReplantConfig.PLAY_SOUNDS.get()).booleanValue()) {
                    level.m_5594_(null, treeData.basePos, SoundEvents.f_11991_, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                TimberReplantMod.LOGGER.info("Replanted {} at {}", (Object)saplingBlock.m_7705_(), (Object)treeData.basePos);
            } else {
                SaplingUtil.dropSaplingAsItem(level, treeData.basePos, saplingBlock);
                TimberReplantMod.LOGGER.info("Dropped sapling item at {} (couldn't plant)", (Object)treeData.basePos);
            }
        } else if (((Boolean)TimberReplantConfig.ENABLE_SAPLING_REPLANTING.get()).booleanValue()) {
            TimberReplantMod.LOGGER.info("Skipped sapling planting - detected structure is not a natural tree (likely placed blocks)");
        }
        if (((Boolean)TimberReplantConfig.DAMAGE_TOOLS.get()).booleanValue() && canDamageTool && logsBroken > 0) {
            tool.m_41622_(logsBroken, (LivingEntity)player, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
            TimberReplantMod.LOGGER.debug("Applied {} durability damage to tool for {} logs", (Object)logsBroken, (Object)logsBroken);
        }
    }

    private void dropBlockLoot(ServerLevel level, BlockPos pos, BlockState state, Player player) {
        LootTable lootTable = level.m_142572_().m_129898_().m_79217_(state.m_60734_().m_60589_());
        LootContext.Builder lootContextBuilder = new LootContext.Builder(level).m_78972_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)pos)).m_78972_(LootContextParams.f_81463_, (Object)player.m_21205_()).m_78984_(LootContextParams.f_81455_, (Object)player).m_78984_(LootContextParams.f_81461_, (Object)state);
        LootContext lootContext = lootContextBuilder.m_78975_(LootContextParamSets.f_81421_);
        List drops = lootTable.m_79129_(lootContext);
        for (ItemStack drop : drops) {
            if (drop.m_41619_()) continue;
            ItemEntity itemEntity = new ItemEntity((Level)level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, drop);
            itemEntity.m_32060_();
            level.m_7967_((Entity)itemEntity);
        }
    }
}

