/*
 * Decompiled with CFR 0.152.
 */
package com.timberreplant.event;

import com.timberreplant.TimberReplantMod;
import com.timberreplant.config.TimberReplantConfig;
import com.timberreplant.util.SaplingUtil;
import com.timberreplant.util.TreeDetector;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class TreeFellingEventHandler {
    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        ItemStack mainHand;
        Level level = (Level)event.getLevel();
        BlockPos pos = event.getPos();
        BlockState state = event.getState();
        Player player = event.getPlayer();
        if (level.isClientSide()) {
            return;
        }
        if (player == null) {
            return;
        }
        if (!TreeDetector.isLog(state)) {
            return;
        }
        if (!((Boolean)TimberReplantConfig.ENABLE_TREE_FELLING.get()).booleanValue()) {
            return;
        }
        if (((Boolean)TimberReplantConfig.REQUIRE_TOOL.get()).booleanValue() && ((mainHand = player.getMainHandItem()).isEmpty() || !mainHand.isCorrectToolForDrops(state))) {
            return;
        }
        TreeDetector.TreeData treeData = TreeDetector.detectTree(level, pos);
        if (treeData.logs.size() > 1 && TreeDetector.isNaturalTree(treeData)) {
            this.fellEntireTree(level, treeData, player, pos, state.getBlock());
            event.setCanceled(true);
        } else if (treeData.logs.size() > 1) {
            TimberReplantMod.LOGGER.info("Found {} connected logs but not treating as natural tree - allowing normal single-block break", (Object)treeData.logs.size());
        }
    }

    private void fellEntireTree(Level level, TreeDetector.TreeData treeData, Player player, BlockPos originalPos, Block logType) {
        ItemStack tool = player.getMainHandItem();
        boolean canDamageTool = !tool.isEmpty() && tool.isDamageableItem();
        int logsBroken = 0;
        ServerLevel serverLevel = (ServerLevel)level;
        TimberReplantMod.LOGGER.info("Felling tree with {} logs and {} leaves", (Object)treeData.logs.size(), (Object)treeData.leaves.size());
        for (BlockPos logPos : treeData.logs) {
            BlockState logState = level.getBlockState(logPos);
            if (!TreeDetector.isLog(logState)) continue;
            this.dropBlockLoot(serverLevel, logPos, logState, player);
            level.removeBlock(logPos, false);
            ++logsBroken;
            if (!((Boolean)TimberReplantConfig.PLAY_SOUNDS.get()).booleanValue()) continue;
            level.playSound(null, logPos, SoundEvents.WOOD_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        if (((Boolean)TimberReplantConfig.FELL_LEAVES.get()).booleanValue()) {
            for (BlockPos leafPos : treeData.leaves) {
                BlockState leafState = level.getBlockState(leafPos);
                if (!TreeDetector.isLeaf(leafState)) continue;
                this.dropBlockLoot(serverLevel, leafPos, leafState, player);
                level.removeBlock(leafPos, false);
                if (!((Boolean)TimberReplantConfig.PLAY_SOUNDS.get()).booleanValue() || !(level.getRandom().nextFloat() < 0.1f)) continue;
                level.playSound(null, leafPos, SoundEvents.GRASS_BREAK, SoundSource.BLOCKS, 0.5f, 1.2f);
            }
        }
        if (((Boolean)TimberReplantConfig.ENABLE_SAPLING_REPLANTING.get()).booleanValue() && TreeDetector.isNaturalTree(treeData)) {
            Block saplingBlock = SaplingUtil.getSaplingForLog(logType);
            boolean planted = SaplingUtil.plantSapling(level, treeData.basePos, saplingBlock);
            if (planted) {
                if (((Boolean)TimberReplantConfig.PLAY_SOUNDS.get()).booleanValue()) {
                    level.playSound(null, treeData.basePos, SoundEvents.GRASS_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                TimberReplantMod.LOGGER.info("Replanted {} at {}", (Object)saplingBlock.getDescriptionId(), (Object)treeData.basePos);
            } else {
                SaplingUtil.dropSaplingAsItem(level, treeData.basePos, saplingBlock);
                TimberReplantMod.LOGGER.info("Dropped sapling item at {} (couldn't plant)", (Object)treeData.basePos);
            }
        } else if (((Boolean)TimberReplantConfig.ENABLE_SAPLING_REPLANTING.get()).booleanValue()) {
            TimberReplantMod.LOGGER.info("Skipped sapling planting - detected structure is not a natural tree (likely placed blocks)");
        }
        if (((Boolean)TimberReplantConfig.DAMAGE_TOOLS.get()).booleanValue() && canDamageTool && logsBroken > 0) {
            tool.hurtAndBreak(logsBroken, (LivingEntity)player, EquipmentSlot.MAINHAND);
            TimberReplantMod.LOGGER.debug("Applied {} durability damage to tool for {} logs", (Object)logsBroken, (Object)logsBroken);
        }
    }

    private void dropBlockLoot(ServerLevel level, BlockPos pos, BlockState state, Player player) {
        LootTable lootTable = level.getServer().reloadableRegistries().getLootTable(state.getBlock().getLootTable());
        LootParams.Builder lootParamsBuilder = new LootParams.Builder(level).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)pos)).withParameter(LootContextParams.TOOL, (Object)player.getMainHandItem()).withOptionalParameter(LootContextParams.THIS_ENTITY, (Object)player).withOptionalParameter(LootContextParams.BLOCK_STATE, (Object)state);
        LootParams lootParams = lootParamsBuilder.create(LootContextParamSets.BLOCK);
        ObjectArrayList drops = lootTable.getRandomItems(lootParams);
        for (ItemStack drop : drops) {
            if (drop.isEmpty()) continue;
            ItemEntity itemEntity = new ItemEntity((Level)level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, drop);
            itemEntity.setDefaultPickUpDelay();
            level.addFreshEntity((Entity)itemEntity);
        }
    }
}

