/*
 * Decompiled with CFR 0.152.
 */
package com.timberreplant.util;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class SaplingUtil {
    private static final Map<Block, Block> LOG_TO_SAPLING = new HashMap<Block, Block>();

    public static Block getSaplingForLog(Block logBlock) {
        return LOG_TO_SAPLING.get(logBlock);
    }

    public static boolean plantSapling(Level level, BlockPos pos, Block saplingBlock) {
        if (saplingBlock == null) {
            return false;
        }
        if (!SaplingUtil.canPlantSapling(level, pos, saplingBlock)) {
            return false;
        }
        BlockState saplingState = saplingBlock.defaultBlockState();
        level.setBlock(pos, saplingState, 3);
        return true;
    }

    private static boolean canPlantSapling(Level level, BlockPos pos, Block saplingBlock) {
        BlockState currentState = level.getBlockState(pos);
        if (!currentState.isAir() && !currentState.canBeReplaced()) {
            return false;
        }
        BlockPos belowPos = pos.below();
        BlockState belowState = level.getBlockState(belowPos);
        if (belowState.is(Blocks.DIRT) || belowState.is(Blocks.GRASS_BLOCK) || belowState.is(Blocks.PODZOL) || belowState.is(Blocks.COARSE_DIRT) || belowState.is(Blocks.ROOTED_DIRT) || belowState.is(Blocks.MYCELIUM)) {
            return true;
        }
        if (saplingBlock == Blocks.MANGROVE_PROPAGULE) {
            return belowState.is(Blocks.DIRT) || belowState.is(Blocks.GRASS_BLOCK) || belowState.is(Blocks.PODZOL) || belowState.is(Blocks.MUD) || belowState.is(Blocks.MUDDY_MANGROVE_ROOTS);
        }
        return false;
    }

    public static void dropSaplingAsItem(Level level, BlockPos pos, Block saplingBlock) {
        if (saplingBlock == null) {
            return;
        }
        ItemStack saplingStack = new ItemStack((ItemLike)saplingBlock.asItem());
        ItemEntity itemEntity = new ItemEntity(level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, saplingStack);
        level.addFreshEntity((Entity)itemEntity);
    }

    static {
        LOG_TO_SAPLING.put(Blocks.OAK_LOG, Blocks.OAK_SAPLING);
        LOG_TO_SAPLING.put(Blocks.STRIPPED_OAK_LOG, Blocks.OAK_SAPLING);
        LOG_TO_SAPLING.put(Blocks.OAK_WOOD, Blocks.OAK_SAPLING);
        LOG_TO_SAPLING.put(Blocks.STRIPPED_OAK_WOOD, Blocks.OAK_SAPLING);
        LOG_TO_SAPLING.put(Blocks.BIRCH_LOG, Blocks.BIRCH_SAPLING);
        LOG_TO_SAPLING.put(Blocks.STRIPPED_BIRCH_LOG, Blocks.BIRCH_SAPLING);
        LOG_TO_SAPLING.put(Blocks.BIRCH_WOOD, Blocks.BIRCH_SAPLING);
        LOG_TO_SAPLING.put(Blocks.STRIPPED_BIRCH_WOOD, Blocks.BIRCH_SAPLING);
        LOG_TO_SAPLING.put(Blocks.SPRUCE_LOG, Blocks.SPRUCE_SAPLING);
        LOG_TO_SAPLING.put(Blocks.STRIPPED_SPRUCE_LOG, Blocks.SPRUCE_SAPLING);
        LOG_TO_SAPLING.put(Blocks.SPRUCE_WOOD, Blocks.SPRUCE_SAPLING);
        LOG_TO_SAPLING.put(Blocks.STRIPPED_SPRUCE_WOOD, Blocks.SPRUCE_SAPLING);
        LOG_TO_SAPLING.put(Blocks.JUNGLE_LOG, Blocks.JUNGLE_SAPLING);
        LOG_TO_SAPLING.put(Blocks.STRIPPED_JUNGLE_LOG, Blocks.JUNGLE_SAPLING);
        LOG_TO_SAPLING.put(Blocks.JUNGLE_WOOD, Blocks.JUNGLE_SAPLING);
        LOG_TO_SAPLING.put(Blocks.STRIPPED_JUNGLE_WOOD, Blocks.JUNGLE_SAPLING);
        LOG_TO_SAPLING.put(Blocks.ACACIA_LOG, Blocks.ACACIA_SAPLING);
        LOG_TO_SAPLING.put(Blocks.STRIPPED_ACACIA_LOG, Blocks.ACACIA_SAPLING);
        LOG_TO_SAPLING.put(Blocks.ACACIA_WOOD, Blocks.ACACIA_SAPLING);
        LOG_TO_SAPLING.put(Blocks.STRIPPED_ACACIA_WOOD, Blocks.ACACIA_SAPLING);
        LOG_TO_SAPLING.put(Blocks.DARK_OAK_LOG, Blocks.DARK_OAK_SAPLING);
        LOG_TO_SAPLING.put(Blocks.STRIPPED_DARK_OAK_LOG, Blocks.DARK_OAK_SAPLING);
        LOG_TO_SAPLING.put(Blocks.DARK_OAK_WOOD, Blocks.DARK_OAK_SAPLING);
        LOG_TO_SAPLING.put(Blocks.STRIPPED_DARK_OAK_WOOD, Blocks.DARK_OAK_SAPLING);
        LOG_TO_SAPLING.put(Blocks.MANGROVE_LOG, Blocks.MANGROVE_PROPAGULE);
        LOG_TO_SAPLING.put(Blocks.STRIPPED_MANGROVE_LOG, Blocks.MANGROVE_PROPAGULE);
        LOG_TO_SAPLING.put(Blocks.MANGROVE_WOOD, Blocks.MANGROVE_PROPAGULE);
        LOG_TO_SAPLING.put(Blocks.STRIPPED_MANGROVE_WOOD, Blocks.MANGROVE_PROPAGULE);
        LOG_TO_SAPLING.put(Blocks.CHERRY_LOG, Blocks.CHERRY_SAPLING);
        LOG_TO_SAPLING.put(Blocks.STRIPPED_CHERRY_LOG, Blocks.CHERRY_SAPLING);
        LOG_TO_SAPLING.put(Blocks.CHERRY_WOOD, Blocks.CHERRY_SAPLING);
        LOG_TO_SAPLING.put(Blocks.STRIPPED_CHERRY_WOOD, Blocks.CHERRY_SAPLING);
    }
}

