/*
 * Decompiled with CFR 0.152.
 */
package com.timberreplant.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class TimberReplantConfig {
    public static final ForgeConfigSpec.Builder BUILDER = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec SPEC;
    public static final ForgeConfigSpec.BooleanValue ENABLE_TREE_FELLING;
    public static final ForgeConfigSpec.BooleanValue ENABLE_SAPLING_REPLANTING;
    public static final ForgeConfigSpec.IntValue MAX_TREE_SIZE;
    public static final ForgeConfigSpec.IntValue MAX_SEARCH_RADIUS;
    public static final ForgeConfigSpec.BooleanValue REQUIRE_TOOL;
    public static final ForgeConfigSpec.BooleanValue DAMAGE_TOOLS;
    public static final ForgeConfigSpec.BooleanValue FELL_LEAVES;
    public static final ForgeConfigSpec.BooleanValue PLAY_SOUNDS;

    static {
        BUILDER.push("General Settings");
        ENABLE_TREE_FELLING = BUILDER.comment("Enable automatic tree felling when breaking a log").define("enableTreeFelling", true);
        ENABLE_SAPLING_REPLANTING = BUILDER.comment("Enable automatic sapling replanting after tree felling").define("enableSaplingReplanting", true);
        BUILDER.pop();
        BUILDER.push("Tree Detection");
        MAX_TREE_SIZE = BUILDER.comment("Maximum number of blocks a tree can have before felling is disabled (prevents lag)").defineInRange("maxTreeSize", 500, 1, 10000);
        MAX_SEARCH_RADIUS = BUILDER.comment("Maximum search radius for tree detection").defineInRange("maxSearchRadius", 32, 1, 128);
        BUILDER.pop();
        BUILDER.push("Requirements");
        REQUIRE_TOOL = BUILDER.comment("Require an axe to fell trees automatically").define("requireTool", false);
        DAMAGE_TOOLS = BUILDER.comment("Apply durability damage to tools when felling trees").define("damageTools", true);
        BUILDER.pop();
        BUILDER.push("Effects");
        FELL_LEAVES = BUILDER.comment("Also break and drop leaves when felling trees").define("fellLeaves", true);
        PLAY_SOUNDS = BUILDER.comment("Play sound effects when felling trees").define("playSounds", true);
        BUILDER.pop();
        SPEC = BUILDER.build();
    }
}

