/*
 * Decompiled with CFR 0.152.
 */
package com.timberreplant.event;

import com.timberreplant.TimberReplantMod;
import com.timberreplant.config.TimberReplantConfig;
import com.timberreplant.util.SaplingUtil;
import com.timberreplant.util.TreeDetector;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.eventbus.api.listener.SubscribeEvent;

public class TreeFellingEventHandler {
    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        ItemStack mainHand;
        Level level = (Level)event.getLevel();
        BlockPos pos = event.getPos();
        BlockState state = event.getState();
        Player player = event.getPlayer();
        if (level.isClientSide()) {
            return;
        }
        TimberReplantMod.LOGGER.debug("Block break event: {} at {} by {}", (Object)state.getBlock(), (Object)pos, (Object)(player != null ? player.getName().getString() : "null"));
        if (player == null) {
            return;
        }
        if (!TreeDetector.isLog(state)) {
            return;
        }
        if (!((Boolean)TimberReplantConfig.ENABLE_TREE_FELLING.get()).booleanValue()) {
            return;
        }
        if (((Boolean)TimberReplantConfig.REQUIRE_TOOL.get()).booleanValue() && ((mainHand = player.getMainHandItem()).isEmpty() || !mainHand.isCorrectToolForDrops(state))) {
            return;
        }
        TreeDetector.TreeData treeData = TreeDetector.detectTree(level, pos);
        TimberReplantMod.LOGGER.info("Tree detection: found {} logs, {} leaves, base at {}", (Object)treeData.logs.size(), (Object)treeData.leaves.size(), (Object)treeData.basePos);
        TimberReplantMod.LOGGER.info("Is natural tree: {}", (Object)TreeDetector.isNaturalTree(treeData));
        if (treeData.logs.size() > 1 && TreeDetector.isNaturalTree(treeData)) {
            treeData.logs.remove(pos);
            this.fellEntireTree(level, treeData, player, pos, state.getBlock());
        } else if (treeData.logs.size() > 1) {
            TimberReplantMod.LOGGER.info("Found {} connected logs but not treating as natural tree - allowing normal single-block break", (Object)treeData.logs.size());
        }
    }

    @SubscribeEvent
    public void onDummyEvent(LivingEvent.LivingTickEvent event) {
    }

    private void fellEntireTree(Level level, TreeDetector.TreeData treeData, Player player, BlockPos originalPos, Block logType) {
        ItemStack tool = player.getMainHandItem();
        boolean canDamageTool = !tool.isEmpty() && tool.isDamageableItem();
        int logsBroken = 0;
        ServerLevel serverLevel = (ServerLevel)level;
        TimberReplantMod.LOGGER.info("Felling tree with {} logs and {} leaves", (Object)treeData.logs.size(), (Object)treeData.leaves.size());
        for (BlockPos logPos : treeData.logs) {
            BlockState logState = level.getBlockState(logPos);
            if (!TreeDetector.isLog(logState)) continue;
            this.dropBlockLoot(serverLevel, logPos, logState, player);
            level.removeBlock(logPos, false);
            ++logsBroken;
            if (!((Boolean)TimberReplantConfig.PLAY_SOUNDS.get()).booleanValue()) continue;
            level.playSound(null, logPos, SoundEvents.WOOD_BREAK, SoundSource.BLOCKS, 1.0f, 1.0f);
        }
        if (((Boolean)TimberReplantConfig.FELL_LEAVES.get()).booleanValue()) {
            for (BlockPos leafPos : treeData.leaves) {
                BlockState leafState = level.getBlockState(leafPos);
                if (!TreeDetector.isLeaf(leafState)) continue;
                this.dropBlockLoot(serverLevel, leafPos, leafState, player);
                level.removeBlock(leafPos, false);
                if (!((Boolean)TimberReplantConfig.PLAY_SOUNDS.get()).booleanValue() || !(level.getRandom().nextFloat() < 0.1f)) continue;
                level.playSound(null, leafPos, SoundEvents.GRASS_BREAK, SoundSource.BLOCKS, 0.5f, 1.2f);
            }
        }
        if (((Boolean)TimberReplantConfig.ENABLE_SAPLING_REPLANTING.get()).booleanValue() && TreeDetector.isNaturalTree(treeData)) {
            Block saplingBlock = SaplingUtil.getSaplingForLog(logType);
            if (saplingBlock == null) {
                TimberReplantMod.LOGGER.warn("No sapling found for log type: {}", (Object)logType);
                return;
            }
            BlockPos plantPos = treeData.basePos;
            BlockState baseState = level.getBlockState(plantPos);
            boolean baseWillBeBrokenByVanilla = originalPos.equals((Object)plantPos);
            if (baseWillBeBrokenByVanilla) {
                TimberReplantMod.LOGGER.info("Base log will be broken by vanilla, scheduling replant");
                serverLevel.getServer().execute(() -> {
                    BlockState stateAtPlant = serverLevel.getBlockState(plantPos);
                    TimberReplantMod.LOGGER.info("Checking plant position {} - isAir: {}", (Object)plantPos, (Object)stateAtPlant.isAir());
                    if (stateAtPlant.isAir()) {
                        boolean planted = SaplingUtil.plantSapling((Level)serverLevel, plantPos, saplingBlock);
                        if (planted) {
                            if (((Boolean)TimberReplantConfig.PLAY_SOUNDS.get()).booleanValue()) {
                                serverLevel.playSound(null, plantPos, SoundEvents.GRASS_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
                            }
                            TimberReplantMod.LOGGER.info("Successfully replanted {} at {}", (Object)saplingBlock.getDescriptionId(), (Object)plantPos);
                        } else {
                            TimberReplantMod.LOGGER.warn("Failed to plant sapling at {} - dropping instead", (Object)plantPos);
                            SaplingUtil.dropSaplingAsItem((Level)serverLevel, plantPos, saplingBlock);
                        }
                    } else {
                        TimberReplantMod.LOGGER.warn("Plant position {} still has block {} - dropping sapling instead", (Object)plantPos, (Object)stateAtPlant.getBlock());
                        SaplingUtil.dropSaplingAsItem((Level)serverLevel, plantPos, saplingBlock);
                    }
                });
            } else if (TreeDetector.isLog(baseState)) {
                TimberReplantMod.LOGGER.info("Breaking base log at {} before planting", (Object)plantPos);
                this.dropBlockLoot(serverLevel, plantPos, baseState, player);
                level.removeBlock(plantPos, false);
                boolean planted = SaplingUtil.plantSapling(level, plantPos, saplingBlock);
                if (planted) {
                    if (((Boolean)TimberReplantConfig.PLAY_SOUNDS.get()).booleanValue()) {
                        level.playSound(null, plantPos, SoundEvents.GRASS_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                    TimberReplantMod.LOGGER.info("Successfully replanted {} at {}", (Object)saplingBlock.getDescriptionId(), (Object)plantPos);
                } else {
                    TimberReplantMod.LOGGER.warn("Failed to plant sapling at {} after breaking base - dropping instead", (Object)plantPos);
                    SaplingUtil.dropSaplingAsItem(level, plantPos, saplingBlock);
                }
            } else {
                TimberReplantMod.LOGGER.info("Base position {} is already {} - attempting to plant", (Object)plantPos, (Object)baseState.getBlock());
                boolean planted = SaplingUtil.plantSapling(level, plantPos, saplingBlock);
                if (planted) {
                    if (((Boolean)TimberReplantConfig.PLAY_SOUNDS.get()).booleanValue()) {
                        level.playSound(null, plantPos, SoundEvents.GRASS_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                    TimberReplantMod.LOGGER.info("Successfully replanted {} at {}", (Object)saplingBlock.getDescriptionId(), (Object)plantPos);
                } else {
                    TimberReplantMod.LOGGER.warn("Failed to plant sapling at {} - dropping instead", (Object)plantPos);
                    SaplingUtil.dropSaplingAsItem(level, plantPos, saplingBlock);
                }
            }
        } else if (((Boolean)TimberReplantConfig.ENABLE_SAPLING_REPLANTING.get()).booleanValue()) {
            TimberReplantMod.LOGGER.info("Skipped sapling planting - detected structure is not a natural tree (likely placed blocks)");
        } else {
            TimberReplantMod.LOGGER.info("Sapling replanting is disabled in config");
        }
        if (((Boolean)TimberReplantConfig.DAMAGE_TOOLS.get()).booleanValue() && canDamageTool && logsBroken > 0) {
            tool.hurtAndBreak(logsBroken, (LivingEntity)player, EquipmentSlot.MAINHAND);
            TimberReplantMod.LOGGER.debug("Applied {} durability damage to tool for {} additional logs (original block handled by vanilla)", (Object)logsBroken, (Object)logsBroken);
        }
    }

    private void dropBlockLoot(ServerLevel level, BlockPos pos, BlockState state, Player player) {
        Optional lootTableKey = state.getBlock().getLootTable();
        if (lootTableKey.isEmpty()) {
            return;
        }
        LootTable lootTable = level.getServer().reloadableRegistries().getLootTable((ResourceKey)lootTableKey.get());
        LootParams.Builder lootParamsBuilder = new LootParams.Builder(level).withParameter(LootContextParams.ORIGIN, (Object)Vec3.atCenterOf((Vec3i)pos)).withParameter(LootContextParams.TOOL, (Object)player.getMainHandItem()).withOptionalParameter(LootContextParams.THIS_ENTITY, (Object)player).withOptionalParameter(LootContextParams.BLOCK_STATE, (Object)state);
        LootParams lootParams = lootParamsBuilder.create(LootContextParamSets.BLOCK);
        ObjectArrayList drops = lootTable.getRandomItems(lootParams);
        for (ItemStack drop : drops) {
            if (drop.isEmpty()) continue;
            ItemEntity itemEntity = new ItemEntity((Level)level, (double)pos.getX() + 0.5, (double)pos.getY() + 0.5, (double)pos.getZ() + 0.5, drop);
            itemEntity.setDefaultPickUpDelay();
            level.addFreshEntity((Entity)itemEntity);
        }
    }
}

