/*
 * Decompiled with CFR 0.152.
 */
package com.timberreplant.util;

import com.timberreplant.config.TimberReplantConfig;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class TreeDetector {
    public static TreeData detectTree(Level level, BlockPos startPos) {
        HashSet<BlockPos> logs = new HashSet<BlockPos>();
        HashSet<BlockPos> leaves = new HashSet<BlockPos>();
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        BlockPos basePos = TreeDetector.findTreeBase(level, startPos);
        TreeDetector.findConnectedLogs(level, basePos, logs, visited, basePos);
        TreeDetector.findConnectedLeaves(level, logs, leaves);
        return new TreeData(logs, leaves, basePos);
    }

    private static void findConnectedLogs(Level level, BlockPos currentPos, Set<BlockPos> logs, Set<BlockPos> visited, BlockPos basePos) {
        LinkedList<BlockPos> toCheck = new LinkedList<BlockPos>();
        toCheck.add(currentPos);
        visited.add(currentPos);
        int maxTreeSize = (Integer)TimberReplantConfig.MAX_TREE_SIZE.get();
        int maxSearchRadius = (Integer)TimberReplantConfig.MAX_SEARCH_RADIUS.get();
        while (!toCheck.isEmpty() && logs.size() < maxTreeSize) {
            boolean isHighInTree;
            BlockState state;
            BlockPos pos = (BlockPos)toCheck.poll();
            int horizontalDistance = Math.max(Math.abs(pos.getX() - basePos.getX()), Math.abs(pos.getZ() - basePos.getZ()));
            if (horizontalDistance > maxSearchRadius || pos.getY() - basePos.getY() > maxSearchRadius * 2 || pos.getY() < basePos.getY() || !TreeDetector.isLog(state = level.getBlockState(pos))) continue;
            logs.add(pos);
            TreeDetector.checkAndAddLog(level, pos.above(), toCheck, visited, basePos, pos);
            TreeDetector.checkAndAddLog(level, pos.below(), toCheck, visited, basePos, pos);
            boolean hasLogAbove = TreeDetector.isLog(level.getBlockState(pos.above()));
            boolean bl = isHighInTree = pos.getY() - basePos.getY() > 3;
            if (!hasLogAbove && !isHighInTree) continue;
            TreeDetector.checkAndAddLog(level, pos.north(), toCheck, visited, basePos, pos);
            TreeDetector.checkAndAddLog(level, pos.south(), toCheck, visited, basePos, pos);
            TreeDetector.checkAndAddLog(level, pos.east(), toCheck, visited, basePos, pos);
            TreeDetector.checkAndAddLog(level, pos.west(), toCheck, visited, basePos, pos);
        }
    }

    private static void checkAndAddLog(Level level, BlockPos pos, Queue<BlockPos> toCheck, Set<BlockPos> visited, BlockPos basePos, BlockPos fromPos) {
        int horizontalDistance;
        if (visited.contains(pos)) {
            return;
        }
        if (!TreeDetector.isLog(level.getBlockState(pos))) {
            return;
        }
        if (pos.getY() == fromPos.getY() && (horizontalDistance = Math.max(Math.abs(pos.getX() - basePos.getX()), Math.abs(pos.getZ() - basePos.getZ()))) > 5) {
            return;
        }
        visited.add(pos);
        toCheck.add(pos);
    }

    private static void findConnectedLeaves(Level level, Set<BlockPos> logs, Set<BlockPos> leaves) {
        HashSet<BlockPos> visited = new HashSet<BlockPos>();
        LinkedList<BlockPos> toCheck = new LinkedList<BlockPos>();
        toCheck.addAll(logs);
        visited.addAll(logs);
        int maxTreeSize = (Integer)TimberReplantConfig.MAX_TREE_SIZE.get();
        while (!toCheck.isEmpty() && leaves.size() < maxTreeSize) {
            BlockPos pos = (BlockPos)toCheck.poll();
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dy = -1; dy <= 1; ++dy) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        BlockPos adjacent;
                        if (dx == 0 && dy == 0 && dz == 0 || visited.contains(adjacent = pos.offset(dx, dy, dz))) continue;
                        visited.add(adjacent);
                        BlockState state = level.getBlockState(adjacent);
                        if (!TreeDetector.isLeaf(state) || !TreeDetector.isLeafBelongsToOurTree(level, adjacent, logs)) continue;
                        leaves.add(adjacent);
                        toCheck.add(adjacent);
                    }
                }
            }
        }
    }

    private static boolean isLeafBelongsToOurTree(Level level, BlockPos leafPos, Set<BlockPos> ourLogs) {
        int minDistanceToOurLogs = Integer.MAX_VALUE;
        for (BlockPos log : ourLogs) {
            int distance = Math.abs(leafPos.getX() - log.getX()) + Math.abs(leafPos.getY() - log.getY()) + Math.abs(leafPos.getZ() - log.getZ());
            minDistanceToOurLogs = Math.min(minDistanceToOurLogs, distance);
        }
        for (int dx = -4; dx <= 4; ++dx) {
            for (int dy = -4; dy <= 4; ++dy) {
                for (int dz = -4; dz <= 4; ++dz) {
                    int distanceToOtherLog;
                    BlockPos checkPos = leafPos.offset(dx, dy, dz);
                    if (ourLogs.contains(checkPos) || !TreeDetector.isLog(level.getBlockState(checkPos)) || (distanceToOtherLog = Math.abs(dx) + Math.abs(dy) + Math.abs(dz)) > minDistanceToOurLogs) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static BlockPos findTreeBase(Level level, BlockPos startPos) {
        BlockPos below;
        BlockState belowState;
        BlockPos currentPos = startPos;
        while (currentPos.getY() > level.getMinY() && TreeDetector.isLog(belowState = level.getBlockState(below = currentPos.below()))) {
            currentPos = below;
        }
        return currentPos;
    }

    public static boolean isLog(BlockState state) {
        return state.is(BlockTags.LOGS);
    }

    public static boolean isLeaf(BlockState state) {
        return state.is(BlockTags.LEAVES);
    }

    public static boolean isNaturalTree(TreeData treeData) {
        if (treeData.leaves.isEmpty()) {
            return false;
        }
        int logCount = treeData.logs.size();
        int leafCount = treeData.leaves.size();
        if (leafCount == 0 && logCount > 1) {
            return false;
        }
        return logCount <= 4 || leafCount <= 0 || leafCount * 10 >= logCount || logCount >= 20;
    }

    public static class TreeData {
        public final Set<BlockPos> logs;
        public final Set<BlockPos> leaves;
        public final BlockPos basePos;

        public TreeData(Set<BlockPos> logs, Set<BlockPos> leaves, BlockPos basePos) {
            this.logs = logs;
            this.leaves = leaves;
            this.basePos = basePos;
        }
    }
}

