/*
 * Decompiled with CFR 0.152.
 */
package lynk.oneblock.biome;

import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import lynk.oneblock.persit.StateSaverAndLoader;
import lynk.oneblock.util.RandomBlockUtil;
import net.minecraft.class_124;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public class BiomeVote {
    private static final Map<UUID, ActiveVote> activeVotes = new ConcurrentHashMap<UUID, ActiveVote>();
    private static final Map<UUID, Long> voteCooldowns = new ConcurrentHashMap<UUID, Long>();

    public static boolean startVote(MinecraftServer server, class_3222 initiator, String biomeName) {
        UUID playerUuid = initiator.method_5667();
        StateSaverAndLoader state = StateSaverAndLoader.getServerState(server);
        if (!state.getConfig().isBiomeVotingEnabled()) {
            initiator.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cBiome voting is not enabled!"), false);
            return false;
        }
        if (!state.getConfig().isBiomeCyclingEnabled()) {
            initiator.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cBiome cycling must be enabled to vote for biomes!"), false);
            return false;
        }
        if (voteCooldowns.containsKey(playerUuid)) {
            long cooldownEnd = voteCooldowns.get(playerUuid);
            long now = System.currentTimeMillis();
            if (now < cooldownEnd) {
                long minutesLeft = (cooldownEnd - now) / 60000L;
                long secondsLeft = (cooldownEnd - now) % 60000L / 1000L;
                initiator.method_7353((class_2561)class_2561.method_43470((String)String.format("\u00a7cYou must wait %d:%02d before starting another vote!", minutesLeft, secondsLeft)), false);
                return false;
            }
            voteCooldowns.remove(playerUuid);
        }
        if (activeVotes.containsKey(playerUuid)) {
            initiator.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cYou already have an active vote!"), false);
            return false;
        }
        if (!BiomeVote.isValidBiome(biomeName)) {
            initiator.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cInvalid biome name! Use /biomes to see available biomes."), false);
            return false;
        }
        int playerCount = server.method_3788();
        if (playerCount == 1) {
            BiomeVote.setBiome(server, playerUuid, biomeName);
            initiator.method_7353((class_2561)class_2561.method_43470((String)("\u00a7aBiome changed to: \u00a7e" + biomeName)), false);
            BiomeVote.addCooldown(playerUuid, state.getConfig().getBiomeVoteCooldownMinutes());
            return true;
        }
        ActiveVote vote = new ActiveVote(playerUuid, biomeName, playerCount);
        activeVotes.put(playerUuid, vote);
        server.method_3760().method_43514((class_2561)class_2561.method_43470((String)("\u00a7e" + initiator.method_5477().getString() + "\u00a77 started a vote to change biome to \u00a7a" + biomeName)).method_10852((class_2561)class_2561.method_43470((String)"\n\u00a77Vote: ")).method_10852((class_2561)class_2561.method_43470((String)"[YES]").method_27694(style -> style.method_10977(class_124.field_1060).method_10958((class_2558)new class_2558.class_10609("/voteyes")))).method_10852((class_2561)class_2561.method_43470((String)" ")).method_10852((class_2561)class_2561.method_43470((String)"[NO]").method_27694(style -> style.method_10977(class_124.field_1061).method_10958((class_2558)new class_2558.class_10609("/voteno")))).method_10852((class_2561)class_2561.method_43470((String)(" \u00a77(" + vote.yesVotes.size() + "/" + playerCount + ")"))), false);
        return true;
    }

    public static boolean voteYes(MinecraftServer server, class_3222 player) {
        UUID initiator = BiomeVote.findActiveVoteForPlayer(player.method_5667());
        if (initiator == null) {
            player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cNo active vote!"), false);
            return false;
        }
        ActiveVote vote = activeVotes.get(initiator);
        if (vote.hasVoted(player.method_5667())) {
            player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cYou already voted!"), false);
            return false;
        }
        vote.yesVotes.add(player.method_5667());
        BiomeVote.updateVoteStatus(server, initiator, vote);
        return true;
    }

    public static boolean voteNo(MinecraftServer server, class_3222 player) {
        UUID initiator = BiomeVote.findActiveVoteForPlayer(player.method_5667());
        if (initiator == null) {
            player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cNo active vote!"), false);
            return false;
        }
        ActiveVote vote = activeVotes.get(initiator);
        if (vote.hasVoted(player.method_5667())) {
            player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cYou already voted!"), false);
            return false;
        }
        vote.noVotes.add(player.method_5667());
        BiomeVote.updateVoteStatus(server, initiator, vote);
        return true;
    }

    private static void updateVoteStatus(MinecraftServer server, UUID initiator, ActiveVote vote) {
        if (vote.hasPassed()) {
            server.method_3760().method_43514((class_2561)class_2561.method_43470((String)("\u00a7aVote passed! Changing biome to: \u00a7e" + vote.targetBiome)), false);
            BiomeVote.setBiome(server, initiator, vote.targetBiome);
            BiomeVote.addCooldown(initiator, StateSaverAndLoader.getServerState(server).getConfig().getBiomeVoteCooldownMinutes());
            activeVotes.remove(initiator);
        } else if (vote.hasFailed()) {
            server.method_3760().method_43514((class_2561)class_2561.method_43470((String)"\u00a7cVote failed! Biome will not change."), false);
            activeVotes.remove(initiator);
        } else {
            server.method_3760().method_43514((class_2561)class_2561.method_43470((String)("\u00a77Vote progress: \u00a7a" + vote.yesVotes.size() + " Yes \u00a77| \u00a7c" + vote.noVotes.size() + " No \u00a77| \u00a7e" + (vote.requiredPlayers - vote.getTotalVotes()) + " remaining")), false);
        }
    }

    public static void tick(MinecraftServer server) {
        Iterator<Map.Entry<UUID, ActiveVote>> iterator = activeVotes.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<UUID, ActiveVote> entry = iterator.next();
            ActiveVote vote = entry.getValue();
            if (!vote.isExpired()) continue;
            server.method_3760().method_43514((class_2561)class_2561.method_43470((String)"\u00a7cVote for biome change expired!"), false);
            iterator.remove();
        }
    }

    private static UUID findActiveVoteForPlayer(UUID playerUuid) {
        return activeVotes.keySet().stream().findFirst().orElse(null);
    }

    private static void addCooldown(UUID playerUuid, int minutes) {
        long cooldownEnd = System.currentTimeMillis() + (long)minutes * 60000L;
        voteCooldowns.put(playerUuid, cooldownEnd);
    }

    private static void setBiome(MinecraftServer server, UUID playerUuid, String biomeName) {
        RandomBlockUtil.setForcedBiome(biomeName);
        server.method_3760().method_43514((class_2561)class_2561.method_43470((String)("\u00a77Biome has been changed to \u00a7a" + biomeName + "\u00a77!")), false);
    }

    private static boolean isValidBiome(String biomeName) {
        return BiomeVote.getAvailableBiomes().contains(biomeName.toLowerCase());
    }

    public static List<String> getAvailableBiomes() {
        return List.of("plains", "sunflower_plains", "desert", "jungle", "taiga", "swamp", "mangrove_swamp", "savanna", "savanna_plateau", "mushroom_fields", "cherry_grove", "badlands", "eroded_badlands", "wooded_badlands", "dark_forest", "forest", "birch_forest", "flower_forest", "snowy_plains", "snowy_taiga", "frozen_peaks", "snowy_slopes", "jagged_peaks", "stony_peaks", "meadow", "grove", "beach", "stony_shore", "snowy_beach", "windswept_hills", "windswept_gravelly_hills", "windswept_forest", "windswept_savanna", "sparse_jungle", "bamboo_jungle", "old_growth_pine_taiga", "old_growth_birch_forest", "old_growth_spruce_taiga", "ice_spikes", "dripstone_caves", "lush_caves", "deep_dark", "ocean", "deep_ocean", "cold_ocean", "deep_cold_ocean", "frozen_ocean", "deep_frozen_ocean", "lukewarm_ocean", "deep_lukewarm_ocean", "warm_ocean", "river", "frozen_river", "nether_wastes", "crimson_forest", "warped_forest", "soul_sand_valley", "basalt_deltas", "the_end", "end_highlands", "end_midlands", "end_barrens", "small_end_islands");
    }

    public static class ActiveVote {
        public final UUID initiator;
        public final String targetBiome;
        public final Set<UUID> yesVotes = ConcurrentHashMap.newKeySet();
        public final Set<UUID> noVotes = ConcurrentHashMap.newKeySet();
        public final long startTime;
        public final int requiredPlayers;

        public ActiveVote(UUID initiator, String targetBiome, int requiredPlayers) {
            this.initiator = initiator;
            this.targetBiome = targetBiome;
            this.requiredPlayers = requiredPlayers;
            this.startTime = System.currentTimeMillis();
            this.yesVotes.add(initiator);
        }

        public boolean hasVoted(UUID player) {
            return this.yesVotes.contains(player) || this.noVotes.contains(player);
        }

        public int getTotalVotes() {
            return this.yesVotes.size() + this.noVotes.size();
        }

        public boolean hasPassed() {
            int total = this.getTotalVotes();
            return total >= this.requiredPlayers && (double)this.yesVotes.size() > (double)total / 2.0;
        }

        public boolean hasFailed() {
            int total = this.getTotalVotes();
            return total >= this.requiredPlayers && (double)this.noVotes.size() >= (double)total / 2.0;
        }

        public boolean isExpired() {
            return System.currentTimeMillis() - this.startTime > 60000L;
        }
    }
}

