/*
 * Decompiled with CFR 0.152.
 */
package lynk.oneblock.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import lynk.oneblock.biome.BiomeVote;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_7157;

public class BiomeVoteCommand {
    private static final SuggestionProvider<class_2168> BIOME_SUGGESTIONS = (context, builder) -> {
        for (String biome : BiomeVote.getAvailableBiomes()) {
            builder.suggest(biome);
        }
        return builder.buildFuture();
    };

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"votebiome").then(class_2170.method_9244((String)"biome", (ArgumentType)StringArgumentType.word()).suggests(BIOME_SUGGESTIONS).executes(BiomeVoteCommand::startVote)));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"voteyes").executes(BiomeVoteCommand::voteYes));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"voteno").executes(BiomeVoteCommand::voteNo));
        dispatcher.register((LiteralArgumentBuilder)class_2170.method_9247((String)"biomes").executes(BiomeVoteCommand::listBiomes));
    }

    private static int startVote(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        class_1297 class_12972 = source.method_9228();
        if (!(class_12972 instanceof class_3222)) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Only players can start votes!"));
            return 0;
        }
        class_3222 player = (class_3222)class_12972;
        String biomeName = StringArgumentType.getString(context, (String)"biome");
        BiomeVote.startVote(source.method_9211(), player, biomeName);
        return 1;
    }

    private static int voteYes(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        class_1297 class_12972 = source.method_9228();
        if (!(class_12972 instanceof class_3222)) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Only players can vote!"));
            return 0;
        }
        class_3222 player = (class_3222)class_12972;
        BiomeVote.voteYes(source.method_9211(), player);
        return 1;
    }

    private static int voteNo(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        class_1297 class_12972 = source.method_9228();
        if (!(class_12972 instanceof class_3222)) {
            source.method_9213((class_2561)class_2561.method_43470((String)"Only players can vote!"));
            return 0;
        }
        class_3222 player = (class_3222)class_12972;
        BiomeVote.voteNo(source.method_9211(), player);
        return 1;
    }

    private static int listBiomes(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        source.method_9226(() -> class_2561.method_43470((String)"\u00a7e\u00a7lAvailable Biomes:"), false);
        for (String biome : BiomeVote.getAvailableBiomes()) {
            source.method_9226(() -> class_2561.method_43470((String)("\u00a77- \u00a7a" + biome)), false);
        }
        source.method_9226(() -> class_2561.method_43470((String)"\u00a77Use \u00a7e/votebiome <biome>\u00a77 to start a vote!"), false);
        return 1;
    }
}

