/*
 * Decompiled with CFR 0.152.
 */
package lynk.oneblock.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import lynk.oneblock.biome.BiomeVote;
import net.minecraft.class_1923;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2672;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7157;
import net.minecraft.class_7924;

public class SetBiomeCommand {
    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"setbiome").then(class_2170.method_9244((String)"biome", (ArgumentType)StringArgumentType.word()).suggests((context, builder) -> {
            for (String biome : BiomeVote.getAvailableBiomes()) {
                builder.suggest(biome);
            }
            return builder.buildFuture();
        }).executes(SetBiomeCommand::setBiome))).executes(SetBiomeCommand::listBiomes));
    }

    private static int setBiome(CommandContext<class_2168> context) {
        int chunkZ;
        int chunkX;
        int offsetZ;
        int offsetX;
        class_2168 source = (class_2168)context.getSource();
        if (!(source.method_9228() instanceof class_3222)) {
            source.method_9213((class_2561)class_2561.method_43470((String)"This command can only be used by players!"));
            return 0;
        }
        class_3222 player = (class_3222)source.method_9228();
        String biomeName = StringArgumentType.getString(context, (String)"biome");
        if (!BiomeVote.getAvailableBiomes().contains(biomeName.toLowerCase())) {
            source.method_9213((class_2561)class_2561.method_43470((String)"\u00a7cInvalid biome! Use /setbiome to see available biomes."));
            return 0;
        }
        class_2960 biomeId = class_2960.method_60655((String)"minecraft", (String)biomeName.toLowerCase());
        class_3218 world = player.method_51469();
        class_2338 playerPos = player.method_24515();
        class_2378 biomeRegistry = world.method_30349().method_30530(class_7924.field_41236);
        class_6880 biomeEntry = null;
        for (class_6880 entry : biomeRegistry.method_40295()) {
            if (!entry.method_40230().isPresent() || !((class_5321)entry.method_40230().get()).method_29177().equals((Object)biomeId)) continue;
            biomeEntry = entry;
            break;
        }
        if (biomeEntry == null) {
            source.method_9213((class_2561)class_2561.method_43470((String)"\u00a7cCould not find biome in registry!"));
            return 0;
        }
        int centerChunkX = playerPos.method_10263() >> 4;
        int centerChunkZ = playerPos.method_10260() >> 4;
        class_6880 finalBiomeEntry = biomeEntry;
        int[] chunksChanged = new int[]{0};
        for (offsetX = -1; offsetX <= 1; ++offsetX) {
            for (offsetZ = -1; offsetZ <= 1; ++offsetZ) {
                chunkX = centerChunkX + offsetX;
                chunkZ = centerChunkZ + offsetZ;
                class_1923 chunkPos = new class_1923(chunkX, chunkZ);
                class_2818 chunk = world.method_8497(chunkPos.field_9181, chunkPos.field_9180);
                chunk.method_38257((x, y, z, noise) -> finalBiomeEntry, world.method_14178().method_41248().method_42371());
                chunksChanged[0] = chunksChanged[0] + 1;
            }
        }
        for (offsetX = -1; offsetX <= 1; ++offsetX) {
            for (offsetZ = -1; offsetZ <= 1; ++offsetZ) {
                chunkX = centerChunkX + offsetX;
                chunkZ = centerChunkZ + offsetZ;
                class_2818 worldChunk = world.method_8497(chunkX, chunkZ);
                class_2672 chunkDataPacket = new class_2672(worldChunk, world.method_22336(), null, null);
                player.field_13987.method_14364((class_2596)chunkDataPacket);
            }
        }
        source.method_9226(() -> class_2561.method_43470((String)("\u00a7aChanged " + chunksChanged[0] + " chunks to biome: \u00a7e" + biomeName)), false);
        return 1;
    }

    private static int listBiomes(CommandContext<class_2168> context) {
        class_2168 source = (class_2168)context.getSource();
        source.method_9226(() -> class_2561.method_43470((String)"\u00a76Available biomes:"), false);
        for (String biome : BiomeVote.getAvailableBiomes()) {
            source.method_9226(() -> class_2561.method_43470((String)("\u00a77- \u00a7e" + biome)), false);
        }
        source.method_9226(() -> class_2561.method_43470((String)"\u00a77Use \u00a7e/setbiome <biome>\u00a77 to change your area biome!"), false);
        return 1;
    }
}

