/*
 * Decompiled with CFR 0.152.
 */
package lynk.oneblock.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import net.minecraft.class_2487;

public class OneBlockConfig {
    private int waveChance = 100;
    private int itemDropChance = 100;
    private int itemDropCount = 1;
    private int friendlyMobChance = 100;
    private int lavaBucketChance = 500;
    private int waterBucketChance = 500;
    private int friendlyMobSpawnRadius = 4;
    private int hostileMobSpawnRadius = 4;
    private int endPortalFrameChance = 200;
    private int endPortalFrameRequirement = 10000;
    private int[] waveCountdowns = new int[]{12, 10, 8, 6, 5, 4, 3};
    private int[] waveThresholds = new int[]{0, 500, 1500, 3000, 5000, 8000, 12000};
    private int maxWaveSize = 100;
    private int waveSizeDivisor = 100;
    private int progressionCap = 10000;
    private boolean itemDropsEnabled = true;
    private boolean mobWavesEnabled = true;
    private boolean friendlyMobsEnabled = true;
    private boolean endPortalFrameEnabled = true;
    private boolean useGlobalBreakCount = false;
    private boolean biomeCyclingEnabled = false;
    private int biomeSwitchInterval = 100;
    private boolean spawnItemsInChest = false;
    private boolean showBreaksInTab = false;
    private boolean gentleItemDropOneBlock = true;
    private boolean gentleItemDropAll = false;
    private boolean biomeVotingEnabled = false;
    private int biomeVoteCooldownMinutes = 5;
    private boolean oneBlockDialogEnabled = true;
    private int dialogDurationSeconds = 60;
    private boolean visualEffectsEnabled = true;
    private boolean waveCompletionFeedback = true;
    private boolean keepInventoryOnDeath = false;
    private boolean waveIncomingAlert = true;
    private int waveAlertDurationTicks = 100;
    public static final Codec<OneBlockConfig> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.INT.optionalFieldOf("waveChance", (Object)100).forGetter(c -> c.waveChance), (App)Codec.INT.optionalFieldOf("itemDropChance", (Object)100).forGetter(c -> c.itemDropChance), (App)Codec.INT.optionalFieldOf("itemDropCount", (Object)1).forGetter(c -> c.itemDropCount), (App)Codec.INT.optionalFieldOf("friendlyMobChance", (Object)100).forGetter(c -> c.friendlyMobChance), (App)Codec.INT.optionalFieldOf("lavaBucketChance", (Object)500).forGetter(c -> c.lavaBucketChance), (App)Codec.INT.optionalFieldOf("waterBucketChance", (Object)500).forGetter(c -> c.waterBucketChance), (App)Codec.INT.optionalFieldOf("friendlyMobSpawnRadius", (Object)4).forGetter(c -> c.friendlyMobSpawnRadius), (App)Codec.INT.optionalFieldOf("hostileMobSpawnRadius", (Object)4).forGetter(c -> c.hostileMobSpawnRadius), (App)Codec.INT.optionalFieldOf("endPortalFrameChance", (Object)200).forGetter(c -> c.endPortalFrameChance), (App)Codec.INT.optionalFieldOf("endPortalFrameRequirement", (Object)10000).forGetter(c -> c.endPortalFrameRequirement), (App)Codec.INT.optionalFieldOf("maxWaveSize", (Object)100).forGetter(c -> c.maxWaveSize), (App)Codec.INT.optionalFieldOf("waveSizeDivisor", (Object)100).forGetter(c -> c.waveSizeDivisor), (App)Codec.INT.optionalFieldOf("progressionCap", (Object)10000).forGetter(c -> c.progressionCap), (App)WaveTiers.CODEC.optionalFieldOf("waveTiers", (Object)new WaveTiers(new int[]{12, 10, 8, 6, 5, 4, 3}, new int[]{0, 500, 1500, 3000, 5000, 8000, 12000}, 100)).forGetter(c -> {
        int[] nArray;
        int[] nArray2;
        if (c.waveCountdowns != null) {
            nArray2 = c.waveCountdowns;
        } else {
            int[] nArray3 = new int[7];
            nArray3[0] = 12;
            nArray3[1] = 10;
            nArray3[2] = 8;
            nArray3[3] = 6;
            nArray3[4] = 5;
            nArray3[5] = 4;
            nArray2 = nArray3;
            nArray3[6] = 3;
        }
        int[] countdowns = nArray2;
        if (c.waveThresholds != null) {
            nArray = c.waveThresholds;
        } else {
            int[] nArray4 = new int[7];
            nArray4[0] = 0;
            nArray4[1] = 500;
            nArray4[2] = 1500;
            nArray4[3] = 3000;
            nArray4[4] = 5000;
            nArray4[5] = 8000;
            nArray = nArray4;
            nArray4[6] = 12000;
        }
        int[] thresholds = nArray;
        int biomeSwitchInterval = c.biomeSwitchInterval != 0 ? c.biomeSwitchInterval : 100;
        return new WaveTiers(countdowns, thresholds, biomeSwitchInterval);
    }), (App)GameplayFeatures.CODEC.optionalFieldOf("gameplayFeatures", (Object)new GameplayFeatures(true, true, true, true, false, false, false, false, true, false, false, 5)).forGetter(c -> new GameplayFeatures(c.itemDropsEnabled, c.mobWavesEnabled, c.friendlyMobsEnabled, c.endPortalFrameEnabled, c.useGlobalBreakCount, c.biomeCyclingEnabled, c.spawnItemsInChest, c.showBreaksInTab, c.gentleItemDropOneBlock, c.gentleItemDropAll, c.biomeVotingEnabled, c.biomeVoteCooldownMinutes)), (App)UIFeatures.CODEC.optionalFieldOf("uiFeatures", (Object)new UIFeatures(true, 60, true, true, false, true, 100)).forGetter(c -> new UIFeatures(c.oneBlockDialogEnabled, c.dialogDurationSeconds, c.visualEffectsEnabled, c.waveCompletionFeedback, c.keepInventoryOnDeath, c.waveIncomingAlert, c.waveAlertDurationTicks))).apply((Applicative)inst, (wc, idc, idCount, fmc, lbc, wbc, fmsr, hmsr, epfc, epfr, mws, wsd, pc, wt, gf, uif) -> {
        OneBlockConfig config = new OneBlockConfig();
        config.waveChance = wc;
        config.itemDropChance = idc;
        config.itemDropCount = idCount;
        config.friendlyMobChance = fmc;
        config.lavaBucketChance = lbc;
        config.waterBucketChance = wbc;
        config.friendlyMobSpawnRadius = fmsr;
        config.hostileMobSpawnRadius = hmsr;
        config.endPortalFrameChance = epfc;
        config.endPortalFrameRequirement = epfr;
        config.maxWaveSize = mws;
        config.waveSizeDivisor = wsd;
        config.progressionCap = pc;
        config.waveCountdowns = wt.countdowns();
        config.waveThresholds = wt.thresholds();
        config.biomeSwitchInterval = wt.biomeSwitchInterval();
        config.itemDropsEnabled = gf.itemDropsEnabled();
        config.mobWavesEnabled = gf.mobWavesEnabled();
        config.friendlyMobsEnabled = gf.friendlyMobsEnabled();
        config.endPortalFrameEnabled = gf.endPortalFrameEnabled();
        config.useGlobalBreakCount = gf.useGlobalBreakCount();
        config.biomeCyclingEnabled = gf.biomeCyclingEnabled();
        config.spawnItemsInChest = gf.spawnItemsInChest();
        config.showBreaksInTab = gf.showBreaksInTab();
        config.gentleItemDropOneBlock = gf.gentleItemDropOneBlock();
        config.gentleItemDropAll = gf.gentleItemDropAll();
        config.biomeVotingEnabled = gf.biomeVotingEnabled();
        config.biomeVoteCooldownMinutes = gf.biomeVoteCooldownMinutes();
        config.oneBlockDialogEnabled = uif.oneBlockDialogEnabled();
        config.dialogDurationSeconds = uif.dialogDurationSeconds();
        config.visualEffectsEnabled = uif.visualEffectsEnabled();
        config.waveCompletionFeedback = uif.waveCompletionFeedback();
        config.keepInventoryOnDeath = uif.keepInventoryOnDeath();
        config.waveIncomingAlert = uif.waveIncomingAlert();
        config.waveAlertDurationTicks = uif.waveAlertDurationTicks();
        return config;
    }));

    public int getWaveChance() {
        return this.waveChance;
    }

    public int getItemDropChance() {
        return this.itemDropChance;
    }

    public int getItemDropCount() {
        return this.itemDropCount;
    }

    public int getFriendlyMobChance() {
        return this.friendlyMobChance;
    }

    public int getLavaBucketChance() {
        return this.lavaBucketChance;
    }

    public int getWaterBucketChance() {
        return this.waterBucketChance;
    }

    public int getFriendlyMobSpawnRadius() {
        return this.friendlyMobSpawnRadius;
    }

    public int getHostileMobSpawnRadius() {
        return this.hostileMobSpawnRadius;
    }

    public int getEndPortalFrameChance() {
        return this.endPortalFrameChance;
    }

    public int getEndPortalFrameRequirement() {
        return this.endPortalFrameRequirement;
    }

    public int getMaxWaveSize() {
        return this.maxWaveSize;
    }

    public int getWaveSizeDivisor() {
        return this.waveSizeDivisor;
    }

    public int getProgressionCap() {
        return this.progressionCap;
    }

    public boolean areItemDropsEnabled() {
        return this.itemDropsEnabled;
    }

    public boolean areMobWavesEnabled() {
        return this.mobWavesEnabled;
    }

    public boolean areFriendlyMobsEnabled() {
        return this.friendlyMobsEnabled;
    }

    public boolean isEndPortalFrameEnabled() {
        return this.endPortalFrameEnabled;
    }

    public boolean useGlobalBreakCount() {
        return this.useGlobalBreakCount;
    }

    public boolean isBiomeCyclingEnabled() {
        return this.biomeCyclingEnabled;
    }

    public boolean isSpawnItemsInChest() {
        return this.spawnItemsInChest;
    }

    public boolean isShowBreaksInTab() {
        return this.showBreaksInTab;
    }

    public boolean isGentleItemDropOneBlock() {
        return this.gentleItemDropOneBlock;
    }

    public boolean isGentleItemDropAll() {
        return this.gentleItemDropAll;
    }

    public int getBiomeSwitchInterval() {
        return this.biomeSwitchInterval;
    }

    public boolean isBiomeVotingEnabled() {
        return this.biomeVotingEnabled;
    }

    public int getBiomeVoteCooldownMinutes() {
        return this.biomeVoteCooldownMinutes;
    }

    public boolean isOneBlockDialogEnabled() {
        return this.oneBlockDialogEnabled;
    }

    public int getDialogDurationSeconds() {
        return this.dialogDurationSeconds;
    }

    public boolean isVisualEffectsEnabled() {
        return this.visualEffectsEnabled;
    }

    public boolean isWaveCompletionFeedback() {
        return this.waveCompletionFeedback;
    }

    public boolean isKeepInventoryOnDeath() {
        return this.keepInventoryOnDeath;
    }

    public void setWaveChance(int value) {
        this.waveChance = Math.max(1, Math.min(1000000, value));
    }

    public void setItemDropChance(int value) {
        this.itemDropChance = Math.max(1, Math.min(1000000, value));
    }

    public void setItemDropCount(int value) {
        this.itemDropCount = Math.max(1, Math.min(64, value));
    }

    public void setFriendlyMobChance(int value) {
        this.friendlyMobChance = Math.max(1, Math.min(1000000, value));
    }

    public void setLavaBucketChance(int value) {
        this.lavaBucketChance = Math.max(1, Math.min(1000000, value));
    }

    public void setWaterBucketChance(int value) {
        this.waterBucketChance = Math.max(1, Math.min(1000000, value));
    }

    public void setFriendlyMobSpawnRadius(int value) {
        this.friendlyMobSpawnRadius = Math.max(1, Math.min(1000000, value));
    }

    public void setHostileMobSpawnRadius(int value) {
        this.hostileMobSpawnRadius = Math.max(1, Math.min(1000000, value));
    }

    public void setEndPortalFrameChance(int value) {
        this.endPortalFrameChance = Math.max(1, Math.min(1000000, value));
    }

    public void setEndPortalFrameRequirement(int value) {
        this.endPortalFrameRequirement = Math.max(0, Math.min(1000000, value));
    }

    public void setMaxWaveSize(int value) {
        this.maxWaveSize = Math.max(1, Math.min(1000000, value));
    }

    public void setWaveSizeDivisor(int value) {
        this.waveSizeDivisor = Math.max(1, Math.min(1000000, value));
    }

    public void setProgressionCap(int value) {
        this.progressionCap = Math.max(1, Math.min(1000000, value));
    }

    public void setItemDropsEnabled(boolean value) {
        this.itemDropsEnabled = value;
    }

    public void setMobWavesEnabled(boolean value) {
        this.mobWavesEnabled = value;
    }

    public void setFriendlyMobsEnabled(boolean value) {
        this.friendlyMobsEnabled = value;
    }

    public void setEndPortalFrameEnabled(boolean value) {
        this.endPortalFrameEnabled = value;
    }

    public void setUseGlobalBreakCount(boolean value) {
        this.useGlobalBreakCount = value;
    }

    public void setBiomeCyclingEnabled(boolean value) {
        this.biomeCyclingEnabled = value;
    }

    public void setSpawnItemsInChest(boolean value) {
        this.spawnItemsInChest = value;
    }

    public void setShowBreaksInTab(boolean value) {
        this.showBreaksInTab = value;
    }

    public void setGentleItemDropOneBlock(boolean value) {
        this.gentleItemDropOneBlock = value;
    }

    public void setGentleItemDropAll(boolean value) {
        this.gentleItemDropAll = value;
    }

    public void setBiomeSwitchInterval(int value) {
        this.biomeSwitchInterval = Math.max(0, Math.min(1000000, value));
    }

    public void setBiomeVotingEnabled(boolean value) {
        this.biomeVotingEnabled = value;
    }

    public void setBiomeVoteCooldownMinutes(int value) {
        this.biomeVoteCooldownMinutes = Math.max(1, Math.min(1440, value));
    }

    public void setOneBlockDialogEnabled(boolean value) {
        this.oneBlockDialogEnabled = value;
    }

    public void setDialogDurationSeconds(int value) {
        this.dialogDurationSeconds = Math.max(1, Math.min(300, value));
    }

    public void setVisualEffectsEnabled(boolean value) {
        this.visualEffectsEnabled = value;
    }

    public void setWaveCompletionFeedback(boolean value) {
        this.waveCompletionFeedback = value;
    }

    public void setKeepInventoryOnDeath(boolean value) {
        this.keepInventoryOnDeath = value;
    }

    public boolean isWaveIncomingAlert() {
        return this.waveIncomingAlert;
    }

    public void setWaveIncomingAlert(boolean value) {
        this.waveIncomingAlert = value;
    }

    public int getWaveAlertDurationTicks() {
        return this.waveAlertDurationTicks;
    }

    public void setWaveAlertDurationTicks(int value) {
        this.waveAlertDurationTicks = Math.max(20, Math.min(200, value));
    }

    public int getWaveCountdown(int totalBreaks) {
        for (int i = this.waveThresholds.length - 1; i >= 0; --i) {
            if (totalBreaks < this.waveThresholds[i]) continue;
            return this.waveCountdowns[i];
        }
        return this.waveCountdowns[0];
    }

    public void setWaveCountdown(int index, int value) {
        if (index >= 0 && index < this.waveCountdowns.length) {
            this.waveCountdowns[index] = Math.max(1, value);
        }
    }

    public int getWaveThreshold(int index) {
        if (index >= 0 && index < this.waveThresholds.length) {
            return this.waveThresholds[index];
        }
        return 0;
    }

    public int getWaveTierCount() {
        return this.waveCountdowns.length;
    }

    public void writeNbt(class_2487 nbt) {
        nbt.method_10569("waveChance", this.waveChance);
        nbt.method_10569("itemDropChance", this.itemDropChance);
        nbt.method_10569("friendlyMobChance", this.friendlyMobChance);
        nbt.method_10569("endPortalFrameChance", this.endPortalFrameChance);
        nbt.method_10569("endPortalFrameRequirement", this.endPortalFrameRequirement);
        nbt.method_10569("maxWaveSize", this.maxWaveSize);
        nbt.method_10569("waveSizeDivisor", this.waveSizeDivisor);
        nbt.method_10569("progressionCap", this.progressionCap);
        nbt.method_10556("itemDropsEnabled", this.itemDropsEnabled);
        nbt.method_10556("mobWavesEnabled", this.mobWavesEnabled);
        nbt.method_10556("friendlyMobsEnabled", this.friendlyMobsEnabled);
        nbt.method_10556("endPortalFrameEnabled", this.endPortalFrameEnabled);
        nbt.method_10539("waveCountdowns", this.waveCountdowns);
        nbt.method_10539("waveThresholds", this.waveThresholds);
    }

    public void readNbt(class_2487 nbt) {
        if (nbt.method_10545("waveChance")) {
            this.waveChance = nbt.method_10550("waveChance").orElse(100);
        }
        if (nbt.method_10545("itemDropChance")) {
            this.itemDropChance = nbt.method_10550("itemDropChance").orElse(100);
        }
        if (nbt.method_10545("friendlyMobChance")) {
            this.friendlyMobChance = nbt.method_10550("friendlyMobChance").orElse(100);
        }
        if (nbt.method_10545("endPortalFrameChance")) {
            this.endPortalFrameChance = nbt.method_10550("endPortalFrameChance").orElse(200);
        }
        if (nbt.method_10545("endPortalFrameRequirement")) {
            this.endPortalFrameRequirement = nbt.method_10550("endPortalFrameRequirement").orElse(10000);
        }
        if (nbt.method_10545("maxWaveSize")) {
            this.maxWaveSize = nbt.method_10550("maxWaveSize").orElse(100);
        }
        if (nbt.method_10545("waveSizeDivisor")) {
            this.waveSizeDivisor = nbt.method_10550("waveSizeDivisor").orElse(100);
        }
        if (nbt.method_10545("progressionCap")) {
            this.progressionCap = nbt.method_10550("progressionCap").orElse(10000);
        }
        if (nbt.method_10545("itemDropsEnabled")) {
            this.itemDropsEnabled = nbt.method_10577("itemDropsEnabled").orElse(true);
        }
        if (nbt.method_10545("mobWavesEnabled")) {
            this.mobWavesEnabled = nbt.method_10577("mobWavesEnabled").orElse(true);
        }
        if (nbt.method_10545("friendlyMobsEnabled")) {
            this.friendlyMobsEnabled = nbt.method_10577("friendlyMobsEnabled").orElse(true);
        }
        if (nbt.method_10545("endPortalFrameEnabled")) {
            this.endPortalFrameEnabled = nbt.method_10577("endPortalFrameEnabled").orElse(true);
        }
        if (nbt.method_10545("waveCountdowns")) {
            this.waveCountdowns = nbt.method_10561("waveCountdowns").orElse(new int[]{12, 10, 8, 6, 5, 4, 3});
        }
        if (nbt.method_10545("waveThresholds")) {
            this.waveThresholds = nbt.method_10561("waveThresholds").orElse(new int[]{0, 500, 1500, 3000, 5000, 8000, 12000});
        }
    }

    public void resetToDefaults() {
        this.waveChance = 100;
        this.itemDropChance = 100;
        this.itemDropCount = 1;
        this.friendlyMobChance = 100;
        this.lavaBucketChance = 500;
        this.friendlyMobSpawnRadius = 4;
        this.hostileMobSpawnRadius = 4;
        this.endPortalFrameChance = 200;
        this.endPortalFrameRequirement = 10000;
        this.maxWaveSize = 100;
        this.waveSizeDivisor = 100;
        this.progressionCap = 10000;
        this.itemDropsEnabled = true;
        this.mobWavesEnabled = true;
        this.friendlyMobsEnabled = true;
        this.endPortalFrameEnabled = true;
        this.waveCountdowns = new int[]{12, 10, 8, 6, 5, 4, 3};
        this.waveThresholds = new int[]{0, 500, 1500, 3000, 5000, 8000, 12000};
    }

    public record WaveTiers(int[] countdowns, int[] thresholds, int biomeSwitchInterval) {
        public static final Codec<WaveTiers> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.INT_STREAM.xmap(s -> s.toArray(), Arrays::stream).optionalFieldOf("countdowns", (Object)new int[]{12, 10, 8, 6, 5, 4, 3}).forGetter(WaveTiers::countdowns), (App)Codec.INT_STREAM.xmap(s -> s.toArray(), Arrays::stream).optionalFieldOf("thresholds", (Object)new int[]{0, 500, 1500, 3000, 5000, 8000, 12000}).forGetter(WaveTiers::thresholds), (App)Codec.INT.optionalFieldOf("biomeSwitchInterval", (Object)100).forGetter(WaveTiers::biomeSwitchInterval)).apply((Applicative)inst, WaveTiers::new));
    }

    public record GameplayFeatures(boolean itemDropsEnabled, boolean mobWavesEnabled, boolean friendlyMobsEnabled, boolean endPortalFrameEnabled, boolean useGlobalBreakCount, boolean biomeCyclingEnabled, boolean spawnItemsInChest, boolean showBreaksInTab, boolean gentleItemDropOneBlock, boolean gentleItemDropAll, boolean biomeVotingEnabled, int biomeVoteCooldownMinutes) {
        public static final Codec<GameplayFeatures> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.BOOL.optionalFieldOf("itemDropsEnabled", (Object)true).forGetter(GameplayFeatures::itemDropsEnabled), (App)Codec.BOOL.optionalFieldOf("mobWavesEnabled", (Object)true).forGetter(GameplayFeatures::mobWavesEnabled), (App)Codec.BOOL.optionalFieldOf("friendlyMobsEnabled", (Object)true).forGetter(GameplayFeatures::friendlyMobsEnabled), (App)Codec.BOOL.optionalFieldOf("endPortalFrameEnabled", (Object)true).forGetter(GameplayFeatures::endPortalFrameEnabled), (App)Codec.BOOL.optionalFieldOf("useGlobalBreakCount", (Object)false).forGetter(GameplayFeatures::useGlobalBreakCount), (App)Codec.BOOL.optionalFieldOf("biomeCyclingEnabled", (Object)false).forGetter(GameplayFeatures::biomeCyclingEnabled), (App)Codec.BOOL.optionalFieldOf("spawnItemsInChest", (Object)false).forGetter(GameplayFeatures::spawnItemsInChest), (App)Codec.BOOL.optionalFieldOf("showBreaksInTab", (Object)false).forGetter(GameplayFeatures::showBreaksInTab), (App)Codec.BOOL.optionalFieldOf("gentleItemDropOneBlock", (Object)true).forGetter(GameplayFeatures::gentleItemDropOneBlock), (App)Codec.BOOL.optionalFieldOf("gentleItemDropAll", (Object)false).forGetter(GameplayFeatures::gentleItemDropAll), (App)Codec.BOOL.optionalFieldOf("biomeVotingEnabled", (Object)false).forGetter(GameplayFeatures::biomeVotingEnabled), (App)Codec.INT.optionalFieldOf("biomeVoteCooldownMinutes", (Object)5).forGetter(GameplayFeatures::biomeVoteCooldownMinutes)).apply((Applicative)inst, GameplayFeatures::new));
    }

    public record UIFeatures(boolean oneBlockDialogEnabled, int dialogDurationSeconds, boolean visualEffectsEnabled, boolean waveCompletionFeedback, boolean keepInventoryOnDeath, boolean waveIncomingAlert, int waveAlertDurationTicks) {
        public static final Codec<UIFeatures> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.BOOL.optionalFieldOf("oneBlockDialogEnabled", (Object)true).forGetter(UIFeatures::oneBlockDialogEnabled), (App)Codec.INT.optionalFieldOf("dialogDurationSeconds", (Object)60).forGetter(UIFeatures::dialogDurationSeconds), (App)Codec.BOOL.optionalFieldOf("visualEffectsEnabled", (Object)true).forGetter(UIFeatures::visualEffectsEnabled), (App)Codec.BOOL.optionalFieldOf("waveCompletionFeedback", (Object)true).forGetter(UIFeatures::waveCompletionFeedback), (App)Codec.BOOL.optionalFieldOf("keepInventoryOnDeath", (Object)false).forGetter(UIFeatures::keepInventoryOnDeath), (App)Codec.BOOL.optionalFieldOf("waveIncomingAlert", (Object)true).forGetter(UIFeatures::waveIncomingAlert), (App)Codec.INT.optionalFieldOf("waveAlertDurationTicks", (Object)100).forGetter(UIFeatures::waveAlertDurationTicks)).apply((Applicative)inst, UIFeatures::new));
    }
}

