/*
 * Decompiled with CFR 0.152.
 */
package lynk.oneblock.dialog;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import lynk.oneblock.persit.StateSaverAndLoader;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5903;
import net.minecraft.class_5904;
import net.minecraft.class_5905;
import net.minecraft.class_8113;
import net.minecraft.server.MinecraftServer;

public class OneBlockDialog {
    private static final Map<UUID, List<ActiveTextDisplay>> activeDisplays = new ConcurrentHashMap<UUID, List<ActiveTextDisplay>>();
    private static final Set<UUID> playersWithWaveWarning = ConcurrentHashMap.newKeySet();
    private static final List<String> GENERAL_DIALOGS = List.of("Keep going, you're doing great!", "Every block brings new possibilities...", "What will appear next?", "The OneBlock never runs out of surprises!", "Breaking blocks, building dreams.", "One block at a time...", "Progress is being made!", "The void watches as you persist.", "Each break brings you closer to greatness.", "Resources are gathering nicely!", "Your island grows with each break!", "The adventure continues!", "Persistence pays off!", "You've got this!", "The journey of a thousand blocks begins with one break.", "Tip: Check the admin panel for settings!", "Tip: Voting for biomes can change your island theme!", "Tip: Waves get harder as you progress!", "Tip: Build a platform to catch items safely!", "Tip: Friendly mobs can drop useful resources!", "Tip: Portal frames spawn at higher break counts!", "Tip: Different biomes spawn different blocks!", "Tip: Break count affects block progression!", "Tip: Chest spawns can collect items for you!", "Tip: The Nether and End unlock as you explore!", "Tip: Wave difficulty scales with your progress!", "Tip: Some blocks only appear in specific biomes!", "Tip: Compress 4 ice blocks + bucket for water!", "Tip: Compress 4 magma blocks + bucket for lava!", "Tip: Buckets drop randomly - save them for recipes!", "Why did the block break up? It needed space!", "This block is really... groundbreaking!", "I'm not saying you're obsessed, but...", "Block joke #47: Still mining my own business!", "What's a block's favorite music? Heavy metal!", "Breaking news: You're doing great!", "This island really blocks out the competition!", "Why don't blocks ever argue? They always stay grounded!", "I wood tell you a joke, but it might be too sappy!", "Stone cold determination right there!", "You really rock at this!", "Coal-d we be any luckier?", "This is un-ore-gettable!", "Diamonds are a miner's best friend!", "You've got some serious bedrock determination!", "In the void, one block is everything.", "From nothing, something emerges...", "The universe in a single block.", "What defines an island? You do.", "Breaking limits, one block at a time.", "The void is just the beginning.", "Every end is a new beginning.", "Creation through destruction.", "The cycle continues, eternal and surprising.", "Your dedication is inspiring!", "Nothing can stop you now!", "Excellence is a habit, you're proving it!", "Champions are made one block at a time!", "The only way is up!", "You're writing your own legend!", "Today's effort, tomorrow's triumph!", "Success is just around the corner... or block!");
    private static final List<String> ITEM_DROP_MESSAGES = List.of("Ooh, something useful dropped!", "A gift from the OneBlock!", "Your efforts are rewarded!", "That might come in handy!", "The OneBlock provides!", "Fortune smiles upon you!", "A helpful item appears!", "Resources acquired!", "Jackpot! An item appeared!", "The void delivers!", "Score! Free loot!", "Santa... Block? Item acquired!", "Your inventory just got better!", "Treasure from the depths!", "The OneBlock is feeling generous!", "Cha-ching! Resources obtained!", "Item get! (Zelda sound not included)", "Today's special delivery!", "The RNG gods favor you!", "Spoils of persistence!");
    private static final List<String> WAVE_INCOMING_MESSAGES = List.of("Enemies approach! Prepare yourself!", "A hostile wave is incoming!", "Danger detected! Arm yourself!", "Battle stations! Enemies inbound!", "The void sends its minions!", "Hostiles detected on the horizon!", "Prepare for combat!", "An enemy wave is approaching!", "Incoming! Brace for impact!", "They're coming... get ready!", "Time to prove your worth in battle!", "The darkness rises against you!", "Sharpen your blade, they're near!", "Combat imminent! Stand your ground!", "A storm of enemies approaches!", "The void grows restless...", "Monsters on the horizon!", "Ready your defenses!", "Here they come! Fight or flight!", "The enemy marches forth!");
    private static final List<String> FRIENDLY_SPAWN_MESSAGES = List.of("A friendly creature appears!", "You've got company!", "A peaceful mob joins you!", "Someone friendly stopped by!", "A gentle soul appears nearby.", "You're not alone anymore!", "A friend has arrived!", "Companionship appears!", "A new friend emerges from the void!", "Company for your lonely island!", "Look! A friendly face!", "The void sends a companion!", "Your island feels less empty now!", "A peaceful visitor has arrived!", "Someone to keep you company!", "Nature's gift: a friendly mob!", "A kindred spirit appears!", "The universe provides companionship!", "An ally emerges!", "Friendship spawned!");
    private static final List<String> MILESTONE_MESSAGES = List.of("You're making excellent progress!", "Breaking milestone achieved!", "Keep up the fantastic work!", "Your dedication is impressive!", "Another milestone reached!", "The journey continues!", "You're really mastering this!", "Incredible progress!", "Wow! Look at that break count!", "Milestone unlocked! Well done!", "Your persistence is legendary!", "Another hundred down!", "The numbers don't lie - you're amazing!", "Century mark reached!", "Breaking records AND blocks!", "Statistical excellence achieved!", "The dedication is real!", "You're on fire! (Metaphorically)", "Achievement unlocked: Block Breaker!", "Your commitment is unbreakable!", "Milestone madness! Keep it up!", "The grind never stops, neither do you!", "Impressive doesn't even cover it!", "History in the making!");
    private static final List<String> BIOME_CHANGE_MESSAGES = List.of("The world around you shifts...", "A new biome emerges!", "The environment transforms!", "The OneBlock adapts to a new theme!", "Reality bends to a new biome!", "The atmosphere changes...", "A different world takes shape!", "The biome has evolved!", "Climate change! (The good kind)", "The OneBlock morphs into something new!", "Biome shift detected!", "Welcome to a new world!", "The ecosystem transforms!", "A fresh environment awaits!", "New biome, new possibilities!", "The landscape evolves!", "Nature's remix activated!", "Biome transition complete!", "A whole new vibe!", "The environment reimagines itself!", "Biome roulette strikes again!", "Your island wears a new face!", "The void cycles through realms!", "Transformation in progress!");

    public static void sendDialog(class_3222 player, String message, DialogType type) {
        class_3218 world = player.method_51469();
        MinecraftServer server = world.method_8503();
        StateSaverAndLoader state = StateSaverAndLoader.getServerState(server);
        if (!state.getConfig().isOneBlockDialogEnabled()) {
            return;
        }
        UUID playerUuid = player.method_5667();
        if (playersWithWaveWarning.contains(playerUuid) && type != DialogType.WARNING) {
            return;
        }
        int duration = state.getConfig().getDialogDurationSeconds();
        class_2338 oneBlockPos = state.getOneBlockPos(playerUuid);
        List<ActiveTextDisplay> existingDisplays = activeDisplays.get(playerUuid);
        if (existingDisplays != null) {
            for (ActiveTextDisplay display : existingDisplays) {
                display.entity.method_31472();
            }
            existingDisplays.clear();
        }
        class_5250 formattedMessage = class_2561.method_43470((String)(type.prefix + message));
        class_8113.class_8123 textDisplay = new class_8113.class_8123(class_1299.field_42457, (class_1937)world);
        textDisplay.method_5814((double)oneBlockPos.method_10263() + 0.5, (double)oneBlockPos.method_10264() + 1.8, (double)oneBlockPos.method_10260() + 0.5);
        textDisplay.method_48911((class_2561)formattedMessage);
        textDisplay.method_48847(class_8113.class_8114.field_42409);
        world.method_8649((class_1297)textDisplay);
        activeDisplays.computeIfAbsent(playerUuid, k -> new ArrayList()).add(new ActiveTextDisplay(textDisplay, duration));
        if (type == DialogType.WARNING) {
            playersWithWaveWarning.add(playerUuid);
        }
    }

    public static void tick(MinecraftServer server) {
        if (activeDisplays.isEmpty()) {
            return;
        }
        Iterator<Map.Entry<UUID, List<ActiveTextDisplay>>> playerIterator = activeDisplays.entrySet().iterator();
        while (playerIterator.hasNext()) {
            Map.Entry<UUID, List<ActiveTextDisplay>> entry = playerIterator.next();
            List<ActiveTextDisplay> displays = entry.getValue();
            Iterator<ActiveTextDisplay> displayIterator = displays.iterator();
            while (displayIterator.hasNext()) {
                ActiveTextDisplay display = displayIterator.next();
                if (!display.isExpired()) continue;
                display.entity.method_31472();
                displayIterator.remove();
            }
            if (!displays.isEmpty()) continue;
            playerIterator.remove();
        }
    }

    public static void clearDialog(UUID playerUuid) {
        List<ActiveTextDisplay> displays = activeDisplays.get(playerUuid);
        if (displays != null) {
            for (ActiveTextDisplay display : displays) {
                display.entity.method_31472();
            }
            displays.clear();
            activeDisplays.remove(playerUuid);
        }
        playersWithWaveWarning.remove(playerUuid);
    }

    public static void sendWelcomeMessage(class_3222 player) {
        OneBlockDialog.sendDialog(player, "Break the OneBlock to begin your journey!", DialogType.MILESTONE);
    }

    public static void sendRandomDialog(class_3222 player) {
        Random random = new Random();
        String message = GENERAL_DIALOGS.get(random.nextInt(GENERAL_DIALOGS.size()));
        OneBlockDialog.sendDialog(player, message, DialogType.GENERAL);
    }

    public static void sendItemDropMessage(class_3222 player) {
        Random random = new Random();
        String message = ITEM_DROP_MESSAGES.get(random.nextInt(ITEM_DROP_MESSAGES.size()));
        OneBlockDialog.sendDialog(player, message, DialogType.ITEM);
    }

    public static void sendWaveIncomingMessage(class_3222 player, int waveSize) {
        StateSaverAndLoader state = StateSaverAndLoader.getServerState(player.method_51469().method_8503());
        if (!state.getConfig().isWaveIncomingAlert()) {
            return;
        }
        int duration = state.getConfig().getWaveAlertDurationTicks();
        int fadeIn = 5;
        int fadeOut = 10;
        int stay = duration - fadeIn - fadeOut;
        player.field_13987.method_14364((class_2596)new class_5905(fadeIn, stay, fadeOut));
        player.field_13987.method_14364((class_2596)new class_5904((class_2561)class_2561.method_43470((String)"\u00a7c\u00a7l\u26a0 INCOMING WAVE \u26a0")));
        player.field_13987.method_14364((class_2596)new class_5903((class_2561)class_2561.method_43470((String)("\u00a77" + waveSize + " enemies approaching"))));
    }

    public static void sendFriendlySpawnMessage(class_3222 player) {
        Random random = new Random();
        String message = FRIENDLY_SPAWN_MESSAGES.get(random.nextInt(FRIENDLY_SPAWN_MESSAGES.size()));
        OneBlockDialog.sendDialog(player, message, DialogType.FRIENDLY);
    }

    public static void sendMilestoneMessage(class_3222 player, long breaks) {
        Random random = new Random();
        Object message = MILESTONE_MESSAGES.get(random.nextInt(MILESTONE_MESSAGES.size()));
        message = (String)message + " (" + breaks + " breaks)";
        OneBlockDialog.sendDialog(player, (String)message, DialogType.MILESTONE);
    }

    public static void sendBiomeChangeMessage(class_3222 player, String biomeName) {
        Random random = new Random();
        Object message = BIOME_CHANGE_MESSAGES.get(random.nextInt(BIOME_CHANGE_MESSAGES.size()));
        message = (String)message + " Now in: " + biomeName;
        OneBlockDialog.sendDialog(player, (String)message, DialogType.BIOME);
    }

    public static enum DialogType {
        GENERAL("\u00a7f", class_124.field_1068),
        ITEM("\u00a76", class_124.field_1065),
        WARNING("\u00a7c", class_124.field_1061),
        FRIENDLY("\u00a7a", class_124.field_1060),
        MILESTONE("\u00a7d", class_124.field_1076),
        BIOME("\u00a73", class_124.field_1062);

        final String prefix;
        final class_124 formatting;

        private DialogType(String prefix, class_124 formatting) {
            this.prefix = prefix;
            this.formatting = formatting;
        }
    }

    private static class ActiveTextDisplay {
        final class_8113.class_8123 entity;
        final long expiryTime;

        ActiveTextDisplay(class_8113.class_8123 entity, int durationSeconds) {
            this.entity = entity;
            this.expiryTime = System.currentTimeMillis() + (long)durationSeconds * 1000L;
        }

        boolean isExpired() {
            return System.currentTimeMillis() >= this.expiryTime;
        }
    }
}

