/*
 * Decompiled with CFR 0.152.
 */
package lynk.oneblock.events;

import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_3218;

public class WaveTracker {
    private static final Map<UUID, Set<UUID>> activeWaveMobs = new ConcurrentHashMap<UUID, Set<UUID>>();
    private static final Map<UUID, Integer> waveSizes = new ConcurrentHashMap<UUID, Integer>();

    public static void registerWaveMob(UUID playerUuid, UUID mobUuid, int totalWaveSize) {
        activeWaveMobs.computeIfAbsent(playerUuid, k -> ConcurrentHashMap.newKeySet()).add(mobUuid);
        waveSizes.put(playerUuid, totalWaveSize);
    }

    public static void onWaveMobDeath(class_3218 world, class_1309 mob, UUID playerUuid) {
        Set<UUID> waveMobs = activeWaveMobs.get(playerUuid);
        if (waveMobs == null) {
            return;
        }
        waveMobs.remove(mob.method_5667());
        if (waveMobs.isEmpty()) {
            WaveTracker.onWaveCompleted(world, playerUuid);
        }
    }

    private static void onWaveCompleted(class_3218 world, UUID playerUuid) {
        activeWaveMobs.remove(playerUuid);
        Integer waveSize = waveSizes.remove(playerUuid);
    }

    public static void clearWave(UUID playerUuid) {
        activeWaveMobs.remove(playerUuid);
        waveSizes.remove(playerUuid);
    }

    public static void tick(class_3218 world) {
        activeWaveMobs.forEach((playerUuid, mobUuids) -> {
            mobUuids.removeIf(mobUuid -> {
                class_1297 entity = world.method_66347(mobUuid);
                return entity == null || !entity.method_5805();
            });
            if (mobUuids.isEmpty()) {
                WaveTracker.onWaveCompleted(world, playerUuid);
            }
        });
    }
}

