/*
 * Decompiled with CFR 0.152.
 */
package lynk.oneblock.mixin;

import lynk.oneblock.persit.StateSaverAndLoader;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;

@Mixin(value={class_1542.class})
public class ItemEntityMixin {
    @Unique
    private boolean oneblock$checkedGentle = false;
    @Unique
    private boolean oneblock$shouldBeGentle = false;
    @Unique
    private int oneblock$ticksSinceSpawn = 0;

    @Inject(method={"<init>(Lnet/minecraft/world/World;DDDLnet/minecraft/item/ItemStack;)V"}, at={@At(value="RETURN")})
    private void onItemEntityInitSimple(class_1937 world, double x, double y, double z, class_1799 stack, CallbackInfo ci) {
        this.checkGentleConfig(world);
    }

    @Inject(method={"<init>(Lnet/minecraft/world/World;DDDLnet/minecraft/item/ItemStack;DDD)V"}, at={@At(value="RETURN")})
    private void onItemEntityInitWithVelocity(class_1937 world, double x, double y, double z, class_1799 stack, double velocityX, double velocityY, double velocityZ, CallbackInfo ci) {
        this.checkGentleConfig(world);
        this.applyGentleDrop();
    }

    @Unique
    private void checkGentleConfig(class_1937 world) {
        if (this.oneblock$checkedGentle) {
            return;
        }
        this.oneblock$checkedGentle = true;
        if (world.method_8608()) {
            return;
        }
        MinecraftServer server = world.method_8503();
        if (server == null) {
            return;
        }
        StateSaverAndLoader state = StateSaverAndLoader.getServerState(server);
        if (state == null) {
            return;
        }
        boolean gentleAll = state.getConfig().isGentleItemDropAll();
        boolean gentleOneBlock = state.getConfig().isGentleItemDropOneBlock();
        boolean bl = this.oneblock$shouldBeGentle = gentleAll || gentleOneBlock;
        if (this.oneblock$shouldBeGentle) {
            System.out.println("[OneBlock] Gentle drop enabled for item entity");
        }
    }

    @Unique
    private void applyGentleDrop() {
        if (this.oneblock$shouldBeGentle) {
            class_1542 self = (class_1542)this;
            self.method_18799(class_243.field_1353);
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    private void onTickStart(CallbackInfo ci) {
        if (this.oneblock$shouldBeGentle && this.oneblock$ticksSinceSpawn < 40) {
            class_1542 self = (class_1542)this;
            self.method_18799(class_243.field_1353);
            ++this.oneblock$ticksSinceSpawn;
        }
    }

    @ModifyArgs(method={"tick()V"}, at=@At(value="INVOKE", target="Lnet/minecraft/entity/ItemEntity;setVelocity(DDD)V"))
    private void modifyTickVelocity(Args args) {
        if (this.oneblock$shouldBeGentle && this.oneblock$ticksSinceSpawn < 40) {
            args.set(0, (Object)0.0);
            args.set(1, (Object)0.0);
            args.set(2, (Object)0.0);
        }
    }

    @Inject(method={"tick()V"}, at={@At(value="RETURN")})
    private void onTickEnd(CallbackInfo ci) {
        if (this.oneblock$shouldBeGentle && this.oneblock$ticksSinceSpawn < 40) {
            class_1542 self = (class_1542)this;
            self.method_18799(class_243.field_1353);
        }
    }
}

