/*
 * Decompiled with CFR 0.152.
 */
package lynk.oneblock.persit;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import lynk.oneblock.config.OneBlockConfig;
import lynk.oneblock.datapack.MultiplayerPackControl;
import net.minecraft.class_10741;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_26;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_4284;
import net.minecraft.server.MinecraftServer;

public class StateSaverAndLoader
extends class_18 {
    private final Map<UUID, PlayerStats> playerStats;
    private PlayerStats globalStats;
    private OneBlockConfig config;
    private static final String STORAGE_KEY = "oneblock_state";
    public static final int ONEBLOCK_Y = 64;
    public static final int STEP = 1000;
    private transient boolean legacyImported = false;
    private static final Codec<Map<UUID, PlayerStats>> STATS_CODEC = Codec.unboundedMap((Codec)Codec.STRING, PlayerStats.CODEC).xmap(stringKeyed -> {
        HashMap out = new HashMap();
        stringKeyed.forEach((k, v) -> {
            try {
                out.put(UUID.fromString(k), v);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        });
        return out;
    }, uuidKeyed -> {
        HashMap out = new HashMap();
        uuidKeyed.forEach((k, v) -> out.put(k.toString(), v));
        return out;
    });
    private static final Codec<StateSaverAndLoader> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)STATS_CODEC.optionalFieldOf("playerStats", new HashMap()).forGetter(s -> s.playerStats), (App)PlayerStats.CODEC.optionalFieldOf("globalStats", (Object)new PlayerStats()).forGetter(s -> s.globalStats != null ? s.globalStats : new PlayerStats()), (App)OneBlockConfig.CODEC.optionalFieldOf("config", (Object)new OneBlockConfig()).forGetter(s -> s.config != null ? s.config : new OneBlockConfig()), (App)Codec.LONG.optionalFieldOf("totalOneBlockBreaks").forGetter(s -> Optional.empty()), (App)Codec.BOOL.optionalFieldOf("MobSpawnSet").forGetter(s -> Optional.empty()), (App)Codec.INT.optionalFieldOf("BreaksTillSpawn").forGetter(s -> Optional.empty()), (App)Codec.INT.optionalFieldOf("PendingMobCount").forGetter(s -> Optional.empty())).apply((Applicative)inst, (map, globalStats, config, legacyBreaksOpt, legacyMobOpt, legacyTillOpt, legacyPendingOpt) -> {
        StateSaverAndLoader out = new StateSaverAndLoader((Map<UUID, PlayerStats>)map, (PlayerStats)globalStats, (OneBlockConfig)config);
        boolean imported = false;
        if (legacyBreaksOpt.isPresent()) {
            out.globalStats.totalOneBlockBreaks = (Long)legacyBreaksOpt.get();
            imported = true;
        }
        if (legacyMobOpt.isPresent()) {
            out.globalStats.mobSpawnSet = (Boolean)legacyMobOpt.get();
            imported = true;
        }
        if (legacyTillOpt.isPresent()) {
            out.globalStats.breaksTillSpawn = (Integer)legacyTillOpt.get();
            imported = true;
        }
        if (legacyPendingOpt.isPresent()) {
            out.globalStats.pendingMobCount = (Integer)legacyPendingOpt.get();
            imported = true;
        }
        out.legacyImported = imported;
        return out;
    }));
    private static final class_10741<StateSaverAndLoader> TYPE = new class_10741("oneblock_state", StateSaverAndLoader::new, CODEC, (class_4284)null);

    public StateSaverAndLoader() {
        this(new HashMap<UUID, PlayerStats>(), new PlayerStats(), new OneBlockConfig());
    }

    private StateSaverAndLoader(Map<UUID, PlayerStats> playerStats, PlayerStats globalStats, OneBlockConfig config) {
        this.playerStats = new HashMap<UUID, PlayerStats>(playerStats);
        this.globalStats = globalStats == null ? new PlayerStats() : globalStats;
        this.config = config == null ? new OneBlockConfig() : config;
    }

    public static StateSaverAndLoader getServerState(MinecraftServer server) {
        class_3218 overworld = server.method_3847(class_1937.field_25179);
        if (overworld == null) {
            throw new IllegalStateException("Overworld not loaded yet");
        }
        class_26 manager = overworld.method_17983();
        return (StateSaverAndLoader)manager.method_17924(TYPE);
    }

    private boolean isMultiplayer() {
        return MultiplayerPackControl.isEnabled();
    }

    private PlayerStats getEffectiveStats(UUID playerId) {
        return this.isMultiplayer() ? this.getStats(playerId) : this.globalStats;
    }

    public PlayerStats getStats(UUID playerId) {
        return this.playerStats.computeIfAbsent(playerId, id -> new PlayerStats());
    }

    public void incrementBreaks(UUID playerId) {
        PlayerStats ps = this.getEffectiveStats(playerId);
        ++ps.totalOneBlockBreaks;
        this.method_80();
    }

    public void addBreaks(UUID playerId, long amount) {
        if (amount <= 0L) {
            return;
        }
        PlayerStats ps = this.getEffectiveStats(playerId);
        ps.totalOneBlockBreaks += amount;
        this.method_80();
    }

    public void setMobSpawnSet(UUID playerId, boolean v) {
        this.getEffectiveStats((UUID)playerId).mobSpawnSet = v;
        this.method_80();
    }

    public boolean getMobSpawnSet(UUID playerId) {
        return this.getEffectiveStats((UUID)playerId).mobSpawnSet;
    }

    public void setBreaksTillSpawn(UUID playerId, int v) {
        this.getEffectiveStats((UUID)playerId).breaksTillSpawn = v;
        this.method_80();
    }

    public long getBreaksTillSpawn(UUID playerId) {
        return this.getEffectiveStats((UUID)playerId).breaksTillSpawn;
    }

    public void decrementBreaksTillSpawn(UUID playerId) {
        --this.getEffectiveStats((UUID)playerId).breaksTillSpawn;
        this.method_80();
    }

    public void setPendingMobCount(UUID playerId, int v) {
        this.getEffectiveStats((UUID)playerId).pendingMobCount = v;
        this.method_80();
    }

    public int getPendingMobCount(UUID playerId) {
        return this.getEffectiveStats((UUID)playerId).pendingMobCount;
    }

    public void setOneBlockPos(UUID playerId, class_2338 pos) {
        this.getEffectiveStats((UUID)playerId).oneBlockPos = pos;
        this.method_80();
    }

    public class_2338 getOneBlockPos(UUID playerId) {
        return this.getEffectiveStats((UUID)playerId).oneBlockPos;
    }

    public OneBlockConfig getConfig() {
        return this.config;
    }

    public Map<UUID, PlayerStats> getAllPlayerStats() {
        return Collections.unmodifiableMap(this.playerStats);
    }

    public long getTotalBreaksAllPlayers() {
        if (!this.isMultiplayer()) {
            return this.globalStats.totalOneBlockBreaks;
        }
        return this.playerStats.values().stream().mapToLong(ps -> ps.totalOneBlockBreaks).sum();
    }

    public void markVisitedNether(UUID playerId) {
        PlayerStats ps = this.getEffectiveStats(playerId);
        if (!ps.hasVisitedNether) {
            ps.hasVisitedNether = true;
            this.method_80();
        }
    }

    public void markVisitedEnd(UUID playerId) {
        PlayerStats ps = this.getEffectiveStats(playerId);
        if (!ps.hasVisitedEnd) {
            ps.hasVisitedEnd = true;
            this.method_80();
        }
    }

    public boolean hasVisitedNether(UUID playerId) {
        return this.getEffectiveStats((UUID)playerId).hasVisitedNether;
    }

    public boolean hasVisitedEnd(UUID playerId) {
        return this.getEffectiveStats((UUID)playerId).hasVisitedEnd;
    }

    public boolean anyoneVisitedNether() {
        if (!this.isMultiplayer()) {
            return this.globalStats.hasVisitedNether;
        }
        for (PlayerStats ps : this.playerStats.values()) {
            if (!ps.hasVisitedNether) continue;
            return true;
        }
        return false;
    }

    public boolean anyoneVisitedEnd() {
        if (!this.isMultiplayer()) {
            return this.globalStats.hasVisitedEnd;
        }
        for (PlayerStats ps : this.playerStats.values()) {
            if (!ps.hasVisitedEnd) continue;
            return true;
        }
        return false;
    }

    public class_2338 allocateOneBlockIfAbsent(UUID playerId) {
        if (this.isMultiplayer()) {
            class_2338 candidate;
            PlayerStats ps = this.getStats(playerId);
            if (ps.oneBlockPos != null) {
                return ps.oneBlockPos;
            }
            Set occupied = this.playerStats.values().stream().map(s -> s.oneBlockPos).filter(Objects::nonNull).map(p -> StateSaverAndLoader.packXZ(p.method_10263(), p.method_10260())).collect(Collectors.toSet());
            int n = 0;
            while (occupied.contains(StateSaverAndLoader.packXZ((candidate = this.computeSlotPosition(n++)).method_10263(), candidate.method_10260()))) {
            }
            ps.oneBlockPos = candidate;
            this.method_80();
            return candidate;
        }
        if (this.globalStats.oneBlockPos == null) {
            this.globalStats.oneBlockPos = new class_2338(0, 64, 0);
            this.method_80();
        }
        return this.globalStats.oneBlockPos;
    }

    private static long packXZ(int x, int z) {
        return (long)x << 32 ^ (long)z & 0xFFFFFFFFL;
    }

    public class_2338 computeSlotPosition(int n) {
        if (n < 0) {
            n = 0;
        }
        int ring = n / 4 + 1;
        int dir = n % 4;
        int dist = ring * 1000;
        int x = 0;
        int z = 0;
        switch (dir) {
            case 0: {
                x = dist;
                break;
            }
            case 1: {
                z = dist;
                break;
            }
            case 2: {
                x = -dist;
                break;
            }
            case 3: {
                z = -dist;
            }
        }
        return new class_2338(x, 64, z);
    }

    public boolean isPlayersOneBlock(class_3222 player, class_2338 pos) {
        return this.isPlayersOneBlock(player.method_5667(), pos);
    }

    public void forEachPlayer(BiConsumer<UUID, PlayerStats> action) {
        this.playerStats.forEach(action);
    }

    public boolean isPlayersOneBlock(UUID playerId, class_2338 pos) {
        return Objects.equals(this.getOneBlockPos(playerId), pos);
    }

    public Optional<UUID> findOwnerByOneBlockPos(class_2338 pos) {
        if (!this.isMultiplayer()) {
            return Optional.empty();
        }
        for (Map.Entry<UUID, PlayerStats> e : this.getAllPlayerStats().entrySet()) {
            class_2338 p = e.getValue().oneBlockPos;
            if (p == null || !p.equals((Object)pos)) continue;
            return Optional.of(e.getKey());
        }
        return Optional.empty();
    }

    public long getPlayerBlockBreaks(UUID uuid) {
        if (this.config.useGlobalBreakCount()) {
            return this.getTotalBreaksAllPlayers();
        }
        return this.getEffectiveStats((UUID)uuid).totalOneBlockBreaks;
    }

    public long getPlayerIndividualBreaks(UUID uuid) {
        return this.getEffectiveStats((UUID)uuid).totalOneBlockBreaks;
    }

    public int getCountRegisteredPlayers() {
        return this.playerStats.size();
    }

    public PlayerStats getAnyOtherPlayersStats(UUID selfUuid) {
        if (!this.isMultiplayer()) {
            return null;
        }
        for (Map.Entry<UUID, PlayerStats> entry : this.playerStats.entrySet()) {
            if (entry.getKey().equals(selfUuid)) continue;
            return entry.getValue();
        }
        return null;
    }

    public void migratePerPlayerIntoGlobalIfNeeded() {
        boolean hasGlobalData;
        if (MultiplayerPackControl.isEnabled()) {
            return;
        }
        if (this.playerStats.isEmpty()) {
            return;
        }
        boolean bl = hasGlobalData = this.globalStats.totalOneBlockBreaks > 0L || this.globalStats.mobSpawnSet || this.globalStats.pendingMobCount > 0 || this.globalStats.oneBlockPos != null || this.globalStats.hasVisitedNether || this.globalStats.hasVisitedEnd;
        if (hasGlobalData) {
            return;
        }
        long totalBreaks = 0L;
        boolean anyMobSpawnSet = false;
        int minBreaksTillSpawn = Integer.MAX_VALUE;
        int sumPending = 0;
        boolean anyVisitedNether = false;
        boolean anyVisitedEnd = false;
        for (PlayerStats ps : this.playerStats.values()) {
            totalBreaks += ps.totalOneBlockBreaks;
            anyMobSpawnSet |= ps.mobSpawnSet;
            if (ps.breaksTillSpawn < minBreaksTillSpawn) {
                minBreaksTillSpawn = ps.breaksTillSpawn;
            }
            sumPending += ps.pendingMobCount;
            anyVisitedNether |= ps.hasVisitedNether;
            anyVisitedEnd |= ps.hasVisitedEnd;
        }
        this.globalStats.totalOneBlockBreaks = totalBreaks;
        this.globalStats.mobSpawnSet = anyMobSpawnSet;
        this.globalStats.breaksTillSpawn = minBreaksTillSpawn == Integer.MAX_VALUE ? this.globalStats.breaksTillSpawn : minBreaksTillSpawn;
        this.globalStats.pendingMobCount = sumPending;
        this.globalStats.hasVisitedNether = anyVisitedNether;
        this.globalStats.hasVisitedEnd = anyVisitedEnd;
        if (this.globalStats.oneBlockPos == null) {
            this.globalStats.oneBlockPos = new class_2338(0, 64, 0);
        }
        this.method_80();
    }

    public void announceLegacyImport(MinecraftServer server) {
        if (!this.legacyImported || server == null) {
            return;
        }
        this.legacyImported = false;
        String msg = "\u00a7e[OneBlock] \u00a77Imported legacy save data into the new format. Your progress and settings have been preserved.";
        System.out.println("[OneBlock] Imported legacy save data into the new format.");
        class_3324 pm = server.method_3760();
        pm.method_14571().forEach(p -> p.method_7353((class_2561)class_2561.method_43470((String)msg), false));
    }

    public static class PlayerStats {
        public long totalOneBlockBreaks = 0L;
        public boolean mobSpawnSet = false;
        public int breaksTillSpawn = 10;
        public int pendingMobCount = 0;
        public class_2338 oneBlockPos = null;
        public boolean hasVisitedNether = false;
        public boolean hasVisitedEnd = false;
        public boolean islandGenerated = false;
        private static final Codec<PlayerStats> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.LONG.optionalFieldOf("totalOneBlockBreaks", (Object)0L).forGetter(p -> p.totalOneBlockBreaks), (App)Codec.BOOL.optionalFieldOf("mobSpawnSet", (Object)false).forGetter(p -> p.mobSpawnSet), (App)Codec.INT.optionalFieldOf("breaksTillSpawn", (Object)10).forGetter(p -> p.breaksTillSpawn), (App)Codec.INT.optionalFieldOf("pendingMobCount", (Object)0).forGetter(p -> p.pendingMobCount), (App)class_2338.field_25064.optionalFieldOf("oneBlockPos").forGetter(p -> Optional.ofNullable(p.oneBlockPos)), (App)Codec.BOOL.optionalFieldOf("hasVisitedNether", (Object)false).forGetter(p -> p.hasVisitedNether), (App)Codec.BOOL.optionalFieldOf("hasVisitedEnd", (Object)false).forGetter(p -> p.hasVisitedEnd), (App)Codec.BOOL.optionalFieldOf("islandGenerated", (Object)false).forGetter(p -> p.islandGenerated)).apply((Applicative)inst, (breaks, mob, till, pending, posOpt, visitedNether, visitedEnd, islandGen) -> new PlayerStats((long)breaks, (boolean)mob, (int)till, (int)pending, posOpt.orElse(null), (boolean)visitedNether, (boolean)visitedEnd, (boolean)islandGen)));

        public PlayerStats() {
        }

        private PlayerStats(long totalOneBlockBreaks, boolean mobSpawnSet, int breaksTillSpawn, int pendingMobCount, class_2338 oneBlockPos, boolean hasVisitedNether, boolean hasVisitedEnd, boolean islandGenerated) {
            this.totalOneBlockBreaks = totalOneBlockBreaks;
            this.mobSpawnSet = mobSpawnSet;
            this.breaksTillSpawn = breaksTillSpawn;
            this.pendingMobCount = pendingMobCount;
            this.oneBlockPos = oneBlockPos;
            this.hasVisitedNether = hasVisitedNether;
            this.hasVisitedEnd = hasVisitedEnd;
            this.islandGenerated = islandGenerated;
        }
    }
}

