/*
 * Decompiled with CFR 0.152.
 */
package lynk.oneblock.server;

import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import lynk.oneblock.biome.BiomeVote;
import lynk.oneblock.config.OneBlockConfig;
import lynk.oneblock.datapack.MultiplayerPackControl;
import lynk.oneblock.dialog.OneBlockDialog;
import lynk.oneblock.events.FriendlySpawn;
import lynk.oneblock.events.MobSpawn;
import lynk.oneblock.events.WaveTracker;
import lynk.oneblock.persit.StateSaverAndLoader;
import lynk.oneblock.server.OneBlockSafety;
import lynk.oneblock.server.PlayerTabListUpdater;
import lynk.oneblock.util.IslandBuilder;
import lynk.oneblock.util.MiscUtil;
import lynk.oneblock.util.RandomBlockUtil;
import lynk.oneblock.util.RandomItemUtil;
import lynk.oneblock.util.UpdateChecker;
import net.fabricmc.fabric.api.entity.event.v1.ServerEntityWorldChangeEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2346;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2709;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_4208;
import net.minecraft.class_5217;
import net.minecraft.server.MinecraftServer;

public final class Events {
    private static int tickCounter = 0;
    private static final Map<UUID, String> lastBiomeMap = new HashMap<UUID, String>();
    private static final Set<UUID> gentleDropItems = new ConcurrentHashMap().keySet(true);
    private static final Map<UUID, Integer> gentleDropItemAge = new ConcurrentHashMap<UUID, Integer>();
    private static final Map<class_2338, class_2680> lastKnownOneBlockState = new ConcurrentHashMap<class_2338, class_2680>();

    public static void register() {
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            UpdateChecker.checkNow(server);
            StateSaverAndLoader state = StateSaverAndLoader.getServerState(server);
            MultiplayerPackControl.refresh(server);
            state.migratePerPlayerIntoGlobalIfNeeded();
            System.out.println("[OneBlock] Aggregated per-player stats into global stats (multiplayer pack disabled).");
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            StateSaverAndLoader s = StateSaverAndLoader.getServerState(server);
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            boolean needsSpawn;
            class_3222 player = handler.field_14140;
            StateSaverAndLoader state = StateSaverAndLoader.getServerState(server);
            state.announceLegacyImport(server);
            class_2338 one = state.allocateOneBlockIfAbsent(player.method_5667());
            IslandBuilder.buildIfMissing(player.method_51469(), one);
            class_2680 oneBlockState = player.method_51469().method_8320(one);
            if (oneBlockState.method_26215()) {
                player.method_51469().method_8501(one, class_2246.field_10219.method_9564());
            }
            boolean bl = needsSpawn = player.method_67564() == null;
            if (needsSpawn) {
                class_2338 blockPos = state.getOneBlockPos(player.method_5667());
                player.method_51469();
                class_4208 globalPos = new class_4208(class_3218.field_25179, blockPos);
                class_5217.class_12064 spawnPoint = new class_5217.class_12064(globalPos, 0.0f, 0.0f);
                class_3222.class_10766 respawn = new class_3222.class_10766(spawnPoint, true);
                player.method_26284(respawn, true);
            }
            if (player.method_24515().method_10262((class_2382)one) > 256.0) {
                player.method_6082((double)one.method_10263() + 0.5, (double)(one.method_10264() + 1), (double)one.method_10260() + 0.5, true);
            }
            player.method_7353((class_2561)class_2561.method_43470((String)String.format("\u00a7e[OneBlock] \u00a77Your island is at \u00a7b(%d, %d, %d)", one.method_10263(), one.method_10264(), one.method_10260())), false);
            if (state.getPlayerBlockBreaks(player.method_5667()) == 0L) {
                OneBlockDialog.sendWelcomeMessage(player);
            }
        });
        PlayerBlockBreakEvents.BEFORE.register((world, player, pos, state, blockEntity) -> {
            if (world.method_8608()) {
                return true;
            }
            StateSaverAndLoader ssal = StateSaverAndLoader.getServerState(world.method_8503());
            if (ssal.isPlayersOneBlock(player.method_5667(), pos)) {
                return true;
            }
            Optional<UUID> owner = ssal.findOwnerByOneBlockPos(pos);
            if (owner.isPresent() && !owner.get().equals(player.method_5667())) {
                player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cYou can only break your own OneBlock."), true);
                return false;
            }
            return true;
        });
        PlayerBlockBreakEvents.BEFORE.register((world, player, pos, state, blockEntity) -> {
            System.out.println("[OneBlock] BEFORE event triggered for block at " + String.valueOf(pos));
            if (world.method_8608()) {
                System.out.println("[OneBlock] Skipping - client side");
                return true;
            }
            StateSaverAndLoader serverState = StateSaverAndLoader.getServerState(world.method_8503());
            boolean isOneBlock = serverState.isPlayersOneBlock(player.method_5667(), pos);
            System.out.println("[OneBlock] isOneBlock: " + isOneBlock);
            System.out.println("[OneBlock] gentleItemDropAll: " + serverState.getConfig().isGentleItemDropAll());
            System.out.println("[OneBlock] gentleItemDropOneBlock: " + serverState.getConfig().isGentleItemDropOneBlock());
            if (isOneBlock && serverState.getConfig().isGentleItemDropOneBlock()) {
                System.out.println("[OneBlock] Applying gentle drop to OneBlock block drops");
                Events.applyGentleDropToOneBlock(world, pos, state, blockEntity, player);
                world.method_8650(pos, false);
                Events.handleOneBlockBreak(world, player);
                return false;
            }
            if (!isOneBlock && serverState.getConfig().isGentleItemDropAll()) {
                System.out.println("[OneBlock] Calling applyGentleDropToBlock for regular block");
                Events.applyGentleDropToBlock(world, pos, state, blockEntity, player);
                return false;
            }
            System.out.println("[OneBlock] Gentle drop not enabled, allowing normal break");
            return true;
        });
        PlayerBlockBreakEvents.AFTER.register((world, player, pos, state, entity) -> {
            StateSaverAndLoader serverState = StateSaverAndLoader.getServerState(world.method_8503());
            if (serverState.isPlayersOneBlock(player.method_5667(), pos)) {
                Events.handleOneBlockBreak(world, player);
            }
        });
        ServerTickEvents.END_WORLD_TICK.register(world -> {
            if (world.method_27983() != class_1937.field_25179) {
                return;
            }
            OneBlockSafety.tick(world);
            Events.detectAndResetPistonMovedOneBlocks(world);
            int PERIOD = 200;
            if (world.method_8510() % 200L == 0L) {
                world.method_17983().method_125();
            }
        });
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            PlayerTabListUpdater.tick(server);
            Events.tickGentleDropItems(server);
            BiomeVote.tick(server);
            OneBlockDialog.tick(server);
            for (class_3218 world : server.method_3738()) {
                WaveTracker.tick(world);
            }
            if (++tickCounter >= 36000) {
                UpdateChecker.checkNow(server);
                tickCounter = 0;
            }
        });
        ServerPlayerEvents.AFTER_RESPAWN.register((oldPlayer, newPlayer, alive) -> {
            if (newPlayer.method_67564() == null) {
                StateSaverAndLoader serverState = StateSaverAndLoader.getServerState(newPlayer.method_51469().method_8503());
                class_3218 targetWorld = newPlayer.method_51469();
                class_2338 one = serverState.getOneBlockPos(newPlayer.method_5667());
                newPlayer.method_48105(targetWorld, (double)one.method_10263() + 0.5, (double)(one.method_10264() + 1), (double)one.method_10260() + 0.5, EnumSet.noneOf(class_2709.class), 1.0f, 1.0f, true);
                newPlayer.method_33572(false);
                newPlayer.field_6017 = 0.0;
                newPlayer.method_7353((class_2561)class_2561.method_43470((String)"You respawned at the OneBlock."), false);
            }
        });
        ServerPlayerEvents.ALLOW_DEATH.register((player, damageSource, damageAmount) -> {
            StateSaverAndLoader state = StateSaverAndLoader.getServerState(player.method_51469().method_8503());
            if (state.getConfig().isKeepInventoryOnDeath()) {
                ((class_1928.class_4310)player.method_51469().method_64395().method_20746(class_1928.field_19389)).method_20758(true, player.method_51469().method_8503());
            }
            return true;
        });
        ServerEntityWorldChangeEvents.AFTER_PLAYER_CHANGE_WORLD.register((player, origin, destination) -> {
            if (!(player instanceof class_3222)) {
                return;
            }
            class_3222 serverPlayer = player;
            MinecraftServer server = serverPlayer.method_51469().method_8503();
            if (server == null) {
                return;
            }
            StateSaverAndLoader state = StateSaverAndLoader.getServerState(server);
            boolean multiplayer = MultiplayerPackControl.isEnabled();
            if (destination.method_27983().equals(class_1937.field_25180) && !state.hasVisitedNether(serverPlayer.method_5667())) {
                state.markVisitedNether(serverPlayer.method_5667());
                if (multiplayer) {
                    serverPlayer.method_7353((class_2561)class_2561.method_43470((String)"\u00a77 [OneBlock] \u00a7cYou have entered the Nether. Nether blocks and monsters will now appear."), false);
                } else {
                    server.method_3760().method_43514((class_2561)class_2561.method_43470((String)"\u00a77 [OneBlock] \u00a7cThe Nether has been visited! Nether blocks and monsters will now appear in the One Block."), false);
                }
            }
            if (destination.method_27983().equals(class_1937.field_25181) && !state.hasVisitedEnd(serverPlayer.method_5667())) {
                state.markVisitedEnd(serverPlayer.method_5667());
                if (multiplayer) {
                    serverPlayer.method_7353((class_2561)class_2561.method_43470((String)"\u00a77 [OneBlock] \u00a75 You have entered the End. End blocks and monsters will now appear."), false);
                } else {
                    server.method_3760().method_43514((class_2561)class_2561.method_43470((String)"\u00a77 [OneBlock] \u00a75 The End has been visited! End blocks and monsters will now appear."), false);
                }
            }
        });
    }

    public static void registerGentleDropItem(UUID itemUuid) {
        gentleDropItems.add(itemUuid);
        gentleDropItemAge.put(itemUuid, 0);
    }

    private static void tickGentleDropItems(MinecraftServer server) {
        Iterator<UUID> iterator = gentleDropItems.iterator();
        while (iterator.hasNext()) {
            UUID itemUuid = iterator.next();
            int age = gentleDropItemAge.getOrDefault(itemUuid, 0);
            if (age >= 20) {
                iterator.remove();
                gentleDropItemAge.remove(itemUuid);
                System.out.println("[OneBlock] Released item " + String.valueOf(itemUuid) + " from gentle tracking");
                continue;
            }
            boolean found = false;
            for (class_3218 world : server.method_3738()) {
                class_1297 entity = world.method_66347(itemUuid);
                if (!(entity instanceof class_1542)) continue;
                class_1542 itemEntity = (class_1542)entity;
                itemEntity.method_18800(0.0, itemEntity.method_18798().field_1351, 0.0);
                if (age % 10 == 0) {
                    System.out.println("[OneBlock] Locking velocity for item " + String.valueOf(itemUuid) + " at age " + age + ", current velocity: " + String.valueOf(itemEntity.method_18798()));
                }
                found = true;
                break;
            }
            if (found) {
                gentleDropItemAge.put(itemUuid, age + 1);
                continue;
            }
            iterator.remove();
            gentleDropItemAge.remove(itemUuid);
        }
    }

    private static void applyGentleDropToOneBlock(class_1937 world, class_2338 pos, class_2680 state, class_2586 blockEntity, class_1657 player) {
        boolean isIce;
        if (!(world instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)world;
        System.out.println("[OneBlock] Gentle drop activated for OneBlock at " + String.valueOf(pos));
        boolean bl = isIce = state.method_27852(class_2246.field_10295) || state.method_27852(class_2246.field_10225) || state.method_27852(class_2246.field_10384);
        if (isIce) {
            class_1542 itemEntity = new class_1542(world, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 1.0, (double)pos.method_10260() + 0.5, new class_1799((class_1935)state.method_26204(), 1));
            itemEntity.method_18800(0.0, 0.0, 0.0);
            world.method_8649((class_1297)itemEntity);
            Events.registerGentleDropItem(itemEntity.method_5667());
            System.out.println("[OneBlock] Spawned ice block as item: " + String.valueOf(itemEntity.method_5667()));
            return;
        }
        List drops = class_2248.method_9609((class_2680)state, (class_3218)serverWorld, (class_2338)pos, (class_2586)blockEntity, (class_1297)player, (class_1799)player.method_6047());
        System.out.println("[OneBlock] Found " + drops.size() + " block drops from OneBlock");
        for (class_1799 stack : drops) {
            if (stack.method_7960()) continue;
            class_1542 itemEntity = new class_1542(world, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 1.0, (double)pos.method_10260() + 0.5, stack);
            itemEntity.method_18800(0.0, 0.0, 0.0);
            world.method_8649((class_1297)itemEntity);
            Events.registerGentleDropItem(itemEntity.method_5667());
            System.out.println("[OneBlock] Spawned gentle OneBlock block drop: " + String.valueOf(itemEntity.method_5667()));
        }
        state.method_26180(serverWorld, pos, player.method_6047(), true);
    }

    private static void applyGentleDropToBlock(class_1937 world, class_2338 pos, class_2680 state, class_2586 blockEntity, class_1657 player) {
        if (!(world instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)world;
        System.out.println("[OneBlock] Gentle drop activated for block at " + String.valueOf(pos));
        List drops = class_2248.method_9609((class_2680)state, (class_3218)serverWorld, (class_2338)pos, (class_2586)blockEntity, (class_1297)player, (class_1799)player.method_6047());
        System.out.println("[OneBlock] Found " + drops.size() + " drops");
        for (class_1799 stack : drops) {
            if (stack.method_7960()) continue;
            class_1542 itemEntity = new class_1542(world, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 1.0, (double)pos.method_10260() + 0.5, stack);
            itemEntity.method_18800(0.0, 0.0, 0.0);
            System.out.println("[OneBlock] Spawning item at (" + itemEntity.method_23317() + "," + itemEntity.method_23318() + "," + itemEntity.method_23321() + ") with velocity " + String.valueOf(itemEntity.method_18798()));
            world.method_8649((class_1297)itemEntity);
            Events.registerGentleDropItem(itemEntity.method_5667());
            System.out.println("[OneBlock] Item spawned, UUID: " + String.valueOf(itemEntity.method_5667()));
        }
        world.method_8650(pos, false);
        state.method_26180(serverWorld, pos, player.method_6047(), true);
        world.method_8444((class_1297)player, 2001, pos, class_2248.method_9507((class_2680)state));
    }

    public static void handleOneBlockBreak(class_1937 world, class_1657 player) {
        class_3222 serverPlayer;
        if (world.method_8608()) {
            return;
        }
        StateSaverAndLoader serverState = StateSaverAndLoader.getServerState(world.method_8503());
        UUID uuid = player.method_5667();
        class_2338 oneblockpos = serverState.getOneBlockPos(uuid);
        serverState.incrementBreaks(player.method_5667());
        long totalBreaks = serverState.getPlayerBlockBreaks(uuid);
        Events.respawnOneBlock(world, uuid, oneblockpos);
        OneBlockConfig config = serverState.getConfig();
        if (config.isVisualEffectsEnabled() && player instanceof class_3222) {
            serverPlayer = (class_3222)player;
            class_3218 serverWorld = (class_3218)world;
            serverWorld.method_65096((class_2394)class_2398.field_11207, (double)oneblockpos.method_10263() + 0.5, (double)oneblockpos.method_10264() + 1.0, (double)oneblockpos.method_10260() + 0.5, 10, 0.3, 0.3, 0.3, 0.05);
            if (totalBreaks % 100L == 0L) {
                serverWorld.method_8396(null, oneblockpos, class_3417.field_14709, class_3419.field_15248, 0.5f, 1.0f);
            }
        }
        if (player instanceof class_3222) {
            serverPlayer = (class_3222)player;
            if (world.method_8409().method_43057() < 0.1f) {
                OneBlockDialog.sendRandomDialog(serverPlayer);
            }
        }
        if (config.areItemDropsEnabled() && MiscUtil.AmILucky(world.method_8409(), config.getItemDropChance(), world.method_8407(), false)) {
            RandomItemUtil.SpawnItem(world, oneblockpos);
            if (player instanceof class_3222) {
                serverPlayer = (class_3222)player;
                OneBlockDialog.sendItemDropMessage(serverPlayer);
                if (config.isVisualEffectsEnabled()) {
                    ((class_3218)world).method_8396(null, oneblockpos, class_3417.field_14627, class_3419.field_15248, 0.3f, 1.2f);
                }
            }
        }
        if (config.areFriendlyMobsEnabled() && MiscUtil.AmILucky(world.method_8409(), config.getFriendlyMobChance(), world.method_8407(), false)) {
            FriendlySpawn.spawn(world, oneblockpos);
            if (player instanceof class_3222) {
                serverPlayer = (class_3222)player;
                OneBlockDialog.sendFriendlySpawnMessage(serverPlayer);
            }
        }
        if (config.areMobWavesEnabled() && !serverState.getMobSpawnSet(uuid) && MiscUtil.AmILucky(world.method_8409(), config.getWaveChance(), world.method_8407(), true)) {
            MobSpawn.setMobSpawn(world, uuid);
        }
        if (serverState.getMobSpawnSet(uuid)) {
            if (serverState.getBreaksTillSpawn(uuid) == 0L) {
                OneBlockDialog.clearDialog(uuid);
                MobSpawn.spawnWaveNow((class_3218)world, uuid);
            } else {
                if (serverState.getBreaksTillSpawn(uuid) == 1L && player instanceof class_3222) {
                    serverPlayer = (class_3222)player;
                    int waveSize = MobSpawn.calculateWaveSize(serverState, uuid);
                    OneBlockDialog.sendWaveIncomingMessage(serverPlayer, waveSize);
                }
                serverState.decrementBreaksTillSpawn(uuid);
            }
        }
        if (totalBreaks % 100L == 0L && player instanceof class_3222) {
            serverPlayer = (class_3222)player;
            OneBlockDialog.sendMilestoneMessage(serverPlayer, totalBreaks);
        }
        if (config.isBiomeCyclingEnabled() && player instanceof class_3222) {
            serverPlayer = (class_3222)player;
            String currentBiome = RandomBlockUtil.getCurrentBiomeName(world, uuid);
            String lastBiome = lastBiomeMap.get(uuid);
            if (currentBiome != null && !currentBiome.equals(lastBiome)) {
                lastBiomeMap.put(uuid, currentBiome);
                if (lastBiome != null) {
                    OneBlockDialog.sendBiomeChangeMessage(serverPlayer, currentBiome);
                }
            } else if (currentBiome != null && lastBiome == null) {
                lastBiomeMap.put(uuid, currentBiome);
            }
        }
        if (config.isEndPortalFrameEnabled() && serverState.getPlayerBlockBreaks(uuid) > (long)config.getEndPortalFrameRequirement() && MiscUtil.AmILucky(world.method_8409(), config.getEndPortalFrameChance(), world.method_8407(), false)) {
            MiscUtil.SpawnBlock(world, class_2246.field_10398);
        }
    }

    private static void respawnOneBlock(class_1937 world, UUID uuid, class_2338 pos) {
        class_2248 randomBlock = RandomBlockUtil.getRandomSolidBlock(world, uuid, world.method_8409());
        if (!IslandBuilder.shouldBuildIslands((class_3218)world)) {
            boolean hasSolidSupport;
            class_2338 belowPos = pos.method_10074();
            class_2680 belowState = world.method_8320(belowPos);
            boolean bl = hasSolidSupport = !belowState.method_26215() && belowState.method_26212((class_1922)world, belowPos);
            if (!hasSolidSupport) {
                for (int attempts = 0; attempts < 20; ++attempts) {
                    class_2680 testState = randomBlock.method_9564();
                    boolean isGravityBlock = randomBlock instanceof class_2346;
                    boolean isFullBlock = testState.method_26234((class_1922)world, pos);
                    if (!isGravityBlock && isFullBlock) break;
                    randomBlock = RandomBlockUtil.getRandomSolidBlock(world, uuid, world.method_8409());
                }
                class_2680 finalState = randomBlock.method_9564();
                boolean isGravityBlock = randomBlock instanceof class_2346;
                boolean isFullBlock = finalState.method_26234((class_1922)world, pos);
                if (isGravityBlock || !isFullBlock) {
                    randomBlock = class_2246.field_10340;
                }
            }
        }
        class_2680 state = randomBlock.method_9564();
        world.method_8501(pos, state);
    }

    private static void detectAndResetPistonMovedOneBlocks(class_3218 world) {
        StateSaverAndLoader state = StateSaverAndLoader.getServerState(world.method_8503());
        if (MultiplayerPackControl.isEnabled()) {
            state.forEachPlayer((uuid, stats) -> {
                class_2338 pos = stats.oneBlockPos;
                if (pos == null || !stats.islandGenerated) {
                    return;
                }
                Events.checkPistonMovedBlock(world, pos);
            });
        } else {
            UUID dummy = new UUID(0L, 0L);
            class_2338 pos = state.getOneBlockPos(dummy);
            if (pos != null && state.getStats((UUID)dummy).islandGenerated) {
                Events.checkPistonMovedBlock(world, pos);
            }
        }
    }

    private static void checkPistonMovedBlock(class_3218 world, class_2338 pos) {
        class_2680 currentState = world.method_8320(pos);
        class_2680 lastState = lastKnownOneBlockState.get(pos);
        if (lastState != null && lastState.method_26215() && !currentState.method_26215()) {
            world.method_8652(pos, class_2246.field_10124.method_9564(), 3);
        }
        lastKnownOneBlockState.put(pos, currentState);
    }
}

