/*
 * Decompiled with CFR 0.152.
 */
package lynk.oneblock.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import lynk.oneblock.datapack.MultiplayerPackControl;
import lynk.oneblock.persit.StateSaverAndLoader;
import net.minecraft.class_1267;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2682;
import net.minecraft.class_5819;
import net.minecraft.class_7923;

public class RandomBlockUtil {
    private static List<class_2248> BASE_CANDIDATES;
    private static final int PROB_TRIES = 128;
    private static final int FALLBACK_SAMPLES = 64;
    private static final Map<class_2248, Float> HARDNESS_CACHE;
    private static final List<class_2248> USEFUL_WOOL;
    private static final List<class_2248> USEFUL_LOGS;
    private static final List<class_2248> USEFUL_PLANKS;
    private static final List<class_2248> USEFUL_MINERALS;
    private static final List<class_2248> RARE_MINERALS;
    private static final List<class_2248> STRUCTURAL_BASICS;
    private static final List<class_2248> OVERWORLD_PLANTS;
    private static final List<class_2248> NETHER_PLANTS;
    private static final List<class_2248> END_PLANTS;
    private static final List<class_2248> OVERWORLD_LEAVES;
    private static final List<class_2248> PLAINS_BLOCKS;
    private static final List<class_2248> DESERT_BLOCKS;
    private static final List<class_2248> JUNGLE_BLOCKS;
    private static final List<class_2248> TAIGA_BLOCKS;
    private static final List<class_2248> SWAMP_BLOCKS;
    private static final List<class_2248> SAVANNA_BLOCKS;
    private static final List<class_2248> MUSHROOM_BLOCKS;
    private static final List<class_2248> CHERRY_GROVE_BLOCKS;
    private static final List<class_2248> BADLANDS_BLOCKS;
    private static final List<class_2248> DARK_FOREST_BLOCKS;
    private static final List<class_2248> FOREST_BLOCKS;
    private static final List<class_2248> BIRCH_FOREST_BLOCKS;
    private static final List<class_2248> FLOWER_FOREST_BLOCKS;
    private static final List<class_2248> SNOWY_PLAINS_BLOCKS;
    private static final List<class_2248> FROZEN_PEAKS_BLOCKS;
    private static final List<class_2248> SNOWY_SLOPES_BLOCKS;
    private static final List<class_2248> JAGGED_PEAKS_BLOCKS;
    private static final List<class_2248> STONY_PEAKS_BLOCKS;
    private static final List<class_2248> MEADOW_BLOCKS;
    private static final List<class_2248> GROVE_BLOCKS;
    private static final List<class_2248> BEACH_BLOCKS;
    private static final List<class_2248> STONY_SHORE_BLOCKS;
    private static final List<class_2248> SNOWY_BEACH_BLOCKS;
    private static final List<class_2248> WINDSWEPT_HILLS_BLOCKS;
    private static final List<class_2248> WINDSWEPT_GRAVELLY_HILLS_BLOCKS;
    private static final List<class_2248> WINDSWEPT_FOREST_BLOCKS;
    private static final List<class_2248> WINDSWEPT_SAVANNA_BLOCKS;
    private static final List<class_2248> SPARSE_JUNGLE_BLOCKS;
    private static final List<class_2248> BAMBOO_JUNGLE_BLOCKS;
    private static final List<class_2248> OLD_GROWTH_PINE_TAIGA_BLOCKS;
    private static final List<class_2248> OLD_GROWTH_BIRCH_FOREST_BLOCKS;
    private static final List<class_2248> OLD_GROWTH_SPRUCE_TAIGA_BLOCKS;
    private static final List<class_2248> ICE_SPIKES_BLOCKS;
    private static final List<class_2248> DRIPSTONE_CAVES_BLOCKS;
    private static final List<class_2248> LUSH_CAVES_BLOCKS;
    private static final List<class_2248> DEEP_DARK_BLOCKS;
    private static final List<class_2248> NETHER_WASTES_BLOCKS;
    private static final List<class_2248> CRIMSON_FOREST_BLOCKS;
    private static final List<class_2248> WARPED_FOREST_BLOCKS;
    private static final List<class_2248> SOUL_SAND_VALLEY_BLOCKS;
    private static final List<class_2248> BASALT_DELTAS_BLOCKS;
    private static final List<class_2248> THE_END_BLOCKS;
    private static final List<class_2248> END_HIGHLANDS_BLOCKS;
    private static final List<class_2248> END_MIDLANDS_BLOCKS;
    private static final List<class_2248> END_BARRENS_BLOCKS;
    private static final List<class_2248> SMALL_END_ISLANDS_BLOCKS;
    private static final List<class_2248> SUNFLOWER_PLAINS_BLOCKS;
    private static final List<class_2248> MANGROVE_SWAMP_BLOCKS;
    private static final List<class_2248> SAVANNA_PLATEAU_BLOCKS;
    private static final List<class_2248> ERODED_BADLANDS_BLOCKS;
    private static final List<class_2248> WOODED_BADLANDS_BLOCKS;
    private static final List<class_2248> SNOWY_TAIGA_BLOCKS;
    private static final List<class_2248> OCEAN_BLOCKS;
    private static final List<class_2248> DEEP_OCEAN_BLOCKS;
    private static final List<class_2248> COLD_OCEAN_BLOCKS;
    private static final List<class_2248> DEEP_COLD_OCEAN_BLOCKS;
    private static final List<class_2248> FROZEN_OCEAN_BLOCKS;
    private static final List<class_2248> DEEP_FROZEN_OCEAN_BLOCKS;
    private static final List<class_2248> LUKEWARM_OCEAN_BLOCKS;
    private static final List<class_2248> DEEP_LUKEWARM_OCEAN_BLOCKS;
    private static final List<class_2248> WARM_OCEAN_BLOCKS;
    private static final List<class_2248> RIVER_BLOCKS;
    private static final List<class_2248> FROZEN_RIVER_BLOCKS;
    private static final List<List<class_2248>> BIOME_BLOCK_LISTS;
    private static final String[] BIOME_NAMES;
    private static final List<class_2248> NETHER_SOLIDS;
    private static final List<class_2248> END_SOLIDS;
    private static final int W_USEFUL = 60;
    private static final int W_STRUCT = 35;
    private static final int W_RARE = 5;
    private static final int W_OVERWORLD_PLANTS = 16;
    private static final int W_BIOME_BLOCKS = 40;
    private static final int W_OVERWORLD_LEAVES = 10;
    private static final int W_NETHER_PLANTS = 10;
    private static final int W_END_PLANTS = 8;
    private static final int W_NETHER_SOLIDS = 18;
    private static final int W_END_SOLIDS = 12;
    private static final Map<class_1267, Mult> DIFF;
    private static final Map<Long, Integer> cycleToBlomeIndex;
    private static String forcedBiomeName;
    private static long forcedBiomeSetTime;
    private static final Set<class_2248> ALWAYS_ALLOW;

    public static class_2248 getAnyRandomBlock(class_5819 random) {
        return class_7923.field_41175.method_10240(random).map(entry -> (class_2248)entry.comp_349()).orElse(class_2246.field_10340);
    }

    public static void setForcedBiome(String biomeName) {
        forcedBiomeName = biomeName;
        forcedBiomeSetTime = System.currentTimeMillis();
        cycleToBlomeIndex.clear();
    }

    private static int getCurrentBiomeIndex(long totalBreaks, int biomeSwitchInterval) {
        if (biomeSwitchInterval <= 0) {
            return 0;
        }
        long cycle = totalBreaks / (long)biomeSwitchInterval;
        if (forcedBiomeName != null) {
            for (int i = 0; i < BIOME_NAMES.length; ++i) {
                if (!BIOME_NAMES[i].equalsIgnoreCase(forcedBiomeName)) continue;
                cycleToBlomeIndex.put(cycle, i);
                if (System.currentTimeMillis() - forcedBiomeSetTime > 300000L) {
                    forcedBiomeName = null;
                }
                return i;
            }
            forcedBiomeName = null;
        }
        return cycleToBlomeIndex.computeIfAbsent(cycle, c -> {
            Random random = new Random();
            return random.nextInt(BIOME_BLOCK_LISTS.size());
        });
    }

    public static String getCurrentBiomeName(class_1937 world, UUID uuid) {
        StateSaverAndLoader serverState = StateSaverAndLoader.getServerState(world.method_8503());
        if (!serverState.getConfig().isBiomeCyclingEnabled()) {
            return null;
        }
        long totalBreaks = serverState.getPlayerBlockBreaks(uuid);
        int biomeSwitchInterval = serverState.getConfig().getBiomeSwitchInterval();
        int biomeIndex = RandomBlockUtil.getCurrentBiomeIndex(totalBreaks, biomeSwitchInterval);
        return BIOME_NAMES[biomeIndex];
    }

    public static class_2248 getRandomSolidBlock(class_1937 world, UUID uuid, class_5819 random) {
        class_2248 candidate;
        int tries;
        StateSaverAndLoader serverState = StateSaverAndLoader.getServerState(world.method_8503());
        List<class_2248> base = RandomBlockUtil.getBaseCandidates();
        if (base.isEmpty()) {
            return class_2246.field_10340;
        }
        long totalBreaks = MultiplayerPackControl.isEnabled() ? (serverState.getConfig().useGlobalBreakCount() ? serverState.getTotalBreaksAllPlayers() : serverState.getStats((UUID)uuid).totalOneBlockBreaks) : serverState.getTotalBreaksAllPlayers();
        int progressionCap = serverState.getConfig().getProgressionCap();
        if (progressionCap <= 0) {
            progressionCap = 1;
        }
        float progress = Math.min((float)totalBreaks / (float)progressionCap, 1.0f);
        float maxHardness = 2.0f + 51.0f * progress;
        double atten = 1.0 - (double)progress;
        boolean netherUnlocked = MultiplayerPackControl.isEnabled() ? serverState.hasVisitedNether(uuid) : serverState.anyoneVisitedNether();
        boolean endUnlocked = MultiplayerPackControl.isEnabled() ? serverState.hasVisitedEnd(uuid) : serverState.anyoneVisitedEnd();
        boolean biomeCyclingEnabled = serverState.getConfig().isBiomeCyclingEnabled();
        int biomeIndex = biomeCyclingEnabled ? RandomBlockUtil.getCurrentBiomeIndex(totalBreaks, serverState.getConfig().getBiomeSwitchInterval()) : -1;
        WeightedBag bag = RandomBlockUtil.buildWeightedBag(world, random, base, atten, netherUnlocked, endUnlocked, biomeCyclingEnabled, biomeIndex);
        for (tries = 0; tries < 128; ++tries) {
            candidate = RandomBlockUtil.pickFromBagOrBase(bag, base, random);
            if (!(RandomBlockUtil.safeHardness(candidate) <= maxHardness)) continue;
            return candidate;
        }
        for (tries = 0; tries < 128; ++tries) {
            candidate = RandomBlockUtil.pickFromBagOrBase(bag, base, random);
            float hardness = RandomBlockUtil.safeHardness(candidate);
            float chance = progress * (hardness / 50.0f);
            if (!(random.method_43057() < chance)) continue;
            return candidate;
        }
        class_2248 best = class_2246.field_10340;
        float bestH = Float.MAX_VALUE;
        for (int i = 0; i < 64; ++i) {
            class_2248 candidate2 = RandomBlockUtil.pickFromBagOrBase(bag, base, random);
            float h = RandomBlockUtil.safeHardness(candidate2);
            if (!(h < bestH)) continue;
            bestH = h;
            best = candidate2;
        }
        return best;
    }

    private static WeightedBag buildWeightedBag(class_1937 world, class_5819 rnd, List<class_2248> base, double atten, boolean netherUnlocked, boolean endUnlocked, boolean biomeCyclingEnabled, int biomeIndex) {
        class_1267 d = world.method_8407();
        Mult m = DIFF.getOrDefault(d, new Mult(1.0, 1.0, 1.0));
        int totalUseful = Math.max(1, Math.round(60.0f * (float)m.useful));
        int wLogs = Math.max(1, Math.round((float)totalUseful * 0.5f * (float)atten));
        int wPlanks = Math.max(1, Math.round((float)totalUseful * 0.0f * (float)atten));
        int wMinerals = Math.max(1, Math.round((float)totalUseful * 0.25f * (float)atten));
        int wWool = Math.max(1, Math.round((float)totalUseful * 0.25f * (float)atten));
        int wStruct = Math.max(1, Math.round(35.0f * (float)m.structural * (float)atten));
        int wRare = Math.max(1, Math.round(5.0f * (float)m.rare * (float)atten));
        int wOverPlants = Math.max(1, Math.round(16.0f * (float)atten));
        int wLeaves = Math.max(1, Math.round(10.0f * (float)atten));
        int wNetherPlant = netherUnlocked ? Math.max(1, Math.round(10.0f * (float)atten)) : 0;
        int wEndPlant = endUnlocked ? Math.max(1, Math.round(8.0f * (float)atten)) : 0;
        int wNetherSol = netherUnlocked ? Math.max(1, Math.round(18.0f * (float)m.structural * (float)atten)) : 0;
        int wEndSol = endUnlocked ? Math.max(1, Math.round(12.0f * (float)m.structural * (float)atten)) : 0;
        int wBiomeBlocks = biomeCyclingEnabled ? Math.max(1, Math.round(40.0f * (float)atten)) : 0;
        WeightedBag bag = new WeightedBag(rnd);
        if (biomeCyclingEnabled && biomeIndex >= 0 && biomeIndex < BIOME_BLOCK_LISTS.size()) {
            List<class_2248> biomeBlocks = BIOME_BLOCK_LISTS.get(biomeIndex);
            bag.addAll(RandomBlockUtil.intersect(base, biomeBlocks), wBiomeBlocks);
        } else {
            bag.addAll(RandomBlockUtil.intersect(base, USEFUL_LOGS), wLogs);
            bag.addAll(RandomBlockUtil.intersect(base, USEFUL_PLANKS), wPlanks);
            bag.addAll(RandomBlockUtil.intersect(base, USEFUL_MINERALS), wMinerals);
            bag.addAll(RandomBlockUtil.intersect(base, USEFUL_WOOL), wWool);
            bag.addAll(RandomBlockUtil.intersect(base, STRUCTURAL_BASICS), wStruct);
            bag.addAll(RandomBlockUtil.intersect(base, RARE_MINERALS), wRare);
            bag.addAll(RandomBlockUtil.intersect(base, OVERWORLD_PLANTS), wOverPlants);
            bag.addAll(RandomBlockUtil.intersect(base, OVERWORLD_LEAVES), wLeaves);
            if (wNetherPlant > 0) {
                bag.addAll(RandomBlockUtil.intersect(base, NETHER_PLANTS), wNetherPlant);
            }
            if (wEndPlant > 0) {
                bag.addAll(RandomBlockUtil.intersect(base, END_PLANTS), wEndPlant);
            }
            if (wNetherSol > 0) {
                bag.addAll(RandomBlockUtil.intersect(base, NETHER_SOLIDS), wNetherSol);
            }
            if (wEndSol > 0) {
                bag.addAll(RandomBlockUtil.intersect(base, END_SOLIDS), wEndSol);
            }
        }
        return bag;
    }

    private static List<class_2248> intersect(List<class_2248> a, List<class_2248> b) {
        ArrayList<class_2248> out = new ArrayList<class_2248>();
        for (class_2248 x : b) {
            if (!a.contains(x)) continue;
            out.add(x);
        }
        return out;
    }

    private static class_2248 pickFromBagOrBase(WeightedBag bag, List<class_2248> base, class_5819 rnd) {
        class_2248 fromBag = bag.pick();
        if (fromBag != null) {
            return fromBag;
        }
        return base.get(rnd.method_43048(base.size()));
    }

    private static List<class_2248> getBaseCandidates() {
        if (BASE_CANDIDATES == null || BASE_CANDIDATES.isEmpty()) {
            BASE_CANDIDATES = class_7923.field_41175.method_10220().filter(RandomBlockUtil::isStaticGoodBlock).toList();
        }
        return BASE_CANDIDATES;
    }

    private static boolean isStaticGoodBlock(class_2248 block) {
        if (block == class_2246.field_9987 || block == class_2246.field_10499 || block == class_2246.field_31037 || block == class_2246.field_10465 || block == class_2246.field_16540 || block == class_2246.field_10525 || block == class_2246.field_10263 || block == class_2246.field_10395 || block == class_2246.field_10027 || block == class_2246.field_10316 || block == class_2246.field_10613 || block == class_2246.field_10295 || block == class_2246.field_10375) {
            return false;
        }
        if (block instanceof class_2237) {
            return false;
        }
        class_2680 s = block.method_9564();
        if (!s.method_26227().method_15769()) {
            return false;
        }
        if (ALWAYS_ALLOW.contains(block)) {
            return true;
        }
        if (s.method_26215()) {
            return false;
        }
        if (s.method_45474()) {
            return false;
        }
        class_265 shape = s.method_26220((class_1922)class_2682.field_12294, class_2338.field_10980);
        return shape.equals((Object)class_259.method_1077());
    }

    private static float safeHardness(class_2248 block) {
        float value;
        Float cached = HARDNESS_CACHE.get(block);
        if (cached != null) {
            return cached.floatValue();
        }
        try {
            value = block.method_36555();
        }
        catch (Throwable t) {
            value = 5.0f;
        }
        HARDNESS_CACHE.put(block, Float.valueOf(value));
        return value;
    }

    static {
        HARDNESS_CACHE = new WeakHashMap<class_2248, Float>();
        USEFUL_WOOL = List.of(class_2246.field_10446, class_2246.field_10222, class_2246.field_10423, class_2246.field_10146, class_2246.field_10113, class_2246.field_10314, class_2246.field_10095, class_2246.field_10490, class_2246.field_10028, class_2246.field_10170, class_2246.field_10619, class_2246.field_10294, class_2246.field_10514, class_2246.field_10259, class_2246.field_10215, class_2246.field_10459);
        USEFUL_LOGS = List.of(class_2246.field_10431, class_2246.field_10511, class_2246.field_10037, class_2246.field_10306, class_2246.field_10533, class_2246.field_10010, class_2246.field_37545, class_2246.field_42729);
        USEFUL_PLANKS = List.of(class_2246.field_10161, class_2246.field_10148, class_2246.field_9975, class_2246.field_10334, class_2246.field_10218, class_2246.field_10075, class_2246.field_37577, class_2246.field_42751, class_2246.field_40294, class_2246.field_22126, class_2246.field_22127);
        USEFUL_MINERALS = List.of(class_2246.field_10418, class_2246.field_10212, class_2246.field_27120, class_2246.field_10571, class_2246.field_10080, class_2246.field_10090, class_2246.field_29219, class_2246.field_29027, class_2246.field_29221, class_2246.field_29026, class_2246.field_29030, class_2246.field_29028, class_2246.field_10213, class_2246.field_23077);
        RARE_MINERALS = List.of(class_2246.field_10442, class_2246.field_29029, class_2246.field_10013, class_2246.field_29220, class_2246.field_22109);
        STRUCTURAL_BASICS = List.of(class_2246.field_10340, class_2246.field_10445, class_2246.field_10115, class_2246.field_10508, class_2246.field_10474, class_2246.field_28888, class_2246.field_10566, class_2246.field_10253, class_2246.field_10219, class_2246.field_10102, class_2246.field_10534, class_2246.field_10255, class_2246.field_10460, class_2246.field_10415, class_2246.field_10491, class_2246.field_10225);
        OVERWORLD_PLANTS = List.of(class_2246.field_10219, class_2246.field_10112, class_2246.field_10428, class_2246.field_10182, class_2246.field_10449, class_2246.field_10086, class_2246.field_10226, class_2246.field_10573, class_2246.field_10270, class_2246.field_10048, class_2246.field_10156, class_2246.field_10315, class_2246.field_10554, class_2246.field_9995, class_2246.field_10548, class_2246.field_10583, class_2246.field_10559, class_2246.field_10251, class_2246.field_16999, class_2246.field_10597);
        NETHER_PLANTS = List.of(class_2246.field_22121, class_2246.field_22114, class_2246.field_22125, class_2246.field_22116, class_2246.field_22117, class_2246.field_22123, class_2246.field_23078, class_2246.field_9974);
        END_PLANTS = List.of(class_2246.field_10021, class_2246.field_10528);
        OVERWORLD_LEAVES = List.of(class_2246.field_10503, class_2246.field_10539, class_2246.field_9988, class_2246.field_10335, class_2246.field_10098, class_2246.field_10035, class_2246.field_37551, class_2246.field_42731, class_2246.field_28673, class_2246.field_28674);
        PLAINS_BLOCKS = List.of(class_2246.field_10219, class_2246.field_10566, class_2246.field_10253, class_2246.field_10520, class_2246.field_10431, class_2246.field_10503, class_2246.field_10161, class_2246.field_10519, class_2246.field_10511, class_2246.field_10539, class_2246.field_10148, class_2246.field_10366, class_2246.field_10182, class_2246.field_10449, class_2246.field_9995, class_2246.field_10573, class_2246.field_10554, class_2246.field_10479, class_2246.field_10214, class_2246.field_10293, class_2246.field_10359, class_2246.field_46282, class_2246.field_46283);
        DESERT_BLOCKS = List.of(class_2246.field_10102, class_2246.field_9979, class_2246.field_10467, class_2246.field_10361, class_2246.field_10292, class_2246.field_10142, class_2246.field_10007, class_2246.field_10534, class_2246.field_10344, class_2246.field_10483, class_2246.field_10518, class_2246.field_10117, class_2246.field_10029, class_2246.field_10428, class_2246.field_10415, class_2246.field_10611, class_2246.field_10184, class_2246.field_10143, class_2246.field_10123, class_2246.field_10328);
        JUNGLE_BLOCKS = List.of(class_2246.field_10306, class_2246.field_10335, class_2246.field_10334, class_2246.field_10254, class_2246.field_10211, class_2246.field_40294, class_2246.field_41072, class_2246.field_41073, class_2246.field_10597, class_2246.field_10302, class_2246.field_46283, class_2246.field_10520, class_2246.field_28681, class_2246.field_28680, class_2246.field_10566, class_2246.field_10219);
        TAIGA_BLOCKS = List.of(class_2246.field_10037, class_2246.field_9988, class_2246.field_9975, class_2246.field_10436, class_2246.field_10520, class_2246.field_10253, class_2246.field_10566, class_2246.field_10219, class_2246.field_10491, class_2246.field_10477, class_2246.field_10225, class_2246.field_10384, class_2246.field_10112, class_2246.field_10313, class_2246.field_16999, class_2246.field_10255, class_2246.field_10340, class_2246.field_10445);
        SWAMP_BLOCKS = List.of(class_2246.field_37576, class_2246.field_37547, class_2246.field_37556, class_2246.field_37557, class_2246.field_37545, class_2246.field_37551, class_2246.field_37577, class_2246.field_37548, class_2246.field_37546, class_2246.field_10588, class_2246.field_10597, class_2246.field_10086, class_2246.field_10030, class_2246.field_10460, class_2246.field_10376, class_2246.field_10219, class_2246.field_10566);
        SAVANNA_BLOCKS = List.of(class_2246.field_10533, class_2246.field_10098, class_2246.field_10218, class_2246.field_10622, class_2246.field_10253, class_2246.field_10566, class_2246.field_10219, class_2246.field_10479, class_2246.field_10214, class_2246.field_10359);
        MUSHROOM_BLOCKS = List.of(class_2246.field_10402, class_2246.field_10566, class_2246.field_10240, class_2246.field_10580, class_2246.field_10556, class_2246.field_10559, class_2246.field_10251);
        CHERRY_GROVE_BLOCKS = List.of(class_2246.field_42729, class_2246.field_42731, class_2246.field_42751, class_2246.field_42732, class_2246.field_42750, class_2246.field_10219, class_2246.field_10566, class_2246.field_28681, class_2246.field_28680);
        BADLANDS_BLOCKS = List.of(class_2246.field_10534, class_2246.field_10415, class_2246.field_10611, class_2246.field_10184, class_2246.field_10143, class_2246.field_10123, class_2246.field_10328, class_2246.field_10590, class_2246.field_10349, class_2246.field_10626, class_2246.field_10571, class_2246.field_10029, class_2246.field_10428);
        DARK_FOREST_BLOCKS = List.of(class_2246.field_10010, class_2246.field_10035, class_2246.field_10075, class_2246.field_10244, class_2246.field_10240, class_2246.field_10580, class_2246.field_10556, class_2246.field_10559, class_2246.field_10251, class_2246.field_10566, class_2246.field_10219, class_2246.field_10520, class_2246.field_28681);
        FOREST_BLOCKS = List.of(class_2246.field_10431, class_2246.field_10503, class_2246.field_10161, class_2246.field_10519, class_2246.field_10511, class_2246.field_10539, class_2246.field_10148, class_2246.field_10366, class_2246.field_10219, class_2246.field_10566, class_2246.field_10520, class_2246.field_10182, class_2246.field_10449, class_2246.field_10378, class_2246.field_10430, class_2246.field_10003, class_2246.field_10548);
        BIRCH_FOREST_BLOCKS = List.of(class_2246.field_10511, class_2246.field_10539, class_2246.field_10148, class_2246.field_10366, class_2246.field_10219, class_2246.field_10566, class_2246.field_10214, class_2246.field_10479, class_2246.field_10182, class_2246.field_10449, class_2246.field_10430);
        FLOWER_FOREST_BLOCKS = List.of(class_2246.field_10219, class_2246.field_10566, class_2246.field_10431, class_2246.field_10511, class_2246.field_10182, class_2246.field_10449, class_2246.field_10226, class_2246.field_10573, class_2246.field_10270, class_2246.field_10048, class_2246.field_10156, class_2246.field_10315, class_2246.field_10554, class_2246.field_9995, class_2246.field_10548, class_2246.field_10378, class_2246.field_10430, class_2246.field_10003, class_2246.field_10583);
        SNOWY_PLAINS_BLOCKS = List.of(class_2246.field_10491, class_2246.field_10477, class_2246.field_10295, class_2246.field_10225, class_2246.field_10219, class_2246.field_10566, class_2246.field_10340, class_2246.field_10255, class_2246.field_10037, class_2246.field_9988);
        FROZEN_PEAKS_BLOCKS = List.of(class_2246.field_10491, class_2246.field_10295, class_2246.field_10225, class_2246.field_10384, class_2246.field_10340, class_2246.field_27114, class_2246.field_10255, class_2246.field_27879);
        SNOWY_SLOPES_BLOCKS = List.of(class_2246.field_10491, class_2246.field_10477, class_2246.field_10340, class_2246.field_10255, class_2246.field_27879, class_2246.field_10295, class_2246.field_10037, class_2246.field_9988);
        JAGGED_PEAKS_BLOCKS = List.of(class_2246.field_10340, class_2246.field_10255, class_2246.field_10491, class_2246.field_10477, class_2246.field_27114, class_2246.field_10295, class_2246.field_10225);
        STONY_PEAKS_BLOCKS = List.of(class_2246.field_10340, class_2246.field_10255, class_2246.field_27114, class_2246.field_10115, class_2246.field_10508, class_2246.field_10474);
        MEADOW_BLOCKS = List.of(class_2246.field_10219, class_2246.field_10566, class_2246.field_10214, class_2246.field_10479, class_2246.field_10182, class_2246.field_10449, class_2246.field_10226, class_2246.field_10573, class_2246.field_9995, class_2246.field_10554, class_2246.field_10431, class_2246.field_10511);
        GROVE_BLOCKS = List.of(class_2246.field_10037, class_2246.field_9988, class_2246.field_9975, class_2246.field_10436, class_2246.field_10491, class_2246.field_10477, class_2246.field_27879, class_2246.field_10566, class_2246.field_10219, class_2246.field_10340);
        BEACH_BLOCKS = List.of(class_2246.field_10102, class_2246.field_9979, class_2246.field_10255, class_2246.field_10340, class_2246.field_10460, class_2246.field_10566);
        STONY_SHORE_BLOCKS = List.of(class_2246.field_10340, class_2246.field_10255, class_2246.field_10115, class_2246.field_10508, class_2246.field_10474, class_2246.field_10445);
        SNOWY_BEACH_BLOCKS = List.of(class_2246.field_10102, class_2246.field_10491, class_2246.field_10477, class_2246.field_10295, class_2246.field_10255, class_2246.field_10340);
        WINDSWEPT_HILLS_BLOCKS = List.of(class_2246.field_10340, class_2246.field_10255, class_2246.field_10219, class_2246.field_10566, class_2246.field_10431, class_2246.field_10503, class_2246.field_10013, class_2246.field_29220);
        WINDSWEPT_GRAVELLY_HILLS_BLOCKS = List.of(class_2246.field_10255, class_2246.field_10340, class_2246.field_10219, class_2246.field_10566, class_2246.field_10445, class_2246.field_10115);
        WINDSWEPT_FOREST_BLOCKS = List.of(class_2246.field_10431, class_2246.field_10503, class_2246.field_10037, class_2246.field_9988, class_2246.field_10219, class_2246.field_10566, class_2246.field_10340, class_2246.field_10255);
        WINDSWEPT_SAVANNA_BLOCKS = List.of(class_2246.field_10533, class_2246.field_10098, class_2246.field_10253, class_2246.field_10219, class_2246.field_10566, class_2246.field_10340, class_2246.field_10255);
        SPARSE_JUNGLE_BLOCKS = List.of(class_2246.field_10306, class_2246.field_10335, class_2246.field_10334, class_2246.field_10211, class_2246.field_10219, class_2246.field_10566, class_2246.field_10520, class_2246.field_46283);
        BAMBOO_JUNGLE_BLOCKS = List.of(class_2246.field_10211, class_2246.field_40294, class_2246.field_41072, class_2246.field_10306, class_2246.field_10335, class_2246.field_10520, class_2246.field_10219, class_2246.field_10566, class_2246.field_28681);
        OLD_GROWTH_PINE_TAIGA_BLOCKS = List.of(class_2246.field_10037, class_2246.field_9988, class_2246.field_9975, class_2246.field_10436, class_2246.field_10520, class_2246.field_10253, class_2246.field_28681, class_2246.field_28680, class_2246.field_10112, class_2246.field_10313, class_2246.field_10556, class_2246.field_10559, class_2246.field_10251);
        OLD_GROWTH_BIRCH_FOREST_BLOCKS = List.of(class_2246.field_10511, class_2246.field_10539, class_2246.field_10148, class_2246.field_10366, class_2246.field_10219, class_2246.field_10566, class_2246.field_10430, class_2246.field_10003, class_2246.field_10378, class_2246.field_10214);
        OLD_GROWTH_SPRUCE_TAIGA_BLOCKS = List.of(class_2246.field_10037, class_2246.field_9988, class_2246.field_9975, class_2246.field_10436, class_2246.field_10520, class_2246.field_10253, class_2246.field_28681, class_2246.field_10112, class_2246.field_10313, class_2246.field_16999);
        ICE_SPIKES_BLOCKS = List.of(class_2246.field_10225, class_2246.field_10384, class_2246.field_10295, class_2246.field_10491, class_2246.field_10477, class_2246.field_10566, class_2246.field_10255);
        DRIPSTONE_CAVES_BLOCKS = List.of(class_2246.field_28049, class_2246.field_28048, class_2246.field_10340, class_2246.field_28888, class_2246.field_27120, class_2246.field_29221, class_2246.field_10115);
        LUSH_CAVES_BLOCKS = List.of(class_2246.field_28681, class_2246.field_28680, class_2246.field_28673, class_2246.field_28674, class_2246.field_10460, class_2246.field_28685, class_2246.field_28686, class_2246.field_28677, class_2246.field_28675);
        DEEP_DARK_BLOCKS = List.of(class_2246.field_37568, class_2246.field_37569, class_2246.field_37570, class_2246.field_28108, class_2246.field_28888, class_2246.field_29031, class_2246.field_28900, class_2246.field_28896);
        NETHER_WASTES_BLOCKS = List.of(class_2246.field_10515, class_2246.field_10255, class_2246.field_10114, class_2246.field_10213, class_2246.field_23077, class_2246.field_10171, class_2246.field_10092);
        CRIMSON_FOREST_BLOCKS = List.of(class_2246.field_22120, class_2246.field_10515, class_2246.field_22121, class_2246.field_22125, class_2246.field_22123, class_2246.field_10541, class_2246.field_22118, class_2246.field_22126, class_2246.field_22122);
        WARPED_FOREST_BLOCKS = List.of(class_2246.field_22113, class_2246.field_10515, class_2246.field_22114, class_2246.field_22116, class_2246.field_22117, class_2246.field_23078, class_2246.field_22115, class_2246.field_22111, class_2246.field_22127, class_2246.field_22122);
        SOUL_SAND_VALLEY_BLOCKS = List.of(class_2246.field_10114, class_2246.field_22090, class_2246.field_22091, class_2246.field_10515, class_2246.field_10166, class_2246.field_23077);
        BASALT_DELTAS_BLOCKS = List.of(class_2246.field_22091, class_2246.field_29032, class_2246.field_23869, class_2246.field_23873, class_2246.field_23874, class_2246.field_10092, class_2246.field_10255, class_2246.field_10515);
        THE_END_BLOCKS = List.of(class_2246.field_10471, class_2246.field_10462, class_2246.field_10540, class_2246.field_10286, class_2246.field_10505);
        END_HIGHLANDS_BLOCKS = List.of(class_2246.field_10471, class_2246.field_10462, class_2246.field_10021, class_2246.field_10528, class_2246.field_10286, class_2246.field_10505);
        END_MIDLANDS_BLOCKS = List.of(class_2246.field_10471, class_2246.field_10462, class_2246.field_10286);
        END_BARRENS_BLOCKS = List.of(class_2246.field_10471, class_2246.field_10462);
        SMALL_END_ISLANDS_BLOCKS = List.of(class_2246.field_10471, class_2246.field_10462, class_2246.field_10540);
        SUNFLOWER_PLAINS_BLOCKS = List.of(class_2246.field_10219, class_2246.field_10566, class_2246.field_10583, class_2246.field_10182, class_2246.field_10449, class_2246.field_9995, class_2246.field_10431, class_2246.field_10503, class_2246.field_10214);
        MANGROVE_SWAMP_BLOCKS = List.of(class_2246.field_37576, class_2246.field_37547, class_2246.field_37556, class_2246.field_37557, class_2246.field_37545, class_2246.field_37551, class_2246.field_37577, class_2246.field_37546, class_2246.field_10597, class_2246.field_10588, class_2246.field_28681, class_2246.field_28680);
        SAVANNA_PLATEAU_BLOCKS = List.of(class_2246.field_10533, class_2246.field_10098, class_2246.field_10218, class_2246.field_10219, class_2246.field_10253, class_2246.field_10566, class_2246.field_10340, class_2246.field_10479, class_2246.field_10214);
        ERODED_BADLANDS_BLOCKS = List.of(class_2246.field_10534, class_2246.field_10415, class_2246.field_10611, class_2246.field_10184, class_2246.field_10143, class_2246.field_10123, class_2246.field_10328, class_2246.field_10590, class_2246.field_10235, class_2246.field_10029, class_2246.field_10428);
        WOODED_BADLANDS_BLOCKS = List.of(class_2246.field_10534, class_2246.field_10415, class_2246.field_10184, class_2246.field_10123, class_2246.field_10328, class_2246.field_10431, class_2246.field_10503, class_2246.field_10253, class_2246.field_10219);
        SNOWY_TAIGA_BLOCKS = List.of(class_2246.field_10037, class_2246.field_9988, class_2246.field_9975, class_2246.field_10491, class_2246.field_10477, class_2246.field_10295, class_2246.field_10566, class_2246.field_10219, class_2246.field_10520, class_2246.field_10112, class_2246.field_16999);
        OCEAN_BLOCKS = List.of(class_2246.field_10102, class_2246.field_10255, class_2246.field_10460, class_2246.field_10566, class_2246.field_10340, class_2246.field_9993, class_2246.field_10376, class_2246.field_10476, class_2246.field_10135, class_2246.field_10006, class_2246.field_10297);
        DEEP_OCEAN_BLOCKS = List.of(class_2246.field_10255, class_2246.field_10340, class_2246.field_28888, class_2246.field_10092, class_2246.field_10135, class_2246.field_10006, class_2246.field_10297, class_2246.field_9993, class_2246.field_10476);
        COLD_OCEAN_BLOCKS = List.of(class_2246.field_10255, class_2246.field_10102, class_2246.field_10460, class_2246.field_9993, class_2246.field_10376, class_2246.field_10340, class_2246.field_10135);
        DEEP_COLD_OCEAN_BLOCKS = List.of(class_2246.field_10255, class_2246.field_10340, class_2246.field_28888, class_2246.field_9993, class_2246.field_10135, class_2246.field_10006);
        FROZEN_OCEAN_BLOCKS = List.of(class_2246.field_10295, class_2246.field_10225, class_2246.field_10384, class_2246.field_10255, class_2246.field_10102, class_2246.field_10491, class_2246.field_9993, class_2246.field_10135);
        DEEP_FROZEN_OCEAN_BLOCKS = List.of(class_2246.field_10295, class_2246.field_10225, class_2246.field_10384, class_2246.field_10255, class_2246.field_10340, class_2246.field_28888, class_2246.field_10135, class_2246.field_10006);
        LUKEWARM_OCEAN_BLOCKS = List.of(class_2246.field_10102, class_2246.field_9979, class_2246.field_9993, class_2246.field_10376, class_2246.field_10476, class_2246.field_10309, class_2246.field_10629, class_2246.field_10000, class_2246.field_10516, class_2246.field_10464);
        DEEP_LUKEWARM_OCEAN_BLOCKS = List.of(class_2246.field_10102, class_2246.field_10340, class_2246.field_9993, class_2246.field_10376, class_2246.field_10135, class_2246.field_10476);
        WARM_OCEAN_BLOCKS = List.of(class_2246.field_10102, class_2246.field_9979, class_2246.field_10309, class_2246.field_10629, class_2246.field_10000, class_2246.field_10516, class_2246.field_10464, class_2246.field_10125, class_2246.field_10339, class_2246.field_10134, class_2246.field_10618, class_2246.field_10169, class_2246.field_10476);
        RIVER_BLOCKS = List.of(class_2246.field_10255, class_2246.field_10102, class_2246.field_10460, class_2246.field_10566, class_2246.field_10376, class_2246.field_9993);
        FROZEN_RIVER_BLOCKS = List.of(class_2246.field_10295, class_2246.field_10255, class_2246.field_10102, class_2246.field_10491, class_2246.field_10460, class_2246.field_10566);
        BIOME_BLOCK_LISTS = List.of(PLAINS_BLOCKS, DESERT_BLOCKS, JUNGLE_BLOCKS, TAIGA_BLOCKS, SWAMP_BLOCKS, SAVANNA_BLOCKS, MUSHROOM_BLOCKS, CHERRY_GROVE_BLOCKS, BADLANDS_BLOCKS, DARK_FOREST_BLOCKS, FOREST_BLOCKS, BIRCH_FOREST_BLOCKS, FLOWER_FOREST_BLOCKS, SNOWY_PLAINS_BLOCKS, FROZEN_PEAKS_BLOCKS, SNOWY_SLOPES_BLOCKS, JAGGED_PEAKS_BLOCKS, STONY_PEAKS_BLOCKS, MEADOW_BLOCKS, GROVE_BLOCKS, BEACH_BLOCKS, STONY_SHORE_BLOCKS, SNOWY_BEACH_BLOCKS, WINDSWEPT_HILLS_BLOCKS, WINDSWEPT_GRAVELLY_HILLS_BLOCKS, WINDSWEPT_FOREST_BLOCKS, WINDSWEPT_SAVANNA_BLOCKS, SPARSE_JUNGLE_BLOCKS, BAMBOO_JUNGLE_BLOCKS, OLD_GROWTH_PINE_TAIGA_BLOCKS, OLD_GROWTH_BIRCH_FOREST_BLOCKS, OLD_GROWTH_SPRUCE_TAIGA_BLOCKS, ICE_SPIKES_BLOCKS, DRIPSTONE_CAVES_BLOCKS, LUSH_CAVES_BLOCKS, DEEP_DARK_BLOCKS, NETHER_WASTES_BLOCKS, CRIMSON_FOREST_BLOCKS, WARPED_FOREST_BLOCKS, SOUL_SAND_VALLEY_BLOCKS, BASALT_DELTAS_BLOCKS, THE_END_BLOCKS, END_HIGHLANDS_BLOCKS, END_MIDLANDS_BLOCKS, END_BARRENS_BLOCKS, SMALL_END_ISLANDS_BLOCKS, SUNFLOWER_PLAINS_BLOCKS, MANGROVE_SWAMP_BLOCKS, SAVANNA_PLATEAU_BLOCKS, ERODED_BADLANDS_BLOCKS, WOODED_BADLANDS_BLOCKS, SNOWY_TAIGA_BLOCKS, OCEAN_BLOCKS, DEEP_OCEAN_BLOCKS, COLD_OCEAN_BLOCKS, DEEP_COLD_OCEAN_BLOCKS, FROZEN_OCEAN_BLOCKS, DEEP_FROZEN_OCEAN_BLOCKS, LUKEWARM_OCEAN_BLOCKS, DEEP_LUKEWARM_OCEAN_BLOCKS, WARM_OCEAN_BLOCKS, RIVER_BLOCKS, FROZEN_RIVER_BLOCKS);
        BIOME_NAMES = new String[]{"Plains", "Desert", "Jungle", "Taiga", "Swamp", "Savanna", "Mushroom Fields", "Cherry Grove", "Badlands", "Dark Forest", "Forest", "Birch Forest", "Flower Forest", "Snowy Plains", "Frozen Peaks", "Snowy Slopes", "Jagged Peaks", "Stony Peaks", "Meadow", "Grove", "Beach", "Stony Shore", "Snowy Beach", "Windswept Hills", "Windswept Gravelly Hills", "Windswept Forest", "Windswept Savanna", "Sparse Jungle", "Bamboo Jungle", "Old Growth Pine Taiga", "Old Growth Birch Forest", "Old Growth Spruce Taiga", "Ice Spikes", "Dripstone Caves", "Lush Caves", "Deep Dark", "Nether Wastes", "Crimson Forest", "Warped Forest", "Soul Sand Valley", "Basalt Deltas", "The End", "End Highlands", "End Midlands", "End Barrens", "Small End Islands", "Sunflower Plains", "Mangrove Swamp", "Savanna Plateau", "Eroded Badlands", "Wooded Badlands", "Snowy Taiga", "Ocean", "Deep Ocean", "Cold Ocean", "Deep Cold Ocean", "Frozen Ocean", "Deep Frozen Ocean", "Lukewarm Ocean", "Deep Lukewarm Ocean", "Warm Ocean", "River", "Frozen River"};
        NETHER_SOLIDS = List.of(class_2246.field_10515, class_2246.field_22091, class_2246.field_29032, class_2246.field_23869, class_2246.field_23873, class_2246.field_23874, class_2246.field_10266, class_2246.field_9986, class_2246.field_10092, class_2246.field_22120, class_2246.field_22113, class_2246.field_10114, class_2246.field_22090, class_2246.field_10541, class_2246.field_22115, class_2246.field_22122);
        END_SOLIDS = List.of(class_2246.field_10471, class_2246.field_10462, class_2246.field_10286, class_2246.field_10505, class_2246.field_10286);
        DIFF = Map.of(class_1267.field_5801, new Mult(1.3, 0.9, 0.8), class_1267.field_5805, new Mult(1.2, 1.0, 0.9), class_1267.field_5802, new Mult(1.0, 1.0, 1.0), class_1267.field_5807, new Mult(0.8, 1.1, 1.1));
        cycleToBlomeIndex = new ConcurrentHashMap<Long, Integer>();
        forcedBiomeName = null;
        forcedBiomeSetTime = 0L;
        ALWAYS_ALLOW = new HashSet<class_2248>();
        ALWAYS_ALLOW.addAll(OVERWORLD_PLANTS);
        ALWAYS_ALLOW.addAll(OVERWORLD_LEAVES);
        ALWAYS_ALLOW.addAll(NETHER_PLANTS);
        ALWAYS_ALLOW.addAll(END_PLANTS);
        ALWAYS_ALLOW.addAll(NETHER_SOLIDS);
        ALWAYS_ALLOW.addAll(END_SOLIDS);
    }

    private static final class WeightedBag {
        private final class_5819 rnd;
        private final ArrayList<class_2248> entries = new ArrayList();

        WeightedBag(class_5819 rnd) {
            this.rnd = rnd;
        }

        void addAll(List<class_2248> list, int weightEach) {
            if (list == null || list.isEmpty() || weightEach <= 0) {
                return;
            }
            for (class_2248 b : list) {
                for (int i = 0; i < weightEach; ++i) {
                    this.entries.add(b);
                }
            }
        }

        class_2248 pick() {
            if (this.entries.isEmpty()) {
                return null;
            }
            int idx = this.rnd.method_43048(this.entries.size());
            return this.entries.get(idx);
        }
    }

    private static final class Mult {
        final double useful;
        final double structural;
        final double rare;

        Mult(double useful, double structural, double rare) {
            this.useful = useful;
            this.structural = structural;
            this.rare = rare;
        }
    }
}

