/*
 * Decompiled with CFR 0.152.
 */
package lynk.oneblock.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_5321;
import net.minecraft.class_6544;
import net.minecraft.class_6880;

public class OneBlockBiomeSource
extends class_1966 {
    public static final MapCodec<OneBlockBiomeSource> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_1959.field_24677.listOf().fieldOf("biomes").forGetter(source -> source.biomeList)).apply((Applicative)instance, OneBlockBiomeSource::new));
    private final List<class_6880<class_1959>> biomeList;

    public OneBlockBiomeSource(List<class_6880<class_1959>> biomes) {
        this.biomeList = biomes;
    }

    protected MapCodec<? extends class_1966> method_28442() {
        return CODEC;
    }

    protected Stream<class_6880<class_1959>> method_49494() {
        return this.biomeList.stream();
    }

    public class_6880<class_1959> method_38109(int x, int y, int z, class_6544.class_6552 noise) {
        int chunkX = x >> 2;
        int chunkZ = z >> 2;
        int plainsRadius = 2;
        if (Math.abs(chunkX) <= plainsRadius && Math.abs(chunkZ) <= plainsRadius) {
            for (class_6880<class_1959> biome : this.biomeList) {
                if (!biome.method_40230().isPresent() || !((class_5321)biome.method_40230().get()).method_29177().method_12832().equals("plains")) continue;
                return biome;
            }
            return this.biomeList.get(0);
        }
        long hash = this.mix(x, y, z);
        int index = Math.abs((int)(hash % (long)this.biomeList.size()));
        return this.biomeList.get(index);
    }

    private long mix(int x, int y, int z) {
        long hash = x >>= 6;
        hash = hash * 31L + (long)(z >>= 6);
        hash = hash * 31L + (long)(y >> 4);
        hash ^= hash >>> 16;
        hash *= -2048144789L;
        hash ^= hash >>> 13;
        hash *= -1028477387L;
        hash ^= hash >>> 16;
        return hash;
    }
}

