/*
 * Decompiled with CFR 0.152.
 */
package lynk.oneblock.config;

import java.util.ArrayList;
import java.util.List;
import lynk.oneblock.config.OneBlockConfig;
import lynk.oneblock.datapack.MultiplayerPackControl;
import lynk.oneblock.persit.StateSaverAndLoader;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.class_5250;
import net.minecraft.class_9285;
import net.minecraft.class_9290;
import net.minecraft.class_9334;

public class AdminPanelScreenHandler
extends class_1703 {
    private final class_1263 inventory;
    private final class_3222 player;

    public AdminPanelScreenHandler(int syncId, class_1661 playerInventory, class_3222 player) {
        super(class_3917.field_17327, syncId);
        int col;
        int row;
        this.player = player;
        this.inventory = new class_1277(54);
        for (row = 0; row < 6; ++row) {
            for (col = 0; col < 9; ++col) {
                this.method_7621(new class_1735(this, this.inventory, col + row * 9, 8 + col * 18, 18 + row * 18){

                    public boolean method_7680(class_1799 stack) {
                        return false;
                    }
                });
            }
        }
        for (row = 0; row < 3; ++row) {
            for (col = 0; col < 9; ++col) {
                this.method_7621(new class_1735((class_1263)playerInventory, col + row * 9 + 9, 8 + col * 18, 140 + row * 18));
            }
        }
        for (int col2 = 0; col2 < 9; ++col2) {
            this.method_7621(new class_1735((class_1263)playerInventory, col2, 8 + col2 * 18, 198));
        }
        this.refreshDisplay();
    }

    public void refreshDisplay() {
        if (this.player == null || this.player.method_51469() == null || this.player.method_51469().method_8503() == null) {
            return;
        }
        StateSaverAndLoader state = StateSaverAndLoader.getServerState(this.player.method_51469().method_8503());
        OneBlockConfig config = state.getConfig();
        this.inventory.method_5448();
        this.inventory.method_5447(0, this.createInfoItem(class_1802.field_8470, "\u00a76\u00a7lWave Settings", List.of("\u00a77Configure mob wave mechanics")));
        this.inventory.method_5447(1, this.createToggleItem(class_1802.field_8371, "Mob Waves", config.areMobWavesEnabled(), List.of("\u00a77Enable or disable hostile mob waves", "\u00a77that spawn periodically during gameplay")));
        this.inventory.method_5447(2, this.createChanceItem(class_1802.field_8557, "Wave Chance", config.getWaveChance(), true, List.of("\u00a77Chance for a mob wave to trigger", "\u00a77after each OneBlock break")));
        this.inventory.method_5447(3, this.createAdjustItem(class_1802.field_8107, "Max Wave Size", String.valueOf(config.getMaxWaveSize()), config.getMaxWaveSize(), List.of("\u00a77Maximum number of mobs that can", "\u00a77spawn in a single wave")));
        this.inventory.method_5447(4, this.createAdjustItem(class_1802.field_8251, "Wave Size Divisor", String.valueOf(config.getWaveSizeDivisor()), config.getWaveSizeDivisor(), List.of("\u00a77Divide total breaks by this to get", "\u00a77wave size (higher = smaller waves)")));
        this.inventory.method_5447(9, this.createInfoItem(class_1802.field_8106, "\u00a76\u00a7lDrop Settings", List.of("\u00a77Configure item and mob drops")));
        this.inventory.method_5447(10, this.createToggleItem(class_1802.field_8477, "Item Drops", config.areItemDropsEnabled(), List.of("\u00a77Enable or disable bonus item drops", "\u00a77when breaking the OneBlock")));
        this.inventory.method_5447(11, this.createChanceItem(class_1802.field_8634, "Item Drop Chance", config.getItemDropChance(), false, List.of("\u00a77Chance for bonus items to drop", "\u00a77after each OneBlock break")));
        this.inventory.method_5447(12, this.createAdjustItem(class_1802.field_8143, "Item Drop Count", String.valueOf(config.getItemDropCount()), config.getItemDropCount(), List.of("\u00a77Number of items to drop when", "\u00a77the item drop chance hits", "\u00a77", "\u00a77Left click: -1 | Right click: +1", "\u00a77Shift+Left: -10 | Shift+Right: +10")));
        this.inventory.method_5447(13, this.createToggleItem(class_1802.field_8073, "Friendly Mobs", config.areFriendlyMobsEnabled(), List.of("\u00a77Enable or disable friendly mob spawns", "\u00a77(animals, villagers, etc.)")));
        this.inventory.method_5447(14, this.createChanceItem(class_1802.field_8184, "Friendly Mob Chance", config.getFriendlyMobChance(), false, List.of("\u00a77Chance for friendly mobs to spawn", "\u00a77after each OneBlock break")));
        this.inventory.method_5447(15, this.createChanceItem(class_1802.field_8187, "Lava Bucket Chance", config.getLavaBucketChance(), false, List.of("\u00a77Chance for a lava bucket to drop", "\u00a77after each OneBlock break", "\u00a77", "\u00a77Easy way to get lava!")));
        this.inventory.method_5447(18, this.createInfoItem(class_1802.field_8827, "\u00a76\u00a7lEnd Portal Frame", List.of("\u00a77Configure end portal frame drops")));
        this.inventory.method_5447(19, this.createToggleItem(class_1802.field_8827, "Portal Frame Drops", config.isEndPortalFrameEnabled(), List.of("\u00a77Enable or disable end portal frame", "\u00a77drops from breaking the OneBlock")));
        this.inventory.method_5447(20, this.createChanceItem(class_1802.field_8557, "Portal Frame Chance", config.getEndPortalFrameChance(), false, List.of("\u00a77Chance for portal frames to drop", "\u00a77after requirement is met")));
        this.inventory.method_5447(21, this.createAdjustItem(class_1802.field_8287, "Min Breaks Required", String.valueOf(config.getEndPortalFrameRequirement()), config.getEndPortalFrameRequirement(), List.of("\u00a77Minimum OneBlock breaks needed", "\u00a77before portal frames can drop")));
        this.inventory.method_5447(27, this.createInfoItem(class_1802.field_8598, "\u00a76\u00a7lProgression", List.of("\u00a77Configure block progression")));
        this.inventory.method_5447(28, this.createAdjustItem(class_1802.field_22018, "Progression Cap", config.getProgressionCap() + " breaks", config.getProgressionCap(), List.of("\u00a77Total breaks needed to reach max", "\u00a77block progression and difficulty", "\u00a77", "\u00a77Left click: -100 | Right click: +100", "\u00a77Shift+Left: -1000 | Shift+Right: +1000")));
        boolean multiplayerEnabled = MultiplayerPackControl.isEnabled();
        if (multiplayerEnabled) {
            this.inventory.method_5447(29, this.createToggleItem(class_1802.field_18674, "Use Global Break Count", config.useGlobalBreakCount(), List.of("\u00a77When enabled: All players share", "\u00a77progression based on total breaks", "\u00a77When disabled: Each player has", "\u00a77independent progression", "\u00a77", "\u00a77(Multiplayer mode only)")));
        }
        this.inventory.method_5447(30, this.createToggleItem(class_1802.field_8270, "Biome Cycling", config.isBiomeCyclingEnabled(), List.of("\u00a77When enabled: Island biome switches", "\u00a77randomly every X breaks", "\u00a77Biome-specific blocks will spawn", "\u00a77from the OneBlock")));
        this.inventory.method_5447(31, this.createAdjustItem(class_1802.field_8251, "Biome Switch Interval", config.getBiomeSwitchInterval() + " breaks", config.getBiomeSwitchInterval(), List.of("\u00a77Number of breaks before switching", "\u00a77to a new random biome", "\u00a77", "\u00a77Left click: -10 | Right click: +10", "\u00a77Shift+Left: -100 | Shift+Right: +100")));
        this.inventory.method_5447(32, this.createToggleItem(class_1802.field_8106, "Spawn Items in Chest", config.isSpawnItemsInChest(), List.of("\u00a77When enabled: Item drops spawn", "\u00a77in a chest at the OneBlock location", "\u00a77instead of being dropped on the ground", "\u00a77", "\u00a77The chest will appear with effects", "\u00a77and disappear after being opened")));
        this.inventory.method_5447(36, this.createInfoItem(class_1802.field_8407, "\u00a76\u00a7lWave Countdowns", List.of("\u00a77Breaks until wave spawns", "\u00a77Click to cycle through tiers")));
        for (int i = 0; i < Math.min(7, config.getWaveTierCount()); ++i) {
            int threshold = config.getWaveThreshold(i);
            int countdown = config.getWaveCountdown(threshold);
            this.inventory.method_5447(37 + i, this.createWaveCountdownItem(i, threshold, countdown));
        }
        this.inventory.method_5447(45, this.createActionItem(class_1802.field_8077, "\u00a7c\u00a7lReset to Defaults", List.of("\u00a77Click to reset all settings")));
        this.inventory.method_5447(49, this.createInfoItem(class_1802.field_8674, "\u00a7e\u00a7lOneBlock Admin Panel", List.of("\u00a77Left click: -1 | Right click: +1", "\u00a77Shift+Left: -10 | Shift+Right: +10")));
        this.inventory.method_5447(53, this.createActionItem(class_1802.field_8691, "\u00a7a\u00a7lClose", List.of("\u00a77Click to close this menu")));
    }

    private class_1799 createInfoItem(class_1792 item, String name, List<String> lore) {
        class_1799 stack = new class_1799((class_1935)item);
        stack.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)name));
        ArrayList<class_5250> loreLines = new ArrayList<class_5250>();
        for (String line : lore) {
            loreLines.add(class_2561.method_43470((String)line));
        }
        stack.method_57379(class_9334.field_49632, (Object)new class_9290(loreLines));
        return stack;
    }

    private class_1799 createToggleItem(class_1792 item, String name, boolean enabled, List<String> description) {
        class_1799 stack = new class_1799((class_1935)item);
        String displayName = (enabled ? "\u00a7a" : "\u00a7c") + name + ": " + (enabled ? "ON" : "OFF");
        stack.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)displayName));
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        lore.add(class_2561.method_43470((String)(enabled ? "\u00a77Status: \u00a7aEnabled" : "\u00a77Status: \u00a7cDisabled")));
        lore.add(class_2561.method_43470((String)""));
        for (String line : description) {
            lore.add(class_2561.method_43470((String)line));
        }
        lore.add(class_2561.method_43470((String)""));
        lore.add(class_2561.method_43470((String)"\u00a77Click to toggle"));
        stack.method_57379(class_9334.field_49632, (Object)new class_9290(lore));
        stack.method_57379(class_9334.field_49636, (Object)class_9285.field_49326);
        if (enabled) {
            stack.method_57379(class_9334.field_49641, (Object)true);
        }
        return stack;
    }

    private class_1799 createAdjustItem(class_1792 item, String name, String value, int currentValue, List<String> description) {
        class_1799 stack = new class_1799((class_1935)item);
        stack.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)("\u00a7b" + name)));
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        lore.add(class_2561.method_43470((String)("\u00a77Current: \u00a7e" + value)));
        lore.add(class_2561.method_43470((String)""));
        for (String line2 : description) {
            lore.add(class_2561.method_43470((String)line2));
        }
        boolean hasCustomControls = description.stream().anyMatch(line -> line.contains("click:"));
        if (!hasCustomControls) {
            lore.add(class_2561.method_43470((String)""));
            lore.add(class_2561.method_43470((String)"\u00a77Left click: -1 | Right click: +1"));
            lore.add(class_2561.method_43470((String)"\u00a77Shift+Left: -10 | Shift+Right: +10"));
        }
        stack.method_57379(class_9334.field_49632, (Object)new class_9290(lore));
        stack.method_7939(Math.min(64, Math.max(1, currentValue / 10)));
        return stack;
    }

    private class_1799 createChanceItem(class_1792 item, String name, int baseChance, boolean isHostileSpawn, List<String> description) {
        class_1799 stack = new class_1799((class_1935)item);
        stack.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)("\u00a7b" + name)));
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        lore.add(class_2561.method_43470((String)("\u00a77Base: \u00a7e1 in " + baseChance + " \u00a77(" + String.format("%.3f", 100.0 / (double)baseChance) + "%)")));
        lore.add(class_2561.method_43470((String)""));
        for (String line : description) {
            lore.add(class_2561.method_43470((String)line));
        }
        lore.add(class_2561.method_43470((String)""));
        lore.add(class_2561.method_43470((String)"\u00a77Actual chances per break:"));
        if (isHostileSpawn) {
            int easyChance = baseChance * 2;
            int normalChance = baseChance;
            int hardChance = Math.max(1, baseChance / 3);
            lore.add(class_2561.method_43470((String)("\u00a7a  Easy: \u00a7e1 in " + easyChance + " \u00a77(" + String.format("%.3f", 100.0 / (double)easyChance) + "%)")));
            lore.add(class_2561.method_43470((String)("\u00a7e  Normal: \u00a7e1 in " + normalChance + " \u00a77(" + String.format("%.3f", 100.0 / (double)normalChance) + "%)")));
            lore.add(class_2561.method_43470((String)("\u00a7c  Hard: \u00a7e1 in " + hardChance + " \u00a77(" + String.format("%.3f", 100.0 / (double)hardChance) + "%)")));
        } else {
            int easyChance = Math.max(1, baseChance / 2);
            int normalChance = baseChance;
            int hardChance = baseChance * 3;
            lore.add(class_2561.method_43470((String)("\u00a7a  Easy: \u00a7e1 in " + easyChance + " \u00a77(" + String.format("%.3f", 100.0 / (double)easyChance) + "%)")));
            lore.add(class_2561.method_43470((String)("\u00a7e  Normal: \u00a7e1 in " + normalChance + " \u00a77(" + String.format("%.3f", 100.0 / (double)normalChance) + "%)")));
            lore.add(class_2561.method_43470((String)("\u00a7c  Hard: \u00a7e1 in " + hardChance + " \u00a77(" + String.format("%.3f", 100.0 / (double)hardChance) + "%)")));
        }
        lore.add(class_2561.method_43470((String)"\u00a78  Peaceful: \u00a780%"));
        lore.add(class_2561.method_43470((String)""));
        lore.add(class_2561.method_43470((String)"\u00a77Left click: -1 (Shift: -10)"));
        lore.add(class_2561.method_43470((String)"\u00a77Right click: +1 (Shift: +10)"));
        stack.method_57379(class_9334.field_49632, (Object)new class_9290(lore));
        stack.method_7939(Math.min(64, Math.max(1, baseChance / 10)));
        return stack;
    }

    private class_1799 createWaveCountdownItem(int tier, int threshold, int countdown) {
        class_1799 stack = new class_1799((class_1935)class_1802.field_8557);
        stack.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)("\u00a7bTier " + tier + " (" + threshold + "+ breaks)")));
        ArrayList<class_5250> lore = new ArrayList<class_5250>();
        lore.add(class_2561.method_43470((String)("\u00a77Countdown: \u00a7e" + countdown + " breaks")));
        lore.add(class_2561.method_43470((String)"\u00a77Left click: -1"));
        lore.add(class_2561.method_43470((String)"\u00a77Right click: +1"));
        stack.method_57379(class_9334.field_49632, (Object)new class_9290(lore));
        stack.method_7939(Math.min(64, countdown));
        return stack;
    }

    private class_1799 createActionItem(class_1792 item, String name, List<String> lore) {
        class_1799 stack = new class_1799((class_1935)item);
        stack.method_57379(class_9334.field_49631, (Object)class_2561.method_43470((String)name));
        ArrayList<class_5250> loreLines = new ArrayList<class_5250>();
        for (String line : lore) {
            loreLines.add(class_2561.method_43470((String)line));
        }
        stack.method_57379(class_9334.field_49632, (Object)new class_9290(loreLines));
        return stack;
    }

    public class_1799 method_7601(class_1657 player, int slot) {
        return class_1799.field_8037;
    }

    public boolean method_7597(class_1657 player) {
        return player.method_64475(2);
    }

    public void method_7593(int slotIndex, int button, class_1713 actionType, class_1657 player) {
        boolean rightClick;
        if (slotIndex < 0 || slotIndex >= 54 || !(player instanceof class_3222)) {
            super.method_7593(slotIndex, button, actionType, player);
            return;
        }
        class_3222 serverPlayer = (class_3222)player;
        StateSaverAndLoader state = StateSaverAndLoader.getServerState(serverPlayer.method_51469().method_8503());
        OneBlockConfig config = state.getConfig();
        boolean shift = actionType == class_1713.field_7794;
        boolean bl = rightClick = button == 1;
        int adjustment = shift && rightClick ? 10 : (shift && !rightClick ? -10 : (rightClick ? 1 : -1));
        boolean changed = false;
        switch (slotIndex) {
            case 1: {
                config.setMobWavesEnabled(!config.areMobWavesEnabled());
                changed = true;
                break;
            }
            case 2: {
                config.setWaveChance(Math.max(1, config.getWaveChance() + adjustment));
                changed = true;
                break;
            }
            case 3: {
                config.setMaxWaveSize(Math.max(1, config.getMaxWaveSize() + adjustment));
                changed = true;
                break;
            }
            case 4: {
                config.setWaveSizeDivisor(Math.max(1, config.getWaveSizeDivisor() + adjustment));
                changed = true;
                break;
            }
            case 10: {
                config.setItemDropsEnabled(!config.areItemDropsEnabled());
                changed = true;
                break;
            }
            case 11: {
                config.setItemDropChance(Math.max(1, config.getItemDropChance() + adjustment));
                changed = true;
                break;
            }
            case 12: {
                config.setItemDropCount(Math.max(1, Math.min(64, config.getItemDropCount() + adjustment)));
                changed = true;
                break;
            }
            case 13: {
                config.setFriendlyMobsEnabled(!config.areFriendlyMobsEnabled());
                changed = true;
                break;
            }
            case 14: {
                config.setFriendlyMobChance(Math.max(1, config.getFriendlyMobChance() + adjustment));
                changed = true;
                break;
            }
            case 15: {
                config.setLavaBucketChance(Math.max(1, config.getLavaBucketChance() + adjustment));
                changed = true;
                break;
            }
            case 19: {
                config.setEndPortalFrameEnabled(!config.isEndPortalFrameEnabled());
                changed = true;
                break;
            }
            case 20: {
                config.setEndPortalFrameChance(Math.max(1, config.getEndPortalFrameChance() + adjustment));
                changed = true;
                break;
            }
            case 21: {
                config.setEndPortalFrameRequirement(Math.max(0, config.getEndPortalFrameRequirement() + adjustment * 100));
                changed = true;
                break;
            }
            case 28: {
                int progressionAdjustment = shift && rightClick ? 1000 : (shift && !rightClick ? -1000 : (rightClick ? 100 : -100));
                config.setProgressionCap(Math.max(1000, config.getProgressionCap() + progressionAdjustment));
                changed = true;
                break;
            }
            case 29: {
                config.setUseGlobalBreakCount(!config.useGlobalBreakCount());
                changed = true;
                break;
            }
            case 30: {
                config.setBiomeCyclingEnabled(!config.isBiomeCyclingEnabled());
                changed = true;
                break;
            }
            case 31: {
                int intervalAdjustment = shift && rightClick ? 100 : (shift && !rightClick ? -100 : (rightClick ? 10 : -10));
                config.setBiomeSwitchInterval(config.getBiomeSwitchInterval() + intervalAdjustment);
                changed = true;
                break;
            }
            case 32: {
                config.setSpawnItemsInChest(!config.isSpawnItemsInChest());
                changed = true;
                break;
            }
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: {
                int tier = slotIndex - 37;
                int currentCountdown = config.getWaveCountdown(config.getWaveThreshold(tier));
                config.setWaveCountdown(tier, Math.max(1, currentCountdown + (rightClick ? 1 : -1)));
                changed = true;
                break;
            }
            case 45: {
                config.resetToDefaults();
                serverPlayer.method_7353((class_2561)class_2561.method_43470((String)"\u00a7a[OneBlock] All settings reset to defaults!"), false);
                changed = true;
                break;
            }
            case 53: {
                serverPlayer.method_7346();
                return;
            }
        }
        if (changed) {
            state.method_80();
            this.refreshDisplay();
        }
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        this.inventory.method_5448();
    }
}

