/*
 * Decompiled with CFR 0.152.
 */
package lynk.oneblock.events;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lynk.oneblock.persit.StateSaverAndLoader;
import lynk.oneblock.worldgen.OneBlockChunkGenerator;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3486;
import net.minecraft.class_3730;
import net.minecraft.class_3986;
import net.minecraft.class_3989;
import net.minecraft.class_5819;

public class FriendlySpawn {
    private static final int MAX_PASSIVE_SIZE = 8;
    private static final double TRADER_EVENT_CHANCE = 0.07;

    public static void spawn(class_1937 world) {
        if (world.method_8608()) {
            return;
        }
        StateSaverAndLoader state = StateSaverAndLoader.getServerState(world.method_8503());
        long breaks = state.totalOneBlockBreaks;
        class_5819 rnd = world.method_8409();
        class_2338 center = OneBlockChunkGenerator.getSpawnBlockPos().method_10074();
        boolean aquaticPool = FriendlySpawn.hasWaterPool(world, center);
        boolean traderEvent = !aquaticPool && rnd.method_43058() < 0.07;
        int spawned = 0;
        if (traderEvent) {
            spawned = FriendlySpawn.spawnWanderingTraderVisit(world, center);
        } else {
            List<class_1299<? extends class_1309>> pool = aquaticPool ? FriendlySpawn.getAquaticPool() : FriendlySpawn.getFullPassivePool();
            int count = FriendlySpawn.getCount(breaks, rnd, aquaticPool);
            int n = spawned = aquaticPool ? FriendlySpawn.spawnAquaticWave(world, center, pool, count, 4, 16) : FriendlySpawn.spawnPassiveWave(world, center, pool, count, 4, 8);
        }
        if (spawned > 0) {
            FriendlySpawn.announceToAll(world, (class_2561)class_2561.method_43470((String)(aquaticPool ? "\u00a7b[OneBlock] Aquatic friends appeared!" : "\u00a7a[OneBlock] Friendly wave: \u00a7e" + spawned + "\u00a77 entities.")));
        }
    }

    private static List<class_1299<? extends class_1309>> getFullPassivePool() {
        ArrayList<class_1299<? extends class_1309>> list = new ArrayList<class_1299<? extends class_1309>>(Arrays.asList(class_1299.field_6132, class_1299.field_6115, class_1299.field_6085, class_1299.field_6093, class_1299.field_6140, class_1299.field_30052, class_1299.field_16281, class_1299.field_6055, class_1299.field_6139, class_1299.field_6067, class_1299.field_6057, class_1299.field_6143, class_1299.field_20346, class_1299.field_6104, class_1299.field_42622, class_1299.field_40116, class_1299.field_6074));
        list.addAll(Arrays.asList(class_1299.field_17943, class_1299.field_6146, class_1299.field_6042, class_1299.field_6113, class_1299.field_6047, class_1299.field_6147, class_1299.field_38384, class_1299.field_47754));
        list.add((class_1299)class_1299.field_6077);
        return list;
    }

    private static List<class_1299<? extends class_1309>> getAquaticPool() {
        return new ArrayList<class_1299<? extends class_1309>>(Arrays.asList(class_1299.field_6070, class_1299.field_6073, class_1299.field_6111, class_1299.field_6062, class_1299.field_6114, class_1299.field_28402, class_1299.field_28315, class_1299.field_37420, class_1299.field_6087, class_1299.field_37419));
    }

    private static int getCount(long breaks, class_5819 rnd, boolean aquaticPool) {
        int cap;
        int n = breaks < 300L ? 2 : (breaks < 1000L ? 4 : (breaks < 2500L ? 5 : (cap = breaks < 5000L ? 6 : 7)));
        if (aquaticPool) {
            cap = Math.max(2, cap - 1);
        }
        cap = Math.min(cap, 8);
        return 1 + rnd.method_43048(cap);
    }

    private static int spawnPassiveWave(class_1937 world, class_2338 center, List<class_1299<? extends class_1309>> pool, int count, int radius, int maxTriesPerMob) {
        class_5819 rand = world.method_8409();
        int spawned = 0;
        for (int i = 0; i < count; ++i) {
            class_1309 entity;
            class_1299<? extends class_1309> type = FriendlySpawn.randomFrom(pool, rand);
            class_2338 pos = FriendlySpawn.pickNearbySurface(world, center, radius, maxTriesPerMob);
            if (pos == null) {
                pos = center;
            }
            if ((entity = (class_1309)type.method_5883(world, class_3730.field_16467)) == null) continue;
            if (entity instanceof class_1308) {
                class_1308 mob = (class_1308)entity;
                if (rand.method_43058() < 0.15) {
                    mob.method_7217(true);
                }
            }
            entity.method_5725(pos, rand.method_43057() * 360.0f, 0.0f);
            if (!world.method_8649((class_1297)entity)) continue;
            ++spawned;
        }
        return spawned;
    }

    private static int spawnAquaticWave(class_1937 world, class_2338 center, List<class_1299<? extends class_1309>> pool, int count, int radius, int maxTriesPerMob) {
        class_5819 rand = world.method_8409();
        int spawned = 0;
        PoolBounds pb = FriendlySpawn.getPoolBounds(center);
        for (int i = 0; i < count; ++i) {
            class_1309 entity;
            class_1299<? extends class_1309> type = FriendlySpawn.randomFrom(pool, rand);
            class_2338 waterPos = FriendlySpawn.pickRandomWaterInPool(world, pb, maxTriesPerMob, rand);
            if (waterPos == null) {
                waterPos = center;
            }
            if ((entity = (class_1309)type.method_5883(world, class_3730.field_16467)) == null) continue;
            entity.method_5808((double)waterPos.method_10263() + 0.5, (double)waterPos.method_10264() + 0.2, (double)waterPos.method_10260() + 0.5, rand.method_43057() * 360.0f, 0.0f);
            if (!world.method_8649((class_1297)entity)) continue;
            ++spawned;
        }
        return spawned;
    }

    private static int spawnWanderingTraderVisit(class_1937 world, class_2338 center) {
        class_1297 t;
        class_5819 rand = world.method_8409();
        class_2338 traderPos = FriendlySpawn.pickNearbySurface(world, center, 3, 12);
        if (traderPos == null) {
            traderPos = center;
        }
        if (!((t = class_1299.field_17713.method_5883(world, class_3730.field_16467)) instanceof class_3989)) {
            return 0;
        }
        class_3989 trader = (class_3989)t;
        trader.method_5725(traderPos, rand.method_43057() * 360.0f, 0.0f);
        int spawned = world.method_8649((class_1297)trader) ? 1 : 0;
        for (int i = 0; i < 2; ++i) {
            class_1297 e;
            class_2338 llamaPos = FriendlySpawn.pickNearbySurface(world, traderPos, 2, 8);
            if (llamaPos == null) {
                llamaPos = traderPos;
            }
            if (!((e = class_1299.field_17714.method_5883(world, class_3730.field_16467)) instanceof class_3986)) continue;
            class_3986 llama = (class_3986)e;
            llama.method_5725(llamaPos, rand.method_43057() * 360.0f, 0.0f);
            if (!world.method_8649((class_1297)llama)) continue;
            ++spawned;
            llama.method_60964((class_1297)trader, true);
        }
        return spawned;
    }

    private static boolean hasWaterPool(class_1937 world, class_2338 center) {
        PoolBounds pb = FriendlySpawn.getPoolBounds(center);
        for (int x = pb.min().method_10263(); x <= pb.max().method_10263(); ++x) {
            for (int z = pb.min().method_10260(); z <= pb.max().method_10260(); ++z) {
                if (FriendlySpawn.isWater(world.method_8320(new class_2338(x, pb.max().method_10264(), z)))) continue;
                return false;
            }
        }
        return true;
    }

    private static PoolBounds getPoolBounds(class_2338 center) {
        int yTop = center.method_10264() - 1;
        class_2338 min = new class_2338(center.method_10263() - 2, yTop - 1, center.method_10260() - 2);
        class_2338 max = new class_2338(center.method_10263() + 2, yTop, center.method_10260() + 2);
        return new PoolBounds(min, max);
    }

    private static boolean isWater(class_2680 state) {
        return state.method_26227().method_15767(class_3486.field_15517);
    }

    private static class_2338 pickRandomWaterInPool(class_1937 world, PoolBounds pb, int tries, class_5819 rnd) {
        for (int i = 0; i < tries; ++i) {
            int x = rnd.method_39332(pb.min().method_10263(), pb.max().method_10263());
            int z = rnd.method_39332(pb.min().method_10260(), pb.max().method_10260());
            int y = rnd.method_43056() ? pb.max().method_10264() : pb.max().method_10264() - 1;
            class_2338 pos = new class_2338(x, y, z);
            if (!FriendlySpawn.isWater(world.method_8320(pos))) continue;
            return pos;
        }
        int cx = (pb.min().method_10263() + pb.max().method_10263()) / 2;
        int cz = (pb.min().method_10260() + pb.max().method_10260()) / 2;
        return new class_2338(cx, pb.max().method_10264(), cz);
    }

    private static class_2338 pickNearbySurface(class_1937 world, class_2338 center, int radius, int tries) {
        class_5819 rand = world.method_8409();
        for (int t = 0; t < tries; ++t) {
            int dz;
            int dx = rand.method_39332(-radius, radius);
            if (dx * dx + (dz = rand.method_39332(-radius, radius)) * dz > radius * radius) continue;
            class_2338 pos = center.method_10069(dx, 0, dz);
            if (world.method_22347(pos)) {
                return pos;
            }
            if (!world.method_22347(pos.method_10084())) continue;
            return pos.method_10084();
        }
        return center;
    }

    private static <T> T randomFrom(List<T> list, class_5819 rnd) {
        return list.get(rnd.method_43048(list.size()));
    }

    private static void announceToAll(class_1937 world, class_2561 message) {
        if (world.method_8503() == null) {
            return;
        }
        for (class_3222 p : world.method_8503().method_3760().method_14571()) {
            p.method_7353(message, false);
        }
    }

    private record PoolBounds(class_2338 min, class_2338 max) {
    }
}

