/*
 * Decompiled with CFR 0.152.
 */
package lynk.oneblock.events;

import java.util.ArrayList;
import java.util.List;
import lynk.oneblock.persit.StateSaverAndLoader;
import lynk.oneblock.worldgen.OneBlockChunkGenerator;
import net.minecraft.class_1267;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3730;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7924;

public class MobSpawn {
    private static int MAX_MOB_SIZE = 100;
    private static final List<class_1299<? extends class_1309>> ENEMIES = List.of(class_1299.field_6051, class_1299.field_6137, class_1299.field_6046, class_1299.field_6079, class_1299.field_6091, class_1299.field_6071, class_1299.field_6098);

    private static Scale scaleFor(class_1267 d) {
        return switch (d) {
            default -> throw new MatchException(null, null);
            case class_1267.field_5801 -> new Scale(0, 0.0, 0, 0);
            case class_1267.field_5805 -> new Scale(0, 0.05, 0, 0);
            case class_1267.field_5802 -> new Scale(1, 0.15, 1, 1);
            case class_1267.field_5807 -> new Scale(3, 0.3, 2, 3);
        };
    }

    public static void setMobSpawn(class_1937 world) {
        if (world.method_8608()) {
            return;
        }
        StateSaverAndLoader state = StateSaverAndLoader.getServerState(world.method_8503());
        long breaks = MobSpawn.getBreakCount(state);
        class_1267 diff = world.method_8407();
        if (diff == class_1267.field_5801) {
            state.MobSpawnSet = false;
            state.BreaksTillSpawn = Integer.MAX_VALUE;
            MobSpawn.announceToAll(world, (class_2561)class_2561.method_43470((String)"\u00a77[OneBlock] Waves are disabled on \u00a7aPEACEFUL\u00a77."));
            return;
        }
        int baseCount = MobSpawn.getCountForBreaks(breaks, world.method_8409());
        int baseCooldown = MobSpawn.getCooldownForBreaks(breaks);
        List<class_1299<? extends class_1309>> pool = MobSpawn.getPoolForBreaks(breaks);
        Scale sc = MobSpawn.scaleFor(diff);
        int finalCount = Math.max(1, Math.min(MAX_MOB_SIZE, baseCount + sc.countBonus));
        int finalCooldown = Math.max(1, baseCooldown - sc.cooldownAdjust);
        state.MobSpawnSet = true;
        state.BreaksTillSpawn = finalCooldown;
        state.PendingMobCount = finalCount;
        MobSpawn.announceToAll(world, (class_2561)class_2561.method_43470((String)("\u00a7e[OneBlock] \u00a77Next wave in \u00a7b" + finalCooldown + "\u00a77 breaks (" + diff.method_5460().toUpperCase() + ").")));
    }

    public static void spawnWaveNow(class_1937 world) {
        if (world.method_8608()) {
            return;
        }
        StateSaverAndLoader state = StateSaverAndLoader.getServerState(world.method_8503());
        long breaks = MobSpawn.getBreakCount(state);
        class_1267 diff = world.method_8407();
        if (diff == class_1267.field_5801) {
            state.MobSpawnSet = false;
            state.BreaksTillSpawn = Integer.MAX_VALUE;
            return;
        }
        List<class_1299<? extends class_1309>> pool = MobSpawn.getPoolForBreaks(breaks);
        int count = Math.max(1, Math.min(MAX_MOB_SIZE, state.PendingMobCount));
        Scale sc = MobSpawn.scaleFor(diff);
        class_2338 center = OneBlockChunkGenerator.getSpawnBlockPos().method_10084();
        int spawned = MobSpawn.spawnWave(world, center, pool, count, 4, 8, sc);
        MobSpawn.announceToAll(world, (class_2561)class_2561.method_43470((String)("\u00a7c[OneBlock] Wave spawned: \u00a7e" + spawned + " \u00a77(" + diff.method_5460().toUpperCase() + ").")));
        state.BreaksTillSpawn = Math.max(1, MobSpawn.getCooldownForBreaks(breaks) - sc.cooldownAdjust);
        state.MobSpawnSet = false;
        state.PendingMobCount = 0;
    }

    private static int getCountForBreaks(long breaks, class_5819 random) {
        if (breaks < 100L) {
            return 1;
        }
        long stage = breaks / 100L;
        long maxMobs = Math.min(stage + 1L, (long)MAX_MOB_SIZE);
        return 1 + random.method_43048((int)maxMobs);
    }

    private static int getCooldownForBreaks(long breaks) {
        if (breaks < 500L) {
            return 12;
        }
        if (breaks < 1500L) {
            return 10;
        }
        if (breaks < 3000L) {
            return 8;
        }
        if (breaks < 5000L) {
            return 6;
        }
        if (breaks < 8000L) {
            return 5;
        }
        if (breaks < 12000L) {
            return 4;
        }
        return 3;
    }

    private static List<class_1299<? extends class_1309>> getPoolForBreaks(long breaks) {
        ArrayList<class_1299<? extends class_1309>> pool = new ArrayList<class_1299<? extends class_1309>>();
        if (breaks < 500L) {
            pool.add(class_1299.field_6051);
            pool.add(class_1299.field_6079);
            return pool;
        }
        pool.add(class_1299.field_6051);
        pool.add(class_1299.field_6079);
        pool.add((class_1299<? extends class_1309>)class_1299.field_6137);
        if (breaks >= 1500L) {
            pool.add((class_1299<? extends class_1309>)class_1299.field_6046);
            pool.add((class_1299<? extends class_1309>)class_1299.field_6071);
            pool.add((class_1299<? extends class_1309>)class_1299.field_6098);
        }
        if (breaks >= 3000L) {
            pool.add((class_1299<? extends class_1309>)class_1299.field_6091);
        }
        if (breaks >= 5000L) {
            pool.add((class_1299<? extends class_1309>)class_1299.field_6046);
        }
        if (breaks >= 8000L) {
            pool.add((class_1299<? extends class_1309>)class_1299.field_6091);
        }
        return pool;
    }

    private static int spawnWave(class_1937 world, class_2338 center, List<class_1299<? extends class_1309>> pool, int count, int radius, int maxTriesPerMob, Scale scale) {
        class_5819 rand = world.method_8409();
        int spawned = 0;
        for (int i = 0; i < count; ++i) {
            class_1309 entity;
            class_1299<? extends class_1309> type = MobSpawn.randomFrom(pool, rand);
            class_2338 spawnPos = MobSpawn.pickNearbySurface(world, center, radius, maxTriesPerMob);
            if (spawnPos == null) {
                spawnPos = center;
            }
            if ((entity = (class_1309)type.method_5883(world, class_3730.field_16471)) == null) continue;
            if (entity instanceof class_1308) {
                class_1308 mob = (class_1308)entity;
                MobSpawn.maybeMakeElite(world, mob, scale, rand);
            }
            entity.method_5725(spawnPos, rand.method_43057() * 360.0f, 0.0f);
            if (!world.method_8649((class_1297)entity)) continue;
            ++spawned;
        }
        return spawned;
    }

    private static void maybeMakeElite(class_1937 world, class_1308 mob, Scale sc, class_5819 rnd) {
        if (rnd.method_43058() >= sc.eliteChance) {
            return;
        }
        switch (sc.eliteTier) {
            case 1: {
                mob.method_5673(class_1304.field_6169, new class_1799((class_1935)class_1802.field_8267));
                mob.method_5673(class_1304.field_6173, new class_1799((class_1935)class_1802.field_8528));
                mob.method_6092(new class_1293(class_1294.field_5904, 1200, 0));
                break;
            }
            case 2: {
                mob.method_5673(class_1304.field_6169, new class_1799((class_1935)class_1802.field_8743));
                class_1799 sword = new class_1799((class_1935)class_1802.field_8371);
                class_6880<class_1887> sharp = MobSpawn.getEnchEntry(world, (class_5321<class_1887>)class_1893.field_9118);
                sword.method_7978(sharp, 2);
                mob.method_5673(class_1304.field_6173, sword);
                mob.method_6092(new class_1293(class_1294.field_5904, 1800, 0));
                mob.method_6092(new class_1293(class_1294.field_5910, 1200, 0));
                break;
            }
            case 3: {
                mob.method_5673(class_1304.field_6169, new class_1799((class_1935)class_1802.field_8805));
                class_1799 sword = new class_1799((class_1935)class_1802.field_8802);
                class_6880<class_1887> sharp = MobSpawn.getEnchEntry(world, (class_5321<class_1887>)class_1893.field_9118);
                sword.method_7978(sharp, 3);
                mob.method_5673(class_1304.field_6173, sword);
                mob.method_6092(new class_1293(class_1294.field_5904, 2400, 1));
                mob.method_6092(new class_1293(class_1294.field_5910, 1800, 1));
                mob.method_6092(new class_1293(class_1294.field_5907, 1200, 0));
                break;
            }
        }
    }

    private static class_2338 pickNearbySurface(class_1937 world, class_2338 center, int radius, int tries) {
        class_5819 rand = world.method_8409();
        for (int t = 0; t < tries; ++t) {
            int dz;
            int dx = rand.method_39332(-radius, radius);
            if (dx * dx + (dz = rand.method_39332(-radius, radius)) * dz > radius * radius) continue;
            class_2338 pos = center.method_10069(dx, 0, dz);
            if (world.method_22347(pos)) {
                return pos;
            }
            if (!world.method_22347(pos.method_10084())) continue;
            return pos.method_10084();
        }
        return center;
    }

    private static <T> T randomFrom(List<T> list, class_5819 rnd) {
        return list.get(rnd.method_43048(list.size()));
    }

    private static long getBreakCount(StateSaverAndLoader state) {
        return state.totalOneBlockBreaks;
    }

    private static void announceToAll(class_1937 world, class_2561 message) {
        if (world.method_8503() == null) {
            return;
        }
        for (class_3222 player : world.method_8503().method_3760().method_14571()) {
            player.method_7353(message, false);
        }
    }

    private static class_6880<class_1887> getEnchEntry(class_1937 world, class_5321<class_1887> key) {
        return world.method_30349().method_30530(class_7924.field_41265).method_46747(key);
    }

    private static final class Scale {
        final int countBonus;
        final double eliteChance;
        final int eliteTier;
        final int cooldownAdjust;

        Scale(int countBonus, double eliteChance, int eliteTier, int cooldownAdjust) {
            this.countBonus = countBonus;
            this.eliteChance = eliteChance;
            this.eliteTier = eliteTier;
            this.cooldownAdjust = cooldownAdjust;
        }
    }
}

