/*
 * Decompiled with CFR 0.152.
 */
package lynk.oneblock.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1937;
import net.minecraft.class_1966;
import net.minecraft.class_1972;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2826;
import net.minecraft.class_2902;
import net.minecraft.class_3233;
import net.minecraft.class_3485;
import net.minecraft.class_4208;
import net.minecraft.class_4543;
import net.minecraft.class_4966;
import net.minecraft.class_5138;
import net.minecraft.class_5217;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_5539;
import net.minecraft.class_5742;
import net.minecraft.class_6544;
import net.minecraft.class_6748;
import net.minecraft.class_6880;
import net.minecraft.class_6908;
import net.minecraft.class_7138;
import net.minecraft.class_7869;

public class OneBlockChunkGenerator
extends class_2794 {
    public static final MapCodec<OneBlockChunkGenerator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_1966.field_24713.fieldOf("biome_source").forGetter(gen -> gen.field_12761), (App)Codec.BOOL.optionalFieldOf("generate_structures", (Object)true).forGetter(gen -> gen.generateStructures), (App)Codec.BOOL.optionalFieldOf("generate_island", (Object)true).forGetter(gen -> gen.generateIsland)).apply((Applicative)instance, OneBlockChunkGenerator::new));
    private final boolean generateStructures;
    private final boolean generateIsland;
    private volatile boolean startComputed = false;
    private static volatile int startX = 0;
    private static volatile int startZ = 0;
    private final Map<class_5321<class_1937>, Boolean> placedPerDim = new HashMap<class_5321<class_1937>, Boolean>();
    private final Map<class_5321<class_1937>, Boolean> spawnSetPerDim = new HashMap<class_5321<class_1937>, Boolean>();
    private static final int ISLAND_BOTTOM_Y = 62;
    private static final int ISLAND_TOP_Y = 63;
    private static final int ONEBLOCK_Y = 64;
    private static final int ISLAND_RADIUS = 5;

    public OneBlockChunkGenerator(class_1966 biomeSource, boolean generateStructures, boolean generateIsland) {
        super(biomeSource);
        this.generateStructures = generateStructures;
        this.generateIsland = generateIsland;
    }

    protected MapCodec<? extends class_2794> method_28506() {
        return CODEC;
    }

    public CompletableFuture<class_2791> method_12088(class_6748 blender, class_7138 noiseConfig, class_5138 structureAccessor, class_2791 chunk) {
        this.computeStartIfNeeded(noiseConfig.method_42371());
        return CompletableFuture.completedFuture(chunk);
    }

    public void method_16129(class_5455 registries, class_7869 placementCalc, class_5138 structureAccessor, class_2791 chunk, class_3485 templateManager, class_5321<class_1937> dimension) {
        if (!this.generateStructures) {
            return;
        }
        super.method_16129(registries, placementCalc, structureAccessor, chunk, templateManager, dimension);
    }

    public void method_16130(class_5281 world, class_5138 structureAccessor, class_2791 chunk) {
        if (!this.generateStructures) {
            return;
        }
        super.method_16130(world, structureAccessor, chunk);
    }

    public void method_12102(class_5281 world, class_2791 chunk, class_5138 structureAccessor) {
        class_5321 dim = world.method_8410().method_27983();
        if (this.generateIsland) {
            this.generateIslandInChunk(chunk, (class_5321<class_1937>)dim);
        }
        if (!Boolean.TRUE.equals(this.placedPerDim.get(dim))) {
            int targetChunkX = startX >> 4;
            int targetChunkZ = startZ >> 4;
            if (chunk.method_12004().field_9181 == targetChunkX && chunk.method_12004().field_9180 == targetChunkZ) {
                class_2338 pos = new class_2338(startX, 64, startZ);
                OneBlockChunkGenerator.setBlockStateInChunk(chunk, pos, OneBlockChunkGenerator.chooseOneBlockForDimension((class_5321<class_1937>)dim));
                this.placedPerDim.put((class_5321<class_1937>)dim, true);
                if (!Boolean.TRUE.equals(this.spawnSetPerDim.get(dim))) {
                    class_4208 globalPos = new class_4208(class_1937.field_25179, new class_2338(0, 65, 0));
                    world.method_8410().method_27873(new class_5217.class_12064(globalPos, 0.5f, 0.5f));
                    this.spawnSetPerDim.put((class_5321<class_1937>)dim, true);
                }
            }
        }
        if (!this.generateStructures) {
            return;
        }
        super.method_12102(world, chunk, structureAccessor);
    }

    private void generateIslandInChunk(class_2791 chunk, class_5321<class_1937> dim) {
        int chunkMinX = chunk.method_12004().method_8326();
        int chunkMinZ = chunk.method_12004().method_8328();
        int chunkMaxX = chunkMinX + 15;
        int chunkMaxZ = chunkMinZ + 15;
        int minX = Math.max(startX - 5, chunkMinX);
        int maxX = Math.min(startX + 5, chunkMaxX);
        int minZ = Math.max(startZ - 5, chunkMinZ);
        int maxZ = Math.min(startZ + 5, chunkMaxZ);
        if (minX > maxX || minZ > maxZ) {
            return;
        }
        IslandPalette palette = OneBlockChunkGenerator.getIslandPalette(dim);
        int r = 5;
        int r2 = r * r;
        for (int x = minX; x <= maxX; ++x) {
            int dx = x - startX;
            for (int z = minZ; z <= maxZ; ++z) {
                int dz = z - startZ;
                int dist2 = dx * dx + dz * dz;
                if (dist2 > r2) continue;
                OneBlockChunkGenerator.setBlockStateInChunk(chunk, new class_2338(x, 62, z), palette.under);
                OneBlockChunkGenerator.setBlockStateInChunk(chunk, new class_2338(x, 63, z), palette.top);
            }
        }
    }

    private static IslandPalette getIslandPalette(class_5321<class_1937> dim) {
        if (dim == class_1937.field_25180) {
            class_2680 n = class_2246.field_10515.method_9564();
            return new IslandPalette(n, n);
        }
        if (dim == class_1937.field_25181) {
            class_2680 e = class_2246.field_10471.method_9564();
            return new IslandPalette(e, e);
        }
        return new IslandPalette(class_2246.field_10219.method_9564(), class_2246.field_10566.method_9564());
    }

    private static class_2680 chooseOneBlockForDimension(class_5321<class_1937> dim) {
        if (dim == class_1937.field_25180) {
            return class_2246.field_10515.method_9564();
        }
        if (dim == class_1937.field_25181) {
            return class_2246.field_10471.method_9564();
        }
        return class_2246.field_10219.method_9564();
    }

    private static void setBlockStateInChunk(class_2791 chunk, class_2338 pos, class_2680 state) {
        int y = pos.method_10264();
        int sectionY = chunk.method_31602(y);
        if (sectionY < 0 || sectionY >= chunk.method_12006().length) {
            return;
        }
        class_2826 section = chunk.method_38259(sectionY);
        int lx = pos.method_10263() & 0xF;
        int ly = y & 0xF;
        int lz = pos.method_10260() & 0xF;
        section.method_12256(lx, ly, lz, state, false);
    }

    public void method_12108(class_3233 region, long seed, class_7138 noiseConfig, class_4543 biomeAccess, class_5138 structureAccessor, class_2791 chunk) {
    }

    public void method_12110(class_3233 region, class_5138 structures, class_7138 noiseConfig, class_2791 chunk) {
    }

    public void method_12107(class_3233 region) {
    }

    public int method_12104() {
        return 384;
    }

    public int method_16398() {
        return 63;
    }

    public int method_33730() {
        return -64;
    }

    public int method_16397(int x, int z, class_2902.class_2903 type, class_5539 world, class_7138 noiseConfig) {
        return 64;
    }

    public class_4966 method_26261(int x, int z, class_5539 world, class_7138 noiseConfig) {
        int minY = this.method_33730();
        int height = this.method_12104();
        class_2680[] states = new class_2680[height];
        for (int i = 0; i < height; ++i) {
            states[i] = class_2246.field_10124.method_9564();
        }
        return new class_4966(minY, states);
    }

    public void method_40450(List<String> text, class_7138 noiseConfig, class_2338 pos) {
        text.add("OneBlock Generator");
        text.add("Structures: " + (this.generateStructures ? "ON" : "OFF"));
        text.add("Island: " + (this.generateIsland ? "ON" : "OFF"));
        if (this.startComputed) {
            text.add("OneBlock target: (" + startX + ", 64, " + startZ + ")");
        }
    }

    private void computeStartIfNeeded(class_6544.class_6552 sampler) {
        if (this.startComputed) {
            return;
        }
        int maxRadius = 2048;
        int step = 32;
        if (!this.isGood(0, 0, sampler) && !this.findNearbyGood(2048, 32, sampler)) {
            startX = 0;
            startZ = 0;
        }
        this.startComputed = true;
    }

    private boolean findNearbyGood(int maxRadius, int step, class_6544.class_6552 sampler) {
        for (int r = step; r <= maxRadius; r += step) {
            for (int dx = -r; dx <= r; dx += step) {
                if (this.isGood(dx, r, sampler)) {
                    return true;
                }
                if (!this.isGood(dx, -r, sampler)) continue;
                return true;
            }
            for (int dz = -r + step; dz <= r - step; dz += step) {
                if (this.isGood(r, dz, sampler)) {
                    return true;
                }
                if (!this.isGood(-r, dz, sampler)) continue;
                return true;
            }
        }
        return false;
    }

    private static int toQuart(int blockCoord) {
        return class_5742.method_33100((int)blockCoord);
    }

    private boolean isGood(int x, int z, class_6544.class_6552 sampler) {
        int qz;
        int qy;
        int qx = OneBlockChunkGenerator.toQuart(x);
        class_6880 entry = this.field_12761.method_38109(qx, qy = OneBlockChunkGenerator.toQuart(64), qz = OneBlockChunkGenerator.toQuart(z), sampler);
        if (entry.method_40225(class_1972.field_9438)) {
            return false;
        }
        if (entry.method_40220(class_6908.field_36509)) {
            return false;
        }
        startX = x;
        startZ = z;
        return true;
    }

    public static class_2338 getSpawnBlockPos() {
        return new class_2338(startX, 64, startZ);
    }

    public static class_2338 getPlayerSpawnPos() {
        return OneBlockChunkGenerator.getSpawnBlockPos().method_10084();
    }

    private static class IslandPalette {
        final class_2680 top;
        final class_2680 under;

        IslandPalette(class_2680 top, class_2680 under) {
            this.top = top;
            this.under = under;
        }
    }
}

