/*
 * Decompiled with CFR 0.152.
 */
package lynk.oneblock.server;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Random;
import lynk.oneblock.utils.Server;
import net.minecraft.class_1297;
import net.minecraft.class_1542;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2247;
import net.minecraft.class_2248;
import net.minecraft.class_2257;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_7157;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;

public class GameObject {
    public static int breaks = 0;
    public static int breaksThisLevel = 0;
    public static int currentLevel = 1;
    public static int levelMultiplier = 2;
    public static int OneBlockPosX = 0;
    public static int OneBlockPosY = 100;
    public static int OneBlockPosZ = 0;
    public static int breaksPerLevel;
    public static int breaksNeededThisLevel;
    public static int percentageRareDrop;
    public static boolean rareDropInChest;
    public static int breaksPerChanceOnRareDrop;
    public static String[][] levels;
    public static String[] levelNames;
    public static String[][] rareDrops;
    public static String configFileLocation;
    public static String configFileName;
    public static boolean randomBlockMode;
    public static boolean randomRareDropMode;
    public static boolean allowBlocksJustAboveOneBlock;

    public static void saveToJson() {
        Gson gson = new Gson();
        File directory = new File(configFileLocation);
        if (!directory.exists()) {
            boolean dirCreated = directory.mkdirs();
            if (dirCreated) {
                System.out.println("oneblock: Config directory created successfully");
            } else {
                System.out.println("oneblock: Failed to create config directory");
                return;
            }
        }
        gson = new Gson();
        GameObjectState state = new GameObjectState();
        String json = gson.toJson((Object)state);
        File file = new File(configFileLocation + configFileName);
        try {
            if (file.createNewFile()) {
                System.out.println("oneblock: File created: " + file.getName());
            } else {
                System.out.println("MOD_SAYS + File already exists.");
            }
            FileWriter writer = new FileWriter(file);
            writer.write(json);
            writer.close();
            System.out.println("Successfully wrote to the file.");
        }
        catch (IOException e) {
            System.out.println("oneblock: An error occurred.");
            e.printStackTrace();
        }
    }

    public static void loadFromJson() {
        String filePath = configFileLocation + configFileName;
        if (!Files.exists(Paths.get(filePath, new String[0]), new LinkOption[0])) {
            System.err.println("File not found: " + filePath);
            return;
        }
        try (FileReader reader = new FileReader(filePath);){
            Gson gson = new Gson();
            JsonObject jsonObject = JsonParser.parseReader((Reader)reader).getAsJsonObject();
            if (jsonObject.has("breaks")) {
                breaks = (Integer)gson.fromJson(jsonObject.get("breaks"), Integer.TYPE);
            }
            if (jsonObject.has("breaksThisLevel")) {
                breaksThisLevel = (Integer)gson.fromJson(jsonObject.get("breaksThisLevel"), Integer.TYPE);
            }
            if (jsonObject.has("currentLevel")) {
                currentLevel = (Integer)gson.fromJson(jsonObject.get("currentLevel"), Integer.TYPE);
            }
            if (jsonObject.has("levelMultiplier")) {
                levelMultiplier = (Integer)gson.fromJson(jsonObject.get("levelMultiplier"), Integer.TYPE);
            }
            if (jsonObject.has("OneBlockPosX")) {
                OneBlockPosX = (Integer)gson.fromJson(jsonObject.get("OneBlockPosX"), Integer.TYPE);
            }
            if (jsonObject.has("OneBlockPosY")) {
                OneBlockPosY = (Integer)gson.fromJson(jsonObject.get("OneBlockPosY"), Integer.TYPE);
            }
            if (jsonObject.has("OneBlockPosZ")) {
                OneBlockPosZ = (Integer)gson.fromJson(jsonObject.get("OneBlockPosZ"), Integer.TYPE);
            }
            if (jsonObject.has("breaksPerLevel")) {
                breaksPerLevel = (Integer)gson.fromJson(jsonObject.get("breaksPerLevel"), Integer.TYPE);
                breaksNeededThisLevel = (Integer)gson.fromJson(jsonObject.get("breaksPerLevel"), Integer.TYPE);
                for (int i = 1; i < currentLevel; ++i) {
                    breaksNeededThisLevel *= levelMultiplier;
                }
            }
            if (jsonObject.has("percentageRareDrop")) {
                percentageRareDrop = (Integer)gson.fromJson(jsonObject.get("percentageRareDrop"), Integer.TYPE);
            }
            if (jsonObject.has("rareDropInChest")) {
                rareDropInChest = (Boolean)gson.fromJson(jsonObject.get("rareDropInChest"), Boolean.TYPE);
            }
            if (jsonObject.has("breaksPerChanceOnRareDrop")) {
                breaksPerChanceOnRareDrop = (Integer)gson.fromJson(jsonObject.get("breaksPerChanceOnRareDrop"), Integer.TYPE);
            }
            if (jsonObject.has("levels")) {
                levels = (String[][])gson.fromJson(jsonObject.get("levels"), String[][].class);
            }
            if (jsonObject.has("rareDrops")) {
                rareDrops = (String[][])gson.fromJson(jsonObject.get("rareDrops"), String[][].class);
            }
            if (jsonObject.has("randomBlockMode")) {
                randomBlockMode = (Boolean)gson.fromJson(jsonObject.get("randomBlockMode"), Boolean.TYPE);
            }
            if (jsonObject.has("randomRareDropMode")) {
                randomRareDropMode = (Boolean)gson.fromJson(jsonObject.get("randomRareDropMode"), Boolean.TYPE);
            }
            if (jsonObject.has("allowBlocksJustAboveOneBlock")) {
                allowBlocksJustAboveOneBlock = (Boolean)gson.fromJson(jsonObject.get("allowBlocksJustAboveOneBlock"), Boolean.TYPE);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static class_2338 getOneBlockPos() {
        return new class_2338(OneBlockPosX, OneBlockPosY, OneBlockPosZ);
    }

    public static void incrementOneBlockBroken() {
        ++breaks;
        ++breaksThisLevel;
    }

    public static void determineLevel(MinecraftServer server) {
        if (breaksThisLevel == breaksNeededThisLevel && currentLevel < levels.length) {
            breaksThisLevel = 0;
            breaksNeededThisLevel *= levelMultiplier;
            String message = "oneblock: OneBlock leveled up! Now level: " + ++currentLevel;
            server.method_3760().method_43514(class_2561.method_30163((String)message), false);
            if (levelNames[currentLevel - 1] != null) {
                message = "oneblock: Level theme: " + levelNames[currentLevel - 1];
                server.method_3760().method_43514(class_2561.method_30163((String)message), false);
            }
        }
    }

    public static class_1799 selectRare(class_1937 world) {
        class_1799 stack = new class_1799((class_1935)class_1802.field_8831);
        if (randomRareDropMode) {
            Random random = new Random();
            int randomIndex = random.nextInt(class_7923.field_41178.method_10204());
            class_1792 randomItem = (class_1792)class_7923.field_41178.method_10200(randomIndex);
            stack = new class_1799((class_1935)randomItem);
        } else {
            Integer randomRare;
            int maxRareLevel;
            boolean itemFound = false;
            MinecraftServer server = world.method_8503();
            int randomLevel = Server.randomInt(currentLevel);
            if (randomLevel < (maxRareLevel = rareDrops.length)) {
                randomRare = Server.randomInt(rareDrops[randomLevel].length);
            } else {
                randomLevel = Server.randomInt(maxRareLevel);
                randomRare = Server.randomInt(rareDrops[maxRareLevel - 1].length);
            }
            String wanted = rareDrops[randomLevel][randomRare].toUpperCase();
            for (class_1792 item : class_7923.field_41178) {
                if (!item.method_7848().getString().toUpperCase().equals(wanted)) continue;
                stack = new class_1799((class_1935)item);
                itemFound = true;
                break;
            }
            if (!itemFound) {
                String message = "oneblock: Could not find item: " + rareDrops[randomLevel][randomRare];
                assert (server != null);
                server.method_3760().method_43514(class_2561.method_30163((String)message), false);
            }
        }
        return stack;
    }

    public static void spawnChestWithRare(class_1937 world) {
        world.method_8652(GameObject.getOneBlockPos(), class_2246.field_10034.method_9564(), 3);
        class_2586 class_25862 = world.method_8321(GameObject.getOneBlockPos());
        if (class_25862 instanceof class_2595) {
            class_2595 chestBlockEntity = (class_2595)class_25862;
            chestBlockEntity.method_5447(0, GameObject.selectRare(world));
            world.method_8413(GameObject.getOneBlockPos(), class_2246.field_10034.method_9564(), class_2246.field_10034.method_9564(), 3);
        }
    }

    public static void spawnRareItem(class_1937 world) {
        world.method_8649((class_1297)new class_1542(world, (double)GameObject.getOneBlockPos().method_10263(), (double)(GameObject.getOneBlockPos().method_10264() + 1), (double)GameObject.getOneBlockPos().method_10260(), GameObject.selectRare(world)));
    }

    private static boolean placeParsedBlock(class_1937 world, class_2338 pos, String blockString) {
        try {
            class_2586 be;
            Parsed parsed = GameObject.parseBlockString((class_3218)world, blockString);
            boolean ok = world.method_8652(pos, parsed.state, 3);
            if (ok && parsed.nbt != null && (be = world.method_8321(pos)) != null) {
                class_2487 current = be.method_38242();
                current.method_10543(parsed.nbt);
                be.method_11014(current);
                be.method_5431();
                world.method_8413(pos, world.method_8320(pos), world.method_8320(pos), 3);
            }
            return ok;
        }
        catch (CommandSyntaxException | IllegalArgumentException e) {
            MinecraftServer server = world.method_8503();
            if (server != null) {
                server.method_3760().method_43514(class_2561.method_30163((String)("oneblock:  Parse error for block '" + blockString + "': " + e.getMessage())), false);
            }
            return false;
        }
    }

    private static Parsed parseBlockString(class_3218 world, String input) throws CommandSyntaxException {
        if (GameObject.looksLikeBareId(input)) {
            class_2960 id = class_2960.method_12829((String)input);
            if (id == null) {
                throw new IllegalArgumentException("Invalid identifier: " + input);
            }
            class_2248 block = (class_2248)class_7923.field_41175.method_17966(id).orElseThrow(() -> new IllegalArgumentException("Unknown block id: " + String.valueOf(id)));
            return new Parsed(block.method_9564(), null);
        }
        class_2257 type = class_2257.method_9653((class_7157)((class_7157)world.method_30349()));
        class_2247 arg = type.method_9654(new StringReader(input));
        class_2680 state = arg.method_9494();
        return new Parsed(state, null);
    }

    private static boolean looksLikeBareId(String s) {
        return s.indexOf(91) < 0 && s.indexOf(123) < 0 && s.indexOf(32) < 0 && s.contains(":");
    }

    public static void respawnOneBlock(class_1937 world) {
        class_3218 sWorld;
        MinecraftServer server = world.method_8503();
        class_3218 class_32182 = sWorld = world instanceof class_3218 ? (class_3218)world : server.method_30002();
        if (randomBlockMode) {
            Random rnd = new Random();
            int size = class_7923.field_41175.method_10204();
            int tries = Math.min(512, size);
            class_2248 candidate = null;
            for (int i = 0; i < tries; ++i) {
                class_2248 b = (class_2248)class_7923.field_41175.method_10200(rnd.nextInt(size));
                if (!Server.isBlockBreakable(b) || !Server.isStandardCube(b.method_9564(), (class_1922)sWorld, GameObject.getOneBlockPos())) continue;
                candidate = b;
                break;
            }
            if (candidate == null) {
                candidate = class_2246.field_10340;
            }
            sWorld.method_8652(GameObject.getOneBlockPos(), candidate.method_9564(), 3);
            return;
        }
        int randomLevel = Server.randomInt(currentLevel);
        int randomBlock = Server.randomInt(levels[randomLevel].length);
        String selectedBlock = levels[randomLevel][randomBlock];
        boolean blockPlaced = false;
        if (selectedBlock.contains(":") || selectedBlock.contains("[") || selectedBlock.contains("{")) {
            blockPlaced = GameObject.placeParsedBlock((class_1937)sWorld, GameObject.getOneBlockPos(), selectedBlock);
        }
        if (!(blockPlaced || selectedBlock.contains(":") || selectedBlock.contains("[") || selectedBlock.contains("{"))) {
            String wanted = selectedBlock.toUpperCase();
            for (class_2248 b : class_7923.field_41175) {
                if (!b.method_9518().getString().toUpperCase().equals(wanted)) continue;
                sWorld.method_8652(GameObject.getOneBlockPos(), b.method_9564(), 3);
                blockPlaced = true;
                break;
            }
        }
        if (!blockPlaced) {
            sWorld.method_8652(GameObject.getOneBlockPos(), class_2246.field_10219.method_9564(), 3);
            String message = "oneblock: Could not find/place block entry: " + selectedBlock + " (level " + (randomLevel + 1) + ")";
            server.method_3760().method_43514(class_2561.method_30163((String)message), false);
        }
    }

    public static int calculateRemainingBreaks() {
        return breaksNeededThisLevel - breaksThisLevel;
    }

    static {
        breaksNeededThisLevel = breaksPerLevel = 100;
        percentageRareDrop = 50;
        rareDropInChest = false;
        breaksPerChanceOnRareDrop = 50;
        levels = new String[][]{{"DIRT", "GRASS BLOCK", "PODZOL", "MYCELIUM"}, {"OAK LOG", "BIRCH LOG", "SPRUCE LOG", "JUNGLE LOG", "ACACIA LOG", "DARK OAK LOG"}, {"STONE", "COBBLESTONE", "ANDESITE", "GRANITE", "DIORITE", "MOSSY COBBLESTONE", "COAL ORE"}, {"FARMLAND", "CLAY", "SUGAR CANE", "PUMPKIN", "MELON"}, {"NETHERRACK", "GLOWSTONE", "NETHER QUARTZ ORE", "MAGMA BLOCK", "SOUL SOIL", "BASALT"}, {"OAK LEAVES", "BIRCH LEAVES", "JUNGLE LEAVES", "ACACIA LEAVES", "DARK OAK LEAVES", "CRIMSON STEM", "WARPED STEM"}, {"COAL ORE", "IRON ORE", "GOLD ORE", "LAPIS LAZULI ORE", "DIAMOND ORE", "EMERALD ORE", "REDSTONE ORE"}, {"SANDSTONE", "CHISELED SANDSTONE", "CUT SANDSTONE", "PRISMARINE", "SEA LANTERN", "TERRACOTTA", "GLASS"}, {"END STONE", "PURPUR BLOCK", "END STONE BRICKS", "CHORUS PLANT", "PURPUR PILLAR"}, {"BLACKSTONE", "CRIMSON NYLIUM", "WARPED NYLIUM", "GILDED BLACKSTONE", "NETHER BRICKS", "SHROOMLIGHT"}, {"CORAL BLOCK", "CORAL", "CORAL FAN", "SPONGE", "WET SPONGE"}, {"ICE", "SNOW", "PACKED ICE", "BLUE ICE", "SNOW BLOCK"}, {"DEEPSLATE", "COBBLED DEEPSLATE", "POLISHED DEEPSLATE", "DEEPSLATE COAL ORE", "DEEPSLATE IRON ORE", "DEEPSLATE COPPER ORE"}, {"BRICKS", "STONE BRICKS", "CRACKED STONE BRICKS", "MOSSY STONE BRICKS", "CHISELED STONE BRICKS", "SMOOTH STONE"}, {"BAMBOO", "SUGAR CANE", "VINE", "LILY PAD", "DANDELION", "POPPY", "BLUE ORCHID"}, {"TUFF", "CALCITE", "AMETHYST BLOCK", "COPPER ORE", "RAW COPPER BLOCK", "RAW IRON BLOCK"}, {"GRASS", "FERN", "DEAD BUSH", "SEA GRASS", "AZALEA", "FLOWERING AZALEA"}, {"POLISHED GRANITE", "POLISHED DIORITE", "POLISHED ANDESITE", "POLISHED BASALT", "CHISELED QUARTZ BLOCK", "QUARTZ BRICKS"}, {"PRISMARINE BRICKS", "DARK PRISMARINE", "TUBE CORAL BLOCK", "BRAIN CORAL BLOCK", "BUBBLE CORAL BLOCK", "FIRE CORAL BLOCK"}, {"CRYING OBSIDIAN", "END ROD", "OBSIDIAN", "RESPAWN ANCHOR"}, {"MOSS BLOCK", "GLOW BERRIES", "BIG DRIPLEAF", "CLAY", "HANGING ROOTS", "MOSS CARPET"}, {"SCULK SENSOR", "SCULK", "SCULK VEIN", "SCULK CATALYST", "SCULK SHRIEKER", "DEEPSLATE GOLD ORE", "DEEPSLATE REDSTONE ORE"}, {"STONE", "GRAVEL", "IRON ORE", "COAL ORE", "COPPER ORE", "GLOW LICHEN"}, {"TUFF", "CALCITE", "DEEPSLATE DIAMOND ORE", "DEEPSLATE EMERALD ORE", "DEEPSLATE LAPIS LAZULI ORE", "DEEPSLATE REDSTONE ORE"}, {"DEEPSLATE COPPER ORE", "POINTED DRIPSTONE", "DRIPSTONE BLOCK", "AMETHYST BUD", "AMETHYST CLUSTER", "BUDDING AMETHYST"}, {"MOSSY COBBLESTONE", "MOSSY STONE BRICKS", "MUD", "HONEYCOMB BLOCK", "NETHER WART BLOCK", "WARPED WART BLOCK"}, {"SOUL SAND", "BASALT", "WEEPING VINES", "TWISTING VINES", "CRIMSON FUNGUS", "WARPED FUNGUS"}, {"JUNGLE LOG", "VINE", "LILY PAD", "MELON", "COCOA BEANS", "LARGE FERN", "BAMBOO"}, {"SPRUCE LOG", "SNOW BLOCK", "ICE", "PACKED ICE", "BLUE ICE"}, {"GLOWSTONE", "JACK O'LANTERN", "LANTERN", "TORCH", "SEA LANTERN", "END ROD", "SHROOMLIGHT"}};
        levelNames = new String[]{"Basic Natural Blocks", "Basic Wood Types", "Stone Variants", "Farming Soil and Plants", "Nether Basics", "Leaves and More Wood Variants", "Ores and Minerals", "Decorative Blocks", "End Blocks", "Advanced Nether Blocks", "Ocean and Coral", "Ice and Snow", "Deepslate Variants", "Building Blocks", "Exotic Wood and Plants", "Rare Earths and Stones", "A Touch of Green", "Varied Stone Types", "Underwater Blocks", "End Game Blocks", "Lush Caves", "Deep Dark Biome", "Mountain Peaks", "Underground Blocks", "Deepslate Ores and Cave Formations", "Lush Underground and Rare Decoratives", "Nether Expansion 2", "Jungle and Swamp", "Taiga and Snowy Biomes", "Overworld Nighttime"};
        rareDrops = new String[][]{{"STRING", "BONE", "ARROW", "ROTTEN FLESH", "FEATHER", "LEATHER", "EGG", "SOUL SAND", "SAND"}, {"WHEAT", "SEEDS", "APPLE", "CARROT", "POTATO", "SUGAR CANE", "PUMPKIN SEEDS", "MELON SEEDS"}, {"FLINT", "COAL", "IRON NUGGET", "GOLD NUGGET", "REDSTONE", "LAPIS LAZULI"}, {"NETHER QUARTZ", "GLOWSTONE DUST", "BLAZE ROD", "NETHER WART", "GHAST TEAR", "MAGMA CREAM"}, {"RAW FISH", "RAW SALMON", "PUFFERFISH", "TROPICAL FISH", "PRISMARINE CRYSTALS", "PRISMARINE SHARD"}, {"ENDER PEARL", "SLIME BALL", "SPIDER EYE", "GUNPOWDER", "PHANTOM MEMBRANE", "SHULKER SHELL"}, {"DIAMOND", "EMERALD", "GOLD ORE", "IRON ORE", "COPPER ORE"}, {"END CRYSTAL", "ENDER PEARL", "DRAGON'S BREATH", "ELYTRA", "SHULKER SHELL"}, {"BAMBOO", "COCOA BEANS", "CHORUS FRUIT", "PODZOL", "MYCELIUM", "BLUE ICE"}, {"HONEYCOMB", "NETHERITE SCRAP", "ANCIENT DEBRIS", "AMETHYST SHARD", "GLOW BERRIES"}, {"SPIDER EYE", "ENDER PEARL", "BONE", "STRING", "GUNPOWDER", "ROTTEN FLESH", "KELP", "SEA GRASS", "SEA PICKLE"}, {"CARROT", "POTATO", "BEETROOT", "WHEAT", "MELON SLICE", "PUMPKIN"}, {"OAK SAPLING", "BIRCH SAPLING", "SPRUCE SAPLING", "JUNGLE SAPLING", "ACACIA SAPLING", "DARK OAK SAPLING"}, {"CACTUS", "DEAD BUSH", "RABBIT HIDE", "RABBIT FOOT", "PRISMARINE SHARD", "PRISMARINE CRYSTALS"}, {"SNOWBALL", "ICE", "PACKED ICE", "BLUE ICE"}, {"EMERALD", "DIAMOND", "GOLD ORE", "IRON ORE", "COAL", "REDSTONE"}, {"ENCHANTED BOOK", "GOLDEN APPLE", "ENCHANTED GOLDEN APPLE", "EXPERIENCE BOTTLE"}, {"SEA LANTERN", "SPONGE", "WET SPONGE", "HEART OF THE SEA", "NAUTILUS SHELL", "TROPICAL FISH"}, {"NETHER WART", "BLAZE ROD", "WITHER SKELETON SKULL", "NETHER BRICK", "MAGMA CREAM", "GOLDEN SWORD"}, {"SHULKER SHELL", "ELYTRA", "DRAGON HEAD", "END STONE", "PURPUR BLOCK", "END ROD"}, {"LILY OF THE VALLEY", "SUNFLOWER", "LILAC", "ROSE BUSH", "PEONY", "BLUE ORCHID"}, {"GLOWSTONE DUST", "QUARTZ", "NETHERITE INGOT", "BLACKSTONE", "GILDED BLACKSTONE", "CRYING OBSIDIAN"}, {"BAMBOO", "COCOA BEANS", "MELON SEEDS"}, {"SWEET BERRIES", "SPRUCE SAPLING", "RABBIT STEW"}, {"EMERALD ORE", "GOAT HORN", "IRON PICKAXE"}, {"GOLDEN APPLE", "DIAMOND HORSE ARMOR", "GOLD INGOT", "IRON INGOT", "BONE MEAL", "SADDLE"}, {"PRISMARINE CRYSTALS", "PRISMARINE SHARD", "SPONGE", "SEA LANTERN", "WET SPONGE", "GOLD BLOCK"}, {"MUSHROOM", "RED MUSHROOM BLOCK", "BROWN MUSHROOM BLOCK", "MUSHROOM STEW", "MYCELIUM"}, {"EMERALD", "BOOKSHELF", "CLOCK", "COMPASS", "MAP", "WRITTEN BOOK"}, {"GOLDEN APPLE", "TREASURE MAP", "HEART OF THE SEA", "CONDUIT"}};
        configFileLocation = "config/OneBlock/";
        configFileName = "OneBlock.json";
        randomBlockMode = false;
        randomRareDropMode = false;
        allowBlocksJustAboveOneBlock = false;
    }

    private static class GameObjectState {
        int breaks = breaks;
        int breaksThislevel = breaksThisLevel;
        int currentLevel = currentLevel;
        int levelMultiplier = levelMultiplier;
        int oneBlockPosX = OneBlockPosX;
        int oneBlockPosY = OneBlockPosY;
        int oneBlockPosZ = OneBlockPosZ;
        int breaksPerLevel = breaksPerLevel;
        int breaksNeededThisLevel;
        int percentageRareDrop = percentageRareDrop;
        boolean rareDropInChest = rareDropInChest;
        int breaksPerChanceOnRareDrop = breaksPerChanceOnRareDrop;
        String[][] levels = levels;
        String[] levelNames = levelNames;
        String[][] rareDrops = rareDrops;
        boolean randomBlockMode = randomBlockMode;
        boolean randomRareDropMode = randomRareDropMode;
        boolean allowBlocksJustAboveOneBlock = allowBlocksJustAboveOneBlock;

        GameObjectState() {
        }
    }

    private record Parsed(class_2680 state, class_2487 nbt) {
    }
}

