/*
 * Decompiled with CFR 0.152.
 */
package lynk.oneblock;

import java.util.EnumSet;
import java.util.Objects;
import lynk.oneblock.persit.StateSaverAndLoader;
import lynk.oneblock.server.Events;
import lynk.oneblock.server.OneBlockSafety;
import lynk.oneblock.server.ServerDebugTicker;
import lynk.oneblock.server.ServerReference;
import lynk.oneblock.util.Registers;
import lynk.oneblock.worldgen.OneBlockChunkGenerator;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2709;
import net.minecraft.class_3218;

public class OneBlock
implements ModInitializer {
    public static final String MOD_ID = "oneblock";

    public void onInitialize() {
        ServerReference.init();
        Registers.RegisterChunkGenerator();
        Registers.RegisterDataPacks();
        ServerDebugTicker.register();
        PlayerBlockBreakEvents.AFTER.register((world, player, pos, state, entity) -> {
            if (Objects.equals(pos, OneBlockChunkGenerator.getSpawnBlockPos())) {
                Events.handleOneBlockBreak(world);
            }
        });
        ServerTickEvents.END_WORLD_TICK.register(world -> {
            if (world.method_27983() != class_1937.field_25179) {
                return;
            }
            OneBlockSafety.tick(world);
            int PERIOD = 200;
            if (world.method_8510() % 200L == 0L) {
                world.method_17983().method_125();
            }
        });
        ServerPlayerEvents.AFTER_RESPAWN.register((oldPlayer, newPlayer, alive) -> {
            if (newPlayer.method_67564() == null) {
                class_3218 targetWorld = newPlayer.method_51469();
                class_2338 one = OneBlockChunkGenerator.getPlayerSpawnPos();
                newPlayer.method_48105(targetWorld, (double)one.method_10263(), (double)one.method_10264(), (double)one.method_10260(), EnumSet.noneOf(class_2709.class), 1.0f, 1.0f, true);
                newPlayer.method_33572(false);
                newPlayer.field_6017 = 0.0;
                newPlayer.method_7353((class_2561)class_2561.method_43470((String)"You respawned at the OneBlock."), false);
            }
        });
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            StateSaverAndLoader s = StateSaverAndLoader.getServerState(server);
            System.out.println("[OneBlock] Loaded breaks: " + s.totalOneBlockBreaks);
            System.out.println("[OneBlock] Loaded MobSpawn: " + s.MobSpawnSet);
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            StateSaverAndLoader s = StateSaverAndLoader.getServerState(server);
            System.out.println("[OneBlock] Saving breaks: " + s.totalOneBlockBreaks);
            System.out.println("[OneBlock] Saving MobSpawn: " + s.MobSpawnSet);
        });
    }
}

