/*
 * Decompiled with CFR 0.152.
 */
package lynk.oneblock.util;

import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import lynk.oneblock.persit.StateSaverAndLoader;
import lynk.oneblock.server.ServerReference;
import net.minecraft.class_1922;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2346;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2682;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;

public class RandomBlockUtil {
    private static List<class_2248> BASE_CANDIDATES;
    private static final int PROB_TRIES = 128;
    private static final int FALLBACK_SAMPLES = 64;
    private static final Map<class_2248, Float> HARDNESS_CACHE;

    public static class_2248 getAnyRandomBlock(class_5819 random) {
        return class_7923.field_41175.method_10240(random).map(entry -> (class_2248)entry.comp_349()).orElse(class_2246.field_10340);
    }

    public static class_2248 getRandomSolidBlock(class_5819 random) {
        class_2248 candidate;
        int tries;
        List<class_2248> base = RandomBlockUtil.getBaseCandidates();
        if (base.isEmpty()) {
            return class_2246.field_10340;
        }
        MinecraftServer server = ServerReference.get();
        long totalBreaks = 0L;
        if (server != null) {
            StateSaverAndLoader state = StateSaverAndLoader.getServerState(server);
            totalBreaks = state.totalOneBlockBreaks;
        }
        float progress = Math.min((float)totalBreaks / 10000.0f, 1.0f);
        float maxHardness = 0.5f + 49.5f * progress;
        for (tries = 0; tries < 128; ++tries) {
            candidate = base.get(random.method_43048(base.size()));
            if (!(RandomBlockUtil.safeHardness(candidate) <= maxHardness)) continue;
            return candidate;
        }
        for (tries = 0; tries < 128; ++tries) {
            candidate = base.get(random.method_43048(base.size()));
            float hardness = RandomBlockUtil.safeHardness(candidate);
            float chance = progress * (hardness / 50.0f);
            if (!(random.method_43057() < chance)) continue;
            return candidate;
        }
        class_2248 best = class_2246.field_10340;
        float bestH = Float.MAX_VALUE;
        for (int i = 0; i < 64; ++i) {
            class_2248 candidate2 = base.get(random.method_43048(base.size()));
            float h = RandomBlockUtil.safeHardness(candidate2);
            if (!(h < bestH)) continue;
            bestH = h;
            best = candidate2;
        }
        return best;
    }

    private static List<class_2248> getBaseCandidates() {
        if (BASE_CANDIDATES == null || BASE_CANDIDATES.isEmpty()) {
            BASE_CANDIDATES = class_7923.field_41175.method_10220().filter(RandomBlockUtil::isStaticGoodSolidBlock).toList();
        }
        return BASE_CANDIDATES;
    }

    private static boolean isStaticGoodSolidBlock(class_2248 block) {
        class_2680 s = block.method_9564();
        if (s.method_26215()) {
            return false;
        }
        if (!s.method_26227().method_15769()) {
            return false;
        }
        if (s.method_45474()) {
            return false;
        }
        if (block == class_2246.field_9987 || block == class_2246.field_10499 || block == class_2246.field_31037 || block == class_2246.field_10465 || block == class_2246.field_16540 || block == class_2246.field_10525 || block == class_2246.field_10263 || block == class_2246.field_10395 || block == class_2246.field_10027 || block == class_2246.field_10316 || block == class_2246.field_10613 || block == class_2246.field_10295 || block == class_2246.field_10375) {
            return false;
        }
        if (block instanceof class_2237) {
            return false;
        }
        if (block instanceof class_2346) {
            return false;
        }
        class_265 shape = s.method_26220((class_1922)class_2682.field_12294, class_2338.field_10980);
        return shape.equals((Object)class_259.method_1077());
    }

    private static float safeHardness(class_2248 block) {
        float value;
        Float cached = HARDNESS_CACHE.get(block);
        if (cached != null) {
            return cached.floatValue();
        }
        try {
            value = block.method_36555();
        }
        catch (Throwable t) {
            value = 5.0f;
        }
        HARDNESS_CACHE.put(block, Float.valueOf(value));
        return value;
    }

    static {
        HARDNESS_CACHE = new WeakHashMap<class_2248, Float>();
    }
}

