/*
 * Decompiled with CFR 0.152.
 */
package lynk.oneblock.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import lynk.oneblock.datapack.MultiplayerPackControl;
import lynk.oneblock.persit.StateSaverAndLoader;
import net.minecraft.class_1267;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2682;
import net.minecraft.class_5819;
import net.minecraft.class_7923;

public class RandomBlockUtil {
    private static List<class_2248> BASE_CANDIDATES;
    private static final int PROB_TRIES = 128;
    private static final int FALLBACK_SAMPLES = 64;
    private static final Map<class_2248, Float> HARDNESS_CACHE;
    private static final List<class_2248> USEFUL_WOOL;
    private static final List<class_2248> USEFUL_LOGS;
    private static final List<class_2248> USEFUL_PLANKS;
    private static final List<class_2248> USEFUL_MINERALS;
    private static final List<class_2248> RARE_MINERALS;
    private static final List<class_2248> STRUCTURAL_BASICS;
    private static final int W_USEFUL = 60;
    private static final int W_STRUCT = 35;
    private static final int W_RARE = 5;
    private static final Map<class_1267, Mult> DIFF;

    public static class_2248 getAnyRandomBlock(class_5819 random) {
        return class_7923.field_41175.method_10240(random).map(entry -> (class_2248)entry.comp_349()).orElse(class_2246.field_10340);
    }

    public static class_2248 getRandomSolidBlock(class_1937 world, UUID uuid, class_5819 random) {
        class_2248 candidate;
        int tries;
        StateSaverAndLoader serverState = StateSaverAndLoader.getServerState(world.method_8503());
        List<class_2248> base = RandomBlockUtil.getBaseCandidates();
        if (base.isEmpty()) {
            return class_2246.field_10340;
        }
        long totalBreaks = MultiplayerPackControl.isEnabled() ? serverState.getStats((UUID)uuid).totalOneBlockBreaks : serverState.getTotalBreaksAllPlayers();
        float progress = Math.min((float)totalBreaks / 10000.0f, 1.0f);
        float maxHardness = 2.0f + 51.0f * progress;
        double atten = 1.0 - (double)progress;
        WeightedBag bag = RandomBlockUtil.buildWeightedBag(world, random, base, atten);
        for (tries = 0; tries < 128; ++tries) {
            candidate = RandomBlockUtil.pickFromBagOrBase(bag, base, random);
            if (!(RandomBlockUtil.safeHardness(candidate) <= maxHardness)) continue;
            return candidate;
        }
        for (tries = 0; tries < 128; ++tries) {
            candidate = RandomBlockUtil.pickFromBagOrBase(bag, base, random);
            float hardness = RandomBlockUtil.safeHardness(candidate);
            float chance = progress * (hardness / 50.0f);
            if (!(random.method_43057() < chance)) continue;
            return candidate;
        }
        class_2248 best = class_2246.field_10340;
        float bestH = Float.MAX_VALUE;
        for (int i = 0; i < 64; ++i) {
            class_2248 candidate2 = RandomBlockUtil.pickFromBagOrBase(bag, base, random);
            float h = RandomBlockUtil.safeHardness(candidate2);
            if (!(h < bestH)) continue;
            bestH = h;
            best = candidate2;
        }
        return best;
    }

    private static WeightedBag buildWeightedBag(class_1937 world, class_5819 rnd, List<class_2248> base, double atten) {
        class_1267 d = world.method_8407();
        Mult m = DIFF.getOrDefault(d, new Mult(1.0, 1.0, 1.0));
        int totalUseful = Math.max(1, Math.round(60.0f * (float)m.useful));
        int wLogs = Math.toIntExact(Math.max(1L, Math.round((double)((float)totalUseful * 0.5f) * atten)));
        int wPlanks = Math.toIntExact(Math.max(1L, Math.round((double)((float)totalUseful * 0.0f) * atten)));
        int wMinerals = Math.toIntExact(Math.max(1L, Math.round((double)((float)totalUseful * 0.25f) * atten)));
        int wWool = Math.toIntExact(Math.max(1L, Math.round((double)((float)totalUseful * 0.25f) * atten)));
        int wStruct = Math.toIntExact(Math.max(1L, Math.round(35.0 * m.structural * atten)));
        int wRare = Math.toIntExact(Math.max(1L, Math.round(5.0 * m.rare * atten)));
        WeightedBag bag = new WeightedBag(rnd);
        bag.addAll(RandomBlockUtil.intersect(base, USEFUL_LOGS), wLogs);
        bag.addAll(RandomBlockUtil.intersect(base, USEFUL_PLANKS), wPlanks);
        bag.addAll(RandomBlockUtil.intersect(base, USEFUL_MINERALS), wMinerals);
        bag.addAll(RandomBlockUtil.intersect(base, USEFUL_WOOL), wWool);
        bag.addAll(RandomBlockUtil.intersect(base, STRUCTURAL_BASICS), wStruct);
        bag.addAll(RandomBlockUtil.intersect(base, RARE_MINERALS), wRare);
        return bag;
    }

    private static int scaleAllowZero(int base, double mul) {
        int v = (int)Math.round((double)base * mul);
        return Math.max(0, v);
    }

    private static int scale(int base, double mul) {
        return Math.max(1, (int)Math.round((double)base * mul));
    }

    private static List<class_2248> intersect(List<class_2248> a, List<class_2248> b) {
        ArrayList<class_2248> out = new ArrayList<class_2248>();
        for (class_2248 x : b) {
            if (!a.contains(x)) continue;
            out.add(x);
        }
        return out;
    }

    private static class_2248 pickFromBagOrBase(WeightedBag bag, List<class_2248> base, class_5819 rnd) {
        class_2248 fromBag = bag.pick();
        if (fromBag != null) {
            return fromBag;
        }
        return base.get(rnd.method_43048(base.size()));
    }

    private static List<class_2248> getBaseCandidates() {
        if (BASE_CANDIDATES == null || BASE_CANDIDATES.isEmpty()) {
            BASE_CANDIDATES = class_7923.field_41175.method_10220().filter(RandomBlockUtil::isStaticGoodSolidBlock).toList();
        }
        return BASE_CANDIDATES;
    }

    private static boolean isStaticGoodSolidBlock(class_2248 block) {
        class_2680 s = block.method_9564();
        if (s.method_26215()) {
            return false;
        }
        if (!s.method_26227().method_15769()) {
            return false;
        }
        if (s.method_45474()) {
            return false;
        }
        if (block == class_2246.field_9987 || block == class_2246.field_10499 || block == class_2246.field_31037 || block == class_2246.field_10465 || block == class_2246.field_16540 || block == class_2246.field_10525 || block == class_2246.field_10263 || block == class_2246.field_10395 || block == class_2246.field_10027 || block == class_2246.field_10316 || block == class_2246.field_10613 || block == class_2246.field_10295 || block == class_2246.field_10375) {
            return false;
        }
        if (block instanceof class_2237) {
            return false;
        }
        class_265 shape = s.method_26220((class_1922)class_2682.field_12294, class_2338.field_10980);
        return shape.equals((Object)class_259.method_1077());
    }

    private static float safeHardness(class_2248 block) {
        float value;
        Float cached = HARDNESS_CACHE.get(block);
        if (cached != null) {
            return cached.floatValue();
        }
        try {
            value = block.method_36555();
        }
        catch (Throwable t) {
            value = 5.0f;
        }
        HARDNESS_CACHE.put(block, Float.valueOf(value));
        return value;
    }

    static {
        HARDNESS_CACHE = new WeakHashMap<class_2248, Float>();
        USEFUL_WOOL = List.of(class_2246.field_10446, class_2246.field_10222, class_2246.field_10423, class_2246.field_10146, class_2246.field_10113, class_2246.field_10314, class_2246.field_10095, class_2246.field_10490, class_2246.field_10028, class_2246.field_10170, class_2246.field_10619, class_2246.field_10294, class_2246.field_10514, class_2246.field_10259, class_2246.field_10215, class_2246.field_10459);
        USEFUL_LOGS = List.of(class_2246.field_10431, class_2246.field_10511, class_2246.field_10037, class_2246.field_10306, class_2246.field_10533, class_2246.field_10010, class_2246.field_37545, class_2246.field_42729);
        USEFUL_PLANKS = List.of(class_2246.field_10161, class_2246.field_10148, class_2246.field_9975, class_2246.field_10334, class_2246.field_10218, class_2246.field_10075, class_2246.field_37577, class_2246.field_42751, class_2246.field_40294, class_2246.field_22126, class_2246.field_22127);
        USEFUL_MINERALS = List.of(class_2246.field_10418, class_2246.field_10212, class_2246.field_27120, class_2246.field_10571, class_2246.field_10080, class_2246.field_10090, class_2246.field_29219, class_2246.field_29027, class_2246.field_29221, class_2246.field_29026, class_2246.field_29030, class_2246.field_29028, class_2246.field_10213, class_2246.field_23077);
        RARE_MINERALS = List.of(class_2246.field_10442, class_2246.field_29029, class_2246.field_10013, class_2246.field_29220, class_2246.field_22109);
        STRUCTURAL_BASICS = List.of(class_2246.field_10340, class_2246.field_10445, class_2246.field_10115, class_2246.field_10508, class_2246.field_10474, class_2246.field_28888, class_2246.field_10566, class_2246.field_10253, class_2246.field_10219, class_2246.field_10102, class_2246.field_10534, class_2246.field_10255, class_2246.field_10460, class_2246.field_10415, class_2246.field_10491, class_2246.field_10225);
        DIFF = Map.of(class_1267.field_5801, new Mult(1.3, 0.9, 0.8), class_1267.field_5805, new Mult(1.2, 1.0, 0.9), class_1267.field_5802, new Mult(1.0, 1.0, 1.0), class_1267.field_5807, new Mult(0.8, 1.1, 1.1));
    }

    private static final class WeightedBag {
        private final class_5819 rnd;
        private final ArrayList<class_2248> entries = new ArrayList();

        WeightedBag(class_5819 rnd) {
            this.rnd = rnd;
        }

        void addAll(List<class_2248> list, int weightEach) {
            if (list == null || list.isEmpty() || weightEach <= 0) {
                return;
            }
            for (class_2248 b : list) {
                for (int i = 0; i < weightEach; ++i) {
                    this.entries.add(b);
                }
            }
        }

        class_2248 pick() {
            if (this.entries.isEmpty()) {
                return null;
            }
            int idx = this.rnd.method_43048(this.entries.size());
            return this.entries.get(idx);
        }
    }

    private static final class Mult {
        final double useful;
        final double structural;
        final double rare;

        Mult(double useful, double structural, double rare) {
            this.useful = useful;
            this.structural = structural;
            this.rare = rare;
        }
    }
}

