/*
 * Decompiled with CFR 0.152.
 */
package lynk.oneblock.util;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Comparator;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_124;
import net.minecraft.class_155;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;

public final class UpdateChecker {
    private static final HttpClient HTTP = HttpClient.newHttpClient();
    private static final Gson GSON = new Gson();
    private static Instant lastCheck = Instant.EPOCH;
    private static String lastAnnouncedVersion = null;

    private UpdateChecker() {
    }

    public static void checkNow(MinecraftServer server) {
        if (Instant.now().minusSeconds(1800L).isBefore(lastCheck)) {
            return;
        }
        lastCheck = Instant.now();
        try {
            String currentModVersion = ((ModContainer)FabricLoader.getInstance().getModContainer("oneblock").orElseThrow()).getMetadata().getVersion().getFriendlyString();
            String gameVersion = class_155.method_16673().comp_4025();
            String loadersParam = URLEncoder.encode("[\"fabric\"]", StandardCharsets.UTF_8);
            String versionsParam = URLEncoder.encode("[\"" + gameVersion + "\"]", StandardCharsets.UTF_8);
            URI uri = new URI("https", "api.modrinth.com", "/v2/project/theoneblock/version", "loaders=" + loadersParam + "&game_versions=" + versionsParam, null);
            HttpRequest req = HttpRequest.newBuilder(uri).header("User-Agent", "oneblock/update-checker (+mod)").GET().build();
            HttpResponse<String> res = HTTP.send(req, HttpResponse.BodyHandlers.ofString());
            if (res.statusCode() != 200) {
                System.out.println("[OneBlock] Update check failed, HTTP " + res.statusCode());
                return;
            }
            JsonArray arr = JsonParser.parseString((String)res.body()).getAsJsonArray();
            if (arr.size() == 0) {
                return;
            }
            JsonObject latest = arr.asList().stream().map(JsonElement::getAsJsonObject).max(Comparator.comparing(o -> Instant.parse(o.get("date_published").getAsString()))).orElse(null);
            if (latest == null) {
                return;
            }
            String latestNumber = latest.get("version_number").getAsString();
            if (latestNumber.equalsIgnoreCase(currentModVersion)) {
                return;
            }
            if (latestNumber.equals(lastAnnouncedVersion)) {
                return;
            }
            String pageUrl = "https://modrinth.com/mod/theoneblock/version/" + latestNumber;
            URI pageURI = URI.create(pageUrl);
            System.out.println("[OneBlock] Update available: " + latestNumber + " (you have " + currentModVersion + ")");
            System.out.println("[OneBlock] " + pageUrl);
            class_3324 pm = server.method_3760();
            class_5250 msg = class_2561.method_43470((String)"OneBlock update available: ").method_27692(class_124.field_1054).method_10852((class_2561)class_2561.method_43470((String)latestNumber).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)(" (you have " + currentModVersion + ") \u2014 "))).method_10852((class_2561)class_2561.method_43470((String)"[Open Modrinth]").method_10862(class_2583.field_24360.method_10977(class_124.field_1060).method_30938(Boolean.valueOf(true)).method_10958((class_2558)new class_2558.class_10608(pageURI))));
            pm.method_14571().forEach(arg_0 -> UpdateChecker.lambda$checkNow$1((class_2561)msg, arg_0));
            lastAnnouncedVersion = latestNumber;
        }
        catch (Throwable t) {
            System.out.println("[OneBlock] Update check error: " + t.getMessage());
        }
    }

    private static /* synthetic */ void lambda$checkNow$1(class_2561 msg, class_3222 p) {
        p.method_7353(msg, false);
    }
}

