/*
 * Decompiled with CFR 0.152.
 */
package lynk.oneblock.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Arrays;
import net.minecraft.class_2487;

public class OneBlockConfig {
    private int waveChance = 100;
    private int itemDropChance = 100;
    private int itemDropCount = 1;
    private int friendlyMobChance = 100;
    private int lavaBucketChance = 500;
    private int friendlyMobSpawnRadius = 4;
    private int hostileMobSpawnRadius = 4;
    private int endPortalFrameChance = 200;
    private int endPortalFrameRequirement = 10000;
    private int[] waveCountdowns = new int[]{12, 10, 8, 6, 5, 4, 3};
    private int[] waveThresholds = new int[]{0, 500, 1500, 3000, 5000, 8000, 12000};
    private int maxWaveSize = 100;
    private int waveSizeDivisor = 100;
    private int progressionCap = 10000;
    private boolean itemDropsEnabled = true;
    private boolean mobWavesEnabled = true;
    private boolean friendlyMobsEnabled = true;
    private boolean endPortalFrameEnabled = true;
    private boolean useGlobalBreakCount = false;
    private boolean biomeCyclingEnabled = false;
    private int biomeSwitchInterval = 100;
    private boolean spawnItemsInChest = false;
    public static final Codec<OneBlockConfig> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.INT.optionalFieldOf("waveChance", (Object)100).forGetter(c -> c.waveChance), (App)Codec.INT.optionalFieldOf("itemDropChance", (Object)100).forGetter(c -> c.itemDropChance), (App)Codec.INT.optionalFieldOf("itemDropCount", (Object)1).forGetter(c -> c.itemDropCount), (App)Codec.INT.optionalFieldOf("friendlyMobChance", (Object)100).forGetter(c -> c.friendlyMobChance), (App)Codec.INT.optionalFieldOf("lavaBucketChance", (Object)500).forGetter(c -> c.lavaBucketChance), (App)Codec.INT.optionalFieldOf("friendlyMobSpawnRadius", (Object)4).forGetter(c -> c.friendlyMobSpawnRadius), (App)Codec.INT.optionalFieldOf("hostileMobSpawnRadius", (Object)4).forGetter(c -> c.hostileMobSpawnRadius), (App)Codec.INT.optionalFieldOf("endPortalFrameChance", (Object)200).forGetter(c -> c.endPortalFrameChance), (App)Codec.INT.optionalFieldOf("endPortalFrameRequirement", (Object)10000).forGetter(c -> c.endPortalFrameRequirement), (App)Codec.INT.optionalFieldOf("maxWaveSize", (Object)100).forGetter(c -> c.maxWaveSize), (App)Codec.INT.optionalFieldOf("waveSizeDivisor", (Object)100).forGetter(c -> c.waveSizeDivisor), (App)Codec.INT.optionalFieldOf("progressionCap", (Object)10000).forGetter(c -> c.progressionCap), (App)Codec.INT.optionalFieldOf("biomeSwitchInterval", (Object)100).forGetter(c -> c.biomeSwitchInterval), (App)WaveTiers.CODEC.optionalFieldOf("waveTiers", (Object)new WaveTiers(new int[]{12, 10, 8, 6, 5, 4, 3}, new int[]{0, 500, 1500, 3000, 5000, 8000, 12000})).forGetter(c -> new WaveTiers(c.waveCountdowns, c.waveThresholds)), (App)Features.CODEC.optionalFieldOf("features", (Object)new Features(true, true, true, true, false, false, false)).forGetter(c -> new Features(c.itemDropsEnabled, c.mobWavesEnabled, c.friendlyMobsEnabled, c.endPortalFrameEnabled, c.useGlobalBreakCount, c.biomeCyclingEnabled, c.spawnItemsInChest))).apply((Applicative)inst, (wc, idc, idCount, fmc, lbc, fmsr, hmsr, epfc, epfr, mws, wsd, pc, bsi, wt, features) -> {
        OneBlockConfig config = new OneBlockConfig();
        config.waveChance = wc;
        config.itemDropChance = idc;
        config.itemDropCount = idCount;
        config.friendlyMobChance = fmc;
        config.lavaBucketChance = lbc;
        config.friendlyMobSpawnRadius = fmsr;
        config.hostileMobSpawnRadius = hmsr;
        config.endPortalFrameChance = epfc;
        config.endPortalFrameRequirement = epfr;
        config.maxWaveSize = mws;
        config.waveSizeDivisor = wsd;
        config.progressionCap = pc;
        config.biomeSwitchInterval = bsi;
        config.waveCountdowns = wt.countdowns();
        config.waveThresholds = wt.thresholds();
        config.itemDropsEnabled = features.itemDropsEnabled();
        config.mobWavesEnabled = features.mobWavesEnabled();
        config.friendlyMobsEnabled = features.friendlyMobsEnabled();
        config.endPortalFrameEnabled = features.endPortalFrameEnabled();
        config.useGlobalBreakCount = features.useGlobalBreakCount();
        config.biomeCyclingEnabled = features.biomeCyclingEnabled();
        config.spawnItemsInChest = features.spawnItemsInChest();
        return config;
    }));

    public int getWaveChance() {
        return this.waveChance;
    }

    public int getItemDropChance() {
        return this.itemDropChance;
    }

    public int getItemDropCount() {
        return this.itemDropCount;
    }

    public int getFriendlyMobChance() {
        return this.friendlyMobChance;
    }

    public int getLavaBucketChance() {
        return this.lavaBucketChance;
    }

    public int getFriendlyMobSpawnRadius() {
        return this.friendlyMobSpawnRadius;
    }

    public int getHostileMobSpawnRadius() {
        return this.hostileMobSpawnRadius;
    }

    public int getEndPortalFrameChance() {
        return this.endPortalFrameChance;
    }

    public int getEndPortalFrameRequirement() {
        return this.endPortalFrameRequirement;
    }

    public int getMaxWaveSize() {
        return this.maxWaveSize;
    }

    public int getWaveSizeDivisor() {
        return this.waveSizeDivisor;
    }

    public int getProgressionCap() {
        return this.progressionCap;
    }

    public boolean areItemDropsEnabled() {
        return this.itemDropsEnabled;
    }

    public boolean areMobWavesEnabled() {
        return this.mobWavesEnabled;
    }

    public boolean areFriendlyMobsEnabled() {
        return this.friendlyMobsEnabled;
    }

    public boolean isEndPortalFrameEnabled() {
        return this.endPortalFrameEnabled;
    }

    public boolean useGlobalBreakCount() {
        return this.useGlobalBreakCount;
    }

    public boolean isBiomeCyclingEnabled() {
        return this.biomeCyclingEnabled;
    }

    public boolean isSpawnItemsInChest() {
        return this.spawnItemsInChest;
    }

    public int getBiomeSwitchInterval() {
        return this.biomeSwitchInterval;
    }

    public void setWaveChance(int value) {
        this.waveChance = Math.max(1, Math.min(1000000, value));
    }

    public void setItemDropChance(int value) {
        this.itemDropChance = Math.max(1, Math.min(1000000, value));
    }

    public void setItemDropCount(int value) {
        this.itemDropCount = Math.max(1, Math.min(64, value));
    }

    public void setFriendlyMobChance(int value) {
        this.friendlyMobChance = Math.max(1, Math.min(1000000, value));
    }

    public void setLavaBucketChance(int value) {
        this.lavaBucketChance = Math.max(1, Math.min(1000000, value));
    }

    public void setFriendlyMobSpawnRadius(int value) {
        this.friendlyMobSpawnRadius = Math.max(1, Math.min(1000000, value));
    }

    public void setHostileMobSpawnRadius(int value) {
        this.hostileMobSpawnRadius = Math.max(1, Math.min(1000000, value));
    }

    public void setEndPortalFrameChance(int value) {
        this.endPortalFrameChance = Math.max(1, Math.min(1000000, value));
    }

    public void setEndPortalFrameRequirement(int value) {
        this.endPortalFrameRequirement = Math.max(0, Math.min(1000000, value));
    }

    public void setMaxWaveSize(int value) {
        this.maxWaveSize = Math.max(1, Math.min(1000000, value));
    }

    public void setWaveSizeDivisor(int value) {
        this.waveSizeDivisor = Math.max(1, Math.min(1000000, value));
    }

    public void setProgressionCap(int value) {
        this.progressionCap = Math.max(1, Math.min(1000000, value));
    }

    public void setItemDropsEnabled(boolean value) {
        this.itemDropsEnabled = value;
    }

    public void setMobWavesEnabled(boolean value) {
        this.mobWavesEnabled = value;
    }

    public void setFriendlyMobsEnabled(boolean value) {
        this.friendlyMobsEnabled = value;
    }

    public void setEndPortalFrameEnabled(boolean value) {
        this.endPortalFrameEnabled = value;
    }

    public void setUseGlobalBreakCount(boolean value) {
        this.useGlobalBreakCount = value;
    }

    public void setBiomeCyclingEnabled(boolean value) {
        this.biomeCyclingEnabled = value;
    }

    public void setSpawnItemsInChest(boolean value) {
        this.spawnItemsInChest = value;
    }

    public void setBiomeSwitchInterval(int value) {
        this.biomeSwitchInterval = Math.max(0, Math.min(1000000, value));
    }

    public int getWaveCountdown(int totalBreaks) {
        for (int i = this.waveThresholds.length - 1; i >= 0; --i) {
            if (totalBreaks < this.waveThresholds[i]) continue;
            return this.waveCountdowns[i];
        }
        return this.waveCountdowns[0];
    }

    public void setWaveCountdown(int index, int value) {
        if (index >= 0 && index < this.waveCountdowns.length) {
            this.waveCountdowns[index] = Math.max(1, value);
        }
    }

    public int getWaveThreshold(int index) {
        if (index >= 0 && index < this.waveThresholds.length) {
            return this.waveThresholds[index];
        }
        return 0;
    }

    public int getWaveTierCount() {
        return this.waveCountdowns.length;
    }

    public void writeNbt(class_2487 nbt) {
        nbt.method_10569("waveChance", this.waveChance);
        nbt.method_10569("itemDropChance", this.itemDropChance);
        nbt.method_10569("friendlyMobChance", this.friendlyMobChance);
        nbt.method_10569("endPortalFrameChance", this.endPortalFrameChance);
        nbt.method_10569("endPortalFrameRequirement", this.endPortalFrameRequirement);
        nbt.method_10569("maxWaveSize", this.maxWaveSize);
        nbt.method_10569("waveSizeDivisor", this.waveSizeDivisor);
        nbt.method_10569("progressionCap", this.progressionCap);
        nbt.method_10556("itemDropsEnabled", this.itemDropsEnabled);
        nbt.method_10556("mobWavesEnabled", this.mobWavesEnabled);
        nbt.method_10556("friendlyMobsEnabled", this.friendlyMobsEnabled);
        nbt.method_10556("endPortalFrameEnabled", this.endPortalFrameEnabled);
        nbt.method_10539("waveCountdowns", this.waveCountdowns);
        nbt.method_10539("waveThresholds", this.waveThresholds);
    }

    public void readNbt(class_2487 nbt) {
        if (nbt.method_10545("waveChance")) {
            this.waveChance = nbt.method_10550("waveChance").orElse(100);
        }
        if (nbt.method_10545("itemDropChance")) {
            this.itemDropChance = nbt.method_10550("itemDropChance").orElse(100);
        }
        if (nbt.method_10545("friendlyMobChance")) {
            this.friendlyMobChance = nbt.method_10550("friendlyMobChance").orElse(100);
        }
        if (nbt.method_10545("endPortalFrameChance")) {
            this.endPortalFrameChance = nbt.method_10550("endPortalFrameChance").orElse(200);
        }
        if (nbt.method_10545("endPortalFrameRequirement")) {
            this.endPortalFrameRequirement = nbt.method_10550("endPortalFrameRequirement").orElse(10000);
        }
        if (nbt.method_10545("maxWaveSize")) {
            this.maxWaveSize = nbt.method_10550("maxWaveSize").orElse(100);
        }
        if (nbt.method_10545("waveSizeDivisor")) {
            this.waveSizeDivisor = nbt.method_10550("waveSizeDivisor").orElse(100);
        }
        if (nbt.method_10545("progressionCap")) {
            this.progressionCap = nbt.method_10550("progressionCap").orElse(10000);
        }
        if (nbt.method_10545("itemDropsEnabled")) {
            this.itemDropsEnabled = nbt.method_10577("itemDropsEnabled").orElse(true);
        }
        if (nbt.method_10545("mobWavesEnabled")) {
            this.mobWavesEnabled = nbt.method_10577("mobWavesEnabled").orElse(true);
        }
        if (nbt.method_10545("friendlyMobsEnabled")) {
            this.friendlyMobsEnabled = nbt.method_10577("friendlyMobsEnabled").orElse(true);
        }
        if (nbt.method_10545("endPortalFrameEnabled")) {
            this.endPortalFrameEnabled = nbt.method_10577("endPortalFrameEnabled").orElse(true);
        }
        if (nbt.method_10545("waveCountdowns")) {
            this.waveCountdowns = nbt.method_10561("waveCountdowns").orElse(new int[]{12, 10, 8, 6, 5, 4, 3});
        }
        if (nbt.method_10545("waveThresholds")) {
            this.waveThresholds = nbt.method_10561("waveThresholds").orElse(new int[]{0, 500, 1500, 3000, 5000, 8000, 12000});
        }
    }

    public void resetToDefaults() {
        this.waveChance = 100;
        this.itemDropChance = 100;
        this.itemDropCount = 1;
        this.friendlyMobChance = 100;
        this.lavaBucketChance = 500;
        this.friendlyMobSpawnRadius = 4;
        this.hostileMobSpawnRadius = 4;
        this.endPortalFrameChance = 200;
        this.endPortalFrameRequirement = 10000;
        this.maxWaveSize = 100;
        this.waveSizeDivisor = 100;
        this.progressionCap = 10000;
        this.itemDropsEnabled = true;
        this.mobWavesEnabled = true;
        this.friendlyMobsEnabled = true;
        this.endPortalFrameEnabled = true;
        this.waveCountdowns = new int[]{12, 10, 8, 6, 5, 4, 3};
        this.waveThresholds = new int[]{0, 500, 1500, 3000, 5000, 8000, 12000};
    }

    public record WaveTiers(int[] countdowns, int[] thresholds) {
        public static final Codec<WaveTiers> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.INT_STREAM.xmap(s -> s.toArray(), Arrays::stream).optionalFieldOf("countdowns", (Object)new int[]{12, 10, 8, 6, 5, 4, 3}).forGetter(WaveTiers::countdowns), (App)Codec.INT_STREAM.xmap(s -> s.toArray(), Arrays::stream).optionalFieldOf("thresholds", (Object)new int[]{0, 500, 1500, 3000, 5000, 8000, 12000}).forGetter(WaveTiers::thresholds)).apply((Applicative)inst, WaveTiers::new));
    }

    public record Features(boolean itemDropsEnabled, boolean mobWavesEnabled, boolean friendlyMobsEnabled, boolean endPortalFrameEnabled, boolean useGlobalBreakCount, boolean biomeCyclingEnabled, boolean spawnItemsInChest) {
        public static final Codec<Features> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Codec.BOOL.optionalFieldOf("itemDropsEnabled", (Object)true).forGetter(Features::itemDropsEnabled), (App)Codec.BOOL.optionalFieldOf("mobWavesEnabled", (Object)true).forGetter(Features::mobWavesEnabled), (App)Codec.BOOL.optionalFieldOf("friendlyMobsEnabled", (Object)true).forGetter(Features::friendlyMobsEnabled), (App)Codec.BOOL.optionalFieldOf("endPortalFrameEnabled", (Object)true).forGetter(Features::endPortalFrameEnabled), (App)Codec.BOOL.optionalFieldOf("useGlobalBreakCount", (Object)false).forGetter(Features::useGlobalBreakCount), (App)Codec.BOOL.optionalFieldOf("biomeCyclingEnabled", (Object)false).forGetter(Features::biomeCyclingEnabled), (App)Codec.BOOL.optionalFieldOf("spawnItemsInChest", (Object)false).forGetter(Features::spawnItemsInChest)).apply((Applicative)inst, Features::new));
    }
}

