/*
 * Decompiled with CFR 0.152.
 */
package lynk.oneblock.events;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lynk.oneblock.persit.StateSaverAndLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3486;
import net.minecraft.class_3730;
import net.minecraft.class_5819;

public class FriendlySpawn {
    private static final int MAX_PASSIVE_SIZE = 6;

    public static void spawn(class_1937 world, class_2338 oneBlockPos) {
        int total;
        if (world.method_8608()) {
            return;
        }
        if (!(world instanceof class_3218)) {
            return;
        }
        class_3218 sw = (class_3218)world;
        class_2338 surfaceCenter = oneBlockPos.method_10074();
        class_5819 rnd = sw.method_8409();
        boolean hasWaterPool = FriendlySpawn.hasWaterPool3x3(sw, surfaceCenter);
        List<class_1299<? extends class_1309>> landPool = FriendlySpawn.getPassivePool();
        List<Object> aquaticPool = hasWaterPool ? FriendlySpawn.getAquaticPool() : List.of();
        int landCount = total = 1 + rnd.method_43048(6);
        int waterCount = 0;
        if (hasWaterPool && !aquaticPool.isEmpty()) {
            waterCount = Math.max(1, total / 2);
            landCount = total - waterCount;
        }
        StateSaverAndLoader state = StateSaverAndLoader.getServerState(sw.method_8503());
        int spawnRadius = state.getConfig().getFriendlyMobSpawnRadius();
        int spawned = 0;
        if (landCount > 0) {
            spawned += FriendlySpawn.spawnPassiveWave(sw, oneBlockPos, landPool, landCount, spawnRadius, 10);
        }
        if (waterCount > 0) {
            spawned += FriendlySpawn.spawnAquaticWave(sw, surfaceCenter, aquaticPool, waterCount, 3, 20);
        }
        if (spawned > 0) {
            String msg = hasWaterPool ? "\u00a7b[OneBlock] Aquatic & friendly visitors appeared: \u00a7e" + spawned + "\u00a77 entities." : "\u00a7a[OneBlock] Friendly wave: \u00a7e" + spawned + "\u00a77 entities.";
            sw.method_8503().method_3760().method_43514((class_2561)class_2561.method_43470((String)msg), false);
        }
    }

    private static List<class_1299<? extends class_1309>> getPassivePool() {
        return new ArrayList<class_1299<? extends class_1309>>(Arrays.asList(class_1299.field_6132, class_1299.field_6115, class_1299.field_6085, class_1299.field_6093, class_1299.field_6140, class_1299.field_30052, class_1299.field_16281, class_1299.field_6055, class_1299.field_6139, class_1299.field_6067, class_1299.field_6057, class_1299.field_6143, class_1299.field_20346, class_1299.field_6104, class_1299.field_40116, class_1299.field_6074, class_1299.field_17943, class_1299.field_6146, class_1299.field_6113, class_1299.field_6047, class_1299.field_6147, class_1299.field_38384));
    }

    private static List<class_1299<? extends class_1309>> getAquaticPool() {
        return new ArrayList<class_1299<? extends class_1309>>(Arrays.asList(class_1299.field_6070, class_1299.field_6073, class_1299.field_6111, class_1299.field_6062, class_1299.field_6114, class_1299.field_28402, class_1299.field_28315, class_1299.field_37420, class_1299.field_6087, class_1299.field_37419));
    }

    private static boolean hasWaterPool3x3(class_3218 world, class_2338 surfaceCenter) {
        int y = surfaceCenter.method_10264();
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dz = -1; dz <= 1; ++dz) {
                class_2338 p = new class_2338(surfaceCenter.method_10263() + dx, y, surfaceCenter.method_10260() + dz);
                if (FriendlySpawn.isWater(world.method_8320(p))) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean isWater(class_2680 state) {
        return state.method_26227().method_15767(class_3486.field_15517);
    }

    private static int spawnPassiveWave(class_3218 sw, class_2338 oneBlockPos, List<class_1299<? extends class_1309>> pool, int count, int radius, int triesPerMob) {
        class_5819 rnd = sw.method_8409();
        int spawned = 0;
        class_2338 center = oneBlockPos;
        for (int i = 0; i < count; ++i) {
            class_1309 e;
            class_1299<? extends class_1309> type = pool.get(rnd.method_43048(pool.size()));
            class_2338 pos = FriendlySpawn.pickNearbySurface((class_1937)sw, center, radius, triesPerMob);
            if (pos == null) {
                pos = center;
            }
            if ((e = (class_1309)type.method_5883((class_1937)sw, class_3730.field_16467)) == null) continue;
            e.method_5725(pos, rnd.method_43057() * 360.0f, 0.0f);
            if (!sw.method_8649((class_1297)e)) continue;
            ++spawned;
        }
        return spawned;
    }

    private static int spawnAquaticWave(class_3218 sw, class_2338 surfaceCenterY63, List<class_1299<? extends class_1309>> aquaticPool, int count, int halfExtent, int maxTries) {
        class_5819 rnd = sw.method_8409();
        int spawned = 0;
        int y = surfaceCenterY63.method_10264();
        for (int i = 0; i < count; ++i) {
            class_1309 e;
            class_1299<? extends class_1309> type = aquaticPool.get(rnd.method_43048(aquaticPool.size()));
            class_2338 waterPos = FriendlySpawn.pickRandomWaterInSquare(sw, surfaceCenterY63, halfExtent, y, maxTries, rnd);
            if (waterPos == null) {
                waterPos = surfaceCenterY63;
            }
            if ((e = (class_1309)type.method_5883((class_1937)sw, class_3730.field_16467)) == null) continue;
            e.method_5808((double)waterPos.method_10263() + 0.5, (double)waterPos.method_10264() + 0.2, (double)waterPos.method_10260() + 0.5, rnd.method_43057() * 360.0f, 0.0f);
            if (!sw.method_8649((class_1297)e)) continue;
            ++spawned;
        }
        return spawned;
    }

    private static class_2338 pickRandomWaterInSquare(class_3218 world, class_2338 centerY63, int halfExtent, int y, int maxTries, class_5819 rnd) {
        for (int t = 0; t < maxTries; ++t) {
            int z;
            int x = centerY63.method_10263() + rnd.method_39332(-halfExtent, halfExtent);
            class_2338 p = new class_2338(x, y, z = centerY63.method_10260() + rnd.method_39332(-halfExtent, halfExtent));
            if (!FriendlySpawn.isWater(world.method_8320(p))) continue;
            return p;
        }
        return null;
    }

    private static class_2338 pickNearbySurface(class_1937 world, class_2338 center, int radius, int tries) {
        class_5819 rnd = world.method_8409();
        for (int t = 0; t < tries; ++t) {
            int dz;
            int dx = rnd.method_39332(-radius, radius);
            if (dx * dx + (dz = rnd.method_39332(-radius, radius)) * dz > radius * radius) continue;
            class_2338 p = center.method_10069(dx, 0, dz);
            if (world.method_22347(p)) {
                return p;
            }
            if (!world.method_22347(p.method_10084())) continue;
            return p.method_10084();
        }
        return center;
    }
}

