/*
 * Decompiled with CFR 0.152.
 */
package lynk.oneblock.events;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import lynk.oneblock.datapack.MultiplayerPackControl;
import lynk.oneblock.persit.StateSaverAndLoader;
import net.minecraft.class_1267;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3730;
import net.minecraft.class_5819;

public class MobSpawn {
    private static final int MAX_MOB_SIZE = 100;
    private static final Set<class_1299<? extends class_1309>> SUNLIGHT_BURNERS = Set.of(class_1299.field_6051, class_1299.field_6137, class_1299.field_6098, class_1299.field_6123, class_1299.field_6054);
    private static final Set<class_1299<? extends class_1309>> STRICT_NIGHT_ONLY = Set.of(class_1299.field_6078);

    public static void setMobSpawn(class_1937 world, UUID uuid) {
        int count;
        if (world.method_8608()) {
            return;
        }
        StateSaverAndLoader state = StateSaverAndLoader.getServerState(world.method_8503());
        long breaks = state.getPlayerBlockBreaks(uuid);
        class_1267 diff = world.method_8407();
        if (diff == class_1267.field_5801) {
            if (MultiplayerPackControl.isEnabled()) {
                state.setMobSpawnSet(uuid, false);
                state.setBreaksTillSpawn(uuid, Integer.MAX_VALUE);
            } else {
                state.forEachPlayer((uuid1, playerStats) -> {
                    playerStats.mobSpawnSet = false;
                    playerStats.breaksTillSpawn = Integer.MAX_VALUE;
                });
            }
            state.method_80();
            return;
        }
        int baseCount = MobSpawn.getCountForBreaks(breaks, world.method_8409(), state);
        int baseCooldown = MobSpawn.getCooldownForBreaks(breaks, state);
        switch (diff) {
            case field_5805: {
                int n = baseCount;
                break;
            }
            case field_5802: {
                int n = Math.min(state.getConfig().getMaxWaveSize(), baseCount + 1);
                break;
            }
            case field_5807: {
                int n = Math.min(state.getConfig().getMaxWaveSize(), baseCount + 3);
                break;
            }
            default: {
                int n = count = baseCount;
            }
        }
        int cooldown = Math.max(1, baseCooldown - (diff == class_1267.field_5807 ? 2 : (diff == class_1267.field_5802 ? 1 : 0)));
        state.setMobSpawnSet(uuid, true);
        state.setBreaksTillSpawn(uuid, cooldown);
        state.setPendingMobCount(uuid, count);
        if (MultiplayerPackControl.isEnabled()) {
            state.forEachPlayer((playerUUID, playerStats) -> {
                if (state.getOneBlockPos(uuid).equals((Object)playerStats.oneBlockPos)) {
                    MobSpawn.announceToPlayer(world, uuid, (class_2561)class_2561.method_43470((String)("\u00a7e[OneBlock] \u00a77Next wave in \u00a7b" + cooldown + "\u00a77 breaks.")));
                }
            });
        } else {
            MobSpawn.announce(world, (class_2561)class_2561.method_43470((String)("\u00a7e[OneBlock] \u00a77Next wave in \u00a7b" + cooldown + "\u00a77 breaks.")));
        }
    }

    public static void spawnWaveNow(class_3218 sw, UUID uuid) {
        StateSaverAndLoader state = StateSaverAndLoader.getServerState(sw.method_8503());
        if (!state.getMobSpawnSet(uuid)) {
            return;
        }
        long breaks = state.getPlayerBlockBreaks(uuid);
        ArrayList<class_1299<? extends class_1309>> pool = new ArrayList<class_1299<? extends class_1309>>(MobSpawn.getPoolForBreaks(breaks, (class_1937)sw, state, uuid));
        int count = Math.max(1, Math.min(100, state.getPendingMobCount(uuid)));
        class_2338 center = state.getOneBlockPos(uuid).method_10084();
        if (sw.method_27983() == class_1937.field_25179 && !MobSpawn.isDarkEnough((class_1937)sw, center)) {
            pool.removeIf(SUNLIGHT_BURNERS::contains);
            pool.removeIf(STRICT_NIGHT_ONLY::contains);
        }
        if (pool.isEmpty()) {
            state.setMobSpawnSet(uuid, false);
            state.setPendingMobCount(uuid, 0);
            state.setBreaksTillSpawn(uuid, MobSpawn.getCooldownForBreaks(breaks, state));
            return;
        }
        int spawnRadius = state.getConfig().getHostileMobSpawnRadius();
        int spawned = MobSpawn.spawnWave(sw, center, pool, count, spawnRadius, 8);
        state.forEachPlayer((playerUUID, playerStats) -> {
            if (state.getOneBlockPos(uuid).equals((Object)playerStats.oneBlockPos)) {
                MobSpawn.announceToPlayer((class_1937)sw, uuid, (class_2561)class_2561.method_43470((String)("\u00a7c[OneBlock] Wave spawned: \u00a7e" + spawned)));
            }
        });
        state.setMobSpawnSet(uuid, false);
        state.setPendingMobCount(uuid, 0);
        state.setBreaksTillSpawn(uuid, MobSpawn.getCooldownForBreaks(breaks, state));
    }

    private static int getCountForBreaks(long breaks, class_5819 rnd, StateSaverAndLoader state) {
        long stage;
        long max;
        if (breaks < 100L) {
            return 1;
        }
        int divisor = state.getConfig().getWaveSizeDivisor();
        if (divisor <= 0) {
            divisor = 1;
        }
        if ((max = Math.min((stage = breaks / (long)divisor) + 1L, (long)state.getConfig().getMaxWaveSize())) <= 0L) {
            return 1;
        }
        return 1 + rnd.method_43048((int)max);
    }

    private static int getCooldownForBreaks(long breaks, StateSaverAndLoader state) {
        return state.getConfig().getWaveCountdown((int)breaks);
    }

    private static List<class_1299<? extends class_1309>> getPoolForBreaks(long breaks, class_1937 world, StateSaverAndLoader state, UUID uuid) {
        boolean endUnlocked;
        ArrayList<class_1299<? extends class_1309>> pool = new ArrayList<class_1299<? extends class_1309>>();
        pool.add(class_1299.field_6051);
        pool.add(class_1299.field_6137);
        pool.add(class_1299.field_6079);
        pool.add(class_1299.field_6046);
        pool.add(class_1299.field_6071);
        pool.add(class_1299.field_6098);
        pool.add(class_1299.field_6091);
        pool.add(class_1299.field_6069);
        pool.add(class_1299.field_6084);
        pool.add(class_1299.field_6123);
        if (breaks >= 1500L) {
            pool.add(class_1299.field_6145);
            pool.add(class_1299.field_6105);
            pool.add(class_1299.field_6059);
            pool.add(class_1299.field_6117);
            pool.add(class_1299.field_6090);
            pool.add(class_1299.field_6134);
            pool.add(class_1299.field_6078);
            pool.add(class_1299.field_6125);
            pool.add((class_1299<? extends class_1309>)class_1299.field_6054);
        }
        boolean netherUnlocked = MultiplayerPackControl.isEnabled() ? state.hasVisitedNether(uuid) : state.anyoneVisitedNether();
        boolean bl = endUnlocked = MultiplayerPackControl.isEnabled() ? state.hasVisitedEnd(uuid) : state.anyoneVisitedEnd();
        if (world.method_27983() == class_1937.field_25180 || netherUnlocked) {
            pool.add(class_1299.field_6099);
            pool.add(class_1299.field_6102);
            pool.add(class_1299.field_6076);
            pool.add(class_1299.field_6050);
            pool.add((class_1299<? extends class_1309>)class_1299.field_21973);
            pool.add((class_1299<? extends class_1309>)class_1299.field_22281);
            pool.add((class_1299<? extends class_1309>)class_1299.field_25751);
            pool.add((class_1299<? extends class_1309>)class_1299.field_6107);
        }
        if (world.method_27983() == class_1937.field_25181 || endUnlocked) {
            pool.add(class_1299.field_6109);
            pool.add(class_1299.field_6128);
            pool.add(class_1299.field_6078);
        }
        if (breaks >= 5000L) {
            pool.add(class_1299.field_6105);
            pool.add((class_1299<? extends class_1309>)class_1299.field_6090);
            pool.add((class_1299<? extends class_1309>)class_1299.field_6059);
            pool.add((class_1299<? extends class_1309>)class_1299.field_6134);
        }
        if (breaks >= 3000L && world.method_27983() != class_1937.field_25180) {
            pool.add((class_1299<? extends class_1309>)class_1299.field_6118);
        }
        return pool;
    }

    private static boolean isDarkEnough(class_1937 world, class_2338 pos) {
        if (world.method_27983() != class_1937.field_25179) {
            return true;
        }
        return world.method_22339(pos) <= 7;
    }

    private static int spawnWave(class_3218 sw, class_2338 center, List<class_1299<? extends class_1309>> pool, int count, int radius, int triesPerMob) {
        class_5819 rnd = sw.method_8409();
        int spawned = 0;
        boolean creeperSpawned = false;
        ArrayList<class_1299<? extends class_1309>> nonCreeperPool = new ArrayList<class_1299<? extends class_1309>>();
        for (class_1299<? extends class_1309> t : pool) {
            if (t == class_1299.field_6046) continue;
            nonCreeperPool.add(t);
        }
        for (int i = 0; i < count; ++i) {
            class_1309 e;
            class_1299 type;
            boolean creeperAvailableInPool = pool.contains(class_1299.field_6046);
            if (creeperSpawned || !creeperAvailableInPool) {
                if (nonCreeperPool.isEmpty()) break;
                type = (class_1299)nonCreeperPool.get(rnd.method_43048(nonCreeperPool.size()));
            } else {
                type = pool.get(rnd.method_43048(pool.size()));
                if (type == class_1299.field_6046) {
                    creeperSpawned = true;
                }
            }
            class_2338 pos = MobSpawn.pickNearbySurface((class_1937)sw, center, radius, triesPerMob);
            if (pos == null) {
                pos = center;
            }
            if ((e = (class_1309)type.method_5883((class_1937)sw, class_3730.field_16467)) == null) continue;
            e.method_5725(pos, rnd.method_43057() * 360.0f, 0.0f);
            if (!sw.method_8649((class_1297)e)) continue;
            ++spawned;
        }
        return spawned;
    }

    private static class_2338 pickNearbySurface(class_1937 world, class_2338 center, int radius, int tries) {
        class_5819 rnd = world.method_8409();
        for (int t = 0; t < tries; ++t) {
            int dz;
            int dx = rnd.method_39332(-radius, radius);
            if (dx * dx + (dz = rnd.method_39332(-radius, radius)) * dz > radius * radius) continue;
            class_2338 p = center.method_10069(dx, 0, dz);
            if (world.method_22347(p)) {
                return p;
            }
            if (!world.method_22347(p.method_10084())) continue;
            return p.method_10084();
        }
        return center;
    }

    private static void announce(class_1937 world, class_2561 msg) {
        if (world.method_8503() == null) {
            return;
        }
        world.method_8503().method_3760().method_43514(msg, false);
    }

    private static void announceToPlayer(class_1937 world, UUID uuid, class_2561 msg) {
        if (world.method_8503() == null) {
            return;
        }
        world.method_18456().forEach(playerEntity -> {
            if (playerEntity.method_5667().equals(uuid)) {
                playerEntity.method_7353(msg, false);
            }
        });
    }

    private static void announceToPlayers(class_1937 world, class_2561 msg) {
        if (world.method_8503() == null) {
            return;
        }
        world.method_8503().method_3760().method_43514(msg, false);
    }
}

