/*
 * Decompiled with CFR 0.152.
 */
package lynk.oneblock.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import lynk.oneblock.datapack.MultiplayerPackControl;
import lynk.oneblock.persit.StateSaverAndLoader;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1542;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1826;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2199;
import net.minecraft.class_2244;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2323;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2346;
import net.minecraft.class_2349;
import net.minecraft.class_2354;
import net.minecraft.class_2389;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2472;
import net.minecraft.class_2482;
import net.minecraft.class_2510;
import net.minecraft.class_2527;
import net.minecraft.class_2533;
import net.minecraft.class_2544;
import net.minecraft.class_2577;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5544;
import net.minecraft.class_5819;
import net.minecraft.class_7923;

public class RandomItemUtil {
    private static final Set<class_1792> BLACKLIST = Set.of(class_1802.field_8827, class_1802.field_8077, class_1802.field_8542, class_1802.field_8238, class_1802.field_16538, class_1802.field_8615, class_1802.field_8866, class_1802.field_8799, class_1802.field_8468, class_1802.field_8688, class_1802.field_30904);
    private static final Set<class_1792> NETHER_ITEMS = Set.of(class_1802.field_8328, class_1802.field_22000, class_1802.field_29024, class_1802.field_23843, class_1802.field_23848, class_1802.field_23837, class_1802.field_20398, class_1802.field_20410, class_1802.field_8354, class_1802.field_22013, class_1802.field_22015, class_1802.field_8067, class_1802.field_21999, class_1802.field_8182, class_1802.field_22008, class_1802.field_22017, class_1802.field_21987, class_1802.field_21988, class_1802.field_21989, class_1802.field_21990, class_1802.field_21991, class_1802.field_21992, class_1802.field_23070, class_1802.field_21981, class_1802.field_21982, class_1802.field_22489, class_1802.field_22490, class_1802.field_21983, class_1802.field_21984, class_1802.field_22487, class_1802.field_22488, class_1802.field_22031, class_1802.field_22032, class_1802.field_8702, class_1802.field_23140, class_1802.field_22019, class_1802.field_8155, class_1802.field_8601, class_1802.field_8397);
    private static final Set<class_1792> END_ITEMS = Set.of(class_1802.field_20399, class_1802.field_20400, class_1802.field_20393, class_1802.field_8490, class_1802.field_8202, class_1802.field_8644, class_1802.field_8056, class_1802.field_8358, class_1802.field_8710, class_1802.field_8233, class_1802.field_8815);
    private static final List<class_1792> BASE_ALLOWED = RandomItemUtil.buildBaseAllowedPool();

    private static List<class_1792> buildBaseAllowedPool() {
        return class_7923.field_41178.method_10220().filter(item -> !BLACKLIST.contains(item)).filter(item -> {
            if (!(item instanceof class_1747)) {
                return true;
            }
            class_1747 bi = (class_1747)item;
            class_2248 b = bi.method_7711();
            if (b instanceof class_2343) {
                return false;
            }
            if (b instanceof class_2346) {
                return false;
            }
            if (b instanceof class_2482 || b instanceof class_2510 || b instanceof class_2354 || b instanceof class_2544 || b instanceof class_2349 || b instanceof class_2323 || b instanceof class_2533 || b instanceof class_2527 || b instanceof class_2577 || b instanceof class_2389 || b instanceof class_2244 || b instanceof class_2472 || b instanceof class_5544 || b instanceof class_2199) {
                return false;
            }
            return b.method_9564().method_26216();
        }).collect(Collectors.toCollection(ArrayList::new));
    }

    public static void SpawnItem(class_1937 world, class_2338 pos) {
        RandomItemUtil.spawnItemInternal(world, pos, null);
    }

    public static void SpawnItem(class_1937 world, class_2338 pos, UUID playerUuid) {
        RandomItemUtil.spawnItemInternal(world, pos, playerUuid);
    }

    private static void spawnItemInternal(class_1937 world, class_2338 pos, UUID playerUuid) {
        StateSaverAndLoader serverState = StateSaverAndLoader.getServerState(world.method_8503());
        int itemCount = serverState.getConfig().getItemDropCount();
        if (serverState.getConfig().isSpawnItemsInChest()) {
            RandomItemUtil.spawnItemInChest(world, pos, playerUuid, itemCount);
        } else {
            for (int i = 0; i < itemCount; ++i) {
                class_1799 itemStack = RandomItemUtil.getFilteredRandomItem(world, playerUuid, world.method_8409());
                class_1542 itemEntity = new class_1542(world, (double)pos.method_10263() + 0.5, (double)(pos.method_10264() + 1), (double)pos.method_10260() + 0.5, itemStack);
                itemEntity.method_18800(0.0, 0.0, 0.0);
                world.method_8649((class_1297)itemEntity);
            }
        }
    }

    private static void spawnItemInChest(class_1937 world, class_2338 pos, UUID playerUuid, int itemCount) {
        if (!(world instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)world;
        world.method_8501(pos, class_2246.field_10034.method_9564());
        class_2586 blockEntity = world.method_8321(pos);
        if (blockEntity instanceof class_2595) {
            class_2595 chest = (class_2595)blockEntity;
            int[] slots = new int[]{13, 12, 14, 11, 15, 10, 16, 9, 17, 8, 18, 7, 19, 6, 20, 5, 21, 4, 22, 3, 23, 2, 24, 1, 25, 0, 26};
            for (int i = 0; i < Math.min(itemCount, slots.length); ++i) {
                class_1799 itemStack = RandomItemUtil.getFilteredRandomItem(world, playerUuid, world.method_8409());
                chest.method_5447(slots[i], itemStack);
            }
            serverWorld.method_65096((class_2394)class_2398.field_11220, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 1.0, (double)pos.method_10260() + 0.5, 30, 0.4, 0.4, 0.4, 0.15);
            serverWorld.method_65096((class_2394)class_2398.field_11207, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 15, 0.2, 0.5, 0.2, 0.05);
            serverWorld.method_8396(null, pos, class_3417.field_26980, class_3419.field_15245, 1.0f, 1.5f);
        }
    }

    private static class_1799 getFilteredRandomItem(class_1937 world, UUID playerUuid, class_5819 random) {
        boolean endUnlocked;
        boolean netherUnlocked;
        StateSaverAndLoader state = StateSaverAndLoader.getServerState(world.method_8503());
        int lavaBucketChance = state.getConfig().getLavaBucketChance();
        if (lavaBucketChance > 0 && random.method_43048(lavaBucketChance) == 0) {
            return new class_1799((class_1935)class_1802.field_8187);
        }
        List<Object> candidates = new ArrayList<class_1792>(BASE_ALLOWED);
        class_7923.field_41178.method_10220().filter(it -> !(it instanceof class_1747)).forEach(candidates::add);
        candidates = candidates.stream().distinct().toList();
        candidates = candidates.stream().filter(item -> !BLACKLIST.contains(item)).filter(item -> {
            class_1826 egg;
            return !(item instanceof class_1826 && RandomItemUtil.isBannedSpawnEgg(egg = (class_1826)item));
        }).collect(Collectors.toCollection(ArrayList::new));
        boolean mp = MultiplayerPackControl.isEnabled();
        boolean bl = mp ? state.hasVisitedNether(playerUuid == null ? RandomItemUtil.getAnyKnownPlayer(state) : playerUuid) : (netherUnlocked = state.anyoneVisitedNether());
        boolean bl2 = mp ? state.hasVisitedEnd(playerUuid == null ? RandomItemUtil.getAnyKnownPlayer(state) : playerUuid) : (endUnlocked = state.anyoneVisitedEnd());
        if (!netherUnlocked) {
            candidates.removeAll(NETHER_ITEMS);
        } else {
            candidates.addAll(NETHER_ITEMS);
        }
        if (!endUnlocked) {
            candidates.removeAll(END_ITEMS);
        } else {
            candidates.addAll(END_ITEMS);
        }
        if (candidates.isEmpty()) {
            return new class_1799((class_1935)class_1802.field_8279);
        }
        return new class_1799((class_1935)candidates.get(random.method_43048(candidates.size())));
    }

    private static UUID getAnyKnownPlayer(StateSaverAndLoader state) {
        return state.getAllPlayerStats().keySet().stream().findFirst().orElse(new UUID(0L, 0L));
    }

    private static boolean isBannedSpawnEgg(class_1826 egg) {
        try {
            class_1799 stack = new class_1799((class_1935)egg);
            class_1299 type = egg.method_8015(stack);
            if (type == null) {
                return false;
            }
            return List.of(class_1299.field_6116, class_1299.field_6119, class_1299.field_38095).contains(type);
        }
        catch (Exception e) {
            return false;
        }
    }
}

