/*
 * Decompiled with CFR 0.152.
 */
package lynk.oneblock.worldgen;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.class_1937;
import net.minecraft.class_1966;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2826;
import net.minecraft.class_2902;
import net.minecraft.class_3233;
import net.minecraft.class_4208;
import net.minecraft.class_4543;
import net.minecraft.class_4966;
import net.minecraft.class_5138;
import net.minecraft.class_5217;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.class_5539;
import net.minecraft.class_6748;
import net.minecraft.class_7138;

public class PuzzleChunkGenerator
extends class_2794 {
    public static final MapCodec<PuzzleChunkGenerator> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_1966.field_24713.fieldOf("biome_source").forGetter(gen -> gen.field_12761), (App)Codec.INT.optionalFieldOf("island_radius", (Object)6).forGetter(gen -> gen.ISLAND_RADIUS), (App)Codec.INT.optionalFieldOf("island_thickness", (Object)2).forGetter(gen -> gen.ISLAND_THICKNESS), (App)Codec.INT.optionalFieldOf("island_top_y", (Object)64).forGetter(gen -> gen.ISLAND_TOP_Y)).apply((Applicative)instance, PuzzleChunkGenerator::new));
    private final int ISLAND_RADIUS;
    private final int ISLAND_THICKNESS;
    private final int ISLAND_TOP_Y;
    private static final int CENTER_X = 0;
    private static final int CENTER_Z = 0;
    private final Map<class_5321<class_1937>, Boolean> spawnSetPerDim = new HashMap<class_5321<class_1937>, Boolean>();
    private static final class_2680 BEDROCK = class_2246.field_9987.method_9564();

    public PuzzleChunkGenerator(class_1966 biomeSource, int islandRadius, int islandThickness, int islandTopY) {
        super(biomeSource);
        this.ISLAND_RADIUS = Math.max(1, islandRadius);
        this.ISLAND_THICKNESS = Math.max(1, islandThickness);
        this.ISLAND_TOP_Y = islandTopY;
    }

    public PuzzleChunkGenerator(class_1966 biomeSource) {
        this(biomeSource, 6, 2, 64);
    }

    protected MapCodec<? extends class_2794> method_28506() {
        return CODEC;
    }

    public CompletableFuture<class_2791> method_12088(class_6748 blender, class_7138 noiseConfig, class_5138 structureAccessor, class_2791 chunk) {
        return CompletableFuture.completedFuture(chunk);
    }

    public void method_12108(class_3233 region, long seed, class_7138 noiseConfig, class_4543 biomeAccess, class_5138 accessor, class_2791 chunk) {
    }

    public void method_12110(class_3233 region, class_5138 accessor, class_7138 noiseConfig, class_2791 chunk) {
    }

    public void method_12107(class_3233 region) {
    }

    public int method_12104() {
        return 384;
    }

    public int method_16398() {
        return 63;
    }

    public int method_33730() {
        return -64;
    }

    public int method_16397(int x, int z, class_2902.class_2903 type, class_5539 world, class_7138 noiseConfig) {
        return this.ISLAND_TOP_Y + 1;
    }

    public class_4966 method_26261(int x, int z, class_5539 world, class_7138 noiseConfig) {
        int minY = this.method_33730();
        int height = this.method_12104();
        class_2680[] states = new class_2680[height];
        for (int i = 0; i < height; ++i) {
            states[i] = class_2246.field_10124.method_9564();
        }
        return new class_4966(minY, states);
    }

    public void method_40450(List<String> text, class_7138 noiseConfig, class_2338 pos) {
        text.add("Puzzle Generator: Island");
        text.add("Center: (0, " + this.ISLAND_TOP_Y + ", 0)");
        text.add("Radius: " + this.ISLAND_RADIUS + " | Thickness: " + this.ISLAND_THICKNESS);
    }

    public void method_12102(class_5281 world, class_2791 chunk, class_5138 structureAccessor) {
        class_5321 dim;
        int chunkMinX = chunk.method_12004().method_8326();
        int chunkMinZ = chunk.method_12004().method_8328();
        int chunkMaxX = chunkMinX + 15;
        int chunkMaxZ = PuzzleChunkGenerator.chunkMaxZ(chunk);
        int minX = Math.max(0 - this.ISLAND_RADIUS, chunkMinX);
        int maxX = Math.min(0 + this.ISLAND_RADIUS, chunkMaxX);
        int minZ = Math.max(0 - this.ISLAND_RADIUS, chunkMinZ);
        int maxZ = Math.min(0 + this.ISLAND_RADIUS, chunkMaxZ);
        if (minX <= maxX && minZ <= maxZ) {
            int r2 = this.ISLAND_RADIUS * this.ISLAND_RADIUS;
            int topY = this.ISLAND_TOP_Y;
            int bottomY = this.ISLAND_TOP_Y - (this.ISLAND_THICKNESS - 1);
            for (int x = minX; x <= maxX; ++x) {
                int dx = x - 0;
                for (int z = minZ; z <= maxZ; ++z) {
                    int dz = z - 0;
                    if (dx * dx + dz * dz > r2) continue;
                    for (int y = bottomY; y < topY; ++y) {
                        PuzzleChunkGenerator.setBlockStateInChunk(chunk, new class_2338(x, y, z), BEDROCK);
                    }
                    PuzzleChunkGenerator.setBlockStateInChunk(chunk, new class_2338(x, topY, z), BEDROCK);
                }
            }
        }
        if (!Boolean.TRUE.equals(this.spawnSetPerDim.get(dim = world.method_8410().method_27983()))) {
            class_4208 globalPos = new class_4208(dim, new class_2338(0, this.ISLAND_TOP_Y + 1, 0));
            world.method_8410().method_27873(new class_5217.class_12064(globalPos, 0.5f, 0.0f));
            this.spawnSetPerDim.put((class_5321<class_1937>)dim, true);
        }
    }

    private static int chunkMaxZ(class_2791 chunk) {
        return chunk.method_12004().method_8328() + 15;
    }

    private static void setBlockStateInChunk(class_2791 chunk, class_2338 pos, class_2680 state) {
        int y = pos.method_10264();
        int sectionY = chunk.method_31602(y);
        if (sectionY < 0 || sectionY >= chunk.method_12006().length) {
            return;
        }
        class_2826 section = chunk.method_38259(sectionY);
        int lx = pos.method_10263() & 0xF;
        int ly = y & 0xF;
        int lz = pos.method_10260() & 0xF;
        section.method_12256(lx, ly, lz, state, false);
    }
}

