/*
 * Decompiled with CFR 0.152.
 */
package lynk.oneblock.events;

import java.util.ArrayList;
import java.util.List;
import lynk.oneblock.persit.StateSaverAndLoader;
import lynk.oneblock.worldgen.OneBlockChunkGenerator;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3730;
import net.minecraft.class_5819;

public class MobSpawn {
    private static int MAX_MOB_SIZE = 100;
    private static final List<class_1299<? extends class_1309>> ENEMIES = List.of(class_1299.field_6051, class_1299.field_6137, class_1299.field_6046, class_1299.field_6079, class_1299.field_6091, class_1299.field_6071, class_1299.field_6098);

    public static void setMobSpawn(class_1937 world) {
        if (world.method_8608()) {
            return;
        }
        StateSaverAndLoader state = StateSaverAndLoader.getServerState(world.method_8503());
        long breaks = MobSpawn.getBreakCount(state);
        int count = MobSpawn.getCountForBreaks(breaks, world.method_8409());
        int nextCooldown = MobSpawn.getCooldownForBreaks(breaks);
        List<class_1299<? extends class_1309>> pool = MobSpawn.getPoolForBreaks(breaks);
        state.setMobSpawnSet(true);
        state.setBreaksTillSpawn(nextCooldown);
        MobSpawn.announceToAll(world, (class_2561)class_2561.method_43470((String)("\u26a0 Monsters will appear after " + nextCooldown + " more block breaks...")));
        state.setPendingMobCount(count);
    }

    public static void spawnWaveNow(class_1937 world) {
        if (world.method_8608()) {
            return;
        }
        StateSaverAndLoader state = StateSaverAndLoader.getServerState(world.method_8503());
        long breaks = MobSpawn.getBreakCount(state);
        List<class_1299<? extends class_1309>> pool = MobSpawn.getPoolForBreaks(breaks);
        int count = state.PendingMobCount;
        class_2338 center = OneBlockChunkGenerator.getSpawnBlockPos().method_10084();
        MobSpawn.spawnWave(world, center, pool, count, 4, 8);
        MobSpawn.announceToAll(world, (class_2561)class_2561.method_43470((String)("A wave of " + count + " enemies has appeared!")));
        state.BreaksTillSpawn = MobSpawn.getCooldownForBreaks(breaks);
        state.MobSpawnSet = false;
    }

    private static int getCountForBreaks(long breaks, class_5819 random) {
        if (breaks < 100L) {
            return 1;
        }
        long stage = breaks / 100L;
        long maxMobs = Math.min(stage + 1L, (long)MAX_MOB_SIZE);
        return 1 + random.method_43048((int)maxMobs);
    }

    private static int getCooldownForBreaks(long breaks) {
        if (breaks < 500L) {
            return 12;
        }
        if (breaks < 1500L) {
            return 10;
        }
        if (breaks < 3000L) {
            return 8;
        }
        if (breaks < 5000L) {
            return 6;
        }
        if (breaks < 8000L) {
            return 5;
        }
        if (breaks < 12000L) {
            return 4;
        }
        return 3;
    }

    private static List<class_1299<? extends class_1309>> getPoolForBreaks(long breaks) {
        ArrayList<class_1299<? extends class_1309>> pool = new ArrayList<class_1299<? extends class_1309>>();
        if (breaks < 500L) {
            pool.add(class_1299.field_6051);
            pool.add(class_1299.field_6079);
            return pool;
        }
        pool.add(class_1299.field_6051);
        pool.add(class_1299.field_6079);
        pool.add((class_1299<? extends class_1309>)class_1299.field_6137);
        if (breaks >= 1500L) {
            pool.add((class_1299<? extends class_1309>)class_1299.field_6046);
            pool.add((class_1299<? extends class_1309>)class_1299.field_6071);
            pool.add((class_1299<? extends class_1309>)class_1299.field_6098);
        }
        if (breaks >= 3000L) {
            pool.add((class_1299<? extends class_1309>)class_1299.field_6091);
        }
        if (breaks >= 5000L) {
            pool.add((class_1299<? extends class_1309>)class_1299.field_6046);
        }
        if (breaks >= 8000L) {
            pool.add((class_1299<? extends class_1309>)class_1299.field_6091);
        }
        return pool;
    }

    private static void spawnWave(class_1937 world, class_2338 center, List<class_1299<? extends class_1309>> pool, int count, int radius, int maxTriesPerMob) {
        class_5819 rand = world.method_8409();
        for (int i = 0; i < count; ++i) {
            class_1309 entity;
            class_1299<? extends class_1309> type = MobSpawn.randomFrom(pool, rand);
            class_2338 spawnPos = MobSpawn.pickNearbySurface(world, center, radius, maxTriesPerMob);
            if (spawnPos == null) {
                spawnPos = center;
            }
            if ((entity = (class_1309)type.method_5883(world, class_3730.field_16471)) == null) continue;
            entity.method_5725(spawnPos, rand.method_43057() * 360.0f, 0.0f);
            world.method_8649((class_1297)entity);
        }
    }

    private static class_2338 pickNearbySurface(class_1937 world, class_2338 center, int radius, int tries) {
        class_5819 rand = world.method_8409();
        for (int t = 0; t < tries; ++t) {
            int dz;
            int dx = rand.method_39332(-radius, radius);
            if (dx * dx + (dz = rand.method_39332(-radius, radius)) * dz > radius * radius) continue;
            class_2338 pos = center.method_10069(dx, 0, dz);
            if (world.method_22347(pos)) {
                return pos;
            }
            if (!world.method_22347(pos.method_10084())) continue;
            return pos.method_10084();
        }
        return center;
    }

    private static <T> T randomFrom(List<T> list, class_5819 rnd) {
        return list.get(rnd.method_43048(list.size()));
    }

    private static long getBreakCount(StateSaverAndLoader state) {
        return state.totalOneBlockBreaks;
    }

    private static void announceToAll(class_1937 world, class_2561 message) {
        if (world.method_8503() == null) {
            return;
        }
        for (class_3222 player : world.method_8503().method_3760().method_14571()) {
            player.method_7353(message, false);
        }
    }
}

