/*
 * Decompiled with CFR 0.152.
 */
package lynk.oneblock.config;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import lynk.oneblock.config.AdminPanelScreenHandler;
import lynk.oneblock.config.OneBlockConfig;
import lynk.oneblock.persit.StateSaverAndLoader;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.class_7157;
import net.minecraft.class_747;

public final class AdminCommand {
    private AdminCommand() {
    }

    public static void register() {
        CommandRegistrationCallback.EVENT.register(AdminCommand::onRegister);
    }

    private static void onRegister(CommandDispatcher<class_2168> dispatcher, class_7157 access, class_2170.class_5364 env) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"oneblock").requires(src -> src.method_9259(2))).then(class_2170.method_9247((String)"admin").executes(ctx -> AdminCommand.openAdminPanel((class_2168)ctx.getSource())))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"config").then(class_2170.method_9247((String)"get").then(class_2170.method_9244((String)"setting", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            builder.suggest("waveChance");
            builder.suggest("itemDropChance");
            builder.suggest("friendlyMobChance");
            builder.suggest("endPortalFrameChance");
            builder.suggest("mobWavesEnabled");
            builder.suggest("itemDropsEnabled");
            return builder.buildFuture();
        }).executes(ctx -> AdminCommand.getSetting((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"setting")))))).then(class_2170.method_9247((String)"set").then(class_2170.method_9244((String)"setting", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            builder.suggest("waveChance");
            builder.suggest("itemDropChance");
            builder.suggest("friendlyMobChance");
            builder.suggest("endPortalFrameChance");
            builder.suggest("endPortalFrameRequirement");
            builder.suggest("maxWaveSize");
            builder.suggest("waveSizeDivisor");
            builder.suggest("progressionCap");
            return builder.buildFuture();
        }).then(class_2170.method_9244((String)"value", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> AdminCommand.setSetting((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"setting"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"value"))))))).then(class_2170.method_9247((String)"toggle").then(class_2170.method_9244((String)"feature", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            builder.suggest("mobWaves");
            builder.suggest("itemDrops");
            builder.suggest("friendlyMobs");
            builder.suggest("endPortalFrame");
            return builder.buildFuture();
        }).executes(ctx -> AdminCommand.toggleFeature((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"feature")))))).then(class_2170.method_9247((String)"reset").executes(ctx -> AdminCommand.resetConfig((class_2168)ctx.getSource())))).then(class_2170.method_9247((String)"list").executes(ctx -> AdminCommand.listSettings((class_2168)ctx.getSource())))));
    }

    private static int openAdminPanel(class_2168 src) {
        class_1297 class_12972 = src.method_9228();
        if (!(class_12972 instanceof class_3222)) {
            src.method_9213((class_2561)class_2561.method_43470((String)"\u00a7cThis command can only be used by players"));
            return 0;
        }
        class_3222 player = (class_3222)class_12972;
        player.method_17355((class_3908)new class_747((syncId, playerInventory, playerEntity) -> new AdminPanelScreenHandler(syncId, playerInventory, player), (class_2561)class_2561.method_43470((String)"\u00a76\u00a7lOneBlock Admin Panel")));
        return 1;
    }

    private static int getSetting(class_2168 src, String setting) {
        OneBlockConfig config = StateSaverAndLoader.getServerState(src.method_9211()).getConfig();
        String value = switch (setting.toLowerCase()) {
            case "wavechance" -> "1 in " + config.getWaveChance();
            case "itemdropchance" -> "1 in " + config.getItemDropChance();
            case "friendlymobchance" -> "1 in " + config.getFriendlyMobChance();
            case "endportalframechance" -> "1 in " + config.getEndPortalFrameChance();
            case "endportalframerequirement" -> String.valueOf(config.getEndPortalFrameRequirement());
            case "maxwavesize" -> String.valueOf(config.getMaxWaveSize());
            case "wavesizedivisor" -> String.valueOf(config.getWaveSizeDivisor());
            case "progressioncap" -> String.valueOf(config.getProgressionCap());
            case "mobwavesenabled" -> String.valueOf(config.areMobWavesEnabled());
            case "itemdropsenabled" -> String.valueOf(config.areItemDropsEnabled());
            case "friendlymobsenabled" -> String.valueOf(config.areFriendlyMobsEnabled());
            case "endportalframeenabled" -> String.valueOf(config.isEndPortalFrameEnabled());
            default -> "Unknown setting";
        };
        src.method_45068((class_2561)class_2561.method_43470((String)("\u00a7e[OneBlock Config] \u00a77" + setting + ": \u00a7b" + value)));
        return 1;
    }

    private static int setSetting(class_2168 src, String setting, int value) {
        boolean success;
        OneBlockConfig config = StateSaverAndLoader.getServerState(src.method_9211()).getConfig();
        switch (setting.toLowerCase()) {
            case "wavechance": {
                config.setWaveChance(value);
                boolean bl = true;
                break;
            }
            case "itemdropchance": {
                config.setItemDropChance(value);
                boolean bl = true;
                break;
            }
            case "friendlymobchance": {
                config.setFriendlyMobChance(value);
                boolean bl = true;
                break;
            }
            case "endportalframechance": {
                config.setEndPortalFrameChance(value);
                boolean bl = true;
                break;
            }
            case "endportalframerequirement": {
                config.setEndPortalFrameRequirement(value);
                boolean bl = true;
                break;
            }
            case "maxwavesize": {
                config.setMaxWaveSize(value);
                boolean bl = true;
                break;
            }
            case "wavesizedivisor": {
                config.setWaveSizeDivisor(value);
                boolean bl = true;
                break;
            }
            case "progressioncap": {
                config.setProgressionCap(value);
                boolean bl = true;
                break;
            }
            default: {
                boolean bl = success = false;
            }
        }
        if (success) {
            StateSaverAndLoader.getServerState(src.method_9211()).method_80();
            src.method_45068((class_2561)class_2561.method_43470((String)("\u00a7a[OneBlock Config] \u00a77Set " + setting + " to " + value)));
            return 1;
        }
        src.method_9213((class_2561)class_2561.method_43470((String)("\u00a7c[OneBlock Config] Unknown setting: " + setting)));
        return 0;
    }

    private static int toggleFeature(class_2168 src, String feature) {
        OneBlockConfig config = StateSaverAndLoader.getServerState(src.method_9211()).getConfig();
        boolean newValue = switch (feature.toLowerCase()) {
            case "mobwaves" -> {
                config.setMobWavesEnabled(!config.areMobWavesEnabled());
                yield config.areMobWavesEnabled();
            }
            case "itemdrops" -> {
                config.setItemDropsEnabled(!config.areItemDropsEnabled());
                yield config.areItemDropsEnabled();
            }
            case "friendlymobs" -> {
                config.setFriendlyMobsEnabled(!config.areFriendlyMobsEnabled());
                yield config.areFriendlyMobsEnabled();
            }
            case "endportalframe" -> {
                config.setEndPortalFrameEnabled(!config.isEndPortalFrameEnabled());
                yield config.isEndPortalFrameEnabled();
            }
            default -> {
                src.method_9213((class_2561)class_2561.method_43470((String)("\u00a7c[OneBlock Config] Unknown feature: " + feature)));
                yield false;
            }
        };
        StateSaverAndLoader.getServerState(src.method_9211()).method_80();
        String status = newValue ? "\u00a7aenabled" : "\u00a7cdisabled";
        src.method_45068((class_2561)class_2561.method_43470((String)("\u00a7e[OneBlock Config] \u00a77" + feature + " is now " + status)));
        return 1;
    }

    private static int resetConfig(class_2168 src) {
        OneBlockConfig config = StateSaverAndLoader.getServerState(src.method_9211()).getConfig();
        config.resetToDefaults();
        StateSaverAndLoader.getServerState(src.method_9211()).method_80();
        src.method_45068((class_2561)class_2561.method_43470((String)"\u00a7a[OneBlock Config] \u00a77All settings reset to defaults"));
        return 1;
    }

    private static int listSettings(class_2168 src) {
        OneBlockConfig config = StateSaverAndLoader.getServerState(src.method_9211()).getConfig();
        src.method_45068((class_2561)class_2561.method_43470((String)"\u00a7e\u00a7l[OneBlock Configuration]"));
        src.method_45068((class_2561)class_2561.method_43470((String)("\u00a77Wave Chance: \u00a7b1 in " + config.getWaveChance() + " \u00a77(Enabled: " + (config.areMobWavesEnabled() ? "\u00a7aYes\u00a77)" : "\u00a7cNo\u00a77)"))));
        src.method_45068((class_2561)class_2561.method_43470((String)("\u00a77Item Drop Chance: \u00a7b1 in " + config.getItemDropChance() + " \u00a77(Enabled: " + (config.areItemDropsEnabled() ? "\u00a7aYes\u00a77)" : "\u00a7cNo\u00a77)"))));
        src.method_45068((class_2561)class_2561.method_43470((String)("\u00a77Friendly Mob Chance: \u00a7b1 in " + config.getFriendlyMobChance() + " \u00a77(Enabled: " + (config.areFriendlyMobsEnabled() ? "\u00a7aYes\u00a77)" : "\u00a7cNo\u00a77)"))));
        src.method_45068((class_2561)class_2561.method_43470((String)("\u00a77End Portal Frame Chance: \u00a7b1 in " + config.getEndPortalFrameChance() + " \u00a77(Enabled: " + (config.isEndPortalFrameEnabled() ? "\u00a7aYes\u00a77)" : "\u00a7cNo\u00a77)"))));
        src.method_45068((class_2561)class_2561.method_43470((String)("\u00a77End Portal Frame Requirement: \u00a7b" + config.getEndPortalFrameRequirement() + " breaks")));
        src.method_45068((class_2561)class_2561.method_43470((String)("\u00a77Max Wave Size: \u00a7b" + config.getMaxWaveSize())));
        src.method_45068((class_2561)class_2561.method_43470((String)("\u00a77Wave Size Divisor: \u00a7b" + config.getWaveSizeDivisor())));
        src.method_45068((class_2561)class_2561.method_43470((String)("\u00a77Progression Cap: \u00a7b" + config.getProgressionCap() + " breaks")));
        src.method_45068((class_2561)class_2561.method_43470((String)"\u00a77"));
        src.method_45068((class_2561)class_2561.method_43470((String)"\u00a77Use \u00a7b/oneblock config set <setting> <value>\u00a77 to change settings"));
        src.method_45068((class_2561)class_2561.method_43470((String)"\u00a77Use \u00a7b/oneblock config toggle <feature>\u00a77 to toggle features"));
        return 1;
    }
}

