/*
 * Decompiled with CFR 0.152.
 */
package lynk.oneblock.server;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import lynk.oneblock.datapack.MultiplayerPackControl;
import lynk.oneblock.persit.StateSaverAndLoader;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3486;
import net.minecraft.class_5321;

public class OneBlockSafety {
    private static final Map<class_2338, Long> lastRegenerateTime = new ConcurrentHashMap<class_2338, Long>();
    private static final long REGENERATE_COOLDOWN = 100L;

    private OneBlockSafety() {
    }

    public static void tick(class_3218 world) {
        if (world.method_27983() != class_1937.field_25179) {
            return;
        }
        StateSaverAndLoader state = StateSaverAndLoader.getServerState(world.method_8503());
        if (MultiplayerPackControl.isEnabled()) {
            state.forEachPlayer((uuid, stats) -> {
                class_2338 pos = stats.oneBlockPos;
                if (pos == null) {
                    return;
                }
                if (!world.method_22340(pos)) {
                    return;
                }
                if (!stats.islandGenerated) {
                    return;
                }
                OneBlockSafety.checkAndRespawnOneBlock(world, pos);
            });
        } else {
            UUID dummy = new UUID(0L, 0L);
            class_2338 pos = state.getOneBlockPos(dummy);
            if (pos == null) {
                return;
            }
            if (!world.method_22340(pos)) {
                return;
            }
            StateSaverAndLoader.PlayerStats stats2 = state.getStats(dummy);
            if (!stats2.islandGenerated) {
                return;
            }
            OneBlockSafety.checkAndRespawnOneBlock(world, pos);
        }
    }

    private static void checkAndRespawnOneBlock(class_3218 world, class_2338 pos) {
        boolean isAirOrWater;
        class_2680 bs = world.method_8320(pos);
        boolean bl = isAirOrWater = bs.method_26215() || bs.method_26227().method_15767(class_3486.field_15517);
        if (isAirOrWater) {
            long currentTime = world.method_8510();
            Long lastTime = lastRegenerateTime.get(pos);
            if (lastTime == null || currentTime - lastTime > 100L) {
                OneBlockSafety.respawnOneBlock(world, pos);
                lastRegenerateTime.put(pos, currentTime);
            }
        }
    }

    private static void respawnOneBlock(class_3218 world, class_2338 pos) {
        class_2680 restore = OneBlockSafety.chooseOneBlockForDimension((class_5321<class_1937>)world.method_27983());
        world.method_8652(pos, restore, 3);
    }

    private static class_2680 chooseOneBlockForDimension(class_5321<class_1937> dim) {
        if (dim == class_1937.field_25180) {
            return class_2246.field_10515.method_9564();
        }
        if (dim == class_1937.field_25181) {
            return class_2246.field_10471.method_9564();
        }
        return class_2246.field_10219.method_9564();
    }
}

