/*
 * Decompiled with CFR 0.152.
 */
package lynk.oneblock.puzzle;

import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lynk.oneblock.puzzle.PuzzleLayout;
import lynk.oneblock.puzzle.PuzzleRegistry;
import lynk.oneblock.worldgen.OneBlockChunkGenerator;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2595;
import net.minecraft.class_2709;
import net.minecraft.class_2806;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5281;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;

public final class PuzzleService {
    private static final Map<class_5321<class_1937>, PuzzleLayout> PUZZLE_BY_DIM = new ConcurrentHashMap<class_5321<class_1937>, PuzzleLayout>();
    private static final Map<class_5321<class_1937>, class_2338> CENTER_BY_DIM = new ConcurrentHashMap<class_5321<class_1937>, class_2338>();
    private static final Map<class_5321<class_1937>, Integer> TOPY_BY_DIM = new ConcurrentHashMap<class_5321<class_1937>, Integer>();
    private static final Map<class_5321<class_1937>, Boolean> DONE_BY_DIM = new ConcurrentHashMap<class_5321<class_1937>, Boolean>();

    private PuzzleService() {
    }

    public static void ensureSelectedAndGenerated(class_3218 world, class_2338 center, int islandTopY) {
        PUZZLE_BY_DIM.computeIfAbsent((class_5321<class_1937>)world.method_27983(), k -> {
            PuzzleLayout p = PuzzleRegistry.random(world.method_8409());
            p.generate((class_5281)world, center, islandTopY);
            CENTER_BY_DIM.put((class_5321<class_1937>)k, center.method_10062());
            TOPY_BY_DIM.put((class_5321<class_1937>)k, islandTopY);
            return p;
        });
    }

    public static void onServerTick(MinecraftServer server) {
        for (class_3218 sw : server.method_3738()) {
            PuzzleLayout p;
            class_5321 dim = sw.method_27983();
            if (Boolean.TRUE.equals(DONE_BY_DIM.get(dim)) || (p = PUZZLE_BY_DIM.get(dim)) == null) continue;
            class_2338 center = CENTER_BY_DIM.get(dim);
            Integer topY = TOPY_BY_DIM.get(dim);
            if (center == null || topY == null || !p.isSolved(sw, center, topY)) continue;
            DONE_BY_DIM.put((class_5321<class_1937>)dim, true);
            PuzzleService.rewardAndExit(server, sw);
        }
    }

    private static void rewardAndExit(MinecraftServer server, class_3218 puzzleWorld) {
        class_3218 overworld = server.method_30002();
        if (overworld == null) {
            return;
        }
        class_2338 oneBlock = OneBlockChunkGenerator.getSpawnBlockPos();
        class_2338 chestPos = oneBlock.method_10084();
        int cx = oneBlock.method_10263() >> 4;
        int cz = oneBlock.method_10260() >> 4;
        overworld.method_8402(cx, cz, class_2806.field_12803, true);
        overworld.method_8652(chestPos, class_2246.field_10034.method_9564(), 3);
        class_2586 be = overworld.method_8321(chestPos);
        if (be instanceof class_2595) {
            class_2595 chest = (class_2595)be;
            chest.method_5447(0, new class_1799((class_1935)class_1802.field_8477, 3));
            chest.method_5447(1, new class_1799((class_1935)class_1802.field_8725, 16));
            chest.method_5447(2, new class_1799((class_1935)class_1802.field_8463, 1));
        }
        List<class_3222> players = List.copyOf(puzzleWorld.method_18456());
        for (class_3222 player : players) {
            player.method_48105(overworld, (double)oneBlock.method_10263() + 0.5, (double)oneBlock.method_10264() + 2.0, (double)oneBlock.method_10260() + 0.5, EnumSet.noneOf(class_2709.class), player.method_36454(), player.method_36455(), false);
            player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7aPuzzle solved! A reward chest appeared on your OneBlock."), false);
        }
    }

    public static void clear(class_5321<class_1937> dim) {
        PUZZLE_BY_DIM.remove(dim);
        CENTER_BY_DIM.remove(dim);
        TOPY_BY_DIM.remove(dim);
        DONE_BY_DIM.remove(dim);
    }
}

