/*
 * Decompiled with CFR 0.152.
 */
package lynk.oneblock.server;

import java.util.EnumSet;
import java.util.Optional;
import java.util.UUID;
import lynk.oneblock.datapack.MultiplayerPackControl;
import lynk.oneblock.events.FriendlySpawn;
import lynk.oneblock.events.MobSpawn;
import lynk.oneblock.persit.StateSaverAndLoader;
import lynk.oneblock.server.OneBlockSafety;
import lynk.oneblock.util.IslandBuilder;
import lynk.oneblock.util.MiscUtil;
import lynk.oneblock.util.RandomBlockUtil;
import lynk.oneblock.util.RandomItemUtil;
import lynk.oneblock.util.UpdateChecker;
import net.fabricmc.fabric.api.entity.event.v1.ServerEntityWorldChangeEvents;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2709;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4208;
import net.minecraft.class_5217;
import net.minecraft.server.MinecraftServer;

public final class Events {
    private static int tickCounter = 0;

    public static void register() {
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            UpdateChecker.checkNow(server);
            StateSaverAndLoader state = StateSaverAndLoader.getServerState(server);
            MultiplayerPackControl.refresh(server);
            state.migratePerPlayerIntoGlobalIfNeeded();
            System.out.println("[OneBlock] Aggregated per-player stats into global stats (multiplayer pack disabled).");
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            StateSaverAndLoader s = StateSaverAndLoader.getServerState(server);
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            boolean needsSpawn;
            class_3222 player = handler.field_14140;
            StateSaverAndLoader state = StateSaverAndLoader.getServerState(server);
            state.announceLegacyImport(server);
            class_2338 one = state.allocateOneBlockIfAbsent(player.method_5667());
            IslandBuilder.buildIfMissing(player.method_51469(), one);
            boolean bl = needsSpawn = player.method_67564() == null;
            if (needsSpawn) {
                class_2338 blockPos = state.getOneBlockPos(player.method_5667());
                player.method_51469();
                class_4208 globalPos = new class_4208(class_3218.field_25179, blockPos);
                class_5217.class_12064 spawnPoint = new class_5217.class_12064(globalPos, 0.0f, 0.0f);
                class_3222.class_10766 respawn = new class_3222.class_10766(spawnPoint, true);
                player.method_26284(respawn, true);
            }
            if (player.method_24515().method_10262((class_2382)one) > 256.0) {
                player.method_6082((double)one.method_10263() + 0.5, (double)(one.method_10264() + 1), (double)one.method_10260() + 0.5, true);
            }
            player.method_7353((class_2561)class_2561.method_43470((String)String.format("\u00a7e[OneBlock] \u00a77Your island is at \u00a7b(%d, %d, %d)", one.method_10263(), one.method_10264(), one.method_10260())), false);
        });
        PlayerBlockBreakEvents.BEFORE.register((world, player, pos, state, blockEntity) -> {
            if (world.method_8608()) {
                return true;
            }
            StateSaverAndLoader ssal = StateSaverAndLoader.getServerState(world.method_8503());
            if (ssal.isPlayersOneBlock(player.method_5667(), pos)) {
                return true;
            }
            Optional<UUID> owner = ssal.findOwnerByOneBlockPos(pos);
            if (owner.isPresent() && !owner.get().equals(player.method_5667())) {
                player.method_7353((class_2561)class_2561.method_43470((String)"\u00a7cYou can only break your own OneBlock."), true);
                return false;
            }
            return true;
        });
        PlayerBlockBreakEvents.AFTER.register((world, player, pos, state, entity) -> {
            StateSaverAndLoader serverState = StateSaverAndLoader.getServerState(world.method_8503());
            if (serverState.isPlayersOneBlock(player.method_5667(), pos)) {
                Events.handleOneBlockBreak(world, player);
            }
        });
        ServerTickEvents.END_WORLD_TICK.register(world -> {
            if (world.method_27983() != class_1937.field_25179) {
                return;
            }
            OneBlockSafety.tick(world);
            int PERIOD = 200;
            if (world.method_8510() % 200L == 0L) {
                world.method_17983().method_125();
            }
        });
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            if (++tickCounter >= 36000) {
                UpdateChecker.checkNow(server);
                tickCounter = 0;
            }
        });
        ServerPlayerEvents.AFTER_RESPAWN.register((oldPlayer, newPlayer, alive) -> {
            if (newPlayer.method_67564() == null) {
                StateSaverAndLoader serverState = StateSaverAndLoader.getServerState(newPlayer.method_51469().method_8503());
                class_3218 targetWorld = newPlayer.method_51469();
                class_2338 one = serverState.getOneBlockPos(newPlayer.method_5667());
                newPlayer.method_48105(targetWorld, (double)one.method_10263() + 0.5, (double)(one.method_10264() + 1), (double)one.method_10260() + 0.5, EnumSet.noneOf(class_2709.class), 1.0f, 1.0f, true);
                newPlayer.method_33572(false);
                newPlayer.field_6017 = 0.0;
                newPlayer.method_7353((class_2561)class_2561.method_43470((String)"You respawned at the OneBlock."), false);
            }
        });
        ServerEntityWorldChangeEvents.AFTER_PLAYER_CHANGE_WORLD.register((player, origin, destination) -> {
            if (!(player instanceof class_3222)) {
                return;
            }
            class_3222 serverPlayer = player;
            MinecraftServer server = serverPlayer.method_51469().method_8503();
            if (server == null) {
                return;
            }
            StateSaverAndLoader state = StateSaverAndLoader.getServerState(server);
            boolean multiplayer = MultiplayerPackControl.isEnabled();
            if (destination.method_27983().equals(class_1937.field_25180) && !state.hasVisitedNether(serverPlayer.method_5667())) {
                state.markVisitedNether(serverPlayer.method_5667());
                if (multiplayer) {
                    serverPlayer.method_7353((class_2561)class_2561.method_43470((String)"\u00a77 [OneBlock] \u00a7cYou have entered the Nether. Nether blocks and monsters will now appear."), false);
                } else {
                    server.method_3760().method_43514((class_2561)class_2561.method_43470((String)"\u00a77 [OneBlock] \u00a7cThe Nether has been visited! Nether blocks and monsters will now appear in the One Block."), false);
                }
            }
            if (destination.method_27983().equals(class_1937.field_25181) && !state.hasVisitedEnd(serverPlayer.method_5667())) {
                state.markVisitedEnd(serverPlayer.method_5667());
                if (multiplayer) {
                    serverPlayer.method_7353((class_2561)class_2561.method_43470((String)"\u00a77 [OneBlock] \u00a75 You have entered the End. End blocks and monsters will now appear."), false);
                } else {
                    server.method_3760().method_43514((class_2561)class_2561.method_43470((String)"\u00a77 [OneBlock] \u00a75 The End has been visited! End blocks and monsters will now appear."), false);
                }
            }
        });
    }

    public static void handleOneBlockBreak(class_1937 world, class_1657 player) {
        if (world.method_8608()) {
            return;
        }
        StateSaverAndLoader serverState = StateSaverAndLoader.getServerState(world.method_8503());
        UUID uuid = player.method_5667();
        class_2338 oneblockpos = serverState.getOneBlockPos(uuid);
        serverState.incrementBreaks(player.method_5667());
        Events.respawnOneBlock(world, uuid, oneblockpos);
        if (MiscUtil.AmILucky(world.method_8409(), 100, world.method_8407(), false)) {
            RandomItemUtil.SpawnItem(world, oneblockpos);
        }
        if (MiscUtil.AmILucky(world.method_8409(), 100, world.method_8407(), false)) {
            FriendlySpawn.spawn(world, oneblockpos);
        }
        if (!serverState.getMobSpawnSet(uuid) && MiscUtil.AmILucky(world.method_8409(), 100, world.method_8407(), true)) {
            MobSpawn.setMobSpawn(world, uuid);
        }
        if (serverState.getMobSpawnSet(uuid)) {
            if (serverState.getBreaksTillSpawn(uuid) == 0L) {
                MobSpawn.spawnWaveNow((class_3218)world, uuid);
            } else {
                serverState.decrementBreaksTillSpawn(uuid);
            }
        }
        if (serverState.getPlayerBlockBreaks(uuid) > 10000L && MiscUtil.AmILucky(world.method_8409(), 200, world.method_8407(), false)) {
            MiscUtil.SpawnBlock(world, class_2246.field_10398);
        }
    }

    private static void respawnOneBlock(class_1937 world, UUID uuid, class_2338 pos) {
        class_2248 randomBlock = RandomBlockUtil.getRandomSolidBlock(world, uuid, world.method_8409());
        class_2680 state = randomBlock.method_9564();
        world.method_8501(pos, state);
    }
}

