/*
 * Decompiled with CFR 0.152.
 */
package me.obkich.superignor;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerLoginEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class SuperIgnor
extends JavaPlugin
implements Listener,
TabCompleter {
    private List<String> mainUsers;
    private List<String> ignoredUsers;
    private String operationMode;
    private String kickType;
    private String kickCustomMessage;
    private List<String> kickRandomMessages;
    private final Random random = new Random();

    public void onEnable() {
        this.saveDefaultConfig();
        this.loadConfig();
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        this.getCommand("superignor").setExecutor((CommandExecutor)this);
        this.getCommand("superignor").setTabCompleter((TabCompleter)this);
        this.getLogger().info("SuperIgnor successfully enabled!");
        this.getLogger().info("Operation mode: " + this.operationMode);
        this.getLogger().info("Kick message type: " + this.kickType);
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        if (args.length > 0 && args[0].equalsIgnoreCase("reload")) {
            if (sender.hasPermission("superignor.admin")) {
                this.saveDefaultConfig();
                this.reloadConfig();
                this.loadConfig();
                sender.sendMessage("\u00a7aSuperIgnor config reloaded successfully!");
                return true;
            }
            sender.sendMessage("\u00a7cYou don't have permission for this command!");
            return true;
        }
        sender.sendMessage("\u00a7eUsage: /superignor reload");
        return true;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1 && sender.hasPermission("superignor.admin") && "reload".startsWith(args[0].toLowerCase())) {
            completions.add("reload");
        }
        return completions;
    }

    private void loadConfig() {
        FileConfiguration config = this.getConfig();
        this.operationMode = config.getString("operation-mode", "when_online");
        this.mainUsers = config.getStringList("main-users");
        this.ignoredUsers = config.getStringList("ignored-users");
        this.kickType = config.getString("kick-type", "custom");
        this.kickCustomMessage = config.getString("kick-custom-message", "\u00a7cYou cannot join the server!");
        this.kickRandomMessages = config.getStringList("kick-random-messages");
        this.getLogger().info("Operation mode: " + this.operationMode);
        this.getLogger().info("Loaded " + this.mainUsers.size() + " main users");
        this.getLogger().info("Loaded " + this.ignoredUsers.size() + " ignored users");
        this.getLogger().info("Loaded " + this.kickRandomMessages.size() + " random kick messages");
        if (this.mainUsers.isEmpty() && "when_online".equalsIgnoreCase(this.operationMode)) {
            this.getLogger().warning("No main users found in config but when_online mode is selected!");
        }
        if (this.ignoredUsers.isEmpty()) {
            this.getLogger().warning("No ignored users found in config!");
        }
        if (this.kickRandomMessages.isEmpty() && "random".equalsIgnoreCase(this.kickType)) {
            this.getLogger().warning("Random mode selected but no random kick messages found!");
        }
    }

    @EventHandler
    public void onPlayerLogin(PlayerLoginEvent event) {
        Player player = event.getPlayer();
        String playerName = player.getName();
        if (this.ignoredUsers.contains(playerName)) {
            boolean mainUserOnline;
            boolean shouldKick = false;
            if ("always".equalsIgnoreCase(this.operationMode)) {
                shouldKick = true;
                this.getLogger().info("Kicking " + playerName + " (always mode)");
            } else if ("when_online".equalsIgnoreCase(this.operationMode) && (mainUserOnline = this.isMainUserOnline())) {
                shouldKick = true;
                this.getLogger().info("Kicking " + playerName + " (main users online)");
            }
            if (shouldKick) {
                String kickMessage = this.getKickMessage();
                event.disallow(PlayerLoginEvent.Result.KICK_OTHER, kickMessage);
                this.getLogger().warning("Ignored player " + playerName + " was kicked from server");
            }
        }
    }

    private String getKickMessage() {
        if ("random".equalsIgnoreCase(this.kickType) && !this.kickRandomMessages.isEmpty()) {
            int index = this.random.nextInt(this.kickRandomMessages.size());
            return this.kickRandomMessages.get(index);
        }
        return this.kickCustomMessage;
    }

    private boolean isMainUserOnline() {
        for (String mainUser : this.mainUsers) {
            Player mainPlayer = Bukkit.getPlayerExact((String)mainUser);
            if (mainPlayer == null || !mainPlayer.isOnline()) continue;
            return true;
        }
        return false;
    }

    public void onDisable() {
        this.getLogger().info("SuperIgnor disabled!");
    }
}

