/*
 * Decompiled with CFR 0.152.
 */
package com.procurer;

import com.destroystokyo.paper.entity.Pathfinder;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Particle;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.entity.Rabbit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;
import org.bukkit.util.Vector;

public class BunnyTamingListener
implements Listener {
    private final JavaPlugin plugin;
    private final Map<UUID, TamedBunnySession> tamedBunnies = new HashMap<UUID, TamedBunnySession>();
    private final Random random = new Random();
    private final NamespacedKey TAMED_KEY;
    private final NamespacedKey OWNER_KEY;
    private final NamespacedKey SITTING_KEY;
    private static final double FOLLOW_DISTANCE = 3.0;
    private static final double TELEPORT_DISTANCE = 12.0;
    private static final double TAMING_CHANCE = 0.3;
    private static final double ENEMY_DETECTION_RANGE = 15.0;
    private static final double ENEMY_ATTACK_RANGE = 3.0;
    private static final double ENEMY_DAMAGE = 2.0;

    public BunnyTamingListener(JavaPlugin plugin) {
        this.plugin = plugin;
        this.TAMED_KEY = new NamespacedKey((Plugin)plugin, "bunny_tamed");
        this.OWNER_KEY = new NamespacedKey((Plugin)plugin, "bunny_owner");
        this.SITTING_KEY = new NamespacedKey((Plugin)plugin, "bunny_sitting");
    }

    @EventHandler
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        if (event.getHand() != null && event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        Player player = event.getPlayer();
        Entity entity = event.getRightClicked();
        ItemStack item = event.getPlayer().getInventory().getItemInMainHand();
        if (entity instanceof Rabbit) {
            Rabbit rabbit = (Rabbit)entity;
            PersistentDataContainer pdc = rabbit.getPersistentDataContainer();
            if (pdc.has(this.TAMED_KEY, PersistentDataType.BYTE)) {
                if (item == null || item.getType() == Material.AIR) {
                    this.handleTamedBunnyInteraction(player, rabbit);
                    event.setCancelled(true);
                }
                return;
            }
            if (item != null && item.getType() == Material.SWEET_BERRIES) {
                this.attemptTaming(player, rabbit, item);
                event.setCancelled(true);
            }
        }
    }

    private void attemptTaming(Player player, Rabbit rabbit, ItemStack item) {
        if (this.random.nextDouble() < 0.3) {
            this.tameBunny(player, rabbit);
            if (item.getAmount() > 1) {
                item.setAmount(item.getAmount() - 1);
            } else {
                player.getInventory().setItemInMainHand(new ItemStack(Material.AIR));
            }
        } else {
            this.spawnFailureParticles(rabbit);
            if (item.getAmount() > 1) {
                item.setAmount(item.getAmount() - 1);
            } else {
                player.getInventory().setItemInMainHand(new ItemStack(Material.AIR));
            }
            player.sendActionBar((Component)Component.text((String)"The bunny enjoyed the berry but isn't ready to be tamed yet..."));
        }
    }

    private void tameBunny(Player player, Rabbit rabbit) {
        PersistentDataContainer pdc = rabbit.getPersistentDataContainer();
        pdc.set(this.TAMED_KEY, PersistentDataType.BYTE, (Object)1);
        pdc.set(this.OWNER_KEY, PersistentDataType.STRING, (Object)player.getUniqueId().toString());
        pdc.set(this.SITTING_KEY, PersistentDataType.BYTE, (Object)0);
        rabbit.setAI(true);
        if (rabbit.customName() == null) {
            rabbit.customName((Component)Component.text((String)"Bunny"));
        }
        this.spawnTamingParticles(rabbit);
        rabbit.getWorld().playSound(rabbit.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 1.0f, 1.5f);
        String bunnyName = this.getBunnyName(rabbit);
        player.sendActionBar((Component)Component.text((String)("You have tamed " + bunnyName + "!")));
        this.startManagingBunny(player, rabbit);
        Bukkit.getScheduler().runTaskLater((Plugin)this.plugin, () -> {
            TamedBunnySession session = this.tamedBunnies.get(rabbit.getUniqueId());
            if (session != null) {
                this.removeFleeGoals(rabbit, session);
            }
        }, 1L);
    }

    private void handleTamedBunnyInteraction(Player player, Rabbit rabbit) {
        if (!this.isOwner(player, rabbit)) {
            player.sendActionBar((Component)Component.text((String)"This bunny belongs to someone else!"));
            return;
        }
        PersistentDataContainer pdc = rabbit.getPersistentDataContainer();
        byte currentSittingByte = (Byte)pdc.getOrDefault(this.SITTING_KEY, PersistentDataType.BYTE, (Object)0);
        boolean currentlySitting = currentSittingByte == 1;
        boolean newSittingState = !currentlySitting;
        byte newSittingByte = newSittingState ? (byte)1 : 0;
        pdc.set(this.SITTING_KEY, PersistentDataType.BYTE, (Object)newSittingByte);
        if (newSittingState) {
            rabbit.setAI(false);
            rabbit.setVelocity(new Vector(0, 0, 0));
            rabbit.setGravity(true);
        } else {
            rabbit.setAI(true);
            rabbit.setGravity(true);
        }
        String bunnyName = this.getBunnyName(rabbit);
        String action = newSittingState ? "sitting" : "standing";
        player.sendActionBar((Component)Component.text((String)(bunnyName + " is now " + action)));
        rabbit.getWorld().playSound(rabbit.getLocation(), Sound.ENTITY_RABBIT_AMBIENT, 0.5f, 1.0f);
    }

    private void startManagingBunny(Player player, Rabbit rabbit) {
        UUID playerId = player.getUniqueId();
        UUID bunnyId = rabbit.getUniqueId();
        TamedBunnySession session = new TamedBunnySession(bunnyId);
        this.tamedBunnies.put(bunnyId, session);
        BukkitTask task = Bukkit.getScheduler().runTaskTimer((Plugin)this.plugin, () -> {
            boolean isSitting;
            if (!rabbit.isValid() || rabbit.isDead()) {
                this.stopManagingBunny(bunnyId);
                return;
            }
            PersistentDataContainer pdc = rabbit.getPersistentDataContainer();
            String ownerIdString = (String)pdc.get(this.OWNER_KEY, PersistentDataType.STRING);
            if (ownerIdString == null) {
                this.stopManagingBunny(bunnyId);
                return;
            }
            Player owner = Bukkit.getPlayer((UUID)UUID.fromString(ownerIdString));
            if (owner == null || !owner.isOnline()) {
                return;
            }
            byte sittingByte = (Byte)pdc.getOrDefault(this.SITTING_KEY, PersistentDataType.BYTE, (Object)0);
            boolean bl = isSitting = sittingByte == 1;
            if (isSitting) {
                if (rabbit.hasAI()) {
                    rabbit.setAI(false);
                }
                rabbit.setVelocity(new Vector(0, 0, 0));
                return;
            }
            if (!session.isFleeGoalsRemoved()) {
                this.removeFleeGoals(rabbit, session);
            }
            this.handleBunnyMovement(owner, rabbit, session);
        }, 0L, 10L);
        session.setTask(task);
    }

    private void handleBunnyMovement(Player owner, Rabbit rabbit, TamedBunnySession session) {
        LivingEntity nearestEnemy;
        Location bunnyLoc;
        Location ownerLoc = owner.getLocation();
        double distanceToOwner = ownerLoc.distance(bunnyLoc = rabbit.getLocation());
        if (distanceToOwner > 12.0) {
            Location teleportLoc = this.findSafeTeleportLocation(ownerLoc);
            if (teleportLoc != null) {
                rabbit.teleport(teleportLoc);
                this.spawnTeleportParticles(teleportLoc);
                session.setCurrentTarget(null);
            }
            return;
        }
        if (!rabbit.hasAI()) {
            rabbit.setAI(true);
        }
        if ((nearestEnemy = this.findNearestEnemy(rabbit, session)) != null) {
            session.setCurrentTarget(nearestEnemy);
            Location enemyLoc = nearestEnemy.getLocation();
            double distanceToEnemy = bunnyLoc.distance(enemyLoc);
            if (distanceToEnemy <= 3.0) {
                this.performAttack(rabbit, nearestEnemy, session);
                return;
            }
            if (distanceToEnemy <= 15.0) {
                this.usePathfinderToMoveToTarget(rabbit, enemyLoc);
                return;
            }
        }
        if (distanceToOwner > 3.0) {
            this.usePathfinderToMoveToTarget(rabbit, ownerLoc);
        }
    }

    private void usePathfinderToMoveToTarget(Rabbit rabbit, Location targetLoc) {
        try {
            Pathfinder pathfinder = rabbit.getPathfinder();
            if (pathfinder != null) {
                double speed = 1.2;
                pathfinder.moveTo(targetLoc, speed);
            } else {
                this.fallbackMovement(rabbit, targetLoc);
            }
        }
        catch (Exception e) {
            this.fallbackMovement(rabbit, targetLoc);
        }
    }

    private void fallbackMovement(Rabbit rabbit, Location targetLoc) {
        Location bunnyLoc = rabbit.getLocation();
        Vector direction = targetLoc.toVector().subtract(bunnyLoc.toVector());
        if (direction.lengthSquared() > 0.0) {
            direction.normalize();
            Vector velocity = direction.multiply(0.4);
            velocity.setY(0.15);
            rabbit.setVelocity(velocity);
        }
    }

    private void removeFleeGoals(Rabbit rabbit, TamedBunnySession session) {
        if (session.isFleeGoalsRemoved()) {
            return;
        }
        try {
            Field[] inner;
            String name;
            Object nmsEntity = rabbit.getClass().getMethod("getHandle", new Class[0]).invoke((Object)rabbit, new Object[0]);
            Field goalSelectorField = null;
            Field targetSelectorField = null;
            for (Field f : nmsEntity.getClass().getFields()) {
                name = f.getName();
                if (goalSelectorField == null && (name.equalsIgnoreCase("bP") || name.toLowerCase().contains("goalselector"))) {
                    goalSelectorField = f;
                }
                if (targetSelectorField != null || !name.equalsIgnoreCase("bQ") && !name.toLowerCase().contains("targetselector")) continue;
                targetSelectorField = f;
            }
            if (goalSelectorField == null) {
                for (Field f : nmsEntity.getClass().getDeclaredFields()) {
                    name = f.getName();
                    if (goalSelectorField == null && (name.equalsIgnoreCase("bP") || name.toLowerCase().contains("goalselector"))) {
                        goalSelectorField = f;
                    }
                    if (targetSelectorField != null || !name.equalsIgnoreCase("bQ") && !name.toLowerCase().contains("targetselector")) continue;
                    targetSelectorField = f;
                }
            }
            if (goalSelectorField == null) {
                session.setFleeGoalsRemoved(true);
                return;
            }
            goalSelectorField.setAccessible(true);
            Object goalSelector = goalSelectorField.get(nmsEntity);
            for (Field innerField : inner = goalSelector.getClass().getDeclaredFields()) {
                innerField.setAccessible(true);
                Object value = innerField.get(goalSelector);
                if (!(value instanceof Iterable)) continue;
                Iterable iterable = (Iterable)value;
                try {
                    Iterator it = iterable.iterator();
                    while (it.hasNext()) {
                        String clsName;
                        Object wrapped = it.next();
                        if (wrapped == null || !(clsName = wrapped.getClass().getName().toLowerCase()).contains("panic") && !clsName.contains("flee") && !clsName.contains("avoid")) continue;
                        it.remove();
                    }
                }
                catch (UnsupportedOperationException unsupportedOperationException) {
                    // empty catch block
                }
            }
            session.setFleeGoalsRemoved(true);
        }
        catch (Exception e) {
            session.setFleeGoalsRemoved(true);
        }
    }

    private Location findSafeTeleportLocation(Location playerLocation) {
        for (int x = -3; x <= 3; ++x) {
            for (int z = -3; z <= 3; ++z) {
                for (int y = -1; y <= 2; ++y) {
                    Location testLoc = playerLocation.clone().add((double)x, (double)y, (double)z);
                    if (!this.isSafeLocation(testLoc)) continue;
                    return testLoc;
                }
            }
        }
        return playerLocation;
    }

    private boolean isSafeLocation(Location location) {
        return !location.getBlock().getType().isSolid() && !location.clone().add(0.0, 1.0, 0.0).getBlock().getType().isSolid();
    }

    private void stopManagingBunny(UUID bunnyId) {
        TamedBunnySession session = this.tamedBunnies.remove(bunnyId);
        if (session != null && session.getTask() != null) {
            session.getTask().cancel();
        }
    }

    private boolean isOwner(Player player, Rabbit rabbit) {
        PersistentDataContainer pdc = rabbit.getPersistentDataContainer();
        String ownerIdString = (String)pdc.get(this.OWNER_KEY, PersistentDataType.STRING);
        if (ownerIdString == null) {
            return false;
        }
        return player.getUniqueId().toString().equals(ownerIdString);
    }

    private String getBunnyName(Rabbit rabbit) {
        Component customName = rabbit.customName();
        if (customName != null) {
            return PlainTextComponentSerializer.plainText().serialize(customName);
        }
        return "Bunny";
    }

    private void spawnTamingParticles(Rabbit rabbit) {
        Location location = rabbit.getLocation().add(0.0, 0.5, 0.0);
        rabbit.getWorld().spawnParticle(Particle.HEART, location, 5, 0.3, 0.3, 0.3, 0.0);
    }

    private void spawnFailureParticles(Rabbit rabbit) {
        Location location = rabbit.getLocation().add(0.0, 0.5, 0.0);
        rabbit.getWorld().spawnParticle(Particle.ANGRY_VILLAGER, location, 3, 0.2, 0.2, 0.2, 0.0);
    }

    private void spawnTeleportParticles(Location location) {
        location.getWorld().spawnParticle(Particle.PORTAL, location, 10, 0.3, 0.5, 0.3, 0.1);
    }

    private LivingEntity findNearestEnemy(Rabbit rabbit, TamedBunnySession session) {
        double currentTargetDistance;
        Location bunnyLoc = rabbit.getLocation();
        LivingEntity nearestEnemy = null;
        double nearestDistance = 15.0;
        if (session.getCurrentTarget() != null && session.getCurrentTarget().isValid() && !session.getCurrentTarget().isDead() && (currentTargetDistance = bunnyLoc.distance(session.getCurrentTarget().getLocation())) <= 15.0) {
            nearestEnemy = session.getCurrentTarget();
            nearestDistance = currentTargetDistance;
        }
        for (Entity entity : rabbit.getNearbyEntities(15.0, 15.0, 15.0)) {
            double distance;
            LivingEntity livingEntity;
            if (!(entity instanceof Monster) || !(entity instanceof LivingEntity) || !(livingEntity = (LivingEntity)entity).isValid() || livingEntity.isDead() || !((distance = bunnyLoc.distance(livingEntity.getLocation())) < nearestDistance)) continue;
            nearestEnemy = livingEntity;
            nearestDistance = distance;
        }
        return nearestEnemy;
    }

    private void performAttack(Rabbit rabbit, LivingEntity target, TamedBunnySession session) {
        long currentTime = System.currentTimeMillis();
        if (currentTime - session.getLastAttackTime() < 1000L) {
            return;
        }
        Location bunnyLoc = rabbit.getLocation().add(0.0, 0.5, 0.0);
        Location targetLoc = target.getLocation().add(0.0, 0.5, 0.0);
        this.spawnRainbowParticles(bunnyLoc, targetLoc);
        rabbit.getWorld().playSound(bunnyLoc, Sound.ENTITY_FIREWORK_ROCKET_BLAST, 0.8f, 1.2f);
        target.damage(2.0);
        target.getWorld().spawnParticle(Particle.EXPLOSION, targetLoc, 3, 0.2, 0.2, 0.2, 0.1);
        session.setLastAttackTime(currentTime);
        if (target.isDead() || target.getHealth() <= 0.0) {
            session.setCurrentTarget(null);
        }
    }

    private void spawnRainbowParticles(Location start, Location end) {
        Vector direction = end.toVector().subtract(start.toVector());
        double length = direction.length();
        direction.normalize();
        for (double i = 0.0; i < length; i += 0.3) {
            Location particleLoc = start.clone().add(direction.clone().multiply(i));
            Particle[] rainbowParticles = new Particle[]{Particle.DUST, Particle.DUST, Particle.DUST, Particle.DUST, Particle.DUST, Particle.DUST};
            Particle.DustOptions[] colors = new Particle.DustOptions[]{new Particle.DustOptions(Color.RED, 1.0f), new Particle.DustOptions(Color.ORANGE, 1.0f), new Particle.DustOptions(Color.YELLOW, 1.0f), new Particle.DustOptions(Color.GREEN, 1.0f), new Particle.DustOptions(Color.BLUE, 1.0f), new Particle.DustOptions(Color.PURPLE, 1.0f)};
            int colorIndex = (int)(i * 2.0) % colors.length;
            start.getWorld().spawnParticle(Particle.DUST, particleLoc, 2, 0.1, 0.1, 0.1, 0.0, (Object)colors[colorIndex]);
        }
    }

    public void cleanup() {
        for (TamedBunnySession session : this.tamedBunnies.values()) {
            if (session.getTask() == null) continue;
            session.getTask().cancel();
        }
        this.tamedBunnies.clear();
    }

    private static class TamedBunnySession {
        private final UUID bunnyId;
        private BukkitTask task;
        private LivingEntity currentTarget;
        private long lastAttackTime;
        private boolean fleeGoalsRemoved;

        public TamedBunnySession(UUID bunnyId) {
            this.bunnyId = bunnyId;
            this.lastAttackTime = 0L;
            this.fleeGoalsRemoved = false;
        }

        public UUID getBunnyId() {
            return this.bunnyId;
        }

        public BukkitTask getTask() {
            return this.task;
        }

        public void setTask(BukkitTask task) {
            this.task = task;
        }

        public LivingEntity getCurrentTarget() {
            return this.currentTarget;
        }

        public void setCurrentTarget(LivingEntity target) {
            this.currentTarget = target;
        }

        public long getLastAttackTime() {
            return this.lastAttackTime;
        }

        public void setLastAttackTime(long time) {
            this.lastAttackTime = time;
        }

        public boolean isFleeGoalsRemoved() {
            return this.fleeGoalsRemoved;
        }

        public void setFleeGoalsRemoved(boolean removed) {
            this.fleeGoalsRemoved = removed;
        }
    }
}

