/*
 * Decompiled with CFR 0.152.
 */
package ws.siri.yarnwrap.mapping;

import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import net.fabricmc.mappingio.tree.MappingTree;
import org.jetbrains.annotations.NotNull;
import ws.siri.yarnwrap.mapping.JavaFunction;
import ws.siri.yarnwrap.mapping.JavaLike;
import ws.siri.yarnwrap.mapping.JavaObject;
import ws.siri.yarnwrap.mapping.JavaPackage;
import ws.siri.yarnwrap.mapping.MappingTree;
import ws.siri.yarnwrap.util.NullableOption;

public class JavaClass
implements JavaLike {
    private MappingTree.ClassMapping mapping = null;
    private HashMap<String, JavaClass> children = new HashMap();

    public MappingTree.ClassMapping getMapping() {
        return this.mapping;
    }

    public static Optional<JavaClass> getWithClass(Class<?> type) {
        Optional<MappingTree.ClassMapping> mapping = JavaClass.getMapping(type);
        if (mapping.isPresent()) {
            String name = mapping.get().getName(0);
            name = name == null ? mapping.get().getSrcName() : name;
            NullableOption<Object> javaLike = MappingTree.getRoot().getRelative(Arrays.asList(name.split("/|\\$")));
            if (javaLike.isPresent() && javaLike.get() instanceof JavaClass) {
                return Optional.of((JavaClass)javaLike.get());
            }
            return Optional.empty();
        }
        return Optional.empty();
    }

    public Optional<Field> getMappedField(String name, boolean staticOnly) {
        Class<?> classObj;
        try {
            classObj = Class.forName(String.join((CharSequence)".", this.mapping.getSrcName().replace('/', '.')));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(String.format("could not find class `%s`: %s", this.stringQualifier(), e));
        }
        for (MappingTree.FieldMapping fieldMapping : this.mapping.getFields()) {
            String fieldName = fieldMapping.getName(0);
            if (fieldName == null) {
                fieldName = fieldMapping.getSrcName();
            }
            if (!fieldName.equals(name)) continue;
            try {
                Field field = classObj.getDeclaredField(fieldMapping.getSrcName());
                if (!Modifier.isStatic(field.getModifiers()) && staticOnly) continue;
                return Optional.ofNullable(field);
            }
            catch (Exception e) {
                throw new RuntimeException(String.format("could not get declared field `%s/%s`: `%s`", this.stringQualifier(), name, e));
            }
        }
        return Optional.empty();
    }

    public static Optional<Field> getSrcField(String name, Class<?> type, boolean staticOnly) {
        type.getEnumConstants();
        try {
            Class<?>[] found = type.getField(name);
            if (!staticOnly || Modifier.isStatic(found.getModifiers())) {
                return Optional.of(found);
            }
        }
        catch (Exception found) {
            // empty catch block
        }
        for (Class<?> interfaceImpl : type.getInterfaces()) {
            Optional<Field> found = JavaClass.getSrcField(name, interfaceImpl, staticOnly);
            if (!found.isPresent()) continue;
            return found;
        }
        try {
            return JavaClass.getSrcField(name, type.getSuperclass(), staticOnly);
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public Optional<Field> getField(String name, boolean staticOnly) {
        Class<?> type;
        try {
            type = Class.forName(String.join((CharSequence)".", this.mapping.getSrcName().replace('/', '.')));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not get class when getting field: " + String.valueOf(e));
        }
        Optional<Field> res = this.getMappedField(name, staticOnly);
        if (res.isPresent()) {
            return res;
        }
        return JavaClass.getSrcField(name, type, staticOnly);
    }

    public static Optional<Object> getEnumValue(String name, Class<?> type) {
        if (type.isEnum()) {
            try {
                return Optional.of(Enum.valueOf(type, name));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Optional.empty();
    }

    public Optional<Object> getEnumValue(String name) {
        Class<?> type;
        try {
            type = Class.forName(String.join((CharSequence)".", this.mapping.getSrcName().replace('/', '.')));
        }
        catch (Exception e) {
            throw new RuntimeException("Could not get class when getting field: " + String.valueOf(e));
        }
        return JavaClass.getEnumValue(name, type);
    }

    @Override
    public String[] getQualifier() {
        return this.stringQualifier().split("\\$|\\/");
    }

    @Override
    public String stringQualifier() {
        String name = this.mapping.getName(0);
        return name == null ? this.mapping.getSrcName() : name;
    }

    public static Method[] getSrcMethod(String name, boolean staticOnly, Class<?> type) {
        ArrayList<Method> methods = new ArrayList<Method>();
        for (Method method : type.getDeclaredMethods()) {
            if (staticOnly && !Modifier.isStatic(method.getModifiers()) || !method.getName().equals(name)) continue;
            methods.add(method);
        }
        for (GenericDeclaration genericDeclaration : type.getInterfaces()) {
            methods.addAll(Arrays.asList(JavaClass.getSrcMethod(name, staticOnly, genericDeclaration)));
        }
        try {
            methods.addAll(Arrays.asList(JavaClass.getSrcMethod(name, staticOnly, type.getSuperclass())));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (Method[])methods.toArray(Method[]::new);
    }

    private static Class<?> toJavaType(String descriptor) {
        switch (descriptor.charAt(0)) {
            case 'B': {
                return Byte.TYPE;
            }
            case 'S': {
                return Short.TYPE;
            }
            case 'I': {
                return Integer.TYPE;
            }
            case 'J': {
                return Long.TYPE;
            }
            case 'F': {
                return Float.TYPE;
            }
            case 'D': {
                return Double.TYPE;
            }
            case 'C': {
                return Character.TYPE;
            }
            case 'Z': {
                return Boolean.TYPE;
            }
            case 'V': {
                return Void.TYPE;
            }
        }
        StringBuilder result = new StringBuilder();
        int arrayLevel = 0;
        boolean isObject = false;
        block18: for (int i = 0; i < descriptor.length(); ++i) {
            switch (descriptor.charAt(i)) {
                case '[': {
                    ++arrayLevel;
                    continue block18;
                }
                case 'L': {
                    isObject = true;
                    while (i + 1 < descriptor.length()) {
                        char c;
                        if ((c = descriptor.charAt(++i)) == '/') {
                            result.append('.');
                            continue;
                        }
                        if (c == ';') continue block18;
                        result.append(c);
                    }
                    continue block18;
                }
                case 'B': 
                case 'C': 
                case 'D': 
                case 'F': 
                case 'I': 
                case 'J': 
                case 'S': 
                case 'V': 
                case 'Z': {
                    result.append(descriptor.charAt(i));
                    continue block18;
                }
                default: {
                    throw new IllegalArgumentException("Unknown character in descriptor: " + descriptor.charAt(i));
                }
            }
        }
        if (arrayLevel != 0) {
            if (isObject) {
                result.insert(0, 'L');
            }
            result.insert(0, "[".repeat(arrayLevel));
            result.append(';');
        }
        try {
            return Class.forName(result.toString());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(String.format("class not found when parsing descriptor `%s`: %s", result.toString(), e));
        }
    }

    public static Constructor<?>[] getConstructor(Class<?> type) {
        return type.getDeclaredConstructors();
    }

    public Constructor<?>[] getConstructor() {
        Class<?> classObj;
        try {
            classObj = Class.forName(String.join((CharSequence)".", this.mapping.getSrcName().replace('/', '.')));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(String.format("could not find class `%s`: %s", this.stringQualifier(), e));
        }
        return JavaClass.getConstructor(classObj);
    }

    public Method[] getMappedMethod(String name, boolean staticOnly) {
        Class<?> classObj;
        ArrayList<Method> methods = new ArrayList<Method>();
        try {
            classObj = Class.forName(String.join((CharSequence)".", this.mapping.getSrcName().replace('/', '.')));
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(String.format("could not find class `%s`: %s", this.stringQualifier(), e));
        }
        this.mapping.getMethods().stream().forEach(methodMapping -> {
            String methodName = methodMapping.getName(0);
            if (methodName == null) {
                methodName = methodMapping.getSrcName();
            }
            if (methodName.equals(name)) {
                try {
                    String desc = methodMapping.getSrcDesc();
                    Class[] args = (Class[])Arrays.stream(desc.substring(desc.indexOf(40) + 1, desc.indexOf(41)).split(";")).filter(s -> s.length() != 0).map(JavaClass::toJavaType).toArray(Class[]::new);
                    Method method = classObj.getDeclaredMethod(methodMapping.getSrcName(), args);
                    if (!Modifier.isStatic(method.getModifiers()) && staticOnly) {
                        return;
                    }
                    methods.add(method);
                }
                catch (NoSuchMethodException e) {
                    throw new RuntimeException(String.format("could not find method `%s/%s`: %s", this.stringQualifier(), methodMapping.getSrcName(), e));
                }
            }
        });
        for (Class<?> interfaceImpl : classObj.getInterfaces()) {
            Optional<JavaClass> type = JavaClass.getWithClass(interfaceImpl);
            if (!type.isPresent()) continue;
            methods.addAll(Arrays.asList(type.get().getMappedMethod(name, staticOnly)));
        }
        try {
            Optional<JavaClass> type = JavaClass.getWithClass(classObj.getSuperclass());
            if (type.isPresent()) {
                methods.addAll(Arrays.asList(type.get().getMappedMethod(name, staticOnly)));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return (Method[])methods.toArray(Method[]::new);
    }

    public Method[] getMethod(String name, boolean staticOnly) {
        ArrayList<Method> methods = new ArrayList<Method>();
        methods.addAll(Arrays.asList(this.getMappedMethod(name, staticOnly)));
        try {
            methods.addAll(Arrays.asList(JavaClass.getSrcMethod(name, staticOnly, Class.forName(String.join((CharSequence)".", this.mapping.getSrcName().replace('/', '.'))))));
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("could not find class `%s`: %s", this.stringQualifier(), e));
        }
        return (Method[])methods.toArray(Method[]::new);
    }

    private JavaClass() {
    }

    private JavaClass(MappingTree.ClassMapping mapping, List<String> className) {
        if (className.isEmpty()) {
            this.mapping = mapping;
        } else {
            this.children.put(className.getFirst(), new JavaClass(mapping, className.subList(1, className.size())));
        }
    }

    private void setMapping(MappingTree.ClassMapping mapping, List<String> remainingClassPath) {
        if (remainingClassPath.isEmpty()) {
            this.mapping = mapping;
        } else if (this.children.containsKey(remainingClassPath.getFirst())) {
            this.children.get(remainingClassPath.getFirst()).setMapping(mapping, remainingClassPath.subList(1, remainingClassPath.size()));
        } else {
            this.children.put(remainingClassPath.getFirst(), new JavaClass(mapping, remainingClassPath.subList(1, remainingClassPath.size())));
        }
    }

    public static void insertClass(MappingTree.ClassMapping mapping, String className, JavaPackage parent) {
        List<String> classPath = List.of(className.split("\\$"));
        NullableOption<JavaLike> immediateChild = parent.getRelative(classPath.getFirst()).map(item -> (JavaLike)item);
        if (immediateChild.isEmpty()) {
            parent.insertClass(new JavaClass(mapping, classPath.subList(1, classPath.size())), classPath.getFirst());
        } else if (immediateChild.get() instanceof JavaClass) {
            ((JavaClass)immediateChild.get()).setMapping(mapping, classPath.subList(1, classPath.size()));
        } else {
            throw new RuntimeException("Expected class, found package");
        }
    }

    @NotNull
    public static Optional<MappingTree.ClassMapping> getMapping(Class<?> target) {
        return Optional.ofNullable(MappingTree.getMappingTree().getClass(target.getName().replace('.', '/')));
    }

    public boolean setField(String name, Object value) {
        value = JavaObject.unwrapAll(value);
        try {
            Optional<Field> field = this.getField(name, true);
            if (field.isPresent()) {
                field.get().setAccessible(true);
                field.get().set(null, value);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not set field `" + name + "` because " + String.valueOf(e));
        }
    }

    @Override
    public NullableOption<Object> getRelative(List<String> path) {
        if (path.isEmpty()) {
            return NullableOption.of(this);
        }
        if (this.children.containsKey(path.getFirst())) {
            return this.children.get(path.getFirst()).getRelative(path.subList(1, path.size()));
        }
        if (path.size() == 1) {
            String name = path.getFirst();
            if (name.equals("<init>")) {
                Executable[] constructors = this.getConstructor();
                if (constructors.length == 0) {
                    return NullableOption.empty();
                }
                return NullableOption.of(new JavaFunction(constructors, this.stringQualifier() + "$<init>", this));
            }
            Optional<Field> field = this.getField(name, true);
            if (field.isPresent()) {
                field.get().setAccessible(true);
                try {
                    return NullableOption.of(JavaObject.autoWrap(field.get().get(null)));
                }
                catch (Exception e) {
                    throw new RuntimeException("Could not get field for class: " + String.valueOf(e));
                }
            }
            Optional<Object> enumConstant = this.getEnumValue(name);
            if (enumConstant.isPresent()) {
                return NullableOption.of(JavaObject.autoWrap(enumConstant.get()));
            }
            ArrayList<Method> methods = new ArrayList<Method>(Arrays.asList(this.getMethod(name, true)));
            NullableOption<JavaLike> parent = this.getParent();
            if (parent.isPresent() && parent.get() instanceof JavaClass) {
                methods.addAll(Arrays.asList(((JavaClass)parent.get()).getMethod(name, true)));
            }
            if (methods.isEmpty()) {
                return NullableOption.empty();
            }
            return NullableOption.of(new JavaFunction((Executable[])methods.toArray(Method[]::new), this.stringQualifier() + "$" + name, this));
        }
        return NullableOption.empty();
    }

    public String toString() {
        return this.mapping == null ? "JavaClass([Mapping missing])" : String.format("JavaClass(%s -> %s)", this.stringQualifier(), this.mapping.getSrcName());
    }
}

