/*
 * Decompiled with CFR 0.152.
 */
package ws.siri.yarnwrap.mapping;

import com.mojang.datafixers.util.Pair;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import ws.siri.yarnwrap.common.ScriptFunction;
import ws.siri.yarnwrap.mapping.JavaLike;
import ws.siri.yarnwrap.mapping.JavaObject;
import ws.siri.yarnwrap.util.NullableOption;

public class JavaFunction
implements ScriptFunction,
JavaLike {
    public final HashMap<Class<?>[], Executable> methods = new HashMap();
    public final String qualifier;
    public final JavaLike parent;
    private static HashMap<Class<?>, HashMap<Class<?>, Integer>> assignAccepts = new HashMap();

    public JavaFunction(Executable[] potentialMethods, String qualifier, JavaLike parent) {
        Arrays.stream(potentialMethods).forEach(method -> this.methods.put(method.getParameterTypes(), (Executable)method));
        this.qualifier = qualifier;
        this.parent = parent;
    }

    private static Class<?> primitiveWrapper(Class<?> primitiveClass) {
        if (primitiveClass == Integer.TYPE) {
            return Integer.class;
        }
        if (primitiveClass == Character.TYPE) {
            return Character.class;
        }
        if (primitiveClass == Double.TYPE) {
            return Double.class;
        }
        if (primitiveClass == Float.TYPE) {
            return Float.class;
        }
        if (primitiveClass == Long.TYPE) {
            return Long.class;
        }
        if (primitiveClass == Short.TYPE) {
            return Short.class;
        }
        if (primitiveClass == Byte.TYPE) {
            return Byte.class;
        }
        if (primitiveClass == Boolean.TYPE) {
            return Boolean.class;
        }
        throw new UnsupportedOperationException(primitiveClass.getName() + " is not a primitive");
    }

    public int areEquivalent(Class<?> a, Class<?> b) {
        if (a.isAssignableFrom(b)) {
            return 0;
        }
        if (a.isPrimitive()) {
            a = JavaFunction.primitiveWrapper(a);
        }
        if (b.isPrimitive()) {
            b = JavaFunction.primitiveWrapper(b);
        }
        if (assignAccepts.containsKey(a) && assignAccepts.get(a).containsKey(b)) {
            return assignAccepts.get(a).get(b);
        }
        return a == b ? 0 : -1;
    }

    @Override
    public Object run(Object ... args) throws Exception {
        for (int i = 0; i < args.length; ++i) {
            args[i] = JavaObject.unwrapAll(args[i]);
        }
        Object[] argTypes = (Class[])Arrays.stream(args).map(arg -> arg.getClass()).toArray(Class[]::new);
        ArrayList<Pair> sigTypes = new ArrayList<Pair>();
        for (Class<?>[] sig : this.methods.keySet()) {
            if (sig.length == argTypes.length) {
                sigTypes.add(new Pair(sig, Optional.empty()));
            }
            if (sig.length > argTypes.length + 1 || sig.length == 0 || !sig[sig.length - 1].isArray()) continue;
            Class[] expanded = new Class[argTypes.length];
            for (int i = 0; i < argTypes.length; ++i) {
                expanded[i] = i < sig.length - 1 ? sig[i] : sig[sig.length - 1].getComponentType();
            }
            sigTypes.add(new Pair((Object)expanded, Optional.of(sig)));
        }
        Executable executable = null;
        Class[] executableSignature = null;
        Optional originalSignature = Optional.empty();
        int executableScore = -1;
        if (this.methods.containsKey(argTypes)) {
            executable = this.methods.get(argTypes);
        } else {
            block5: for (Pair pair : sigTypes) {
                Class[] signature = (Class[])pair.getFirst();
                if (signature.length != argTypes.length) continue;
                int runningScore = 0;
                for (int i = 0; i < signature.length; ++i) {
                    int score = this.areEquivalent(signature[i], (Class<?>)argTypes[i]);
                    if (score == -1) continue block5;
                    runningScore += score;
                }
                if (executableScore == -1 || runningScore < executableScore) {
                    executable = this.methods.get(((Optional)pair.getSecond()).orElse(signature));
                    executableSignature = signature;
                    executableScore = runningScore;
                    originalSignature = (Optional)pair.getSecond();
                }
                if (runningScore != 0) continue;
                break;
            }
            if (executable == null) {
                throw new UnsupportedOperationException(String.format("no method implementation with arguments `%s`", Arrays.toString(argTypes)));
            }
            for (int i = 0; i < executableSignature.length; ++i) {
                Class<?> sig = executableSignature[i];
                if (sig.isPrimitive()) {
                    sig = JavaFunction.primitiveWrapper(sig);
                }
                if (sig == args[i].getClass() || !assignAccepts.containsKey(sig)) continue;
                Number n = (Number)args[i];
                if (sig == Short.class) {
                    args[i] = n.shortValue();
                    continue;
                }
                if (sig == Integer.class) {
                    args[i] = n.intValue();
                    continue;
                }
                if (sig == Long.class) {
                    args[i] = n.longValue();
                    continue;
                }
                if (sig == Double.class) {
                    args[i] = n.doubleValue();
                    continue;
                }
                if (sig != Float.class) continue;
                args[i] = Float.valueOf(n.floatValue());
            }
            if (originalSignature.isPresent()) {
                int i;
                Class[] original = (Class[])originalSignature.get();
                Object[] newArgs = new Object[original.length];
                for (i = 0; i < original.length - 1; ++i) {
                    newArgs[i] = args[i];
                }
                newArgs[original.length - 1] = Array.newInstance(original[original.length - 1].getComponentType(), args.length - original.length + 1);
                for (i = 0; i < args.length - original.length + 1; ++i) {
                    Array.set(newArgs[original.length - 1], i, args[i + original.length - 1]);
                }
                args = newArgs;
            }
        }
        if (executable instanceof Constructor) {
            return JavaObject.autoWrap(((Constructor)executable).newInstance(args));
        }
        Method method = (Method)executable;
        method.setAccessible(true);
        try {
            if (Modifier.isStatic(method.getModifiers())) {
                return JavaObject.autoWrap(method.invoke(null, args));
            }
            if (this.parent instanceof JavaObject) {
                return JavaObject.autoWrap(method.invoke(JavaObject.unwrapAll(this.parent), args));
            }
            throw new UnsupportedOperationException(String.format("no static implementation with arguments `%s`", Arrays.toString(argTypes)));
        }
        catch (InvocationTargetException e) {
            throw new Exception(e.getTargetException());
        }
    }

    @Override
    @NotNull
    public NullableOption<Object> getRelative(List<String> path) {
        return NullableOption.empty();
    }

    @Override
    @NotNull
    public String[] getQualifier() {
        return this.qualifier.split("\\$|/");
    }

    @Override
    @NotNull
    public String stringQualifier() {
        return this.qualifier;
    }

    public String toString() {
        return String.format("JavaPackage(%s)", this.stringQualifier());
    }

    static {
        HashMap<Class, Integer> map = new HashMap<Class, Integer>();
        map.put(Byte.class, 0);
        map.put(Short.class, 10);
        map.put(Integer.class, 15);
        map.put(Long.class, 18);
        map.put(Float.class, 30);
        map.put(Double.class, 30);
        assignAccepts.put(Byte.class, map);
        map = new HashMap();
        map.put(Byte.class, 1);
        map.put(Short.class, 0);
        map.put(Integer.class, 10);
        map.put(Long.class, 15);
        map.put(Float.class, 30);
        map.put(Double.class, 30);
        assignAccepts.put(Short.class, map);
        map = new HashMap();
        map.put(Byte.class, 1);
        map.put(Short.class, 1);
        map.put(Integer.class, 0);
        map.put(Long.class, 10);
        map.put(Float.class, 30);
        map.put(Double.class, 30);
        assignAccepts.put(Integer.class, map);
        map = new HashMap();
        map.put(Byte.class, 1);
        map.put(Short.class, 1);
        map.put(Integer.class, 1);
        map.put(Long.class, 0);
        map.put(Float.class, 30);
        map.put(Double.class, 30);
        assignAccepts.put(Long.class, map);
        map = new HashMap();
        map.put(Byte.class, 2);
        map.put(Short.class, 2);
        map.put(Integer.class, 2);
        map.put(Long.class, 2);
        map.put(Float.class, 0);
        map.put(Double.class, 1);
        assignAccepts.put(Float.class, map);
        map = new HashMap();
        map.put(Byte.class, 2);
        map.put(Short.class, 2);
        map.put(Integer.class, 2);
        map.put(Long.class, 2);
        map.put(Float.class, 1);
        map.put(Double.class, 0);
        assignAccepts.put(Double.class, map);
    }
}

