/*
 * Decompiled with CFR 0.152.
 */
package ws.siri.yarnwrap.mapping;

import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import net.fabricmc.mappingio.tree.MappingTree;
import org.jetbrains.annotations.NotNull;
import ws.siri.yarnwrap.mapping.JavaClass;
import ws.siri.yarnwrap.mapping.JavaFunction;
import ws.siri.yarnwrap.mapping.JavaLike;
import ws.siri.yarnwrap.mapping.MappingTree;
import ws.siri.yarnwrap.util.NullableOption;

public class JavaObject
implements JavaLike {
    public final Object internal;
    public final Optional<JavaClass> type;
    public static HashSet<String> doNotWrap = new HashSet<String>(Arrays.asList("java"));

    public JavaObject(Object internal) {
        this.internal = internal;
        Optional<MappingTree.ClassMapping> mapping = JavaClass.getMapping(internal.getClass());
        if (mapping.isPresent()) {
            String name = mapping.get().getName(0);
            name = name == null ? mapping.get().getSrcName() : name;
            NullableOption<Object> javaLike = MappingTree.getRoot().getRelative(Arrays.asList(name.split("/|\\$")));
            this.type = javaLike.isPresent() && javaLike.get() instanceof JavaClass ? Optional.of((JavaClass)javaLike.get()) : Optional.empty();
        } else {
            this.type = Optional.empty();
        }
    }

    public Object get() {
        return this.internal;
    }

    public String toString() {
        return String.format("JavaObject(%s%s)", this.internal.toString().replace("\u00a7", "\u00a7\u00a7"), this.type.isPresent() ? " -> " + this.type.get().stringQualifier() : "");
    }

    public boolean setField(String name, Object value) {
        value = JavaObject.unwrapAll(value);
        try {
            Optional<Field> field = this.type.isPresent() ? this.type.get().getField(name, false) : JavaClass.getSrcField(name, this.internal.getClass(), false);
            if (field.isPresent()) {
                field.get().setAccessible(true);
                field.get().set(this.internal, value);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new RuntimeException("Could not set field `" + name + "` because " + String.valueOf(e));
        }
    }

    @Override
    @NotNull
    public NullableOption<Object> getRelative(List<String> path) {
        if (path.size() != 1) {
            return NullableOption.empty();
        }
        if (path.getFirst().equals("<init>")) {
            Executable[] constructors = JavaClass.getConstructor(this.internal.getClass());
            if (constructors.length == 0) {
                return NullableOption.empty();
            }
            return NullableOption.of(new JavaFunction(constructors, this.stringQualifier() + "$<init>", this));
        }
        String name = path.getFirst();
        Optional<Field> field = this.type.isPresent() ? this.type.get().getField(name, false) : JavaClass.getSrcField(name, this.internal.getClass(), false);
        if (field.isPresent()) {
            field.get().setAccessible(true);
            try {
                return NullableOption.of(JavaObject.autoWrap(field.get().get(this.internal)));
            }
            catch (Exception e) {
                throw new RuntimeException("Could not get field for object: " + String.valueOf(e));
            }
        }
        Optional<Object> enumConstant = JavaClass.getEnumValue(name, this.internal.getClass());
        if (enumConstant.isPresent()) {
            return NullableOption.of(JavaObject.autoWrap(enumConstant.get()));
        }
        ArrayList<Method> methods = new ArrayList<Method>(Arrays.stream(this.internal.getClass().getDeclaredMethods()).filter(method -> method.getName().equals(name)).toList());
        if (this.type.isPresent()) {
            methods.addAll(Arrays.asList(this.type.get().getMethod(name, false)));
        } else {
            methods.addAll(Arrays.asList(JavaClass.getSrcMethod(name, false, this.internal.getClass())));
        }
        if (methods.isEmpty()) {
            return NullableOption.empty();
        }
        return NullableOption.of(new JavaFunction((Executable[])methods.toArray(Method[]::new), this.stringQualifier() + "$" + name, this));
    }

    @Override
    @NotNull
    public String[] getQualifier() {
        if (this.type.isPresent()) {
            return this.type.get().getQualifier();
        }
        return this.internal.getClass().getName().split("\\.|\\$");
    }

    @Override
    @NotNull
    public String stringQualifier() {
        if (this.type.isPresent()) {
            return this.type.get().stringQualifier();
        }
        return this.internal.getClass().getName().replace('.', '/');
    }

    public static boolean addNoWrap(String name) {
        return doNotWrap.add(name);
    }

    public static boolean shouldWrap(Object source) {
        if (source == null) {
            return false;
        }
        if (source instanceof JavaObject) {
            return JavaObject.shouldWrap(((JavaObject)source).internal);
        }
        String[] path = source.getClass().getName().split("\\.|\\$|/");
        for (int i = 1; i < path.length; ++i) {
            if (!doNotWrap.contains(String.join((CharSequence)".", (CharSequence[])Arrays.asList(path).subList(0, i).toArray(String[]::new)))) continue;
            return false;
        }
        return true;
    }

    public static Object unwrapAll(Object source) {
        if (source == null) {
            return null;
        }
        if (source instanceof JavaObject) {
            return JavaObject.unwrapAll(((JavaObject)source).internal);
        }
        return source;
    }

    public static Object autoWrap(Object source) {
        if (JavaObject.shouldWrap(source)) {
            if (source instanceof JavaLike) {
                return source;
            }
            return new JavaObject(source);
        }
        return JavaObject.unwrapAll(source);
    }
}

