/*
 * Decompiled with CFR 0.152.
 */
package ws.siri.yarnwrap.mapping;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.fabricmc.mappingio.tree.MappingTree;
import ws.siri.yarnwrap.mapping.JavaClass;
import ws.siri.yarnwrap.mapping.JavaLike;
import ws.siri.yarnwrap.util.NullableOption;

public class JavaPackage
implements JavaLike {
    public final String[] path;
    private HashMap<String, JavaLike> children = new HashMap();

    public static JavaPackage root() {
        return new JavaPackage();
    }

    @Override
    public String[] getQualifier() {
        return this.path;
    }

    @Override
    public String stringQualifier() {
        return String.join((CharSequence)"/", this.path);
    }

    public void addClass(MappingTree.ClassMapping mapping) {
        if (this.path.length != 0) {
            throw new UnsupportedOperationException("addClass should only be used from root package");
        }
        String name = mapping.getName(0);
        this.insertClass(mapping, List.of((name == null ? mapping.getSrcName() : mapping.getName(0)).split("/")));
    }

    private JavaPackage() {
        this.path = new String[0];
    }

    private JavaPackage(String qualifier) {
        this.path = qualifier.split("/");
    }

    public void insertClass(JavaClass javaClass, String immediateName) {
        if (this.children.containsKey(immediateName)) {
            throw new RuntimeException("Key already exists `" + immediateName + "`");
        }
        this.children.put(immediateName, javaClass);
    }

    @Override
    public NullableOption<Object> getRelative(List<String> path) {
        if (path.isEmpty()) {
            return NullableOption.of(this);
        }
        if (this.children.containsKey(path.getFirst())) {
            return this.children.get(path.getFirst()).getRelative(path.subList(1, path.size()));
        }
        return NullableOption.empty();
    }

    public void insertClass(MappingTree.ClassMapping mapping, List<String> pathRemaining) {
        JavaLike immediateChild;
        if (pathRemaining.size() == 1) {
            JavaClass.insertClass(mapping, pathRemaining.getFirst(), this);
            return;
        }
        if (!this.children.containsKey(pathRemaining.getFirst())) {
            ArrayList<String> newPath = new ArrayList<String>(Arrays.asList(this.path));
            newPath.add(pathRemaining.getFirst());
            this.children.put(pathRemaining.getFirst(), new JavaPackage(String.join((CharSequence)"/", newPath)));
        }
        if ((immediateChild = this.children.get(pathRemaining.getFirst())) instanceof JavaPackage) {
            ((JavaPackage)immediateChild).insertClass(mapping, pathRemaining.subList(1, pathRemaining.size()));
        } else {
            JavaClass.insertClass(mapping, pathRemaining.getFirst(), this);
        }
    }

    public String toString() {
        return String.format("JavaPackage(%s)", this.stringQualifier());
    }
}

