/*
 * Decompiled with CFR 0.152.
 */
package ws.siri.yarnwrap.mapping;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.stream.Stream;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.mappingio.MappingReader;
import net.fabricmc.mappingio.MappingVisitor;
import net.fabricmc.mappingio.tree.MappingTree;
import net.fabricmc.mappingio.tree.MemoryMappingTree;
import net.fabricmc.mappingio.tree.VisitableMappingTree;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.NotNull;
import ws.siri.yarnwrap.mapping.JavaPackage;

public class MappingTree {
    private static VisitableMappingTree mappingTree = new MemoryMappingTree();
    private static JavaPackage packageRoot = JavaPackage.root();

    public static void init() {
        MappingTree.walkMappings((Path)((ModContainer)FabricLoader.getInstance().getModContainer("yarnwrap").get()).findPath("yarn").get(), mappingTree);
        mappingTree.getClasses().stream().forEach(entry -> packageRoot.addClass((MappingTree.ClassMapping)entry));
    }

    private static void walkMappings(Path dir, VisitableMappingTree tree) {
        try (Stream<Path> stream = Files.list(dir);){
            stream.forEach(entry -> {
                if (Files.isDirectory(entry, new LinkOption[0])) {
                    MappingTree.walkMappings(entry, tree);
                } else if (FilenameUtils.getExtension((String)entry.getFileName().toString()).equals("mapping")) {
                    try {
                        MappingReader.read((Path)entry, (MappingVisitor)tree);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            });
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @NotNull
    public static JavaPackage getRoot() {
        return packageRoot;
    }

    @NotNull
    public static VisitableMappingTree getMappingTree() {
        return mappingTree;
    }

    static {
        MappingTree.init();
    }
}

