/*
 * Decompiled with CFR 0.152.
 */
package ws.siri.yarnwrap.util;

import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class NullableOption<T> {
    private final boolean isPresent;
    private final T value;

    private NullableOption(T value) {
        this.isPresent = true;
        this.value = value;
    }

    private NullableOption() {
        this.isPresent = false;
        this.value = null;
    }

    public static <T> NullableOption<T> of(T value) {
        return new NullableOption<T>(value);
    }

    public static <T> NullableOption<T> empty() {
        return new NullableOption<T>();
    }

    public boolean isPresent() {
        return this.isPresent;
    }

    public boolean isEmpty() {
        return !this.isPresent;
    }

    public T get() {
        if (this.isPresent) {
            return this.value;
        }
        throw new IllegalAccessError("Nullable option is not present");
    }

    public boolean equals(Object obj) {
        if (obj instanceof NullableOption) {
            NullableOption other = (NullableOption)obj;
            if (this.isPresent) {
                if (this.value == null) {
                    return other.value == null;
                }
                return this.value.equals(other.value);
            }
            return !other.isPresent;
        }
        return false;
    }

    public <U> NullableOption<U> flatMap(Function<? super T, NullableOption<U>> mapper) {
        if (this.isPresent) {
            return mapper.apply(this.value);
        }
        return NullableOption.empty();
    }

    public void ifPresent(Consumer<? super T> consumer) {
        consumer.accept(this.value);
    }

    public <U> NullableOption<U> map(Function<? super T, ? extends U> mapper) {
        if (this.isPresent) {
            return NullableOption.of(mapper.apply(this.value));
        }
        return NullableOption.empty();
    }

    public T orElse(T other) {
        return this.isPresent ? this.value : other;
    }

    T orElseGet(Supplier<? extends T> other) {
        if (this.isPresent) {
            return this.value;
        }
        return other.get();
    }

    <X extends Throwable> T orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        if (this.isPresent) {
            return this.value;
        }
        throw (Throwable)exceptionSupplier.get();
    }

    public String toString() {
        return this.isPresent ? ("NullableOption[" + String.valueOf(this.value) == null ? "null" : String.valueOf(this.value) + "]") : "NullableOption.empty";
    }
}

