/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.killmods.block.entity;

import io.netty.buffer.Unpooled;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.mcreator.killmods.init.KillmodsModBlockEntities;
import net.mcreator.killmods.init.KillmodsModFluids;
import net.mcreator.killmods.world.inventory.PandemoniumAltarGUIMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.energy.EnergyStorage;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;
import net.neoforged.neoforge.items.wrapper.SidedInvWrapper;

public class PandemoniumAltarBlockEntity
extends RandomizableContainerBlockEntity
implements WorldlyContainer {
    private NonNullList<ItemStack> stacks = NonNullList.withSize((int)12, (Object)ItemStack.EMPTY);
    private final SidedInvWrapper handler = new SidedInvWrapper((WorldlyContainer)this, null);
    private final EnergyStorage energyStorage = new EnergyStorage(400000, 200, 200, 0){

        public int receiveEnergy(int maxReceive, boolean simulate) {
            int retval = super.receiveEnergy(maxReceive, simulate);
            if (!simulate) {
                PandemoniumAltarBlockEntity.this.setChanged();
                PandemoniumAltarBlockEntity.this.level.sendBlockUpdated(PandemoniumAltarBlockEntity.this.worldPosition, PandemoniumAltarBlockEntity.this.level.getBlockState(PandemoniumAltarBlockEntity.this.worldPosition), PandemoniumAltarBlockEntity.this.level.getBlockState(PandemoniumAltarBlockEntity.this.worldPosition), 2);
            }
            return retval;
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            int retval = super.extractEnergy(maxExtract, simulate);
            if (!simulate) {
                PandemoniumAltarBlockEntity.this.setChanged();
                PandemoniumAltarBlockEntity.this.level.sendBlockUpdated(PandemoniumAltarBlockEntity.this.worldPosition, PandemoniumAltarBlockEntity.this.level.getBlockState(PandemoniumAltarBlockEntity.this.worldPosition), PandemoniumAltarBlockEntity.this.level.getBlockState(PandemoniumAltarBlockEntity.this.worldPosition), 2);
            }
            return retval;
        }
    };
    private final FluidTank fluidTank = new FluidTank(8000, fs -> fs.getFluid() == KillmodsModFluids.FLUID_PANDEMONIUM.get()){

        protected void onContentsChanged() {
            super.onContentsChanged();
            PandemoniumAltarBlockEntity.this.setChanged();
            PandemoniumAltarBlockEntity.this.level.sendBlockUpdated(PandemoniumAltarBlockEntity.this.worldPosition, PandemoniumAltarBlockEntity.this.level.getBlockState(PandemoniumAltarBlockEntity.this.worldPosition), PandemoniumAltarBlockEntity.this.level.getBlockState(PandemoniumAltarBlockEntity.this.worldPosition), 2);
        }
    };

    public PandemoniumAltarBlockEntity(BlockPos position, BlockState state) {
        super((BlockEntityType)KillmodsModBlockEntities.PANDEMONIUM_ALTAR.get(), position, state);
    }

    public void loadAdditional(CompoundTag compound, HolderLookup.Provider lookupProvider) {
        super.loadAdditional(compound, lookupProvider);
        if (!this.tryLoadLootTable(compound)) {
            this.stacks = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        }
        ContainerHelper.loadAllItems((CompoundTag)compound, this.stacks, (HolderLookup.Provider)lookupProvider);
        Tag tag = compound.get("energyStorage");
        if (tag instanceof IntTag) {
            IntTag intTag = (IntTag)tag;
            this.energyStorage.deserializeNBT(lookupProvider, (Tag)intTag);
        }
        if ((tag = compound.get("fluidTank")) instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)tag;
            this.fluidTank.readFromNBT(lookupProvider, compoundTag);
        }
    }

    public void saveAdditional(CompoundTag compound, HolderLookup.Provider lookupProvider) {
        super.saveAdditional(compound, lookupProvider);
        if (!this.trySaveLootTable(compound)) {
            ContainerHelper.saveAllItems((CompoundTag)compound, this.stacks, (HolderLookup.Provider)lookupProvider);
        }
        compound.put("energyStorage", this.energyStorage.serializeNBT(lookupProvider));
        compound.put("fluidTank", (Tag)this.fluidTank.writeToNBT(lookupProvider, new CompoundTag()));
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider lookupProvider) {
        return this.saveWithFullMetadata(lookupProvider);
    }

    public int getContainerSize() {
        return this.stacks.size();
    }

    public boolean isEmpty() {
        for (ItemStack itemstack : this.stacks) {
            if (itemstack.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public Component getDefaultName() {
        return Component.literal((String)"pandemonium_altar");
    }

    public int getMaxStackSize() {
        return 64;
    }

    public AbstractContainerMenu createMenu(int id, Inventory inventory) {
        return new PandemoniumAltarGUIMenu(id, inventory, new FriendlyByteBuf(Unpooled.buffer()).writeBlockPos(this.worldPosition));
    }

    public Component getDisplayName() {
        return Component.literal((String)"Pandemonium Altar");
    }

    protected NonNullList<ItemStack> getItems() {
        return this.stacks;
    }

    protected void setItems(NonNullList<ItemStack> stacks) {
        this.stacks = stacks;
    }

    public boolean canPlaceItem(int index, ItemStack stack) {
        return true;
    }

    public int[] getSlotsForFace(Direction side) {
        return IntStream.range(0, this.getContainerSize()).toArray();
    }

    public boolean canPlaceItemThroughFace(int index, ItemStack stack, @Nullable Direction direction) {
        return this.canPlaceItem(index, stack);
    }

    public boolean canTakeItemThroughFace(int index, ItemStack stack, Direction direction) {
        return true;
    }

    public SidedInvWrapper getItemHandler() {
        return this.handler;
    }

    public EnergyStorage getEnergyStorage() {
        return this.energyStorage;
    }

    public FluidTank getFluidTank() {
        return this.fluidTank;
    }
}

